/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.access;

import com.kingdee.bos.metadata.access.Select;

public class SelectKey {
    public static final char Split = '$';
    public static final char SegmentSplit = '&';
    public static final char UriSplit = '|';
    public static final char SubselectSplit = '~';
    private String type;
    private InnerList<String> uri;
    private InnerList<String> segment;
    private InnerList<SelectKey> subSelect;
    private boolean isPlain = true;

    public SelectKey() {
        this(null, 1);
    }

    public SelectKey(String type) {
        this(type, 1);
    }

    public SelectKey(String type, int initCapacity) {
        this.type = type;
        this.uri = new InnerList<String>(initCapacity, new StringMerger(true), '|');
        this.segment = new InnerList<String>(4, new StringMerger(false), '&');
        this.subSelect = new InnerList<SelectKey>(4, new SelectKeyMerger(), '~');
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPlain(boolean isPlain) {
        this.isPlain = isPlain;
    }

    public boolean isSameType(SelectKey another) {
        return this.type == null ? another.type == null : this.type.equals(another.type);
    }

    public String getUri() {
        return this.type + '$' + this.uri.toString();
    }

    public boolean contains(SelectKey another) {
        if (this.isPlain) {
            return this.equals(another);
        }
        if (another == null) {
            return true;
        }
        return this.isSameType(another) && this.uri.contains(another.uri) && this.segment.contains(another.segment) && this.subSelect.contains(another.subSelect);
    }

    public boolean canMerge(SelectKey another) {
        if (this.isPlain) {
            return false;
        }
        if (another == null) {
            return true;
        }
        return this.isSameType(another) && this.uri.canMerge(another.uri) && this.segment.canMerge(another.segment) && this.subSelect.canMerge(another.subSelect);
    }

    public void merge(SelectKey another) {
        if (another == null || !this.isSameType(another)) {
            return;
        }
        this.uri.merge(another.uri);
        this.segment.merge(another.segment);
        this.subSelect.merge(another.subSelect);
    }

    public void addUri(String ... s) {
        this.uri.add((String[])s);
    }

    public void addSegment(Object o) {
        this.segment.add((String[])new String[]{this.objectToString(o)});
    }

    private String objectToString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            if (((Boolean)o).booleanValue()) {
                return "1";
            }
            return null;
        }
        return o.toString();
    }

    public void addSegment(String ... s) {
        this.segment.add((String[])s);
    }

    public void addSubSelect(String type, Select s) {
        if (s == null) {
            this.addSubSelect(new SelectKey[]{null});
        } else {
            SelectKey sub = (SelectKey)s.getIdentity();
            this.subSelect.add((SelectKey[])new SelectKey[]{sub});
            if (type != null) {
                sub.setType(type);
            }
        }
    }

    public void addSubSelect(SelectKey ... s) {
        this.subSelect.add((SelectKey[])s);
    }

    public int hashCode() {
        int hashCode = this.type == null ? 0 : this.type.hashCode();
        hashCode = 31 * hashCode + this.uri.hashCode();
        hashCode = 31 * hashCode + this.segment.hashCode();
        hashCode = 31 * hashCode + this.subSelect.hashCode();
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SelectKey)) {
            return false;
        }
        SelectKey that = (SelectKey)obj;
        return this.isSameType(that) && this.uri.equals(that.uri) && this.segment.equals(that.segment) && this.subSelect.equals(that.subSelect);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.type != null) {
            str.append(this.type);
        }
        str.append('$');
        str.append(this.uri);
        str.append('$');
        str.append(this.segment);
        if (this.subSelect.size() > 0) {
            str.append('{');
            str.append(this.subSelect);
            str.append('}');
        }
        return str.toString();
    }

    static class StringMerger
    implements Merger<String> {
        private boolean supportSubset = false;

        StringMerger(boolean supportSubset) {
            this.supportSubset = supportSubset;
        }

        @Override
        public boolean contains(String thiz, String that) {
            if (thiz == null) {
                return that == null;
            }
            if ("*".equals(thiz)) {
                return true;
            }
            return thiz.equals(that);
        }

        @Override
        public boolean supportSubset() {
            return this.supportSubset;
        }

        @Override
        public boolean canMerge(String thiz, String that) {
            if (thiz != null && that != null) {
                return thiz.equals(that);
            }
            return true;
        }

        @Override
        public void merge(String thiz, String that) {
        }
    }

    static class SelectKeyMerger
    implements Merger<SelectKey> {
        SelectKeyMerger() {
        }

        @Override
        public boolean contains(SelectKey thiz, SelectKey that) {
            if (thiz == null) {
                return that == null;
            }
            return thiz.contains(that);
        }

        @Override
        public boolean supportSubset() {
            return false;
        }

        @Override
        public boolean canMerge(SelectKey thiz, SelectKey that) {
            if (thiz != null && that != null) {
                return thiz.canMerge(that);
            }
            return true;
        }

        @Override
        public void merge(SelectKey thiz, SelectKey that) {
            if (thiz != null) {
                thiz.merge(that);
            }
        }
    }

    static interface Merger<E> {
        public boolean contains(E var1, E var2);

        public boolean supportSubset();

        public boolean canMerge(E var1, E var2);

        public void merge(E var1, E var2);
    }

    static class InnerList<E> {
        private E[] elementData;
        private int size = 0;
        private final Merger<E> merger;
        private final char split;

        InnerList(int initialCapacity, Merger<E> merger, char split) {
            this.elementData = new Object[initialCapacity];
            this.merger = merger;
            this.split = split;
        }

        public void add(E ... e) {
            int len = e == null || e.length == 0 ? 1 : e.length;
            this.ensureCapacity(this.size + len);
            if (e == null || e.length == 0) {
                this.elementData[this.size++] = null;
            } else {
                for (int i = 0; i < e.length; ++i) {
                    this.elementData[this.size++] = e[i];
                }
            }
        }

        public E get(int i) {
            if (i < 0 || i >= this.size) {
                return null;
            }
            return this.elementData[i];
        }

        public boolean contains(InnerList<E> list) {
            boolean contain;
            if (list == null || list.size == 0) {
                return true;
            }
            if (this.merger.supportSubset()) {
                boolean contain2;
                boolean bl = contain2 = list.size <= this.size;
                if (contain2) {
                    for (int i = 0; i < list.size; ++i) {
                        boolean c = false;
                        for (int j = 0; j < this.size; ++j) {
                            if (!this.merger.contains(this.elementData[j], list.elementData[i])) continue;
                            c = true;
                            break;
                        }
                        if (c) continue;
                        return false;
                    }
                }
                return contain2;
            }
            boolean bl = contain = this.size == list.size;
            if (contain) {
                for (int i = 0; i < this.size; ++i) {
                    if (list.elementData[i] == null) continue;
                    if (this.elementData[i] == null) {
                        return false;
                    }
                    contain = this.merger.contains(this.elementData[i], list.elementData[i]);
                    if (contain) continue;
                    return false;
                }
            }
            return contain;
        }

        public boolean canMerge(InnerList<E> list) {
            boolean canMerge;
            boolean bl = canMerge = this.size == list.size;
            if (canMerge) {
                for (int i = 0; i < this.size; ++i) {
                    if (list.elementData[i] == null || this.elementData[i] == null || this.merger.canMerge(this.elementData[i], list.elementData[i])) continue;
                    return false;
                }
            }
            return canMerge;
        }

        public void merge(InnerList<E> list) {
            if (this.size != list.size) {
                return;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] == null) {
                    this.elementData[i] = list.elementData[i];
                    continue;
                }
                this.merger.merge(this.elementData[i], list.elementData[i]);
            }
        }

        public int size() {
            return this.size;
        }

        private void ensureCapacity(int size) {
            while (this.elementData.length < size) {
                E[] old = this.elementData;
                this.elementData = new Object[old.length * 3 / 2 + 1];
                System.arraycopy(old, 0, this.elementData, 0, old.length);
            }
        }

        public void trimToSize() {
            E[] old = this.elementData;
            this.elementData = new Object[this.size];
            System.arraycopy(old, 0, this.elementData, 0, this.size);
        }

        public int hashCode() {
            int hashCode = 0;
            for (int i = 0; i < this.size; ++i) {
                hashCode = 31 * hashCode + (this.elementData[i] == null ? 0 : this.elementData[i].hashCode());
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof InnerList)) {
                return false;
            }
            InnerList that = (InnerList)obj;
            boolean isEqual = this.size == that.size;
            for (int i = 0; i < this.size; ++i) {
                boolean bl = this.elementData[i] == null ? that.elementData[i] == null : (isEqual = this.elementData[i].equals(that.elementData[i]));
                if (isEqual) continue;
                return false;
            }
            return isEqual;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < this.size; ++i) {
                if (i != 0) {
                    str.append(this.split);
                }
                if (this.elementData[i] == null) continue;
                str.append(this.elementData[i]);
            }
            return str.toString();
        }
    }
}

