/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizunit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.RelationManager;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.metadata.AbstractMetaDataCtrl;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizrule.ConditionRuleCollection;
import com.kingdee.bos.metadata.bizrule.ConditionRuleInfo;
import com.kingdee.bos.metadata.bizrule.RuleSetInfo;
import com.kingdee.bos.metadata.bizrule.common.RuleCollection;
import com.kingdee.bos.metadata.bizunit.BIMException;
import com.kingdee.bos.metadata.bizunit.BIMNameFactory;
import com.kingdee.bos.metadata.bizunit.BizComponentInfo;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizFieldViewInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizMethodCollection;
import com.kingdee.bos.metadata.bizunit.BizMethodInfo;
import com.kingdee.bos.metadata.bizunit.BizType;
import com.kingdee.bos.metadata.bizunit.BizUnitHelper;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.DataSourceType;
import com.kingdee.bos.metadata.bizunit.HorizontalAlignmentType;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.bizunit.ViewType;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.bizunit.proxy.EditUIFunctionProxy;
import com.kingdee.bos.metadata.bizunit.proxy.EditUIProxy;
import com.kingdee.bos.metadata.bizunit.proxy.EntityExtProxy;
import com.kingdee.bos.metadata.bizunit.proxy.EntityFunctionProxy;
import com.kingdee.bos.metadata.bizunit.proxy.EntityProxy;
import com.kingdee.bos.metadata.bizunit.proxy.ListUIFunctionProxy;
import com.kingdee.bos.metadata.bizunit.proxy.ListUIProxy;
import com.kingdee.bos.metadata.bizunit.proxy.QueryProxy;
import com.kingdee.bos.metadata.bizunit.proxy.RuleSetProxy;
import com.kingdee.bos.metadata.bizunit.proxy.TableEditUIProxy;
import com.kingdee.bos.metadata.bizunit.proxy.TableExtProxy;
import com.kingdee.bos.metadata.bizunit.proxy.TableProxy;
import com.kingdee.bos.metadata.bizunit.proxy.WebEditUIProxy;
import com.kingdee.bos.metadata.bizunit.proxy.WebListUIProxy;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.bo.SubClassingMode;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.DataTableCollection;
import com.kingdee.bos.metadata.data.DataTableCtrl;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.ForeignKeyCollection;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectCtrl;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.event.EventCollection;
import com.kingdee.bos.metadata.event.EventInfo;
import com.kingdee.bos.metadata.event.EventMethodCollection;
import com.kingdee.bos.metadata.event.EventMethodInfo;
import com.kingdee.bos.metadata.event.FormalParameterCollection;
import com.kingdee.bos.metadata.event.FormalParameterInfo;
import com.kingdee.bos.metadata.function.FunctionObjectCtrl;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.management.DeployOptionInfo;
import com.kingdee.bos.metadata.management.SolutionCtrl;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.management.SuffixCollection;
import com.kingdee.bos.metadata.management.SuffixInfo;
import com.kingdee.bos.metadata.mr.Ref;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinQueryCtrl;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.resource.BizEnumCtrl;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ActionCollection;
import com.kingdee.bos.metadata.ui.ActionExtendPropertyHelper;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.EventBindingCollection;
import com.kingdee.bos.metadata.ui.EventBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectAssembler;
import com.kingdee.bos.metadata.ui.UIObjectCollection;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.metadata.util.MetadataUDFUpdater;
import com.kingdee.bos.metadata.webpage.WebPageObjectCollection;
import com.kingdee.bos.metadata.webpage.WebPageObjectCtrl;
import com.kingdee.bos.metadata.webpage.WebPageObjectInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectCtrl;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.metadata.webui.transfer.Component2XmlHelper;
import com.kingdee.bos.ui.bizunitproxy.EditUIProxyHelper;
import com.kingdee.bos.ui.bizunitproxy.UIProxyHelper;
import com.kingdee.bos.ui.bizunitproxy.WebUIProxyHelper;
import com.kingdee.bos.ui.dtp.kdlayout.KDLayoutConstraint;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractBizUnitCtrl
extends AbstractMetaDataCtrl {
    private static final Logger log = Logger.getLogger((String)"com.kingdee.bos.metadata.bizunit.AbstractBizUnitCtrl");
    private Project depend = null;

    public AbstractBizUnitCtrl(Context ctx) {
        super(ctx);
        new EntityObjectCtrl(ctx);
        new UIObjectCtrl(ctx);
    }

    public AbstractBizUnitCtrl() {
    }

    protected void extractTableColumns(DataTableInfo table, BizFieldCollection fields) throws BIMException {
        if (table == null) {
            return;
        }
    }

    protected void extractQueryFields(JoinQueryInfo query, BizFieldCollection bizFields, EntityObjectInfo mainEntity) throws BIMException {
        if (query == null) {
            return;
        }
        ArrayList<QueryFieldInfo> list = query.getSelector().getFields();
        for (int i = 0; i < list.size(); ++i) {
            QueryFieldInfo field = list.get(i);
            BizFieldInfo bizField = this.getFieldForQuery(mainEntity, field, bizFields);
            if (bizField == null || !StringUtils.isEmpty((String)bizField.getQueryFieldName())) continue;
            bizField.setQueryFieldName(field.getName());
            AbstractBizUnitCtrl.copyExtendedProperties(field, bizField);
        }
    }

    protected BizFieldInfo getFieldForQuery(EntityObjectInfo entity, QueryFieldInfo queryField, BizFieldCollection bizFields) {
        BizFieldInfo bizField;
        int i;
        int n;
        if (queryField.getPropertyRefs() != null && queryField.getPropertyRefs().size() == 0) {
            return null;
        }
        PropertyRefInfo pri = queryField.getPropertyRefs().get(0);
        SubObjectInfo soi = pri.getSubEntity();
        if (soi == null) {
            soi = pri.getSubQuery();
        }
        String refObjectName = soi.getRealName();
        String refPropertyName = pri.getRefProperty() != null ? pri.getRefProperty().getRealName() : pri.getRefUnit().getRealName();
        refPropertyName = AbstractBizUnitCtrl.getLastName(refPropertyName);
        BizFieldCollection fields = null;
        if (entity.getRealName().equalsIgnoreCase(refObjectName)) {
            fields = bizFields;
        } else {
            n = bizFields.size();
            for (i = 0; i < n; ++i) {
                bizField = bizFields.get(i);
                if (bizField.getDataSource() != null && bizField.getName().equalsIgnoreCase(refObjectName)) {
                    return bizField;
                }
                if (!(bizField instanceof BizGroupFieldInfo)) continue;
                BizGroupFieldInfo groupField = (BizGroupFieldInfo)bizField;
                if (groupField.getEntityObject() != null && groupField.getName().equalsIgnoreCase(refObjectName)) {
                    fields = groupField.getFields();
                    break;
                }
                BizFieldCollection subFields = groupField.getFields();
                int m = subFields.size();
                for (int j = 0; j < m; ++j) {
                    bizField = subFields.get(j);
                    if (bizField.getDataSource() == null || !(groupField.getName() + "_" + bizField.getName()).equals(refObjectName)) continue;
                    return bizField;
                }
            }
        }
        if (fields != null) {
            n = fields.size();
            for (i = 0; i < n; ++i) {
                bizField = fields.get(i);
                if (!refPropertyName.equalsIgnoreCase(bizField.getPropertyName())) continue;
                return bizField;
            }
        }
        return null;
    }

    public static String getLastName(String fullName) {
        if (StringUtils.isEmpty((String)fullName)) {
            return "";
        }
        int pos = fullName.lastIndexOf(".");
        if (pos > 0) {
            return fullName.substring(pos + 1);
        }
        return fullName;
    }

    public static ComponentCollection treeToCol(ComponentCollection components) {
        ComponentCollection col = new ComponentCollection();
        int n = components.size();
        for (int i = 0; i < n; ++i) {
            AbstractBizUnitCtrl.addToCol(components.get(i), col);
        }
        return col;
    }

    protected static void addToCol(ComponentInfo info, ComponentCollection col) {
        col.add(info);
        int n = info.getComponents().size();
        for (int i = 0; i < n; ++i) {
            AbstractBizUnitCtrl.addToCol(info.getComponents().get(i), col);
        }
    }

    private void preparePropBindings(PropertyBindingCollection propBindings) {
        if (propBindings == null || propBindings.size() <= 1) {
            return;
        }
        int n = propBindings.size();
        for (int i = 0; i < n; ++i) {
            PropertyBindingInfo propBinding = propBindings.get(i);
            String bindFieldName = propBinding.getBingdingField();
            if (bindFieldName.indexOf(".") < 0) continue;
            if (i == 0) {
                return;
            }
            propBindings.swap(0, i);
            return;
        }
    }

    private BizEnumInfo getEnumType(ComponentInfo component) {
        String itemsValue;
        PropertyInfo property;
        if (component == null) {
            return null;
        }
        if ("com.kingdee.bos.ctrl.swing.KDComboBox".equalsIgnoreCase(component.getClassType()) && (property = component.getPropertyByName("items")) != null && !StringUtils.isEmpty((String)(itemsValue = property.getValue())) && itemsValue.startsWith("[Enum]")) {
            String pk = itemsValue.substring("[Enum]".length());
            try {
                BizEnumInfo enumInfo = new BizEnumCtrl(this.getContext()).getValue(MetaDataPK.create(pk));
                return enumInfo;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private static boolean isToolBarItemOrMenuBarItem(ComponentInfo component) {
        for (ComponentInfo parent = component; parent != null; parent = parent.getParent()) {
            if (parent.getClassType() == null || !parent.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDToolBar") && !parent.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDMenuBar")) continue;
            return true;
        }
        return false;
    }

    public void extractTableEditUIControls(UIObjectInfo editUI, BizFieldCollection bizFields, EntityObjectInfo entity, BizFieldInfo parentPanel) throws BIMException {
        PropertyInfo property;
        if (editUI == null) {
            return;
        }
        ComponentInfo tblMain = UIProxyHelper.findControlByName(editUI, "tblMain");
        if (tblMain != null && (property = tblMain.getProperties().get("formatXml")) != null) {
            TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom(property.getValue());
            List columns = tableInfo.getColumns();
            if (tableInfo.getHeaders().size() > 0) {
                HeaderInfo header = (HeaderInfo)tableInfo.getHeaders().get(0);
                ColumnInfo column = null;
                String propertyName = null;
                String bindFieldName = null;
                BizFieldInfo subField = null;
                int m = columns.size();
                for (int j = 0; j < m; ++j) {
                    column = (ColumnInfo)columns.get(j);
                    propertyName = column.getName();
                    bindFieldName = AbstractBizUnitCtrl.getBindFieldName(tblMain.getPropertyBindings(), propertyName + ".text");
                    if (StringUtils.isEmpty((String)bindFieldName) || "id".equalsIgnoreCase(bindFieldName)) continue;
                    subField = this.getFieldByPropertyName(bizFields, bindFieldName);
                    if (subField != null) {
                        subField.setControlName(propertyName);
                        subField.getFieldView().setViewType(ViewType.TABLECOLUMN);
                        continue;
                    }
                    int index = tableInfo.getColumns().indexOf(column);
                    subField = new BizFieldInfo();
                    subField.setName(propertyName);
                    subField.setAlias(((CellInfo)header.getCells().get(index)).getName());
                    subField.getFieldView().setWidth(column.getWidth());
                    subField.getFieldView().setVisible(!column.isHide());
                    subField.getFieldView().setEnable(!column.isLock());
                    subField.getFieldView().setTabIndex(index);
                    subField.setPersistence(false);
                    subField.setControlName(propertyName);
                    subField.getFieldView().setViewType(ViewType.TABLECOLUMN);
                    subField.setBizDataType(BizDataType.STRING);
                    subField.setUserDefined(true);
                    bizFields.add(subField);
                }
            }
        }
    }

    private static boolean isIgnoredComponent(ComponentInfo component) {
        String classType = component.getClassType();
        ViewType viewType = AbstractBizUnitCtrl.getViewType(classType);
        if (viewType == null || component.getParent() == null) {
            return true;
        }
        if (component.getParent().getName().equalsIgnoreCase("CoreUI_toolbar")) {
            return true;
        }
        return "com.kingdee.bos.ctrl.swing.KDLabelContainer".equalsIgnoreCase(classType) ? component.getComponents().size() > 0 : ("com.kingdee.bos.ctrl.swing.KDButtonGroup".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDSeparator".equalsIgnoreCase(classType) ? AbstractBizUnitCtrl.isToolBarItemOrMenuBarItem(component) : "com.kingdee.bos.ctrl.swing.KDMenu".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDRadioButtonMenuItem".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDCheckBoxMenuItem".equalsIgnoreCase(classType) || "javax.swing.JPopupMenu.Separator".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDToolButton".equalsIgnoreCase(classType));
    }

    public BizComponentInfo extractWebEditUIControls(WebUIObjectInfo editUI, BizFieldCollection bizFields, EntityObjectInfo entity, BizUnitInfo unit) {
        if (editUI == null) {
            return null;
        }
        ComponentInfo main = editUI.getMainPanelComponent();
        if (main != null) {
            DataObjectCollection dataObjects = editUI.getDataObjects();
            if (dataObjects == null || dataObjects.size() == 0) {
                log.info((Object)("[extractWebEditUIControls] found " + editUI.getRealFullName() + "'s dataobject is null."));
            }
            String bindEntityName = null;
            int n = dataObjects.size();
            for (int i = 0; i < n; ++i) {
                DataObjectInfo dataObject = dataObjects.get(i);
                String queryPK = entity.getRealPackage();
                queryPK = StringUtils.isEmpty((String)queryPK) ? entity.getRealName() : queryPK + "." + entity.getRealName();
                if (!queryPK.equals(dataObject.getType())) continue;
                bindEntityName = dataObject.getRealName();
                break;
            }
            BizComponentInfo bizMain = this.buildBizComponentInfo4Web(bindEntityName, bizFields, entity, main);
            int n2 = bizFields.size();
            for (int i = 0; i < n2; ++i) {
                if (!(bizFields.get(i) instanceof BizGroupFieldInfo)) continue;
                BizGroupFieldInfo groupField = (BizGroupFieldInfo)bizFields.get(i);
                AbstractBizUnitCtrl.addBizFieldRules(groupField);
            }
            unit.setWEBDesignerModel(bizMain);
            return bizMain;
        }
        return null;
    }

    private BizComponentInfo buildBizComponentInfo4Web(String bindEntityName, BizFieldCollection bizFields, EntityObjectInfo entity, ComponentInfo parent) {
        BizFieldInfo bizField = null;
        if (!StringUtils.isEmpty((String)bindEntityName)) {
            PropertyBindingCollection propBindings = parent.getPropertyBindings();
            this.preparePropBindings(propBindings);
            int m = propBindings.size();
            for (int j = 0; j < m; ++j) {
                String bindFieldName;
                PropertyBindingInfo propBinding = propBindings.get(j);
                if (!bindEntityName.equalsIgnoreCase(propBinding.getBindingObject()) || StringUtils.isEmpty((String)(bindFieldName = propBinding.getBingdingField())) || (bizField = this.getFieldByPropertyName(bizFields, bindFieldName)) == null || bizField.getDataSource() == null || !StringUtils.isEmpty((String)bizField.getDataField()) || bindFieldName.indexOf(".") < 0) continue;
                bizField.setDataField(bindFieldName.substring(bindFieldName.lastIndexOf(".") + 1));
            }
        }
        if (bizField == null && (parent.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.web.DataGrid") || parent.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.web.EditDataGrid")) && (bizField = this.getGroupFieldByComponent4Web(bizFields, parent)) == null) {
            bizField = new BizGroupFieldInfo();
            bizField.setName(parent.getName());
            bizField.setPersistence(false);
            bizFields.add(bizField);
        }
        AbstractBizUnitCtrl.setBizFieldView4Web(bizField, parent);
        BizComponentInfo bizParent = new BizComponentInfo(bizField, parent);
        Iterator iter = parent.getComponents().iterator();
        while (iter.hasNext()) {
            ComponentInfo child = (ComponentInfo)iter.next();
            BizComponentInfo bizChild = this.buildBizComponentInfo4Web(bindEntityName, bizFields, entity, child);
            bizParent.getBizComponents().add(bizChild);
        }
        return bizParent;
    }

    private BizGroupFieldInfo getGroupFieldByComponent4Web(BizFieldCollection bizFields, ComponentInfo datagrid) {
        ComponentCollection col = datagrid.getComponents();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            ComponentInfo child = col.get(i);
            if (!"com.kingdee.bos.ctrl.web.Column".equals(child.getClassType()) && !"com.kingdee.bos.ctrl.web.EditableColumn".equals(child.getClassType())) continue;
            PropertyBindingCollection propBindings = child.getPropertyBindings();
            this.preparePropBindings(propBindings);
            BizGroupFieldInfo groupField = null;
            int m = propBindings.size();
            for (int j = 0; j < m; ++j) {
                PropertyBindingInfo propBinding = propBindings.get(j);
                String bindFieldName = propBinding.getBingdingField();
                if (StringUtils.isEmpty((String)bindFieldName) || (groupField = this.getGroupFieldByPropertyName(bizFields, bindFieldName)) == null) continue;
                return groupField;
            }
        }
        return null;
    }

    protected void extractWebListUIItems(WebUIObjectInfo listUI, BizFieldCollection bizFields, JoinQueryInfo mainQuery, BizUnitInfo bizUnit) throws BIMException {
        if (listUI == null) {
            return;
        }
        this.extractWebListUIItems(listUI, bizFields, mainQuery);
    }

    private void extractWebListUIItems(WebUIObjectInfo listUI, BizFieldCollection bizFields, JoinQueryInfo query) {
        if (listUI == null || query == null) {
            return;
        }
        DataObjectInfo dataObject = UIProxyHelper.findDataObjectByType(listUI, query.getRealFullName());
        if (dataObject == null) {
            return;
        }
        String bindQueryName = dataObject.getRealName();
        ComponentInfo kdTable = UIProxyHelper.findDataGridByDataObject(listUI, dataObject);
        if (kdTable != null && bindQueryName != null) {
            ComponentCollection col = kdTable.getComponents();
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                ComponentInfo cInfo = col.get(i);
                PropertyBindingCollection propertyBindings = cInfo.getPropertyBindings();
                int size = propertyBindings.size();
                for (int j = 0; j < size; ++j) {
                    BizFieldInfo bizField;
                    PropertyBindingInfo pbInfo = propertyBindings.get(j);
                    if (!bindQueryName.equalsIgnoreCase(pbInfo.getBindingObject()) || (bizField = this.getFieldByQueryFieldName(bizFields, pbInfo.getBingdingField())) == null) continue;
                    bizField.setWebListItemName(cInfo.getName());
                    PropertyInfo hidden = cInfo.getPropertyByName("hidden");
                    if (hidden != null) {
                        bizField.getFieldView().setWebListVisible(Boolean.valueOf(hidden.getValue()) == false);
                    } else {
                        bizField.getFieldView().setWebListVisible(true);
                    }
                    PropertyInfo header = cInfo.getPropertyByName("header");
                    if (header == null) continue;
                    bizField.setWebListLabelText(header.getValue());
                }
            }
        }
    }

    public BizComponentInfo extractGUIEditUIControls(UIObjectInfo editUI, BizFieldCollection bizFields, EntityObjectInfo entity, BizUnitInfo unit) {
        if (editUI == null) {
            return null;
        }
        ComponentInfo main = editUI.getMainPanelComponent();
        if (main != null) {
            int i;
            DataObjectCollection dataObjects = editUI.getDataObjects();
            if (dataObjects == null || dataObjects.size() == 0) {
                log.info((Object)("[extractGUIEditUIControls] found " + editUI.getRealFullName() + "'s dataobject is null."));
            }
            String bindEntityName = null;
            int n = dataObjects.size();
            for (int i2 = 0; i2 < n; ++i2) {
                DataObjectInfo dataObject = dataObjects.get(i2);
                String queryPK = entity.getRealPackage();
                queryPK = StringUtils.isEmpty((String)queryPK) ? entity.getRealName() : queryPK + "." + entity.getRealName();
                if (!queryPK.equals(dataObject.getType())) continue;
                bindEntityName = dataObject.getRealName();
                break;
            }
            BizComponentInfo bizMain = this.buildBizComponentInfo4GUI(bindEntityName, bizFields, entity, main);
            ComponentCollection components = AbstractBizUnitCtrl.treeToCol(main.getComponents());
            int n2 = bizFields.size();
            for (i = 0; i < n2; ++i) {
                bizFields.get(i).setGenControl(bizFields.get(i).hasControl());
                if (!(bizFields.get(i) instanceof BizGroupFieldInfo)) continue;
                BizGroupFieldInfo groupField = (BizGroupFieldInfo)bizFields.get(i);
                AbstractBizUnitCtrl.setKDTableFieldView(groupField, components, entity);
            }
            n2 = bizFields.size();
            for (i = 0; i < n2; ++i) {
                if (!(bizFields.get(i) instanceof BizGroupFieldInfo)) continue;
                BizGroupFieldInfo groupField = (BizGroupFieldInfo)bizFields.get(i);
                AbstractBizUnitCtrl.addBizFieldRules(groupField);
            }
            unit.setGUIDesignerModel(bizMain);
            return bizMain;
        }
        return null;
    }

    private BizComponentInfo buildBizComponentInfo4GUI(String bindEntityName, BizFieldCollection bizFields, EntityObjectInfo entity, ComponentInfo parent) {
        BizEnumInfo enumInfo;
        PropertyInfo property;
        int j;
        int m;
        BizFieldInfo bizField = null;
        if (!StringUtils.isEmpty((String)bindEntityName)) {
            PropertyBindingCollection propBindings = parent.getPropertyBindings();
            this.preparePropBindings(propBindings);
            m = propBindings.size();
            for (j = 0; j < m; ++j) {
                String bindFieldName;
                PropertyBindingInfo propBinding = propBindings.get(j);
                if (!bindEntityName.equalsIgnoreCase(propBinding.getBindingObject()) || StringUtils.isEmpty((String)(bindFieldName = propBinding.getBingdingField()))) continue;
                BizGroupFieldInfo groupField = this.getGroupFieldByPropertyName(bizFields, bindFieldName);
                if (groupField != null) {
                    bizField = groupField;
                    break;
                }
                bizField = this.getFieldByPropertyName(bizFields, bindFieldName);
                if (bizField == null || bizField.getDataSource() == null || !StringUtils.isEmpty((String)bizField.getDataField()) || bindFieldName.indexOf(".") < 0) continue;
                bizField.setDataField(bindFieldName.substring(bindFieldName.lastIndexOf(".") + 1));
            }
        }
        if (bizField != null && bizField instanceof BizGroupFieldInfo && parent.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.kdf.table.KDTable") && (property = parent.getProperties().get("formatXml")) != null) {
            TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom(property.getValue());
            List columns = tableInfo.getColumns();
            if (tableInfo.getHeaders().size() > 0) {
                HeaderInfo header = (HeaderInfo)tableInfo.getHeaders().get(0);
                ColumnInfo column = null;
                String propertyName = null;
                String bindFieldName = null;
                BizFieldInfo subField = null;
                int m2 = columns.size();
                for (int j2 = 0; j2 < m2; ++j2) {
                    column = (ColumnInfo)columns.get(j2);
                    propertyName = column.getName();
                    bindFieldName = AbstractBizUnitCtrl.getBindFieldName(parent.getPropertyBindings(), propertyName + ".text");
                    if (StringUtils.isEmpty((String)bindFieldName)) continue;
                    int dotPos = bindFieldName.indexOf(".");
                    int lastDotPos = bindFieldName.lastIndexOf(".");
                    if (dotPos <= 0 || "id".equalsIgnoreCase(bindFieldName.substring(lastDotPos + 1))) continue;
                    subField = this.getFieldByPropertyName(((BizGroupFieldInfo)bizField).getFields(), bindFieldName.substring(dotPos + 1));
                    int index = tableInfo.getColumns().indexOf(column);
                    if (subField != null) {
                        subField.setControlName(propertyName);
                        subField.setEditLabelText(((CellInfo)header.getCells().get(index)).getName());
                        subField.getFieldView().setViewType(ViewType.TABLECOLUMN);
                        continue;
                    }
                    subField = new BizFieldInfo();
                    subField.setName(propertyName);
                    subField.setAlias(((CellInfo)header.getCells().get(index)).getName());
                    subField.getFieldView().setWidth(column.getWidth());
                    subField.getFieldView().setVisible(!column.isHide());
                    subField.getFieldView().setEnable(!column.isLock());
                    subField.getFieldView().setTabIndex(index);
                    subField.setPersistence(false);
                    subField.setControlName(propertyName);
                    subField.getFieldView().setViewType(ViewType.TABLECOLUMN);
                    subField.setBizDataType(BizDataType.STRING);
                    subField.setUserDefined(true);
                    ((BizGroupFieldInfo)bizField).getFields().add(subField);
                }
            }
        }
        if (bizField == null && (enumInfo = this.getEnumType(parent)) != null) {
            bizField = new BizFieldInfo();
            String controlName = parent.getName();
            bizField.setName(controlName);
            bizField.setBizDataType(BizDataType.ENUM);
            bizField.setEnumType(enumInfo);
            bizField.setDataSourceType(DataSourceType.ENUMLIST);
            bizField.setPersistence(false);
            bizField.setUserDefined(parent.isUserDefined());
            bizField.setAlias(bizField.getFieldView().getDisplayText());
            bizFields.add(bizField);
        }
        if (bizField != null && parent.getRules() != null) {
            RuleCollection rules = parent.getRules();
            m = rules.size();
            for (j = 0; j < m; ++j) {
                if (!(rules.get(j) instanceof ConditionRuleInfo)) continue;
                bizField.getConditionRules().add((ConditionRuleInfo)rules.get(j));
            }
        }
        AbstractBizUnitCtrl.setBizFieldView(bizField, parent);
        BizComponentInfo bizParent = new BizComponentInfo(bizField, parent);
        Iterator iter = parent.getComponents().iterator();
        while (iter.hasNext()) {
            ComponentInfo child = (ComponentInfo)iter.next();
            BizComponentInfo bizChild = this.buildBizComponentInfo4GUI(bindEntityName, bizFields, entity, child);
            bizParent.getBizComponents().add(bizChild);
        }
        return bizParent;
    }

    public static void setBizFieldView(BizFieldInfo bizField, ComponentInfo control) {
        if (bizField == null || control == null) {
            return;
        }
        bizField.setControlName(control.getName());
        PropertyInfo prop = control.getPropertyByName("queryInfo");
        if (prop != null) {
            bizField.getFieldView().setF7QueryPK(prop.getValue());
        }
        if ((prop = control.getPropertyByName("required")) == null || !"true".equals(prop.getValue())) {
            control.removeExtendedProperty("requiredPrompt");
        }
        bizField.getFieldView().setTabIndex(control.getTabIndex());
        if (!BizDataType.ENUM.equals((Object)bizField.getBizDataType()) && !BizDataType.OBJECT.equals((Object)bizField.getBizDataType()) && (prop = control.getPropertyByName("text")) != null && prop.getValue() != null) {
            bizField.setDefaultValue(prop.getValue());
        }
    }

    public static void setBizFieldView4Web(BizFieldInfo bizField, ComponentInfo control) {
        if (bizField == null || control == null) {
            return;
        }
        bizField.setWebControlName(control.getName());
    }

    public void extractEditUIControls(UIObjectInfo editUI, BizFieldCollection bizFields, EntityObjectInfo entity, BizFieldInfo parentPanel) throws BIMException {
        int i;
        if (editUI == null) {
            return;
        }
        DataObjectCollection dataObjects = editUI.getDataObjects();
        String bindEntityName = null;
        int n = dataObjects.size();
        for (int i2 = 0; i2 < n; ++i2) {
            DataObjectInfo dataObject = dataObjects.get(i2);
            String queryPK = entity.getRealPackage();
            queryPK = StringUtils.isEmpty((String)queryPK) ? entity.getRealName() : queryPK + "." + entity.getRealName();
            if (!queryPK.equals(dataObject.getType())) continue;
            bindEntityName = dataObject.getRealName();
            break;
        }
        ComponentCollection components = AbstractBizUnitCtrl.treeToCol(editUI.getComponents());
        ComponentInfo component = null;
        int n2 = components.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            String uiObjectPK;
            PropertyInfo property;
            int j;
            int m;
            component = components.get(i3);
            String classType = component.getClassType();
            if (AbstractBizUnitCtrl.isIgnoredComponent(component) || parentPanel != null && !"com.kingdee.bos.ctrl.kdf.table.KDTable".equalsIgnoreCase(classType) || ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equalsIgnoreCase(classType) ? component.getComponents().size() > 0 : ("com.kingdee.bos.ctrl.swing.KDButtonGroup".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDSeparator".equalsIgnoreCase(classType) ? AbstractBizUnitCtrl.isToolBarItemOrMenuBarItem(component) : ("com.kingdee.bos.ctrl.swing.KDScrollPane".equalsIgnoreCase(classType) ? component.getParent() != null && "com.kingdee.bos.ctrl.swing.KDLabelContainer".equalsIgnoreCase(component.getParent().getClassType()) : "com.kingdee.bos.ctrl.swing.KDMenu".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDMenuItem".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDRadioButtonMenuItem".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDCheckBoxMenuItem".equalsIgnoreCase(classType) || "javax.swing.JPopupMenu.Separator".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDToolButton".equalsIgnoreCase(classType))))) continue;
            BizFieldInfo bizField = null;
            if (!StringUtils.isEmpty((String)bindEntityName)) {
                PropertyBindingCollection propBindings = component.getPropertyBindings();
                this.preparePropBindings(propBindings);
                m = propBindings.size();
                for (j = 0; j < m; ++j) {
                    String bindFieldName;
                    PropertyBindingInfo propBinding = propBindings.get(j);
                    if (!bindEntityName.equalsIgnoreCase(propBinding.getBindingObject()) || StringUtils.isEmpty((String)(bindFieldName = propBinding.getBingdingField()))) continue;
                    BizGroupFieldInfo groupField = this.getGroupFieldByPropertyName(bizFields, bindFieldName);
                    if (groupField != null) {
                        bizField = groupField;
                        AbstractBizUnitCtrl.setBizFieldView(bizField, component, bizFields, editUI);
                        BizFieldInfo subField = this.getFieldByPropertyName(bizFields, bindFieldName);
                        if (subField != null && !(subField instanceof BizGroupFieldInfo)) {
                            subField.setControlName(StringUtils.replace((String)propBinding.getPropertyName(), (String)".text", (String)""));
                            subField.getFieldView().setViewType(ViewType.TABLECOLUMN);
                        }
                        if (parentPanel == null) continue;
                        bizField.setParent(parentPanel);
                        bizField.getFieldView().setLeft(0);
                        bizField.getFieldView().setTop(0);
                        bizField.getFieldView().setWidth(parentPanel.getFieldView().getWidth());
                        bizField.getFieldView().setHeight(parentPanel.getFieldView().getHeight());
                        bizField.setControlName(component.getName());
                        parentPanel.setAlias(bizField.getAlias());
                        continue;
                    }
                    bizField = this.getFieldByPropertyName(bizFields, bindFieldName);
                    if (bizField == null) continue;
                    if (bizField.getDataSource() != null) {
                        if (!StringUtils.isEmpty((String)bizField.getControlName())) {
                            bizField = null;
                            continue;
                        }
                        bizField.setControlName(component.getName());
                        if (StringUtils.isEmpty((String)bizField.getDataField()) && bindFieldName.indexOf(".") >= 0) {
                            bizField.setDataField(bindFieldName.substring(bindFieldName.lastIndexOf(".") + 1));
                        }
                        AbstractBizUnitCtrl.setBizFieldView(bizField, component, bizFields, editUI);
                        continue;
                    }
                    if (!StringUtils.isEmpty((String)bizField.getControlName())) continue;
                    AbstractBizUnitCtrl.setBizFieldView(bizField, component, bizFields, editUI);
                }
            }
            if (bizField != null && bizField instanceof BizGroupFieldInfo && "com.kingdee.bos.ctrl.kdf.table.KDTable".equalsIgnoreCase(classType) && (property = component.getProperties().get("formatXml")) != null) {
                TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom(property.getValue());
                List columns = tableInfo.getColumns();
                if (tableInfo.getHeaders().size() > 0) {
                    HeaderInfo header = (HeaderInfo)tableInfo.getHeaders().get(0);
                    ColumnInfo column = null;
                    String propertyName = null;
                    String bindFieldName = null;
                    BizFieldInfo subField = null;
                    int m2 = columns.size();
                    for (int j2 = 0; j2 < m2; ++j2) {
                        column = (ColumnInfo)columns.get(j2);
                        propertyName = column.getName();
                        bindFieldName = AbstractBizUnitCtrl.getBindFieldName(component.getPropertyBindings(), propertyName + ".text");
                        if (StringUtils.isEmpty((String)bindFieldName)) continue;
                        int dotPos = bindFieldName.indexOf(".");
                        int lastDotPos = bindFieldName.lastIndexOf(".");
                        if (dotPos <= 0 || "id".equalsIgnoreCase(bindFieldName.substring(lastDotPos + 1)) || (subField = this.getFieldByPropertyName(((BizGroupFieldInfo)bizField).getFields(), bindFieldName.substring(dotPos + 1))) != null) continue;
                        int index = tableInfo.getColumns().indexOf(column);
                        subField = new BizFieldInfo();
                        subField.setName(propertyName);
                        subField.setAlias(((CellInfo)header.getCells().get(index)).getName());
                        subField.getFieldView().setWidth(column.getWidth());
                        subField.getFieldView().setVisible(!column.isHide());
                        subField.getFieldView().setEnable(!column.isLock());
                        subField.getFieldView().setTabIndex(index);
                        subField.setPersistence(false);
                        subField.setControlName(propertyName);
                        subField.getFieldView().setViewType(ViewType.TABLECOLUMN);
                        subField.setBizDataType(BizDataType.STRING);
                        subField.setUserDefined(true);
                        ((BizGroupFieldInfo)bizField).getFields().add(subField);
                    }
                }
            }
            if (bizField == null) {
                if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equalsIgnoreCase(classType)) {
                    String groupFieldName = component.getName();
                    if (groupFieldName.length() > 3 && groupFieldName.substring(0, 3).equalsIgnoreCase("kdt")) {
                        groupFieldName = groupFieldName.substring(3);
                        bizField = this.getFieldByPropertyName(bizFields, groupFieldName);
                    }
                    if (bizField != null) {
                        AbstractBizUnitCtrl.setBizFieldView(bizField, component, bizFields, editUI);
                    } else {
                        bizField = new BizGroupFieldInfo();
                        bizField.setName(component.getName());
                        bizField.setPersistence(false);
                        AbstractBizUnitCtrl.setBizFieldView(bizField, component, bizFields, editUI);
                        bizFields.add(bizField);
                    }
                    if (parentPanel != null) {
                        bizField.setParent(parentPanel);
                        bizField.getFieldView().setLeft(0);
                        bizField.getFieldView().setTop(0);
                        bizField.getFieldView().setWidth(parentPanel.getFieldView().getWidth());
                        bizField.getFieldView().setHeight(parentPanel.getFieldView().getHeight());
                    }
                } else {
                    bizField = new BizFieldInfo();
                    String controlName = component.getName();
                    bizField.setName(controlName);
                    BizEnumInfo enumInfo = this.getEnumType(component);
                    if (enumInfo != null) {
                        bizField.setBizDataType(BizDataType.ENUM);
                        bizField.setEnumType(enumInfo);
                        bizField.setDataSourceType(DataSourceType.ENUMLIST);
                    }
                    bizField.setPersistence(false);
                    AbstractBizUnitCtrl.setBizFieldView(bizField, component, bizFields, editUI);
                    bizField.setUserDefined(component.isUserDefined());
                    bizField.setAlias(bizField.getFieldView().getDisplayText());
                    bizFields.add(bizField);
                }
            }
            if (bizField != null && component.getRules() != null) {
                RuleCollection rules = component.getRules();
                m = rules.size();
                for (j = 0; j < m; ++j) {
                    if (!(rules.get(j) instanceof ConditionRuleInfo)) continue;
                    bizField.getConditionRules().add((ConditionRuleInfo)rules.get(j));
                }
            }
            if (bizField == null || bizField.getFieldView().getViewType() != ViewType.PANEL || StringUtils.isEmpty((String)(uiObjectPK = component.getBimUIObjectPK()))) continue;
            Context ctx = this.getContext();
            UIObjectCtrl uiCtrl = new UIObjectCtrl(ctx);
            UIObjectInfo entryUI = null;
            try {
                entryUI = uiCtrl.getAllValue(MetaDataPK.create(uiObjectPK));
                if (entryUI == null) continue;
                bizField.setUIObject(entryUI);
                this.extractEditUIControls(entryUI, bizFields, entity, bizField);
                continue;
            }
            catch (BOSException e) {
                throw new BIMException(e);
            }
        }
        int n3 = bizFields.size();
        for (i = 0; i < n3; ++i) {
            bizFields.get(i).setGenControl(bizFields.get(i).hasControl());
            if (!(bizFields.get(i) instanceof BizGroupFieldInfo)) continue;
            BizGroupFieldInfo groupField = (BizGroupFieldInfo)bizFields.get(i);
            AbstractBizUnitCtrl.setKDTableFieldView(groupField, components, entity);
        }
        n3 = bizFields.size();
        for (i = 0; i < n3; ++i) {
            if (!(bizFields.get(i) instanceof BizGroupFieldInfo)) continue;
            BizGroupFieldInfo groupField = (BizGroupFieldInfo)bizFields.get(i);
            AbstractBizUnitCtrl.addBizFieldRules(groupField);
        }
    }

    private static void setKDTableFieldView(BizGroupFieldInfo groupField, ComponentCollection components, EntityObjectInfo entity) {
        BizFieldCollection subFields = groupField.getFields();
        ComponentInfo control = components.getComponentInfo(groupField.getControlName());
        if (control != null) {
            int j;
            int m = subFields.size();
            for (j = 0; j < m; ++j) {
                if (subFields.get(j) instanceof BizGroupFieldInfo) {
                    AbstractBizUnitCtrl.setKDTableFieldView((BizGroupFieldInfo)subFields.get(j), components, entity);
                }
                String columnName = subFields.get(j).getControlName();
                AbstractBizUnitCtrl.setBizFieldView(subFields.get(j), control, columnName, entity);
                subFields.get(j).setGenControl(subFields.get(j).hasControl());
            }
            m = subFields.size();
            for (j = 0; j < m; ++j) {
                for (int k = j + 1; k < m; ++k) {
                    if (subFields.get(k).getFieldView().getTabIndex() >= subFields.get(j).getFieldView().getTabIndex()) continue;
                    subFields.swap(j, k);
                }
            }
        }
    }

    private static void addBizFieldRules(BizGroupFieldInfo groupField) {
        Hashtable<String, BizFieldInfo> hash = new Hashtable<String, BizFieldInfo>();
        int m = groupField.getFields().size();
        for (int j = 0; j < m; ++j) {
            hash.put(groupField.getFields().get(j).getName(), groupField.getFields().get(j));
        }
        ConditionRuleCollection rules = groupField.getConditionRules();
        for (int j = rules.size() - 1; j >= 0; --j) {
            String columnName = rules.get(j).getExtendedProperty("columnName");
            if (!StringUtils.isEmpty((String)columnName) && hash.containsKey(columnName)) {
                BizFieldInfo bizField = (BizFieldInfo)hash.get(columnName);
                bizField.getConditionRules().insertObject(-1, (IObjectValue)rules.get(j));
            }
            rules.removeObject(j);
        }
        int n = groupField.getFields().size();
        for (int i = 0; i < n; ++i) {
            if (!(groupField.getFields().get(i) instanceof BizGroupFieldInfo)) continue;
            AbstractBizUnitCtrl.addBizFieldRules((BizGroupFieldInfo)groupField.getFields().get(i));
        }
    }

    private static String getBindFieldName(PropertyBindingCollection propBindings, String propertyName) {
        int n = propBindings.size();
        for (int i = 0; i < n; ++i) {
            if (!propertyName.equalsIgnoreCase(propBindings.get(i).getPropertyName())) continue;
            return propBindings.get(i).getBingdingField();
        }
        return null;
    }

    public static void copyExtendedProperties(IObjectValue srcObj, IObjectValue desObj) {
        if (srcObj == null || desObj == null) {
            return;
        }
        Map extProps = srcObj.getExtendedProperties();
        for (Object key : extProps.keySet()) {
            String value;
            desObj.setExtendedProperty((String)key, (String)extProps.get(key));
            if (!"isVisibleForKDTable".equals(key) || !(desObj instanceof BizFieldInfo) || (value = srcObj.getExtendedProperty("isVisibleForKDTable")) == null) continue;
            ((BizFieldInfo)desObj).getFieldView().setListVisible(Boolean.valueOf(value));
        }
    }

    public static void setBizFieldView(BizFieldInfo bizField, ComponentInfo kdTable, String columnName, UIObjectInfo editUI) {
        PropertyInfo property = kdTable.getProperties().get("formatXml");
        if (property != null) {
            TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom(property.getValue());
            List columns = tableInfo.getColumns();
            int[] indexs = new int[]{-1};
            UIProxyHelper.getInstance();
            ColumnInfo column = UIProxyHelper.findColumn(columns, columnName, indexs);
            if (column != null) {
                boolean isRequired;
                bizField.getFieldView().setF7QueryPK(EditUIProxyHelper.getColumnBindQueryPK(editUI, kdTable, column.getName()));
                bizField.getFieldView().setWidth(column.getWidth());
                bizField.getFieldView().setVisible(!column.isHide());
                bizField.getFieldView().setEnable(!column.isLock());
                bizField.getFieldView().setTabIndex(tableInfo.getColumns().indexOf(column));
                com.kingdee.bos.metadata.entity.PropertyInfo prop = EditUIProxyHelper.getColumnBindProperty(editUI, kdTable, column.getName());
                if (prop != null && (isRequired = ConvertUtils.getExtendedPropertyBooelanValue(prop, "required"))) {
                    bizField.setRequired(true);
                    bizField.setRequiredPrompt(prop.getExtendedProperty("requiredPrompt"));
                }
            }
        }
    }

    public static void setBizFieldView(BizFieldInfo bizField, ComponentInfo kdTable, String columnName, EntityObjectInfo entity) {
        PropertyInfo property = kdTable.getProperties().get("formatXml");
        if (property != null) {
            TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom(property.getValue());
            List columns = tableInfo.getColumns();
            int[] indexs = new int[]{-1};
            UIProxyHelper.getInstance();
            ColumnInfo column = UIProxyHelper.findColumn(columns, columnName, indexs);
            if (column != null) {
                boolean isRequired;
                bizField.getFieldView().setF7QueryPK(EditUIProxyHelper.getColumnBindQueryPK(entity, kdTable, column.getName()));
                bizField.getFieldView().setWidth(column.getWidth());
                bizField.getFieldView().setVisible(!column.isHide());
                bizField.getFieldView().setEnable(!column.isLock());
                bizField.getFieldView().setTabIndex(tableInfo.getColumns().indexOf(column));
                com.kingdee.bos.metadata.entity.PropertyInfo prop = EditUIProxyHelper.getColumnBindProperty(entity, kdTable, column.getName());
                if (prop != null && (isRequired = ConvertUtils.getExtendedPropertyBooelanValue(prop, "required"))) {
                    bizField.setRequired(true);
                    bizField.setRequiredPrompt(prop.getExtendedProperty("requiredPrompt"));
                }
            }
        }
    }

    private static ComponentInfo getLabelContainer(ComponentInfo control) {
        if (control == null || control.getParent() == null) {
            return null;
        }
        if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equalsIgnoreCase(control.getParent().getClassType())) {
            return control.getParent();
        }
        if ("com.kingdee.bos.ctrl.swing.KDScrollPane".equalsIgnoreCase(control.getParent().getClassType()) && control.getParent().getParent() != null && "com.kingdee.bos.ctrl.swing.KDLabelContainer".equalsIgnoreCase(control.getParent().getParent().getClassType())) {
            return control.getParent().getParent();
        }
        return null;
    }

    public static void setBizFieldView(BizFieldInfo bizField, ComponentInfo control, BizFieldCollection bizFields, UIObjectInfo editUI) {
        String value;
        String propValue;
        PropertyInfo prop;
        if (bizField == null || control == null) {
            return;
        }
        bizField.setControlName(control.getName());
        BizFieldViewInfo fieldView = bizField.getFieldView();
        fieldView.setLayout(control.getLayoutInfo());
        ComponentInfo labContainer = AbstractBizUnitCtrl.getLabelContainer(control);
        if (control.getParent() != null) {
            if (bizField.getParent() == null) {
                if (labContainer != null && labContainer.getParent() != null) {
                    bizField.setParent(AbstractBizUnitCtrl.getFieldByControlName(bizFields, labContainer.getParent().getName()));
                } else {
                    bizField.setParent(AbstractBizUnitCtrl.getFieldByControlName(bizFields, control.getParent().getName()));
                }
            }
        } else {
            bizField.setParent(null);
        }
        if (labContainer != null) {
            fieldView.setLabel(true);
            prop = labContainer.getPropertyByName("boundLabelLength");
            if (prop != null && !StringUtils.isEmpty((String)(propValue = prop.getValue()))) {
                fieldView.setLabelWidth(Integer.parseInt(propValue));
            }
            if ((prop = labContainer.getPropertyByName("boundLabelAlignment")) != null) {
                if (prop.getValue() == null || prop.getValue().equals("")) {
                    fieldView.setLabelLocation(String.valueOf(7));
                } else {
                    fieldView.setLabelLocation(prop.getValue());
                }
            }
            if ((prop = labContainer.getPropertyByName("background")) != null) {
                fieldView.setBackgroundColor4Label(prop.getValue());
            }
            if ((prop = labContainer.getPropertyByName("foreground")) != null) {
                fieldView.setForeColor4Label(prop.getValue());
            }
        }
        if ((prop = control.getPropertyByName("queryInfo")) != null) {
            fieldView.setF7QueryPK(prop.getValue());
        }
        if ((prop = control.getPropertyByName("font")) != null) {
            fieldView.setFontString(prop.getValue());
        }
        if ((prop = control.getPropertyByName("background")) != null) {
            fieldView.setBackgroundColor(prop.getValue());
        }
        if ((prop = control.getPropertyByName("foreground")) != null) {
            fieldView.setForeColor(prop.getValue());
        }
        if (!BizDataType.ENUM.equals((Object)bizField.getBizDataType()) && !BizDataType.OBJECT.equals((Object)bizField.getBizDataType()) && (prop = control.getPropertyByName("text")) != null && prop.getValue() != null) {
            bizField.setDefaultValue(prop.getValue());
        }
        if ((prop = control.getPropertyByName("required")) != null) {
            bizField.setRequired(new Boolean(prop.getValue()));
        }
        if (bizField.isRequired()) {
            bizField.setRequiredPrompt(control.getExtendedProperty("requiredPrompt"));
        }
        if ((value = control.getExtendedProperty("isUseCurDateAsDef")) != null) {
            bizField.setExtendedProperty("isUseCurDateAsDef", value);
        }
        Rectangle rect = null;
        rect = labContainer != null ? AbstractBizUnitCtrl.getRectangle(labContainer) : AbstractBizUnitCtrl.getRectangle(control);
        if (rect != null) {
            fieldView.setLeft(rect.x);
            fieldView.setTop(rect.y);
            fieldView.setWidth(rect.width);
            fieldView.setHeight(rect.height);
        }
        fieldView.setAnchor(AbstractBizUnitCtrl.getAnchor(control));
        fieldView.setDisplayText(AbstractBizUnitCtrl.getDisplayText(control, editUI));
        fieldView.setTabIndex(control.getTabIndex());
        if (StringUtils.isEmpty((String)bizField.getAlias())) {
            bizField.setAlias(fieldView.getDisplayText());
        }
        fieldView.setHorizontalAlignment(AbstractBizUnitCtrl.getAlignment(control));
        fieldView.setEnable(AbstractBizUnitCtrl.isEnabled(control));
        fieldView.setVisible(AbstractBizUnitCtrl.isVisible(control));
        fieldView.setViewType(AbstractBizUnitCtrl.getViewType(control.getClassType()));
        if (!(fieldView.getViewType() != ViewType.LABEL && bizField.getFieldView().getViewType() != ViewType.LABELCONTAINER || BizDataType.IMAGE.equals((Object)bizField.getBizDataType()))) {
            bizField.setBizDataType(BizDataType.LABEL);
            bizField.setPersistence(false);
            prop = fieldView.getViewType() == ViewType.LABEL ? control.getPropertyByName("text") : control.getPropertyByName("boundLabelText");
            if (prop != null) {
                propValue = prop.getValue();
                fieldView.setDisplayText(propValue);
            }
        }
        if (fieldView.getViewType() == ViewType.RADIOBUTTON && (prop = control.getPropertyByName("buttonGroup")) != null && !StringUtils.isEmpty((String)(propValue = prop.getValue()))) {
            fieldView.setGroupName(propValue);
        }
        if (bizField.getBizDataType() == null) {
            if (fieldView.getViewType() == ViewType.PANEL) {
                bizField.setBizDataType(BizDataType.PANEL);
            } else if (fieldView.getViewType() == ViewType.TABCONTROL) {
                bizField.setBizDataType(BizDataType.TABFOLDER);
            } else if (fieldView.getViewType() == ViewType.SCROLLPANE) {
                bizField.setBizDataType(BizDataType.SCROLLPANE);
            } else if (fieldView.getViewType() == ViewType.KDCONTAINER) {
                bizField.setBizDataType(BizDataType.KDCONTAINER);
            } else if (fieldView.getViewType() == ViewType.BUTTON) {
                bizField.setBizDataType(BizDataType.BUTTON);
            } else if (fieldView.getViewType() == ViewType.RADIOBUTTON) {
                bizField.setBizDataType(BizDataType.RADIOBUTTON);
            } else if (fieldView.getViewType() == ViewType.KDSEPARATOR) {
                bizField.setBizDataType(BizDataType.KDSEPARATOR);
            } else if (fieldView.getViewType() == ViewType.BUTTONGROUP) {
                bizField.setBizDataType(BizDataType.BUTTONGROUP);
            } else {
                bizField.setBizDataType(BizDataType.STRING);
            }
        }
    }

    public static boolean isVisible(ComponentInfo control) {
        String propValue;
        PropertyInfo prop = control.getPropertyByName("visible");
        if (prop != null && (propValue = prop.getValue()) != null && propValue.equalsIgnoreCase("false")) {
            return false;
        }
        ComponentInfo labContainer = AbstractBizUnitCtrl.getLabelContainer(control);
        return labContainer == null || (prop = labContainer.getPropertyByName("visible")) == null || (propValue = prop.getValue()) == null || !propValue.equalsIgnoreCase("false");
    }

    public static boolean isEnabled(ComponentInfo control) {
        String propValue;
        PropertyInfo prop = control.getPropertyByName("enabled");
        return prop == null || (propValue = prop.getValue()) == null || !propValue.equalsIgnoreCase("false");
    }

    public static HorizontalAlignmentType getAlignment(ComponentInfo control) {
        PropertyInfo prop = control.getPropertyByName("horizontalAlignment");
        if (prop != null && !StringUtils.isEmpty((String)prop.getValue())) {
            int alignType = Integer.parseInt(prop.getValue());
            if (alignType == 0) {
                return HorizontalAlignmentType.Center;
            }
            if (alignType == 2) {
                return HorizontalAlignmentType.Left;
            }
            if (alignType == 4) {
                return HorizontalAlignmentType.Right;
            }
            if (alignType == 10) {
                return HorizontalAlignmentType.Leading;
            }
            if (alignType == 11) {
                return HorizontalAlignmentType.Trailing;
            }
        }
        return HorizontalAlignmentType.Left;
    }

    public static String getDisplayText(ComponentInfo control, AbstractUIObjectInfo editUI) {
        PropertyInfo prop = control.getPropertyByName("text");
        PropertyInfo actionProp = control.getPropertyByName("action");
        if (actionProp == null) {
            actionProp = control.getPropertyByName("actionBinding");
        }
        if (actionProp != null) {
            String actionName = actionProp.getValue();
            ActionInfo action = null;
            if (!StringUtils.isEmpty((String)actionName)) {
                action = editUI.getActionByName(actionName);
            }
            if (action != null && !StringUtils.isEmpty((String)action.getControlName())) {
                return action.getControlName();
            }
            if (prop != null) {
                return prop.getValue();
            }
            return "";
        }
        if ("com.kingdee.bos.ctrl.web.Button".equalsIgnoreCase(control.getClassType())) {
            prop = control.getPropertyByName("label");
            if (prop != null) {
                return prop.getValue();
            }
        } else if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equalsIgnoreCase(control.getClassType())) {
            prop = control.getPropertyByName("boundLabelText");
            if (prop != null) {
                return prop.getValue();
            }
        } else if (control.getParent() != null && "com.kingdee.bos.ctrl.swing.KDLabelContainer".equalsIgnoreCase(control.getParent().getClassType())) {
            prop = control.getParent().getPropertyByName("boundLabelText");
            if (prop != null) {
                return prop.getValue();
            }
        } else if (control.getParent() != null && "com.kingdee.bos.ctrl.swing.KDScrollPane".equalsIgnoreCase(control.getParent().getClassType()) && control.getParent().getParent() != null && "com.kingdee.bos.ctrl.swing.KDLabelContainer".equalsIgnoreCase(control.getParent().getParent().getClassType())) {
            prop = control.getParent().getParent().getPropertyByName("boundLabelText");
            if (prop != null) {
                return prop.getValue();
            }
        } else {
            if (prop != null) {
                return prop.getValue();
            }
            if ("com.kingdee.bos.ctrl.swing.KDPanel".equalsIgnoreCase(control.getClassType()) || "com.kingdee.bos.ctrl.swing.KDTabbedPane".equalsIgnoreCase(control.getClassType())) {
                if (control.getParent() != null && "com.kingdee.bos.ctrl.swing.KDTabbedPane".equalsIgnoreCase(control.getParent().getClassType())) {
                    if (control.getConstraint() != null && control.getConstraint() instanceof String) {
                        return control.getConstraint().toString();
                    }
                } else if ("com.kingdee.bos.ctrl.swing.KDTabbedPane".equalsIgnoreCase(control.getClassType())) {
                    return control.getAlias();
                }
            } else if (control.getParent() != null && "com.kingdee.bos.ctrl.swing.KDLabelContainer".equalsIgnoreCase(control.getParent().getClassType()) && (prop = control.getParent().getPropertyByName("boundLabelText")) != null) {
                return prop.getValue();
            }
        }
        return null;
    }

    public static int getAnchor(ComponentInfo control) {
        ComponentInfo labelContainer = AbstractBizUnitCtrl.getLabelContainer(control);
        if (labelContainer != null) {
            if (labelContainer.getConstraint() instanceof KDLayoutConstraint) {
                return ((KDLayoutConstraint)labelContainer.getConstraint()).anchor;
            }
        } else if (control.getConstraint() instanceof KDLayoutConstraint) {
            return ((KDLayoutConstraint)control.getConstraint()).anchor;
        }
        return 0;
    }

    public static Rectangle getRectangle(ComponentInfo control) {
        ComponentInfo labelContainer = AbstractBizUnitCtrl.getLabelContainer(control);
        Rectangle rect = null;
        if (labelContainer != null) {
            Object constraint = labelContainer.getConstraint();
            if (constraint != null && (constraint instanceof Rectangle || constraint instanceof KDLayoutConstraint)) {
                rect = constraint instanceof Rectangle ? (Rectangle)constraint : ((KDLayoutConstraint)constraint).toRectangle();
            }
        } else {
            Object constraint = control.getConstraint();
            if (constraint != null && (constraint instanceof Rectangle || constraint instanceof KDLayoutConstraint)) {
                if (control.getParent() != null && control.getParent().getLayoutInfo() != null && "SameGridLayout".equals(control.getParent().getLayoutInfo().getType())) {
                    rect = AbstractBizUnitCtrl.getRectangle(control.getParent());
                    rect = new Rectangle(rect);
                    rect.x = 0;
                    rect.y = 0;
                    return rect;
                }
                rect = constraint instanceof Rectangle ? (Rectangle)constraint : ((KDLayoutConstraint)constraint).toRectangle();
            }
        }
        if (rect == null && control.getParent() != null) {
            return AbstractBizUnitCtrl.getRectangle(control.getParent());
        }
        return rect;
    }

    public static BizFieldInfo getBizField(BizFieldCollection bizFields, String controlName) {
        if (StringUtils.isEmpty((String)controlName)) {
            return null;
        }
        int n = bizFields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = bizFields.get(i);
            if (controlName.equalsIgnoreCase(bizField.getControlName())) {
                return bizField;
            }
            if (!(bizField instanceof BizGroupFieldInfo)) continue;
            BizGroupFieldInfo groupField = (BizGroupFieldInfo)bizField;
            BizFieldCollection subFields = groupField.getFields();
            int m = subFields.size();
            for (int j = 0; j < m; ++j) {
                bizField = subFields.get(j);
                if (!controlName.equalsIgnoreCase(bizField.getControlName())) continue;
                return bizField;
            }
        }
        return null;
    }

    public static ViewType getViewType(String classType) {
        if (StringUtils.isEmpty((String)classType)) {
            return ViewType.TEXTFIELD;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDFormattedTextField")) {
            return ViewType.FORMATTEXTFIELD;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDMultiLangBox")) {
            return ViewType.MULTILANGBOX;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDRadioButton")) {
            return ViewType.RADIOBUTTON;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea")) {
            return ViewType.KDBIZMUTLILANGAREA;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox")) {
            return ViewType.KDBIZMUTLILANGBOX;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox")) {
            return ViewType.F7SELECTOR;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.kdf.table.KDTable")) {
            return ViewType.TABLEVIEW;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDButton")) {
            return ViewType.BUTTON;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDButtonGroup")) {
            return ViewType.BUTTONGROUP;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDWorkButton")) {
            return ViewType.BUTTON;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDCheckBox")) {
            return ViewType.CHECKBOX;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDMenu")) {
            return ViewType.MENU;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDMenuItem")) {
            return ViewType.MENUITEM;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDCheckBoxMenuItem")) {
            return ViewType.MENUITEM;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDTextField")) {
            return ViewType.TEXTFIELD;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDLabel")) {
            return ViewType.LABEL;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDSeparator")) {
            return ViewType.KDSEPARATOR;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDButton")) {
            return ViewType.BUTTON;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDTimePicker")) {
            return ViewType.TIMEPICKER;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDDatePicker")) {
            return ViewType.DATEPICKER;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDTextArea")) {
            return ViewType.TEXTAREA;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDPanel")) {
            return ViewType.PANEL;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDComboBox")) {
            return ViewType.COMBOBOX;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDTabbedPane")) {
            return ViewType.TABCONTROL;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDScrollPane")) {
            return ViewType.SCROLLPANE;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDLabelContainer")) {
            return ViewType.LABELCONTAINER;
        }
        if (classType.equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDContainer")) {
            return ViewType.KDCONTAINER;
        }
        return ViewType.UNKOWN;
    }

    protected void extractListUIItems(UIObjectInfo listUI, BizFieldCollection bizFields, JoinQueryInfo mainQuery, BizUnitInfo bizUnit) throws BIMException {
        if (listUI == null) {
            return;
        }
        this.extractListUIItems(listUI, bizFields, mainQuery);
        if ("TreeDetail4Detail".equalsIgnoreCase(bizUnit.getBimTemplateType())) {
            DataObjectCollection dataObjects = listUI.getDataObjects();
            try {
                int n = dataObjects.size();
                for (int i = 0; i < n; ++i) {
                    BizGroupFieldInfo groupField;
                    JoinQueryInfo subQuery;
                    if (!MetaDataTypeList.JOINQUERY.toString().equals(dataObjects.get(i).getObjectType()) || mainQuery.getRealName().equalsIgnoreCase(dataObjects.get(i).getRealName()) || (subQuery = (JoinQueryInfo)dataObjects.get(i).getInstanceOfQueryForBim()) == null || subQuery.getMainObject() == null || !(subQuery.getMainObject() instanceof SubEntityInfo) || !bizUnit.getEntity().getRealFullName().equalsIgnoreCase(((SubEntityInfo)subQuery.getMainObject()).getEntityRef().getRealFullName()) || (groupField = AbstractBizUnitCtrl.getGroupFieldBySubQuery(bizUnit, subQuery)) == null) continue;
                    groupField.setQuery(subQuery);
                    this.extractQueryFields(subQuery, bizFields, bizUnit.getEntity());
                    this.extractListUIItems(listUI, bizFields, subQuery);
                }
            }
            catch (BOSException e) {
                throw new BIMException("\u88c5\u8f7d\u5217\u8868\u5b50\u67e5\u8be2\u51fa\u9519\uff01", e);
            }
        }
    }

    private void extractListUIItems(UIObjectInfo listUI, BizFieldCollection bizFields, JoinQueryInfo query) {
        String formatXML = "formatXml";
        if (listUI == null || query == null) {
            return;
        }
        DataObjectInfo dataObject = UIProxyHelper.findDataObjectByType(listUI, query.getRealFullName());
        if (dataObject == null) {
            return;
        }
        String bindQueryName = dataObject.getRealName();
        ComponentInfo kdTable = UIProxyHelper.findKDTableByDataObject(listUI, dataObject);
        if (kdTable != null && bindQueryName != null) {
            PropertyBindingCollection propBindings = kdTable.getPropertyBindings();
            PropertyInfo prop = kdTable.getPropertyByName(formatXML);
            TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom(prop.getValue());
            int n = propBindings.size();
            for (int i = 0; i < n; ++i) {
                BizFieldInfo bizField;
                PropertyBindingInfo propBinding = propBindings.get(i);
                if (!bindQueryName.equalsIgnoreCase(propBinding.getBindingObject()) || (bizField = this.getFieldByQueryFieldName(bizFields, propBinding.getBingdingField())) == null || !StringUtils.isEmpty((String)bizField.getListItemName())) continue;
                bizField.setListItemName(StringUtils.replace((String)propBinding.getPropertyName(), (String)".text", (String)""));
                ColumnInfo column = AbstractBizUnitCtrl.getColumn(tableInfo, bizField.getListItemName());
                if (column == null) continue;
                bizField.getFieldView().setListVisible(!column.isHide());
                bizField.getFieldView().setListIndex(tableInfo.getColumns().indexOf(column) + 1);
                if (tableInfo.getHeaderCount() <= 0) continue;
                HeaderInfo headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
                bizField.setListLabelText(((CellInfo)headerInfo.getCells().get(tableInfo.getColumns().indexOf(column))).getName());
            }
        }
    }

    private static BizGroupFieldInfo getGroupFieldByEntity(BizFieldCollection bizFields, EntityObjectInfo entity) {
        BizGroupFieldInfo groupField = null;
        int n = bizFields.size();
        for (int i = 0; i < n; ++i) {
            if (!(bizFields.get(i) instanceof BizGroupFieldInfo)) continue;
            groupField = (BizGroupFieldInfo)bizFields.get(i);
            if (groupField.getEntityObject() != null && entity.getRealFullName().equalsIgnoreCase(groupField.getEntityObject().getRealFullName())) {
                return groupField;
            }
            if ((groupField = AbstractBizUnitCtrl.getGroupFieldByEntity(groupField.getFields(), entity)) == null) continue;
            return groupField;
        }
        return null;
    }

    private static BizGroupFieldInfo getGroupFieldBySubQuery(BizUnitInfo bizUnit, JoinQueryInfo subQuery) throws BOSException {
        if (bizUnit == null || subQuery == null) {
            return null;
        }
        SubObjectCollection subObjects = subQuery.getSubObjects();
        int n = subObjects.size();
        for (int i = 0; i < n; ++i) {
            BizGroupFieldInfo groupField;
            if (subQuery.getMainObject().equals(subObjects.get(i)) || !(subObjects.get(i) instanceof SubEntityInfo) || (groupField = AbstractBizUnitCtrl.getGroupFieldByEntity(bizUnit.getFields(), ((SubEntityInfo)subObjects.get(i)).getEntityRef())) == null) continue;
            return groupField;
        }
        return null;
    }

    private static ColumnInfo getColumn(TableInfo tableInfo, String listItemName) {
        if (tableInfo == null || StringUtils.isEmpty((String)listItemName)) {
            return null;
        }
        List columns = tableInfo.getColumns();
        ColumnInfo column = null;
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            column = (ColumnInfo)columns.get(i);
            if (!listItemName.equalsIgnoreCase(column.getName())) continue;
            return column;
        }
        return null;
    }

    protected BizGroupFieldInfo getGroupFieldByPropertyName(BizFieldCollection bizFields, String propertyName) {
        String[] props = StringUtils.split((String)propertyName, (String)".");
        BizFieldCollection subFields = bizFields;
        BizGroupFieldInfo groupField = null;
        int n = props.length;
        for (int i = 0; i < n; ++i) {
            int m = subFields.size();
            for (int j = 0; j < m; ++j) {
                BizFieldInfo bizField = subFields.get(j);
                if (!props[i].equalsIgnoreCase(bizField.getPropertyName())) continue;
                if (!(bizField instanceof BizGroupFieldInfo)) break;
                groupField = (BizGroupFieldInfo)bizField;
                subFields = ((BizGroupFieldInfo)bizField).getFields();
                break;
            }
            if (groupField != null) continue;
            return null;
        }
        return groupField;
    }

    protected BizFieldInfo getFieldByPropertyName(BizFieldCollection bizFields, String propertyName) {
        String[] props = StringUtils.split((String)propertyName, (String)".");
        BizFieldCollection subFields = bizFields;
        int n = props.length;
        block0: for (int i = 0; i < n; ++i) {
            int m = subFields.size();
            for (int j = 0; j < m; ++j) {
                BizFieldInfo bizField = subFields.get(j);
                if (!props[i].equalsIgnoreCase(bizField.getPropertyName())) continue;
                if (i == n - 1) {
                    return bizField;
                }
                if (bizField instanceof BizGroupFieldInfo) {
                    subFields = ((BizGroupFieldInfo)bizField).getFields();
                    continue block0;
                }
                return null;
            }
        }
        return null;
    }

    private BizFieldInfo getFieldByQueryFieldName(BizFieldCollection bizFields, String queryFieldName) {
        if (StringUtils.isEmpty((String)queryFieldName)) {
            return null;
        }
        int n = bizFields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = bizFields.get(i);
            if (queryFieldName.equalsIgnoreCase(bizField.getQueryFieldName())) {
                return bizField;
            }
            if (!(bizField instanceof BizGroupFieldInfo)) continue;
            BizGroupFieldInfo groupField = (BizGroupFieldInfo)bizField;
            BizFieldCollection subFields = groupField.getFields();
            int m = subFields.size();
            for (int j = 0; j < m; ++j) {
                bizField = subFields.get(j);
                if (!queryFieldName.equalsIgnoreCase(bizField.getQueryFieldName())) continue;
                return bizField;
            }
        }
        return null;
    }

    protected void extractEntityFunctionOperations(FunctionObjectInfo function, BizMethodCollection bizMethods) throws BIMException {
        if (function == null) {
            return;
        }
        OperationCollection operations = function.getOperation();
        int n = operations.size();
        for (int i = 0; i < n; ++i) {
            BizMethodInfo bizMethod;
            OperationInfo operation = operations.get(i);
            if (operation.getEventRef() == null || operation.getEventRef().getEventMethods().size() <= 0 || operation.getEventRef().getEventMethods().get(0).getMethodRef() == null || (bizMethod = this.getMethodByEntityMethodName(bizMethods, operation.getEventRef().getEventMethods().get(0).getMethodRef().getName())) == null) continue;
            bizMethod.setOperationName(operation.getEventRef().getEventMethods().get(0).getMethodRef().getName());
        }
    }

    protected void extractUIFunctionOperations(FunctionObjectInfo function, BizMethodCollection bizMethods) throws BIMException {
        if (function == null) {
            return;
        }
        OperationCollection operations = function.getOperation();
        int n = operations.size();
        for (int i = 0; i < n; ++i) {
            BizMethodInfo bizMethod;
            OperationInfo operation = operations.get(i);
            if (operation.getUiActionRef() == null || (bizMethod = this.getMethodByActionName(bizMethods, operation.getUiActionRef().getActionRefName())) == null) continue;
            bizMethod.setUIOperationName(operation.getName());
        }
    }

    protected BizMethodInfo getMethodByName(BizMethodCollection bizMethods, String name) {
        int n = bizMethods.size();
        for (int i = 0; i < n; ++i) {
            if (bizMethods.get(i).getName() == null || !bizMethods.get(i).getName().equalsIgnoreCase(name)) continue;
            return bizMethods.get(i);
        }
        return null;
    }

    protected BizMethodInfo getMethodByEntityMethodName(BizMethodCollection bizMethods, String methodName) {
        int n = bizMethods.size();
        for (int i = 0; i < n; ++i) {
            if (StringUtils.isEmpty((String)bizMethods.get(i).getName()) || !bizMethods.get(i).getName().equalsIgnoreCase(methodName)) continue;
            return bizMethods.get(i);
        }
        return null;
    }

    protected BizMethodInfo getMethodByActionName(BizMethodCollection bizMethods, String actionName) {
        int n = bizMethods.size();
        for (int i = 0; i < n; ++i) {
            if (bizMethods.get(i).getActionName() == null || !bizMethods.get(i).getActionName().equalsIgnoreCase(actionName)) continue;
            return bizMethods.get(i);
        }
        return null;
    }

    public void extractListUIActions(AbstractUIObjectInfo listUI, BizMethodCollection bizMethods, boolean isWebUI) throws BIMException {
        if (listUI == null) {
            return;
        }
        ActionCollection actions = listUI.getActions();
        int n = actions.size();
        block0: for (int i = 0; i < n; ++i) {
            String value;
            ActionExtendPropertyHelper actionHelper;
            BizMethodInfo bizMethod;
            ActionInfo action = actions.get(i);
            String methodName = action.getName();
            if (methodName.length() > "action".length()) {
                if ("action".equalsIgnoreCase(methodName.substring(0, "action".length()))) {
                    methodName = methodName.substring("action".length());
                } else if ("action".equalsIgnoreCase(methodName.substring(methodName.length() - "action".length()))) {
                    methodName = methodName.substring(0, methodName.length() - "action".length());
                }
            }
            if ((bizMethod = this.getMethodByEntityMethodName(bizMethods, methodName)) != null) {
                if (isWebUI) {
                    bizMethod.setWebListActionName(action.getName());
                    bizMethod.setWebListActionClassName(action.getClassName());
                } else {
                    bizMethod.setListActionName(action.getName());
                    bizMethod.setListActionClassName(action.getClassName());
                }
            } else {
                bizMethod = new BizMethodInfo();
                bizMethod.setName(methodName);
                if (StringUtils.isEmpty((String)action.getControlName())) {
                    bizMethod.setAlias(methodName);
                } else {
                    bizMethod.setAlias(action.getControlName());
                }
                if (isWebUI) {
                    bizMethod.setWebListActionName(action.getName());
                    bizMethod.setWebListActionClassName(action.getClassName());
                } else {
                    bizMethod.setListActionName(action.getName());
                    bizMethod.setListActionClassName(action.getClassName());
                }
                bizMethods.add(bizMethod);
            }
            if (action.isBindWorkFlow()) {
                bizMethod.setBindWorkFlow(true);
            }
            if ((actionHelper = new ActionExtendPropertyHelper(action.getActionExtendProperty())).containsKey("Mutex")) {
                bizMethod.setMutexValue(actionHelper.getValue("Mutex"));
            }
            if (actionHelper.containsKey("isObjectUpdateLock")) {
                bizMethod.setObjectUpdateLock(Boolean.valueOf(actionHelper.getValue("isObjectUpdateLock")));
            }
            if ((value = actionHelper.getValue("userDefined")) == null) {
                bizMethod.setUserDefined(false);
            } else {
                bizMethod.setUserDefined(Boolean.valueOf(value));
            }
            ComponentCollection components = AbstractBizUnitCtrl.treeToCol(listUI.getComponents());
            boolean findMenu = false;
            boolean findButton = false;
            int m = components.size();
            for (int j = 0; j < m; ++j) {
                PropertyInfo actionProp;
                ComponentInfo component = components.get(j);
                if (!findMenu && "com.kingdee.bos.ctrl.swing.KDMenuItem".equalsIgnoreCase(component.getClassType())) {
                    actionProp = component.getPropertyByName("action");
                    if (action != null && !StringUtils.isEmpty((String)action.getName()) && actionProp != null && !StringUtils.isEmpty((String)actionProp.getName())) {
                        bizMethod.setGenMenuItem(true);
                        bizMethod.setMenuItemName(component.getName());
                        findMenu = true;
                    }
                }
                if (!findButton && "com.kingdee.bos.ctrl.swing.KDWorkButton".equalsIgnoreCase(component.getClassType())) {
                    actionProp = component.getPropertyByName("action");
                    if (action != null && !StringUtils.isEmpty((String)action.getName()) && actionProp != null && !StringUtils.isEmpty((String)actionProp.getName()) && action.getName().equalsIgnoreCase(actionProp.getValue())) {
                        bizMethod.setGenToolBarButton(true);
                        bizMethod.setToolBarButtonName(component.getName());
                        findButton = true;
                    }
                }
                if (findMenu && findButton) continue block0;
            }
        }
    }

    public void extractEditUIActions(AbstractUIObjectInfo editUI, BizMethodCollection bizMethods, BizUnitInfo bizUnit, boolean isWebUI) throws BIMException {
        BizFieldInfo bizField;
        if (editUI == null) {
            return;
        }
        BizEnumInfo enumInfo = null;
        if (!StringUtils.isEmpty((String)bizUnit.getBizStatusFieldName()) && (bizField = bizUnit.getFieldByName(bizUnit.getBizStatusFieldName())) != null && bizField.getEnumType() != null) {
            enumInfo = bizField.getEnumType();
        }
        ActionCollection actions = editUI.getActions();
        int n = actions.size();
        block0: for (int i = 0; i < n; ++i) {
            String value;
            BizMethodInfo bizMethod;
            ActionInfo action = actions.get(i);
            String methodName = action.getName();
            if (methodName.length() > "action".length()) {
                if ("action".equalsIgnoreCase(methodName.substring(0, "action".length()))) {
                    methodName = methodName.substring("action".length());
                } else if ("action".equalsIgnoreCase(methodName.substring(methodName.length() - "action".length()))) {
                    methodName = methodName.substring(0, methodName.length() - "action".length());
                }
            }
            if ((bizMethod = this.getMethodByEntityMethodName(bizMethods, methodName)) != null) {
                if (isWebUI) {
                    bizMethod.setWebActionName(action.getName());
                    bizMethod.setWebActionClassName(action.getClassName());
                } else {
                    bizMethod.setActionName(action.getName());
                    bizMethod.setActionClassName(action.getClassName());
                }
            } else {
                bizMethod = new BizMethodInfo();
                bizMethod.setName(methodName);
                if (StringUtils.isEmpty((String)action.getControlName())) {
                    bizMethod.setAlias(methodName);
                } else {
                    bizMethod.setAlias(action.getControlName());
                }
                if (isWebUI) {
                    bizMethod.setWebActionName(action.getName());
                    bizMethod.setWebActionClassName(action.getClassName());
                } else {
                    bizMethod.setActionName(action.getName());
                    bizMethod.setActionClassName(action.getClassName());
                }
                bizMethods.add(bizMethod);
            }
            if (bizMethod != null && action.getRules() != null) {
                RuleCollection rules = action.getRules();
                int m = rules.size();
                for (int j = 0; j < m; ++j) {
                    if (!(rules.get(j) instanceof ConditionRuleInfo)) continue;
                    bizMethod.getConditionRules().add((ConditionRuleInfo)rules.get(j));
                }
            }
            bizMethod.setBindWorkFlow(action.isBindWorkFlow());
            ActionExtendPropertyHelper actionHelper = new ActionExtendPropertyHelper(action.getActionExtendProperty());
            if (actionHelper.containsKey("Mutex")) {
                bizMethod.setMutexValue(actionHelper.getValue("Mutex"));
            }
            if (actionHelper.containsKey("isObjectUpdateLock")) {
                bizMethod.setObjectUpdateLock(Boolean.valueOf(actionHelper.getValue("isObjectUpdateLock")));
            }
            if ((value = actionHelper.getValue("userDefined")) == null) {
                bizMethod.setUserDefined(false);
            } else {
                bizMethod.setUserDefined(Boolean.valueOf(value));
            }
            String enumItemName = actionHelper.getValue("BizStatusFieldValue");
            if (bizMethod.getBizStatusFieldValue() == null && enumInfo != null && !StringUtils.isEmpty((String)enumItemName)) {
                int m = enumInfo.getEnumValue().size();
                for (int j = 0; j < m; ++j) {
                    if (!enumItemName.equalsIgnoreCase(enumInfo.getEnumValue().get(j).getName())) continue;
                    bizMethod.setBizStatusFieldValue(enumInfo.getEnumValue().get(j));
                    break;
                }
            }
            ComponentCollection components = AbstractBizUnitCtrl.treeToCol(editUI.getComponents());
            boolean findMenu = false;
            boolean findButton = false;
            int m = components.size();
            for (int j = 0; j < m; ++j) {
                PropertyInfo actionProp;
                ComponentInfo component = components.get(j);
                if (!findMenu && "com.kingdee.bos.ctrl.swing.KDMenuItem".equalsIgnoreCase(component.getClassType())) {
                    actionProp = component.getPropertyByName("action");
                    if (action != null && !StringUtils.isEmpty((String)action.getName()) && actionProp != null && !StringUtils.isEmpty((String)actionProp.getName())) {
                        bizMethod.setGenMenuItem(true);
                        bizMethod.setMenuItemName(component.getName());
                        findMenu = true;
                    }
                }
                if (!findButton && "com.kingdee.bos.ctrl.swing.KDWorkButton".equalsIgnoreCase(component.getClassType())) {
                    actionProp = component.getPropertyByName("action");
                    if (action != null && !StringUtils.isEmpty((String)action.getName()) && actionProp != null && !StringUtils.isEmpty((String)actionProp.getName()) && action.getName().equalsIgnoreCase(actionProp.getValue())) {
                        bizMethod.setGenToolBarButton(true);
                        bizMethod.setToolBarButtonName(component.getName());
                        findButton = true;
                    }
                }
                if (findMenu && findButton) continue block0;
            }
        }
    }

    protected void extractEntityFields(EntityObjectInfo entity, BizFieldCollection bizFields) throws BIMException {
        if (entity == null) {
            return;
        }
        PropertyCollection props = entity.getInheritedNoDuplicatedProperties();
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            String prompt;
            String cfgPro;
            BizFieldInfo field = null;
            com.kingdee.bos.metadata.entity.PropertyInfo prop = props.get(i);
            if (entity.getLogicalKey() != null && entity.getLogicalKey().getKeyPropertys().size() == 1 && entity.getLogicalKey().getKeyPropertys().get(0).getName().equalsIgnoreCase(prop.getName())) continue;
            if (prop instanceof LinkPropertyInfo) {
                EntityObjectInfo subEntity;
                LinkPropertyInfo lnkProp = (LinkPropertyInfo)prop;
                RelationshipInfo relation = lnkProp.getRelationship();
                if (relation == null) {
                    throw new BIMException("entity: " + entity.getRealFullName() + " 's linkProperty " + lnkProp.getName() + " 's relation is null");
                }
                if (relation.getSupplierCardinality() == CardinalityType.ONE || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_ONE) {
                    field = new BizFieldInfo();
                    field.setName(lnkProp.getName());
                    field.setAlias(lnkProp.getAlias());
                    field.setDescription(lnkProp.getDescription());
                    field.setBizDataType(BizDataType.OBJECT);
                    if (lnkProp.getMappingField() != null) {
                        field.setPersistence(true);
                        AbstractBizUnitCtrl.checkProperty(entity, lnkProp);
                        field.setColumnName(lnkProp.getMappingField().getName());
                        field.setLength(lnkProp.getMappingField().getLength());
                        field.setPrecision(lnkProp.getMappingField().getPrecision());
                        field.setScale(lnkProp.getMappingField().getScale());
                    } else {
                        field.setPersistence(false);
                    }
                    field.setDataSourceType(DataSourceType.BASEDATA);
                    field.setDataSource(relation.getSupplierObject());
                    field.setDataField(lnkProp.getExtendedProperty("dataField"));
                    field.setPropertyName(lnkProp.getName());
                    field.setF7FilterItems(lnkProp.getExtendedProperty("f7FilterItems"));
                    field.setF7ListUIClassName(lnkProp.getExtendedProperty("f7ListUIClassName"));
                    field.setConsignType(lnkProp.getExtendedProperty("consignType"));
                    field.setDefaultValue(lnkProp.getExtendedProperty("defaultValue"));
                    bizFields.add(field);
                } else if (!(relation.getSupplierCardinality() != CardinalityType.ZERO_TO_UNBOUNDED && relation.getSupplierCardinality() != CardinalityType.ONE_TO_UNBOUNDED || (subEntity = relation.getSupplierObject()).equals(entity))) {
                    BizGroupFieldInfo groupField = new BizGroupFieldInfo();
                    groupField.setName(lnkProp.getName());
                    groupField.setAlias(lnkProp.getAlias());
                    groupField.setDescription(lnkProp.getDescription());
                    groupField.setBizDataType(BizDataType.COLLECTION);
                    groupField.setTableObject(subEntity.getTable());
                    groupField.setEntityObject(subEntity);
                    this.extractEntityFields(subEntity, groupField.getFields());
                    groupField.setPropertyName(lnkProp.getName());
                    bizFields.add(groupField);
                    field = groupField;
                }
            } else if (prop instanceof OwnPropertyInfo) {
                String bizDataType;
                OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
                field = new BizFieldInfo();
                field.setName(ownProp.getName());
                field.setAlias(ownProp.getAlias());
                field.setDescription(ownProp.getDescription());
                if (!StringUtils.isEmpty((String)prop.getExtendedProperty("enableFieldPermission"))) {
                    field.setEnableFieldPermission(Boolean.valueOf(prop.getExtendedProperty("enableFieldPermission")));
                }
                if (!StringUtils.isEmpty((String)prop.getExtendedProperty("needSum"))) {
                    field.setNeedSum(ConvertUtils.getExtendedPropertyBooelanValue(prop, "needSum"));
                }
                if (!StringUtils.isEmpty((String)prop.getExtendedProperty("needSumInListUI"))) {
                    field.setNeedSumInListUI(ConvertUtils.getExtendedPropertyBooelanValue(prop, "needSumInListUI"));
                }
                if (!StringUtils.isEmpty((String)prop.getExtendedProperty("DataSourceType"))) {
                    DataSourceType dataSource = DataSourceType.getEnum(prop.getExtendedProperty("DataSourceType"));
                    if (dataSource != null) {
                        field.setDataSourceType(dataSource);
                    }
                    field.setDataField(prop.getExtendedProperty("DataField"));
                }
                if (!StringUtils.isEmpty((String)(bizDataType = ownProp.getExtendedProperty("bizDataType")))) {
                    field.setBizDataType(BizDataType.getEnum(bizDataType));
                } else {
                    field.setBizDataType(AbstractBizUnitCtrl.getBizDataType(ownProp.getDataType()));
                }
                if (ownProp.getDataType() == DataType.ENUM) {
                    if (this.depend != null) {
                        field.setEnumType(ownProp.getEnumType(Project.Projects.getProjects(new Project[]{this.depend})));
                    } else {
                        field.setEnumType(ownProp.getEnumType());
                    }
                    field.setDataSourceType(DataSourceType.ENUMLIST);
                    field.setLength(ownProp.getLength());
                    field.setDefaultValue(ownProp.getExtendedProperty("defaultValue"));
                } else {
                    field.setDefaultValue(ownProp.getDefaultValue());
                }
                if (ownProp.getMappingField() != null) {
                    field.setPersistence(true);
                    AbstractBizUnitCtrl.checkProperty(entity, ownProp);
                    field.setColumnName(ownProp.getMappingField().getName());
                    if (!DataType.ENUM.equals(ownProp.getDataType())) {
                        field.setLength(ownProp.getMappingField().getLength());
                    }
                    field.setPrecision(ownProp.getMappingField().getPrecision());
                    field.setScale(ownProp.getMappingField().getScale());
                } else {
                    field.setPersistence(false);
                }
                field.setPropertyName(ownProp.getName());
                bizFields.add(field);
            }
            if (field == null) continue;
            if (!StringUtils.isEmpty((String)prop.getExtendedProperty("isSupportConfigure"))) {
                field.setSupportConfigure(ConvertUtils.getExtendedPropertyBooelanValue(prop, "isSupportConfigure"));
            }
            if (!StringUtils.isEmpty((String)(cfgPro = prop.getExtendedProperty("configureProperty")))) {
                int cfg = 111;
                try {
                    cfg = new Integer(cfgPro);
                }
                catch (NumberFormatException ne) {
                    cfg = 111;
                }
                field.setConfigureProperty(cfg);
            }
            if (!StringUtils.isEmpty((String)(prompt = prop.getExtendedProperty("requiredPrompt")))) {
                field.setRequiredPrompt(prompt);
            }
            AbstractBizUnitCtrl.copyExtendedProperties(prop, field);
            if (entity.getPropertyByName(prop.getName(), false) != null) {
                field.setInherited(false);
            } else {
                field.setInherited(true);
            }
            if (prop.isUserDefined()) {
                field.setUserDefined(true);
                continue;
            }
            field.setUserDefined(false);
        }
    }

    protected BizMethodCollection extractEntityMethods(BizUnitInfo bizUnit, EntityObjectInfo entity) throws BIMException {
        BizFieldInfo bizField;
        BizMethodCollection bizMethods = new BizMethodCollection();
        if (entity == null) {
            return bizMethods;
        }
        MethodCollection methods = entity.getMethods();
        ArrayList<String> methodNames = new ArrayList<String>();
        methodNames.add("addnew");
        methodNames.add("getValue");
        methodNames.add("update");
        methodNames.add("delete");
        methodNames.add("exists");
        methodNames.add("getPKList");
        methodNames.add("getCollection");
        BizEnumInfo enumInfo = null;
        if (!StringUtils.isEmpty((String)bizUnit.getBizStatusFieldName()) && (bizField = bizUnit.getFieldByName(bizUnit.getBizStatusFieldName())) != null && bizField.getEnumType() != null) {
            enumInfo = bizField.getEnumType();
        }
        int n = methods.size();
        for (int i = 0; i < n; ++i) {
            MethodInfo method = methods.get(i);
            String methodName = method.getName();
            if (methodNames.contains(methodName)) continue;
            BizMethodInfo bizMethod = new BizMethodInfo();
            bizMethod.setName(method.getName());
            bizMethod.setAlias(method.getAlias());
            bizMethod.setDescription(method.getDescription());
            bizMethod.setMethodName(method.getName());
            String enumItemName = method.getExtendedProperty("BizStatusFieldValue");
            if (enumInfo != null && !StringUtils.isEmpty((String)enumItemName)) {
                int m = enumInfo.getEnumValue().size();
                for (int j = 0; j < m; ++j) {
                    if (!enumItemName.equalsIgnoreCase(enumInfo.getEnumValue().get(j).getName())) continue;
                    bizMethod.setBizStatusFieldValue(enumInfo.getEnumValue().get(j));
                    break;
                }
            }
            bizMethods.add(bizMethod);
        }
        return bizMethods;
    }

    public static void checkProperty(EntityObjectInfo entity, com.kingdee.bos.metadata.entity.PropertyInfo prop) {
        if (entity == null || prop == null || entity.getTable() == null) {
            return;
        }
        entity.getMappingFieldOfProperty(prop);
    }

    protected BizFieldCollection extractBizFields(BizUnitInfo bizUnit) throws BIMException {
        DataTableInfo table = bizUnit.getTable();
        EntityObjectInfo entity = bizUnit.getEntity();
        JoinQueryInfo query = bizUnit.getQuery();
        UIObjectInfo editUI = bizUnit.getEditUI();
        UIObjectInfo listUI = bizUnit.getListUI();
        WebUIObjectInfo webEditUI = bizUnit.getWebEditUI();
        WebUIObjectInfo webListUI = bizUnit.getWebListUI();
        BizFieldCollection bizFields = new BizFieldCollection();
        bizUnit.put("fields", bizFields);
        this.extractEntityFields(entity, bizFields);
        AbstractBizUnitCtrl.copyExtendedProperties(entity, bizUnit);
        this.extractTableColumns(table, bizFields);
        this.extractQueryFields(query, bizFields, entity);
        this.extractGUIEditUIControls(editUI, bizFields, entity, bizUnit);
        this.extractListUIItems(listUI, bizFields, query, bizUnit);
        this.extractWebEditUIControls(webEditUI, bizFields, entity, bizUnit);
        this.extractWebListUIItems(webListUI, bizFields, query, bizUnit);
        AbstractBizUnitCtrl.setBizFieldRelation(bizFields);
        AbstractBizUnitCtrl.setSavedProperty(bizFields, true);
        if (entity != null && !StringUtils.isEmpty((String)entity.getExtendedProperty("enableFieldPermission"))) {
            bizUnit.setEnableFieldPermission(Boolean.valueOf(entity.getExtendedProperty("enableFieldPermission")));
        }
        return bizFields;
    }

    private static void setBizFieldRelation(BizFieldCollection bizFields) {
        if (bizFields != null) {
            int size = bizFields.size();
            for (int i = 0; i < size; ++i) {
                BizFieldInfo field = bizFields.get(i);
                if (!(field instanceof BizGroupFieldInfo)) continue;
                BizFieldCollection childs = ((BizGroupFieldInfo)field).getFields();
                int size2 = childs.size();
                for (int j = 0; j < size2; ++j) {
                    BizFieldInfo child = childs.get(j);
                    child.setParent(field);
                }
                AbstractBizUnitCtrl.setBizFieldRelation(((BizGroupFieldInfo)field).getFields());
            }
        }
    }

    private static void setSavedProperty(BizFieldCollection fields, boolean saved) {
        if (fields == null) {
            return;
        }
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = fields.get(i);
            bizField.setSaved(saved);
            if (!(bizField instanceof BizGroupFieldInfo)) continue;
            BizGroupFieldInfo groupField = (BizGroupFieldInfo)bizField;
            int m = groupField.getFields().size();
            for (int j = 0; j < m; ++j) {
                groupField.getFields().get(j).setSaved(saved);
            }
        }
    }

    protected BizMethodCollection extractBizMethods(BizUnitInfo bizUnit) throws BIMException {
        EntityObjectInfo entity = bizUnit.getEntity();
        UIObjectInfo editUI = bizUnit.getEditUI();
        UIObjectInfo listUI = bizUnit.getListUI();
        WebUIObjectInfo webEditUI = bizUnit.getWebEditUI();
        WebUIObjectInfo webListUI = bizUnit.getWebListUI();
        FunctionObjectInfo entityFunction = bizUnit.getEntityFunction();
        FunctionObjectInfo editUIFunction = bizUnit.getEditUIFunction();
        FunctionObjectInfo listUIFunction = bizUnit.getListUIFunction();
        BizMethodCollection methods = this.extractEntityMethods(bizUnit, entity);
        this.extractEditUIActions(editUI, methods, bizUnit, false);
        this.extractListUIActions(listUI, methods, false);
        this.extractEditUIActions(webEditUI, methods, bizUnit, true);
        this.extractListUIActions(webListUI, methods, true);
        this.extractEntityFunctionOperations(entityFunction, methods);
        this.extractUIFunctionOperations(editUIFunction, methods);
        this.extractUIFunctionOperations(listUIFunction, methods);
        return methods;
    }

    public static BizDataType getBizDataType(DataType dataType) throws BIMException {
        BizDataType bizDataType = null;
        if (dataType == DataType.STRING) {
            bizDataType = BizDataType.STRING;
        } else if (dataType == DataType.DATE) {
            bizDataType = BizDataType.DATE;
        } else if (dataType == DataType.DECIMAL || dataType == DataType.FLOAT || dataType == DataType.DOUBLE) {
            bizDataType = BizDataType.DECIMAL;
        } else if (dataType == DataType.INTEGER || dataType == DataType.LONG || dataType == DataType.SHORT) {
            bizDataType = BizDataType.INTEGER;
        } else if (dataType == DataType.STRING) {
            bizDataType = BizDataType.NOTE;
        } else if (dataType == DataType.BOOLEAN) {
            bizDataType = BizDataType.BOOLEAN;
        } else if (dataType == DataType.TIMESTAMP) {
            bizDataType = BizDataType.DATE;
        } else if (dataType == DataType.ENUM) {
            bizDataType = BizDataType.ENUM;
        } else if (dataType == DataType.BYTEARRAY) {
            bizDataType = BizDataType.IMAGE;
        } else if (dataType == DataType.BOSUUID) {
            bizDataType = BizDataType.STRING;
        } else if (dataType == DataType.TIME) {
            bizDataType = BizDataType.TIME;
        } else if (dataType == DataType.BYTEARRAY) {
            bizDataType = BizDataType.IMAGE;
        } else {
            throw new BIMException("unknow bizDataType:" + dataType);
        }
        return bizDataType;
    }

    public static boolean isBizDataTypeEquals(BizDataType firstDataType, BizDataType secondDataType) {
        boolean bEquals = false;
        if (firstDataType.equals((Object)secondDataType)) {
            bEquals = true;
        } else if (BizDataType.AMOUNT.equals((Object)firstDataType) && (BizDataType.DECIMAL.equals((Object)secondDataType) || BizDataType.QUANTITY.equals((Object)secondDataType) || BizDataType.PRICE.equals((Object)secondDataType) || BizDataType.INTEGER.equals((Object)secondDataType))) {
            bEquals = true;
        } else if (BizDataType.QUANTITY.equals((Object)firstDataType) && (BizDataType.DECIMAL.equals((Object)secondDataType) || BizDataType.AMOUNT.equals((Object)secondDataType) || BizDataType.PRICE.equals((Object)secondDataType) || BizDataType.INTEGER.equals((Object)secondDataType))) {
            bEquals = true;
        } else if (BizDataType.PRICE.equals((Object)firstDataType) && (BizDataType.DECIMAL.equals((Object)secondDataType) || BizDataType.AMOUNT.equals((Object)secondDataType) || BizDataType.QUANTITY.equals((Object)secondDataType) || BizDataType.INTEGER.equals((Object)secondDataType))) {
            bEquals = true;
        } else if (BizDataType.DECIMAL.equals((Object)firstDataType) && (BizDataType.PRICE.equals((Object)secondDataType) || BizDataType.AMOUNT.equals((Object)secondDataType) || BizDataType.QUANTITY.equals((Object)secondDataType) || BizDataType.INTEGER.equals((Object)secondDataType))) {
            bEquals = true;
        }
        return bEquals;
    }

    public static void afterSave(BizUnitInfo bizUnit) {
        bizUnit.removeDeletedFields();
        AbstractBizUnitCtrl.setSavedProperty(bizUnit.getFields(), true);
    }

    public static void beforeSave(BizUnitInfo bizUnit) {
        FunctionObjectInfo listUIFunction;
        FunctionObjectInfo editUIFunction;
        FunctionObjectInfo entityFunction;
        JoinQueryInfo relatedQuery;
        WebPageObjectCollection webPages;
        WebPageObjectInfo relatedWebEditPage;
        WebPageObjectInfo webBriefPage;
        WebPageObjectInfo webViewPage;
        WebPageObjectInfo webListPage;
        WebPageObjectInfo webEditPage;
        WebUIObjectInfo relatedWebEditUI;
        UIObjectInfo relatedEditUI;
        WebUIObjectInfo webListUI;
        WebUIObjectInfo webEditUI;
        UIObjectInfo listUI;
        UIObjectInfo editUI;
        JoinQueryInfo query;
        if (bizUnit.getEntryUI() != null) {
            bizUnit.setString("entryUIPK", AbstractBizUnitCtrl.getPKFullName(bizUnit.getEntryUI().getRealPackage(), bizUnit.getEntryUI().getRealName()));
        }
        List menuPKList = bizUnit.getMenuPKList();
        String menuPKString = "";
        int n = menuPKList.size();
        for (int i = 0; i < n; ++i) {
            menuPKString = i == 0 ? menuPKString + (String)menuPKList.get(i) : menuPKString + ";" + (String)menuPKList.get(i);
        }
        bizUnit.setString("menuPKList", menuPKString);
        EntityObjectInfo entity = bizUnit.getEntity();
        if (entity != null) {
            bizUnit.setString("entityPK", AbstractBizUnitCtrl.getPKFullName(entity.getRealPackage(), entity.getRealName()));
        }
        if ((query = bizUnit.getQuery()) != null) {
            bizUnit.setString("queryPK", AbstractBizUnitCtrl.getPKFullName(query.getRealPackage(), query.getRealName()));
        }
        if ((editUI = bizUnit.getEditUI()) != null) {
            bizUnit.setString("editUIPK", AbstractBizUnitCtrl.getPKFullName(editUI.getRealPackage(), editUI.getRealName()));
        }
        if ((listUI = bizUnit.getListUI()) != null) {
            bizUnit.setString("listUIPK", AbstractBizUnitCtrl.getPKFullName(listUI.getRealPackage(), listUI.getRealName()));
        }
        if ((webEditUI = bizUnit.getWebEditUI()) != null) {
            bizUnit.setWebEditUIPK(webEditUI.getRealFullName());
        }
        if ((webListUI = bizUnit.getWebListUI()) != null) {
            bizUnit.setWebListUIPK(webListUI.getRealFullName());
        }
        if ((relatedEditUI = bizUnit.getRelatedTreeUI()) != null) {
            bizUnit.setRelatedEditUIPK(relatedEditUI.getRealFullName());
        }
        if ((relatedWebEditUI = bizUnit.getRelatedWebTreeUI()) != null) {
            bizUnit.setRelatedWebEditUIPK(relatedWebEditUI.getRealFullName());
        }
        if ((webEditPage = bizUnit.getWebEditPage()) != null) {
            bizUnit.setWebEditPagePK(webEditPage.getRealFullName());
        }
        if ((webListPage = bizUnit.getWebListPage()) != null) {
            bizUnit.setWebListPagePK(webListPage.getRealFullName());
        }
        if ((webViewPage = bizUnit.getWebViewPage()) != null) {
            bizUnit.setWebViewPagePK(webViewPage.getRealFullName());
        }
        if ((webBriefPage = bizUnit.getWebBriefPage()) != null) {
            bizUnit.setWebBriefPagePK(webBriefPage.getRealFullName());
        }
        if ((relatedWebEditPage = bizUnit.getRelatedWebEditPage()) != null) {
            bizUnit.setRelatedWebEditPagePK(relatedWebEditPage.getRealFullName());
        }
        if ((webPages = bizUnit.getWebPages()).size() > 0) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < webPages.size(); ++i) {
                buf.append(webPages.get(i).getRealFullName());
                if (i == webPages.size() - 1) continue;
                buf.append(";");
            }
            bizUnit.setWebPagePKS(buf.toString());
        }
        if ((relatedQuery = bizUnit.getRelatedQuery()) != null) {
            bizUnit.setString("relatedQueryPK", AbstractBizUnitCtrl.getPKFullName(relatedQuery.getRealPackage(), relatedQuery.getRealName()));
        }
        if ((entityFunction = bizUnit.getEntityFunction()) != null) {
            bizUnit.setString("entityFunctionPK", AbstractBizUnitCtrl.getPKFullName(entityFunction.getRealPackage(), entityFunction.getRealName()));
        }
        if ((editUIFunction = bizUnit.getEditUIFunction()) != null) {
            bizUnit.setString("editUIFunctionPK", AbstractBizUnitCtrl.getPKFullName(editUIFunction.getRealPackage(), editUIFunction.getRealName()));
        }
        if ((listUIFunction = bizUnit.getListUIFunction()) != null) {
            bizUnit.setString("listUIFunctionPK", AbstractBizUnitCtrl.getPKFullName(listUIFunction.getRealPackage(), listUIFunction.getRealName()));
        }
        bizUnit.setString("menuPKList", AbstractBizUnitCtrl.convertArrayToString(bizUnit.getMenuPKList()));
    }

    private static String convertArrayToString(List list) {
        String result = "";
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                result = i == 0 ? result + list.get(i) : result + ";" + list.get(i);
            }
        }
        return result;
    }

    public static void afterLoad(BizUnitInfo bizUnit) throws BIMException {
    }

    @Override
    public void deploy(IMetaDataPK pk, DeployOptionInfo options) throws BOSException {
        super.deploy(pk, options);
    }

    public static BizFieldInfo getFieldByControlName(BizFieldCollection bizFields, String controlName) {
        if (StringUtils.isEmpty((String)controlName)) {
            return null;
        }
        int n = bizFields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = bizFields.get(i);
            if (controlName.equalsIgnoreCase(bizField.getControlName())) {
                return bizField;
            }
            if (!(bizField instanceof BizGroupFieldInfo)) continue;
            BizFieldCollection subFields = ((BizGroupFieldInfo)bizField).getFields();
            int m = subFields.size();
            for (int j = 0; j < m; ++j) {
                bizField = subFields.get(j);
                if (!controlName.equalsIgnoreCase(bizField.getControlName())) continue;
                return bizField;
            }
        }
        return null;
    }

    private static String getPackageWithSuffix(String pk, SuffixCollection c, BOSObjectType type) {
        assert (pk != null);
        SuffixInfo info = c.get(type);
        if (info != null && !StringUtils.isEmpty((String)info.getSuffix())) {
            if (pk.length() == 0) {
                return info.getSuffix();
            }
            return pk + "." + info.getSuffix();
        }
        if (MetaDataTypeList.WEBUIOBJECT.equals((Object)type)) {
            if (pk.length() == 0) {
                return "web";
            }
            return pk + ".web";
        }
        return pk;
    }

    public static String getPKFullName(String packageName, String name) {
        if (StringUtils.isEmpty((String)packageName)) {
            return name;
        }
        return packageName + "." + name;
    }

    private static String getEntryName(String entityName, String entrysName) {
        String name = entrysName;
        if (name.endsWith("ies")) {
            name = name.substring(0, name.length() - 3) + "y";
        } else if (name.endsWith("s")) {
            name = name.substring(0, name.length() - 1);
        }
        name = entityName + StringUtils.headCharUpperCase((String)name);
        return name;
    }

    public BizUnitInfo clone(BizUnitInfo srcUnit, SuffixCollection c, String pk, String name, String[] removeFields, int clientMode) {
        BizUnitInfo bizUnit;
        block12: {
            bizUnit = this.clone(srcUnit, c, pk, name, clientMode);
            try {
                int i;
                BizFieldCollection fields = bizUnit.getFields();
                bizUnit.setLoading(false);
                bizUnit.attach(new TableProxy(this.getContext(), bizUnit.getTable()));
                bizUnit.attach(new EntityProxy(this.getContext(), bizUnit.getEntity()));
                bizUnit.attach(new QueryProxy(this.getContext(), bizUnit.getQuery()));
                if (clientMode != 1) {
                    bizUnit.attach(new EditUIProxy(this.getContext(), bizUnit.getEditUI()));
                    bizUnit.attach(new ListUIProxy(this.getContext(), bizUnit.getListUI()));
                    bizUnit.attach(new RuleSetProxy(this.getContext(), bizUnit.getRuleSet()));
                }
                if (clientMode != 0) {
                    bizUnit.attach(new WebEditUIProxy(this.getContext(), bizUnit.getWebEditUI()));
                    bizUnit.attach(new WebListUIProxy(this.getContext(), bizUnit.getWebListUI()));
                }
                if (removeFields == null || removeFields.length <= 0) break block12;
                Hashtable<String, String> fieldHash = new Hashtable<String, String>();
                int n = removeFields.length;
                for (i = 0; i < n; ++i) {
                    fieldHash.put(removeFields[i], "");
                }
                n = fields.size();
                for (i = 0; i < n; ++i) {
                    BizFieldInfo field = fields.get(i);
                    if (field instanceof BizGroupFieldInfo) {
                        String groupName = field.getName();
                        if (fieldHash.containsKey(groupName)) {
                            if (field.getParent() != null && field.getParent().getUIObject() != null) {
                                field.getParent().setObjectState(ObjectStateType.DELETING);
                            }
                            field.setObjectState(ObjectStateType.DELETING);
                            field.setEffectUI(6);
                            continue;
                        }
                        BizFieldCollection subFields = ((BizGroupFieldInfo)field).getFields();
                        int m = subFields.size();
                        for (int j = 0; j < m; ++j) {
                            if (!fieldHash.containsKey(groupName + "." + subFields.get(j).getName())) continue;
                            subFields.get(j).setObjectState(ObjectStateType.DELETING);
                            subFields.get(j).setEffectUI(6);
                        }
                        continue;
                    }
                    if (!fieldHash.containsKey(field.getName())) continue;
                    field.setObjectState(ObjectStateType.DELETING);
                    field.setEffectUI(6);
                }
                bizUnit.doSynchronize(this.getContext());
            }
            catch (BIMException e) {
                log.error((Object)"error", (Throwable)((Object)e));
            }
        }
        if (AbstractBizUnitCtrl.setSCMBillCopyTag(bizUnit, srcUnit.getEntity()) && bizUnit.getEntity() != null && bizUnit.getEntity().getTable() != null) {
            DataTableInfo table = bizUnit.getEntity().getTable();
            table.getIndexes().clear();
            BizFieldCollection fields = bizUnit.getFields();
            int n = fields.size();
            for (int i = 0; i < n; ++i) {
                BizGroupFieldInfo groupField;
                if (!(fields.get(i) instanceof BizGroupFieldInfo) || (groupField = (BizGroupFieldInfo)fields.get(i)).getEntityObject() == null || groupField.getEntityObject().getTable() == null) continue;
                groupField.getEntityObject().getTable().getIndexes().clear();
            }
        }
        return bizUnit;
    }

    public BizUnitInfo clone(BizUnitInfo srcUnit, SuffixCollection c, String pk, String name, int clientMode) {
        int i;
        int n;
        if (srcUnit == null) {
            return null;
        }
        List list = BizUnitHelper.getRelatedMetadatas(srcUnit);
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((AbstractMetaDataValue)list.get(i2)).setDirty(true);
        }
        BizUnitInfo desUnit = (BizUnitInfo)srcUnit.clone();
        if (clientMode == 0) {
            desUnit.setWebEditUI(null);
            desUnit.setWebEditUIPK(null);
            desUnit.setWebListUI(null);
            desUnit.setWebListUIPK(null);
        } else if (clientMode == 1) {
            desUnit.setEditUI(null);
            desUnit.setEditUIPK(null);
            desUnit.setListUI(null);
            desUnit.setListUIPK(null);
        }
        if (desUnit.getEditUI() != null) {
            UIObjectInfo editUI = desUnit.getEditUI();
            if (editUI.getRuleSet() == null) {
                editUI.setRuleSet(new RuleSetInfo());
            }
            editUI.getRuleSet().setPackage(AbstractBizUnitCtrl.getPackageWithSuffix(pk, c, MetaDataTypeList.ENTITY));
            editUI.getRuleSet().setName(name + "RuleSet");
        }
        desUnit.setName(name);
        desUnit.setPackage(pk);
        if (desUnit.getTable() != null) {
            desUnit.getTable().setPackage(AbstractBizUnitCtrl.getPackageWithSuffix(pk, c, MetaDataTypeList.ABSTRACTTABLE));
            AbstractBizUnitCtrl.updateTable(desUnit.getTable(), BIMNameFactory.createTableName(pk, name));
        }
        this.updateEntity(desUnit.getEntity(), desUnit.getTable(), c, pk, name);
        desUnit.getEntity().setAbstract(false);
        desUnit.getEntity().setSubClassingMode(SubClassingMode.NORMAL);
        if (desUnit.getQuery() != null) {
            desUnit.getQuery().setExtendedProperty("f7WindowTitle", desUnit.getAlias());
            desUnit.getQuery().setPackage(AbstractBizUnitCtrl.getPackageWithSuffix(pk, c, MetaDataTypeList.BASEQUERY));
            AbstractBizUnitCtrl.updateQuery(desUnit.getQuery(), name + "Query");
            AbstractBizUnitCtrl.updateQuery(desUnit.getQuery(), srcUnit.getEntity(), desUnit.getEntity());
            EntityObjectInfo entity = desUnit.getEntity();
            PropertyCollection props = entity.getProperties();
            n = props.size();
            for (i = 0; i < n; ++i) {
                EntityObjectInfo subEntity;
                LinkPropertyInfo lnkProp;
                RelationshipInfo rel;
                com.kingdee.bos.metadata.entity.PropertyInfo prop = props.get(i);
                if (!(prop instanceof LinkPropertyInfo) || (rel = (lnkProp = (LinkPropertyInfo)prop).getRelationship()).getType() != RelationshipType.COMPOSITION || rel.getSupplierCardinality() != CardinalityType.ZERO_TO_UNBOUNDED && rel.getSupplierCardinality() != CardinalityType.ONE_TO_UNBOUNDED || (subEntity = rel.getSupplierObject()).getTable() == null) continue;
                AbstractBizUnitCtrl.updateQuery(desUnit.getQuery(), srcUnit.getEntity(), desUnit.getEntity());
            }
        }
        if (desUnit.getEditUI() != null) {
            desUnit.getEditUI().setPackage(AbstractBizUnitCtrl.getPackageWithSuffix(pk, c, MetaDataTypeList.UIOBJECT));
            AbstractBizUnitCtrl.updateEditUI(desUnit.getEditUI(), name + "EditUI");
            AbstractBizUnitCtrl.updateEditUI((AbstractUIObjectInfo)desUnit.getEditUI(), srcUnit.getEntity(), desUnit.getEntity());
        }
        if (desUnit.getListUI() != null) {
            desUnit.getListUI().setPackage(AbstractBizUnitCtrl.getPackageWithSuffix(pk, c, MetaDataTypeList.UIOBJECT));
            AbstractBizUnitCtrl.updateListUI(desUnit.getListUI(), name + "ListUI");
            AbstractBizUnitCtrl.updateListUI(desUnit.getListUI(), srcUnit.getQuery(), desUnit.getQuery(), srcUnit.getEntity(), desUnit.getEntity());
        }
        if (desUnit.getWebEditUI() != null) {
            desUnit.getWebEditUI().setPackage(AbstractBizUnitCtrl.getPackageWithSuffix(pk, c, MetaDataTypeList.WEBUIOBJECT));
            AbstractBizUnitCtrl.updateEditUI(desUnit.getWebEditUI(), name + "EditUI");
            AbstractBizUnitCtrl.updateWebEditUI(srcUnit, desUnit);
        }
        if (desUnit.getWebListUI() != null) {
            desUnit.getWebListUI().setPackage(AbstractBizUnitCtrl.getPackageWithSuffix(pk, c, MetaDataTypeList.WEBUIOBJECT));
            AbstractBizUnitCtrl.updateListUI(desUnit.getWebListUI(), name + "ListUI");
            AbstractBizUnitCtrl.updateWebListUI(srcUnit, desUnit);
        }
        if (desUnit.getEntityFunction() != null) {
            desUnit.getEntityFunction().setPackage(AbstractBizUnitCtrl.getPackageWithSuffix(pk, c, MetaDataTypeList.FUNCTION));
            AbstractBizUnitCtrl.updateEntityFunction(desUnit.getEntityFunction(), name + "Function");
            AbstractBizUnitCtrl.updateEntityFunction(desUnit.getEntityFunction(), srcUnit.getEntity(), desUnit.getEntity());
            AbstractBizUnitCtrl.updateUIFunction(desUnit.getEntityFunction(), null, desUnit.getEditUI());
            AbstractBizUnitCtrl.updateWebUIFunction(desUnit.getEntityFunction(), srcUnit.getWebEditUI(), desUnit.getWebEditUI());
        }
        if (desUnit.getEditUIFunction() != null) {
            desUnit.getEditUIFunction().setPackage(AbstractBizUnitCtrl.getPackageWithSuffix(pk, c, MetaDataTypeList.FUNCTION));
            AbstractBizUnitCtrl.updateUIFunction(desUnit.getEditUIFunction(), name + "EditUIFunction");
            AbstractBizUnitCtrl.updateUIFunction(desUnit.getEditUIFunction(), desUnit.getEntity(), desUnit.getEditUI());
            AbstractBizUnitCtrl.updateWebUIFunction(desUnit.getEditUIFunction(), srcUnit.getWebEditUI(), desUnit.getWebEditUI());
        }
        if (desUnit.getListUIFunction() != null) {
            desUnit.getListUIFunction().setPackage(AbstractBizUnitCtrl.getPackageWithSuffix(pk, c, MetaDataTypeList.FUNCTION));
            AbstractBizUnitCtrl.updateUIFunction(desUnit.getListUIFunction(), name + "ListUIFunction");
            AbstractBizUnitCtrl.updateUIFunction(desUnit.getListUIFunction(), desUnit.getEntity(), desUnit.getListUI());
            AbstractBizUnitCtrl.updateWebUIFunction(desUnit.getListUIFunction(), srcUnit.getWebListUI(), desUnit.getWebListUI());
        }
        UIObjectInfo editUI = desUnit.getEditUI();
        WebUIObjectInfo webEditUI = desUnit.getWebEditUI();
        EntityObjectInfo entity = desUnit.getEntity();
        DataTableInfo table = desUnit.getTable();
        String templateType = srcUnit.getBimTemplateType();
        if (!StringUtils.isEmpty((String)templateType) && !templateType.equalsIgnoreCase("BillBase") && (templateType.equalsIgnoreCase("TreeDetail") || templateType.equalsIgnoreCase("TreeDetail4Detail"))) {
            String relatedEditUIPK = null;
            String relatedWebEditUIPK = null;
            String relatedEntityPK = null;
            String relatedTablePK = null;
            if (entity != null) {
                relatedEntityPK = srcUnit.getRelatedEntityPK();
                if (table != null) {
                    relatedTablePK = srcUnit.getRelatedTablePK();
                }
            }
            if (editUI != null) {
                relatedEditUIPK = srcUnit.getRelatedEditUIPK();
            }
            if (webEditUI != null) {
                relatedWebEditUIPK = srcUnit.getRelatedWebEditUIPK();
            }
            DataTableCtrl tableCtrl = new DataTableCtrl(this.getContext());
            EntityObjectCtrl entityCtrl = new EntityObjectCtrl(this.getContext());
            UIObjectCtrl uiCtrl = new UIObjectCtrl(this.getContext());
            WebUIObjectCtrl webUICtrl = new WebUIObjectCtrl(this.getContext());
            try {
                EntityObjectInfo oldRelatedEntity = null;
                DataTableInfo oldRelatedTable = null;
                AbstractMDValue relatedTable = null;
                UIObjectInfo relatedEditUI = null;
                WebUIObjectInfo relatedWebEditUI = null;
                EntityObjectInfo newRelatedEntity = null;
                if (!StringUtils.isEmpty((String)relatedEntityPK)) {
                    oldRelatedEntity = entityCtrl.getValue(MetaDataPK.create(relatedEntityPK));
                    if (oldRelatedEntity != null) {
                        newRelatedEntity = (EntityObjectInfo)oldRelatedEntity.clone();
                        oldRelatedTable = oldRelatedEntity.getTable();
                        if (oldRelatedTable == null && !StringUtils.isEmpty((String)relatedTablePK)) {
                            oldRelatedTable = tableCtrl.getValue(MetaDataPK.create(relatedTablePK));
                        }
                        if (oldRelatedTable != null) {
                            relatedTable = (DataTableInfo)oldRelatedTable.clone();
                            newRelatedEntity.setTable((DataTableInfo)relatedTable);
                        }
                        if (relatedTable != null) {
                            ((AbstractMetaDataValue)relatedTable).setPackage(AbstractBizUnitCtrl.getPackageWithSuffix(pk, c, MetaDataTypeList.ABSTRACTTABLE));
                            AbstractBizUnitCtrl.updateTable((DataTableInfo)relatedTable, BIMNameFactory.createTreeTableName(pk, name));
                        }
                        this.updateEntity(newRelatedEntity, (DataTableInfo)relatedTable, c, pk, name + "Tree");
                        newRelatedEntity.setAbstract(false);
                        newRelatedEntity.setSubClassingMode(SubClassingMode.NORMAL);
                    }
                    DataTableInfo tableInfo = desUnit.getTable();
                    ForeignKeyCollection fks = tableInfo.getForeignKeys();
                    ForeignKeyInfo fk = null;
                    int size = fks.size();
                    for (int loop = 0; loop < size; ++loop) {
                        fk = fks.get(loop);
                        if (!"FTreeID".equalsIgnoreCase(fk.getFKColumnPairs().get(0).getForeignKeyColumn().getName())) continue;
                        fk.setRefTable((AbstractTableInfo)relatedTable);
                    }
                }
                if (!StringUtils.isEmpty((String)relatedEditUIPK) && (relatedEditUI = uiCtrl.getAllValue(MetaDataPK.create(relatedEditUIPK))) != null) {
                    relatedEditUI.setPackage(AbstractBizUnitCtrl.getPackageWithSuffix(pk, c, MetaDataTypeList.UIOBJECT));
                    AbstractBizUnitCtrl.updateEditUI(relatedEditUI, name + "TreeEditUI");
                    if (newRelatedEntity != null && oldRelatedEntity != null) {
                        AbstractBizUnitCtrl.updateEditUI((AbstractUIObjectInfo)relatedEditUI, oldRelatedEntity, newRelatedEntity);
                        newRelatedEntity.setExtendedProperty("defaultF7Query", null);
                        newRelatedEntity.setExtendedProperty("editUI", relatedEditUI.getRealFullName());
                        newRelatedEntity.setBizUnitPK(desUnit.getRealFullName());
                    }
                }
                if (!StringUtils.isEmpty((String)relatedWebEditUIPK) && (relatedWebEditUI = webUICtrl.getAllValue(MetaDataPK.create(relatedWebEditUIPK))) != null) {
                    relatedWebEditUI.setPackage(AbstractBizUnitCtrl.getPackageWithSuffix(pk, c, MetaDataTypeList.WEBUIOBJECT));
                    AbstractBizUnitCtrl.updateEditUI(relatedWebEditUI, name + "TreeEditUI");
                    if (newRelatedEntity != null && oldRelatedEntity != null) {
                        AbstractBizUnitCtrl.updateEditUI(relatedWebEditUI, oldRelatedEntity, newRelatedEntity);
                        newRelatedEntity.setExtendedProperty("defaultF7Query", null);
                        newRelatedEntity.setExtendedProperty("editUI", relatedWebEditUI.getRealFullName());
                        newRelatedEntity.setBizUnitPK(desUnit.getRealFullName());
                    }
                }
                if (relatedTable != null) {
                    desUnit.setRelatedTable((DataTableInfo)relatedTable);
                    desUnit.setRelatedTablePK(AbstractBizUnitCtrl.getPKFullName(relatedTable.getRealPackage(), relatedTable.getRealName()));
                }
                if (newRelatedEntity != null) {
                    desUnit.setRelatedEntity(newRelatedEntity);
                    desUnit.setRelatedEntityPK(AbstractBizUnitCtrl.getPKFullName(newRelatedEntity.getRealPackage(), newRelatedEntity.getRealName()));
                    PropertyCollection props = entity.getProperties();
                    int n3 = props.size();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        RelationshipInfo relation;
                        LinkPropertyInfo lnkProp;
                        com.kingdee.bos.metadata.entity.PropertyInfo prop = props.get(i3);
                        if (!(prop instanceof LinkPropertyInfo) || (lnkProp = (LinkPropertyInfo)prop) == null || lnkProp.getRelationship() == null || (relation = lnkProp.getRelationship()).getSupplierCardinality() != CardinalityType.ZERO_TO_ONE && relation.getSupplierCardinality() != CardinalityType.ONE || !relation.getSupplierObject().equals(oldRelatedEntity)) continue;
                        relation.setName(entity.getRealName() + "_" + newRelatedEntity.getRealName());
                        relation.setSupplierObject(newRelatedEntity);
                    }
                    AbstractBizUnitCtrl.updateQuery(desUnit.getQuery(), oldRelatedEntity, newRelatedEntity);
                }
                if (relatedEditUI != null) {
                    desUnit.setRelatedTreeUI(relatedEditUI);
                    desUnit.setRelatedEditUIPK(AbstractBizUnitCtrl.getPKFullName(relatedEditUI.getRealPackage(), relatedEditUI.getRealName()));
                }
                if (relatedWebEditUI != null) {
                    desUnit.setRelatedWebTreeUI(relatedWebEditUI);
                    desUnit.setRelatedWebEditUIPK(AbstractBizUnitCtrl.getPKFullName(relatedWebEditUI.getRealPackage(), relatedWebEditUI.getRealName()));
                }
            }
            catch (Exception e) {
                log.error((Object)"error", (Throwable)e);
            }
        }
        if (desUnit.getEntity() != null && desUnit.getQuery() != null) {
            desUnit.getEntity().setExtendedProperty("defaultF7Query", AbstractBizUnitCtrl.getPKFullName(desUnit.getQuery().getRealPackage(), desUnit.getQuery().getRealName()));
        }
        AbstractBizUnitCtrl.setUserDefined(desUnit, ConvertUtils.getUserDefinedBooleanVaule());
        if (desUnit.getEditUI() != null && editUI != null) {
            RuleSetInfo ruleSet = editUI.getRuleSet();
            if (ruleSet == null) {
                ruleSet = new RuleSetInfo();
                editUI.setRuleSet(ruleSet);
            }
            ruleSet.setUserDefined(true);
            ruleSet.setPackage(AbstractBizUnitCtrl.getPackageWithSuffix(pk, c, MetaDataTypeList.ENTITY));
            ruleSet.setName(name + "RuleSet");
        }
        if (desUnit.getEntryUI() != null) {
            BizFieldCollection bizFields = desUnit.getFields();
            int n4 = bizFields.size();
            for (int i4 = 0; i4 < n4; ++i4) {
                BizFieldInfo bizField = bizFields.get(i4);
                if (!(bizField instanceof BizGroupFieldInfo) || bizField.getParent() == null || bizField.getParent().getUIObject() == null) continue;
                UIObjectInfo entryUI = srcUnit.getFields().get(i4).getParent().getUIObject();
                String oldEntryUIPK = AbstractBizUnitCtrl.getPKFullName(entryUI.getRealPackage(), entryUI.getRealName());
                entryUI.setPackage(AbstractBizUnitCtrl.getPackageWithSuffix(pk, c, MetaDataTypeList.UIOBJECT));
                AbstractBizUnitCtrl.updateEditUI(entryUI, name + bizField.getName() + "EditUI");
                AbstractBizUnitCtrl.updateEditUI((AbstractUIObjectInfo)entryUI, srcUnit.getEntity(), desUnit.getEntity());
                String newEntryUIPK = AbstractBizUnitCtrl.getPKFullName(entryUI.getRealPackage(), entryUI.getRealName());
                bizField.getParent().setExtendedProperty("uiObject", newEntryUIPK);
                AbstractBizUnitCtrl.updateEditUI(editUI, oldEntryUIPK, newEntryUIPK);
                entryUI.setRuleSet(editUI.getRuleSet());
                entryUI = UIObjectAssembler.assembleUI(this.getContext(), entryUI);
                bizField.getParent().setUIObject(entryUI);
            }
        }
        if ((entity = desUnit.getEntity()) != null) {
            if (desUnit.getQuery() != null) {
                entity.setExtendedProperty("defaultF7Query", desUnit.getQuery().getRealFullName());
            }
            if (desUnit.getListUI() != null) {
                entity.setExtendedProperty("listUI", desUnit.getListUI().getRealFullName());
            } else {
                entity.removeExtendedProperty("listUI");
            }
            if (desUnit.getEditUI() != null) {
                entity.setExtendedProperty("editUI", desUnit.getEditUI().getRealFullName());
            } else {
                entity.removeExtendedProperty("editUI");
            }
            if (desUnit.getWebListUI() != null) {
                entity.setExtendedProperty("webListUI", desUnit.getWebListUI().getRealFullName());
            } else {
                entity.removeExtendedProperty("webListUI");
            }
            if (desUnit.getWebEditUI() != null) {
                entity.setExtendedProperty("webEditUI", desUnit.getWebEditUI().getRealFullName());
            } else {
                entity.removeExtendedProperty("webEditUI");
            }
            if (desUnit.getEditUI() == null && desUnit.getWebEditUI() != null) {
                entity.setExtendedProperty("webSupportOnly", "true");
            }
            entity.setExtendedProperty("isParamObject", "false");
            entity.setExtendedProperty("codingRuleEnabled", "true");
            if (BizType.BaseData.equals((Object)desUnit.getBizType())) {
                entity.setExtendedProperty("defaultDisplayField", desUnit.getExtendedProperty("defaultDisplayField") == null ? "" : desUnit.getExtendedProperty("defaultDisplayField"));
            } else {
                entity.setExtendedProperty("defaultDisplayField", "");
            }
            if (srcUnit.getEntity() != null && !StringUtils.isEmpty((String)srcUnit.getEntity().getExtendedProperty("controllerBeanEx"))) {
                desUnit.setExtendedProperty("controllerBeanEx", entity.getBusinessControllerBean() + "Ex");
                entity.setExtendedProperty("controllerBeanEx", entity.getBusinessControllerBean() + "Ex");
            }
        }
        desUnit.setGenImplementCode(true);
        list = BizUnitHelper.getRelatedMetadatas(desUnit);
        n = list.size();
        for (i = 0; i < n; ++i) {
            ((AbstractMetaDataValue)list.get(i)).setDirty(true);
        }
        return desUnit;
    }

    private void updateEntity(EntityObjectInfo entity, DataTableInfo table, SuffixCollection c, String pk, String name) {
        if (entity != null) {
            entity.setPackage(AbstractBizUnitCtrl.getPackageWithSuffix(pk, c, MetaDataTypeList.ENTITY));
            AbstractBizUnitCtrl.updateEntity(entity, name);
            AbstractBizUnitCtrl.updateEntity(entity, table);
            PropertyCollection props = entity.getProperties();
            int n = props.size();
            for (int i = 0; i < n; ++i) {
                EntityObjectInfo subEntity;
                com.kingdee.bos.metadata.entity.PropertyInfo prop = props.get(i);
                if (!(prop instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo lnkProp = (LinkPropertyInfo)prop;
                RelationshipInfo rel = lnkProp.getRelationship();
                rel.setPackage(AbstractBizUnitCtrl.getPackageWithSuffix(pk, c, MetaDataTypeList.RELATIONSHIP));
                if (rel.getType() == RelationshipType.ASSOCIATION && (rel.getSupplierCardinality() == CardinalityType.ONE || rel.getSupplierCardinality() == CardinalityType.ZERO_TO_ONE)) {
                    if (entity.getFullName() != null && entity.getFullName().equals(rel.getSupplierObject().getFullName())) {
                        rel.setSupplierObject(entity);
                    }
                    AbstractBizUnitCtrl.updateRelationship(rel, "R_" + entity.getRealName() + "_" + rel.getSupplierObject().getRealName() + "_" + prop.getName());
                    rel.setClientObject(entity);
                    continue;
                }
                if (rel.getSupplierCardinality() != CardinalityType.ZERO_TO_UNBOUNDED && rel.getSupplierCardinality() != CardinalityType.ONE_TO_UNBOUNDED || (subEntity = rel.getSupplierObject()).equals(entity)) continue;
                subEntity.setAbstract(false);
                subEntity.setSubClassingMode(SubClassingMode.NORMAL);
                if (subEntity.getTable() != null) {
                    subEntity.getTable().setPackage(AbstractBizUnitCtrl.getPackageWithSuffix(pk, c, MetaDataTypeList.ABSTRACTTABLE));
                    String tableName = BIMNameFactory.createEntryTableName(pk, name, AbstractBizUnitCtrl.getEntryName(entity.getRealName(), lnkProp.getName()));
                    AbstractBizUnitCtrl.updateTable(subEntity.getTable(), tableName);
                }
                subEntity.setPackage(AbstractBizUnitCtrl.getPackageWithSuffix(pk, c, MetaDataTypeList.ENTITY));
                this.updateEntity(subEntity, subEntity.getTable(), c, pk, AbstractBizUnitCtrl.getEntryName(entity.getRealName(), lnkProp.getName()));
                AbstractBizUnitCtrl.updateRelationship(rel, "R_" + entity.getRealName() + "_" + rel.getSupplierObject().getRealName() + "_" + prop.getName());
                rel.setClientObject(entity);
            }
        }
    }

    private static void updateTable(DataTableInfo table, String newName) {
        table.setName(newName);
        if (table.getPrimaryKey() != null) {
            String pkName;
            pkName = pkName.substring(0, (pkName = BIMNameFactory.createTablePKName(table.getRealPackage(), table.getRealName(), "FID", true)).length() > 18 ? 18 : pkName.length());
            pkName = pkName.replace('.', '_');
            table.getPrimaryKey().setName(pkName);
        }
        ForeignKeyCollection fkcol = table.getForeignKeys();
        int n = fkcol.size();
        for (int i = 0; i < n; ++i) {
            ForeignKeyInfo fk = fkcol.get(i);
            String fkName = "";
            if (fk == null) continue;
            if (fk.getRefTable() != null && fk.getFKColumnPairs() != null && fk.getFKColumnPairs().get(0) != null && fk.getFKColumnPairs().get(0).getForeignKeyColumn() != null && fk.getFKColumnPairs().get(0).getForeignKeyColumn().getName() != null) {
                fkName = BIMNameFactory.createTableFKName(table.getRealPackage(), table.getRealName(), fk.getRefTable().getRealName(), fk.getFKColumnPairs().get(0).getForeignKeyColumn().getName(), true);
            }
            fkName = fkName.replace('.', '_');
            fk.setName(fkName);
        }
    }

    private static void updateEntity(EntityObjectInfo entity, String newName) {
        entity.setName(newName);
        entity.setType(AbstractBizUnitCtrl.genBOSType(entity.getRealFullName()));
        MethodCollection methods = entity.getMethods();
        int n = methods.size();
        for (int i = 0; i < n; ++i) {
            MethodInfo method = methods.get(i);
            if (!StringUtils.isEmpty((String)method.getMetaDataRef())) {
                method.setMetadataRef(entity.getRealFullName());
            }
            method.setString("innerID", Uuid.create().toString());
            ParameterCollection col = method.getParameters();
            int m = col.size();
            for (int j = 0; j < m; ++j) {
                ParameterInfo param = col.get(j);
                if (StringUtils.isEmpty((String)param.getMetaDataRef())) continue;
                param.setMetadataRef(entity.getRealFullName());
            }
        }
        EventCollection events = entity.getEvents();
        int l = events.size();
        for (int i = 0; i < l; ++i) {
            EventInfo event = events.get(i);
            FormalParameterCollection formalParams = event.getFormalParameters();
            int m = formalParams.size();
            for (int j = 0; j < m; ++j) {
                FormalParameterInfo formalParam = formalParams.get(j);
                if (formalParam.getParameter() == null) continue;
                formalParam.getParameter().setMetadataRef(entity.getRealFullName());
            }
        }
        entity.setBusinessControllerName(entity.getRealPackage() + "." + newName + "Controller");
        entity.setBusinessImplName(AbstractBizUnitCtrl.removePackageSuffix(entity.getRealPackage()) + "." + newName);
    }

    private static String removePackageSuffix(String packageName) {
        if (StringUtils.endsWithIgnoreCase((String)packageName, (String)".client")) {
            return packageName.substring(0, packageName.length() - ".client".length());
        }
        if (StringUtils.endsWithIgnoreCase((String)packageName, (String)".app")) {
            return packageName.substring(0, packageName.length() - ".app".length());
        }
        return packageName;
    }

    private static void updateEntity(EntityObjectInfo entity, DataTableInfo newTable) {
        entity.setTable(newTable);
        PropertyCollection props = entity.getProperties();
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            com.kingdee.bos.metadata.entity.PropertyInfo prop = props.get(i);
            if (prop.getMappingField() == null) continue;
            prop.setMappingField(newTable.getColumnByName(prop.getMappingField().getName()));
        }
    }

    private static void updateQuery(JoinQueryInfo query, String newName) {
        query.setName(newName);
    }

    private static void updateQuery(JoinQueryInfo query, EntityObjectInfo oldEntity, EntityObjectInfo newEntity) {
        SubObjectCollection subEntitys = query.getSubObjects();
        int n = subEntitys.size();
        for (int i = 0; i < n; ++i) {
            SubEntityInfo subEntity = (SubEntityInfo)subEntitys.get(i);
            if (subEntity.getEntityRef().equals(newEntity)) {
                subEntity.setEntityRef(newEntity);
                String oldSubEntityName = subEntity.getRealName();
                subEntity.setName(newEntity.getRealName());
                PropertyUnitCollection props = query.getUnits();
                int m = props.size();
                for (int j = 0; j < m; ++j) {
                    PropertyUnitInfo prop = props.get(j);
                    if (prop == null || prop.getPropertyRefs().size() != 1 || !StringUtils.equalsIgnoreCase((String)(subEntity = prop.getPropertyRefs().get(0).getSubEntity()).getRealName(), (String)oldSubEntityName)) continue;
                    subEntity.setName(newEntity.getRealName());
                }
                JoinCollection joins = query.getJoins();
                int m2 = joins.size();
                for (int j = 0; j < m2; ++j) {
                    SubObjectInfo subObj;
                    JoinInfo join = joins.get(j);
                    if (join == null || join.getLeftObject() == null || !StringUtils.equalsIgnoreCase((String)(subObj = join.getLeftObject()).getRealName(), (String)oldSubEntityName)) continue;
                    subObj.setName(newEntity.getRealName());
                }
                continue;
            }
            if (!subEntity.getEntityRef().getFullName().equalsIgnoreCase(oldEntity.getFullName())) continue;
            subEntity.setEntityRef(newEntity);
        }
    }

    private static void updateEditUI(AbstractUIObjectInfo editUI, String newName) {
        editUI.setName(newName);
    }

    private static void updateWebEditUI(BizUnitInfo srcUnit, BizUnitInfo desUnit) {
        AbstractBizUnitCtrl.updateEditUI(desUnit.getWebEditUI(), srcUnit.getEntity(), desUnit.getEntity());
        WebUIObjectInfo srcEditUI = srcUnit.getWebEditUI();
        WebUIObjectInfo desEditUI = desUnit.getWebEditUI();
        if (desEditUI != null) {
            Context ctx = ContextManager.getContext();
            SolutionCtrl solutionCtrl = new SolutionCtrl(ctx);
            SolutionInfo slnInfo = null;
            try {
                slnInfo = solutionCtrl.getValue();
            }
            catch (BOSException e) {
                log.error((Object)"solution not found", (Throwable)e);
            }
            if (slnInfo == null) {
                return;
            }
            Locale[] supportedLocales = slnInfo.getSupportedLocales();
            String elSrc = WebUIProxyHelper.getWebUIShortPackage(srcEditUI.getRealPackage()) + "." + srcEditUI.getRealName() + "Bean";
            String elDes = WebUIProxyHelper.getWebUIShortPackage(desEditUI.getRealPackage()) + "." + desEditUI.getRealName() + "Bean";
            EntityObjectInfo srcEntity = srcUnit.getEntity();
            EntityObjectInfo destEntity = desUnit.getEntity();
            String srcbindBean = srcEntity.getRealPackage().substring(0, srcEntity.getRealPackage().length() - 4) + "." + srcEntity.getRealName() + "Info";
            String destbindBean = destEntity.getRealPackage().substring(0, destEntity.getRealPackage().length() - 4) + "." + destEntity.getRealName() + "Info";
            ComponentCollection controls = AbstractBizUnitCtrl.treeToCol(desEditUI.getComponents());
            int n = controls.size();
            for (int m = 0; m < n; ++m) {
                ComponentInfo componentInfo = controls.get(m);
                com.kingdee.bos.metadata.ui.PropertyCollection ps = componentInfo.getProperties();
                int k = ps.size();
                for (int j = 0; j < k; ++j) {
                    int i;
                    PropertyInfo property = ps.get(j);
                    String value = property.getValue();
                    if ("bindBean".equalsIgnoreCase(property.getName())) {
                        value = StringUtils.replace((String)value, (String)srcbindBean, (String)destbindBean);
                        property.setValue(value);
                        if (supportedLocales != null) {
                            for (i = 0; i < supportedLocales.length; ++i) {
                                property.setValue(value, supportedLocales[i]);
                            }
                        }
                    }
                    if (!WebUIProxyHelper.isEL(value) || value.indexOf(elSrc) < 0) continue;
                    value = StringUtils.replace((String)value, (String)elSrc, (String)elDes);
                    property.setValue(value);
                    if (supportedLocales == null) continue;
                    for (i = 0; i < supportedLocales.length; ++i) {
                        property.setValue(value, supportedLocales[i]);
                    }
                }
            }
        }
    }

    private static void updateEditUI(UIObjectInfo editUI, String oldEntryUIPK, String newEntryUIPK) {
        ComponentCollection controls = AbstractBizUnitCtrl.treeToCol(editUI.getComponents());
        int m = controls.size();
        for (int j = 0; j < m; ++j) {
            String uiObjectPK;
            ComponentInfo control = controls.get(j);
            if (!control.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDPanel") || StringUtils.isEmpty((String)(uiObjectPK = control.getBimUIObjectPK())) || !uiObjectPK.equalsIgnoreCase(oldEntryUIPK)) continue;
            control.setBimUIObjectPK(newEntryUIPK);
        }
    }

    private static void updateEditUI(AbstractUIObjectInfo editUI, EntityObjectInfo oldEntity, EntityObjectInfo newEntity) {
        AbstractBizUnitCtrl.updateEditUI(editUI, oldEntity, newEntity, null, null);
    }

    private static void updateEditUI(AbstractUIObjectInfo editUI, EntityObjectInfo oldEntity, EntityObjectInfo newEntity, String oldEntryName, String newEntryName) {
        DataObjectCollection dataObjects = editUI.getDataObjects();
        ComponentCollection controls = AbstractBizUnitCtrl.treeToCol(editUI.getComponents());
        if (editUI instanceof WebUIObjectInfo) {
            Context ctx = ContextManager.getContext();
            SolutionCtrl solutionCtrl = new SolutionCtrl(ctx);
            SolutionInfo slnInfo = null;
            try {
                slnInfo = solutionCtrl.getValue();
            }
            catch (BOSException e) {
                log.error((Object)"solution not found", (Throwable)e);
            }
            if (slnInfo == null) {
                return;
            }
            Locale[] supportedLocales = slnInfo.getSupportedLocales();
            ComponentInfo innerWindow = WebUIProxyHelper.findInnerWindowUserTag(controls);
            if (innerWindow != null) {
                PropertyInfo pInfo = innerWindow.getPropertyByName("attributes");
                String shortName = WebUIProxyHelper.getWebUIShortPackage(editUI.getRealPackage());
                String value = "beanName=#{" + shortName + "." + editUI.getRealName() + "Bean}";
                if (supportedLocales != null) {
                    for (int i = 0; i < supportedLocales.length; ++i) {
                        pInfo.setValue(value, supportedLocales[i]);
                    }
                }
                pInfo.setOverride(true);
            }
        }
        int n = dataObjects.size();
        for (int i = 0; i < n; ++i) {
            DataObjectInfo dataObject = dataObjects.get(i);
            if (!dataObject.getType().equalsIgnoreCase(AbstractBizUnitCtrl.getPKFullName(oldEntity.getRealPackage(), oldEntity.getRealName()))) continue;
            if (dataObject.getRealName().equalsIgnoreCase(oldEntity.getRealName())) {
                dataObject.setName(newEntity.getRealName());
            }
            if (editUI instanceof WebUIObjectInfo) {
                PropertyCollection collection = newEntity.getInheritedNoDuplicatedProperties();
                int size = collection.size();
                for (int h = 0; h < size; ++h) {
                    ComponentInfo dataGrid;
                    EntityObjectInfo entityObj;
                    CardinalityType cardinalType;
                    com.kingdee.bos.metadata.entity.PropertyInfo prop = collection.get(h);
                    if (!(prop instanceof LinkPropertyInfo) || !CardinalityType.ONE_TO_UNBOUNDED.equals((Object)(cardinalType = ((LinkPropertyInfo)prop).getRelationship().getSupplierCardinality())) && !CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)cardinalType) || (entityObj = ((LinkPropertyInfo)prop).getRelationship().getSupplierObject()) == null || (dataGrid = WebUIProxyHelper.findBindingKDTable4Entry(controls, prop.getName(), "com.kingdee.bos.ctrl.web.EditDataGrid")) == null) continue;
                    String entryBeanName = Component2XmlHelper.getEntryBeanName((WebUIObjectInfo)editUI, entityObj);
                    PropertyInfo pvalue = new PropertyInfo();
                    pvalue.setName("value");
                    pvalue.setType("java.lang.String");
                    pvalue.setValue("#{" + entryBeanName + ".listModel}");
                    PropertyInfo pbinding = new PropertyInfo();
                    pbinding.setName("binding");
                    pbinding.setType("java.lang.String");
                    pbinding.setValue("#{" + entryBeanName + ".editGrid}");
                    dataGrid.getProperties().add(pvalue);
                    dataGrid.getProperties().add(pbinding);
                }
            }
            int m = controls.size();
            for (int j = 0; j < m; ++j) {
                ComponentInfo control = controls.get(j);
                PropertyBindingCollection propBindings = control.getPropertyBindings();
                int l = propBindings.size();
                for (int k = 0; k < l; ++k) {
                    PropertyBindingInfo propBinding = propBindings.get(k);
                    if (propBinding.getBindingObject().equalsIgnoreCase(oldEntity.getRealName())) {
                        propBinding.setBindingObject(newEntity.getRealName());
                        propBinding.setOverride(true);
                    }
                    if (!StringUtils.isEmpty((String)oldEntryName) && !StringUtils.isEmpty((String)newEntryName)) {
                        propBinding.setBingdingField(StringUtils.replace((String)propBinding.getBingdingField(), (String)oldEntryName, (String)newEntryName));
                    }
                    propBinding.setOverride(true);
                    if ("com.kingdee.eas.bim.BizBillEntryBaseInfo".equalsIgnoreCase(propBinding.getFieldType()) || "com.kingdee.eas.bim.BizMBillEntryBaseInfo".equalsIgnoreCase(propBinding.getFieldType()) || "com.kingdee.eas.bim.BizMCoreBillEntryBaseInfo".equalsIgnoreCase(propBinding.getFieldType())) {
                        propBinding.setFieldType(AbstractBizUnitCtrl.getEntryEntityReleaseInfoName(newEntity, propBinding.getBingdingField()));
                        propBinding.setOverride(true);
                        continue;
                    }
                    if (!"userObject".equalsIgnoreCase(propBinding.getPropertyName()) || !"com.kingdee.bos.ctrl.kdf.table.KDTable".equalsIgnoreCase(control.getClassType())) continue;
                    propBinding.setFieldType(AbstractBizUnitCtrl.getEntryEntityReleaseCollectionName(newEntity, propBinding.getBingdingField()));
                    propBinding.setOverride(true);
                }
            }
            dataObject.setType(AbstractBizUnitCtrl.getPKFullName(newEntity.getRealPackage(), newEntity.getRealName()));
            dataObject.setOverride(true);
        }
        ActionCollection actions = editUI.getActions();
        int n2 = actions.size();
        for (int i = 0; i < n2; ++i) {
            ActionInfo action = actions.get(i);
            String actionCode = action.getActionPerformed();
            if (StringUtils.isEmpty((String)actionCode)) continue;
            actionCode = StringUtils.trim((String)actionCode);
            String testActionCode = oldEntity.getBusinessImplFactory();
            if (actionCode.equalsIgnoreCase(testActionCode = testActionCode + ".getRemoteInstance()." + StringUtils.headCharLowerCase((String)action.getName()) + "(editData);")) {
                testActionCode = newEntity.getBusinessImplFactory();
                testActionCode = testActionCode + ".getRemoteInstance()." + StringUtils.headCharLowerCase((String)action.getName()) + "(editData);";
                action.setActionPerformed(testActionCode);
                continue;
            }
            testActionCode = oldEntity.getBusinessImplFactory();
            if (!actionCode.equalsIgnoreCase(testActionCode = testActionCode + ".getRemoteInstance()." + StringUtils.headCharLowerCase((String)StringUtils.replaceIgnoreCase((String)action.getName(), (String)"action", (String)"")) + "(editData);")) continue;
            testActionCode = newEntity.getBusinessImplFactory();
            testActionCode = testActionCode + ".getRemoteInstance()." + StringUtils.headCharLowerCase((String)StringUtils.replaceIgnoreCase((String)action.getName(), (String)"action", (String)"")) + "(editData);";
            action.setActionPerformed(testActionCode);
        }
        editUI.setReleasePackage(editUI.getRealPackage());
        editUI.setReleaseClass(editUI.getRealName());
    }

    private static String getEntryEntityReleaseInfoName(EntityObjectInfo mainEntity, String propertyName) {
        LinkPropertyInfo lnkProp = (LinkPropertyInfo)BizUnitHelper.getPropertyByName(mainEntity, propertyName);
        return lnkProp.getRelationship().getSupplierObject().getBusinessImplName() + "Info";
    }

    private static String getEntryEntityReleaseCollectionName(EntityObjectInfo mainEntity, String propertyName) {
        LinkPropertyInfo lnkProp = (LinkPropertyInfo)BizUnitHelper.getPropertyByName(mainEntity, propertyName);
        return lnkProp.getRelationship().getSupplierObject().getBusinessImplName() + "Collection";
    }

    private static void updateListUI(AbstractUIObjectInfo queryUI, String newName) {
        queryUI.setName(newName);
    }

    private static void updateWebListUI(BizUnitInfo srcUnit, BizUnitInfo desUnit) {
        AbstractBizUnitCtrl.updateListUI(desUnit.getWebListUI(), srcUnit.getQuery(), desUnit.getQuery(), srcUnit.getEntity(), desUnit.getEntity());
        WebUIObjectInfo srcListUI = srcUnit.getWebListUI();
        WebUIObjectInfo desListUI = desUnit.getWebListUI();
        if (desListUI != null) {
            String elSrc = WebUIProxyHelper.getWebUIShortPackage(srcListUI.getRealPackage()) + "." + srcListUI.getRealName() + "Bean";
            String elDes = WebUIProxyHelper.getWebUIShortPackage(desListUI.getRealPackage()) + "." + desListUI.getRealName() + "Bean";
            ComponentCollection controls = AbstractBizUnitCtrl.treeToCol(desListUI.getComponents());
            Context ctx = ContextManager.getContext();
            SolutionCtrl solutionCtrl = new SolutionCtrl(ctx);
            SolutionInfo slnInfo = null;
            try {
                slnInfo = solutionCtrl.getValue();
            }
            catch (BOSException e) {
                log.error((Object)"solution not found", (Throwable)e);
            }
            if (slnInfo == null) {
                return;
            }
            Locale[] supportedLocales = slnInfo.getSupportedLocales();
            int n = controls.size();
            for (int m = 0; m < n; ++m) {
                ComponentInfo componentInfo = controls.get(m);
                com.kingdee.bos.metadata.ui.PropertyCollection ps = componentInfo.getProperties();
                int k = ps.size();
                for (int j = 0; j < k; ++j) {
                    PropertyInfo property = ps.get(j);
                    String value = property.getValue();
                    if (!WebUIProxyHelper.isEL(value)) continue;
                    value = StringUtils.replace((String)value, (String)elSrc, (String)elDes);
                    property.setValue(value);
                    if (supportedLocales == null) continue;
                    for (int i = 0; i < supportedLocales.length; ++i) {
                        property.setValue(value, supportedLocales[i]);
                    }
                }
                EventBindingCollection eventBindingCollection = componentInfo.getEventBindings();
                int j = eventBindingCollection.size();
                for (int i = 0; i < j; ++i) {
                    EventBindingInfo eb = eventBindingCollection.get(i);
                    String methodName = eb.getMethodName();
                    if (StringUtils.isEmpty((String)methodName)) continue;
                    methodName = StringUtils.replace((String)methodName, (String)elSrc, (String)elDes);
                    eb.setMethodName(methodName);
                }
            }
            ActionCollection actionCollection = desListUI.getActions();
            for (int i = 0; i < actionCollection.size(); ++i) {
                ActionInfo actionInfo = actionCollection.get(i);
                String actionBinding = actionInfo.getActionBinding();
                if (StringUtils.isEmpty((String)actionBinding)) continue;
                actionBinding = StringUtils.replace((String)actionBinding, (String)elSrc, (String)elDes);
                actionInfo.setActionBinding(actionBinding);
            }
        }
    }

    private static void updateListUI(AbstractUIObjectInfo queryUI, JoinQueryInfo oldQuery, JoinQueryInfo newQuery, EntityObjectInfo oldEntity, EntityObjectInfo newEntity) {
        DataObjectCollection dataObjects = queryUI.getDataObjects();
        ComponentCollection controls = AbstractBizUnitCtrl.treeToCol(queryUI.getComponents());
        if (queryUI instanceof WebUIObjectInfo) {
            Context ctx = ContextManager.getContext();
            SolutionCtrl solutionCtrl = new SolutionCtrl(ctx);
            SolutionInfo slnInfo = null;
            try {
                slnInfo = solutionCtrl.getValue();
            }
            catch (BOSException e) {
                log.error((Object)"solution not found", (Throwable)e);
            }
            if (slnInfo == null) {
                return;
            }
            Locale[] supportedLocales = slnInfo.getSupportedLocales();
            ComponentInfo innerWindow = WebUIProxyHelper.findInnerWindowUserTag(controls);
            if (innerWindow != null) {
                PropertyInfo pInfo = innerWindow.getPropertyByName("attributes");
                String shortName = WebUIProxyHelper.getWebUIShortPackage(queryUI.getRealPackage());
                String value = "beanName=#{" + shortName + "." + queryUI.getRealName() + "Bean}";
                if (supportedLocales != null) {
                    for (int i = 0; i < supportedLocales.length; ++i) {
                        pInfo.setValue(value, supportedLocales[i]);
                    }
                }
                pInfo.setOverride(true);
            }
        }
        int n = dataObjects.size();
        for (int i = 0; i < n; ++i) {
            ComponentInfo dataGrid;
            DataObjectInfo dataObject = dataObjects.get(i);
            if (!dataObject.getType().equalsIgnoreCase(AbstractBizUnitCtrl.getPKFullName(oldQuery.getRealPackage(), oldQuery.getRealName()))) continue;
            if (dataObject.getRealName().equalsIgnoreCase(oldQuery.getRealName())) {
                dataObject.setName(newQuery.getRealName());
            }
            if (queryUI instanceof WebUIObjectInfo && (dataGrid = WebUIProxyHelper.findBindingKDTable(controls, dataObject.getRealName(), "com.kingdee.bos.ctrl.web.DataGrid")) != null) {
                String shortName = WebUIProxyHelper.getWebUIShortPackage(queryUI.getRealPackage());
                PropertyInfo binding = new PropertyInfo();
                binding.setName("binding");
                binding.setMultiLanguage(false);
                binding.setType("java.lang.String");
                binding.setValue("#{" + shortName + "." + queryUI.getRealName() + "Bean.grid}");
                dataGrid.getProperties().add(binding);
            }
            int m = controls.size();
            for (int j = 0; j < m; ++j) {
                ComponentInfo control = controls.get(j);
                PropertyBindingCollection propBindings = control.getPropertyBindings();
                int l = propBindings.size();
                for (int k = 0; k < l; ++k) {
                    PropertyBindingInfo propBinding = propBindings.get(k);
                    if (!propBinding.getBindingObject().equalsIgnoreCase(oldQuery.getRealName())) continue;
                    propBinding.setBindingObject(newQuery.getRealName());
                }
            }
            dataObject.setType(AbstractBizUnitCtrl.getPKFullName(newQuery.getRealPackage(), newQuery.getRealName()));
            dataObject.setOverride(true);
        }
        ActionCollection actions = queryUI.getActions();
        int n2 = actions.size();
        for (int i = 0; i < n2; ++i) {
            ActionInfo action = actions.get(i);
            String actionCode = action.getActionPerformed();
            if (StringUtils.isEmpty((String)actionCode)) continue;
            actionCode = StringUtils.trim((String)actionCode);
            String testActionCode1 = oldEntity.getBusinessImplName() + "Info editData = (" + oldEntity.getBusinessImplName() + "Info)getBizInterface().getValue(new com.kingdee.bos.dao.ormapping.ObjectUuidPK(BOSUuid.read(getSelectedKeyValue())));";
            String testActionCode2 = oldEntity.getBusinessImplFactory() + ".getRemoteInstance()." + StringUtils.headCharLowerCase((String)action.getName()) + "(editData);";
            if (actionCode.indexOf(testActionCode1) >= 0 && actionCode.indexOf(testActionCode2) >= 0) {
                testActionCode1 = "if (getSelectedKeyValue() == null) return;\n";
                testActionCode1 = testActionCode1 + newEntity.getBusinessImplName() + "Info editData = (" + newEntity.getBusinessImplName() + "Info)getBizInterface().getValue(new com.kingdee.bos.dao.ormapping.ObjectUuidPK(BOSUuid.read(getSelectedKeyValue())));";
                testActionCode2 = newEntity.getBusinessImplFactory() + ".getRemoteInstance()." + StringUtils.headCharLowerCase((String)action.getName()) + "(editData);";
                action.setActionPerformed(testActionCode1 + "\n" + testActionCode2);
                continue;
            }
            testActionCode1 = oldEntity.getBusinessImplName() + "Info editData = (" + oldEntity.getBusinessImplName() + "Info)getBizInterface().getValue(new com.kingdee.bos.dao.ormapping.ObjectUuidPK(BOSUuid.read(getSelectedKeyValue())));";
            testActionCode2 = oldEntity.getBusinessImplFactory() + ".getRemoteInstance()." + StringUtils.headCharLowerCase((String)StringUtils.replaceIgnoreCase((String)action.getName(), (String)"action", (String)"")) + "(editData);";
            if (actionCode.indexOf(testActionCode1) < 0 || actionCode.indexOf(testActionCode2) < 0) continue;
            testActionCode1 = "if (getSelectedKeyValue() == null) return;\n";
            testActionCode1 = testActionCode1 + newEntity.getBusinessImplName() + "Info editData = (" + newEntity.getBusinessImplName() + "Info)getBizInterface().getValue(new com.kingdee.bos.dao.ormapping.ObjectUuidPK(BOSUuid.read(getSelectedKeyValue())));";
            testActionCode2 = newEntity.getBusinessImplFactory() + ".getRemoteInstance()." + StringUtils.headCharLowerCase((String)StringUtils.replaceIgnoreCase((String)action.getName(), (String)"action", (String)"")) + "(editData);";
            action.setActionPerformed(testActionCode1 + "\n" + testActionCode2);
        }
        queryUI.setReleasePackage(queryUI.getRealPackage());
        queryUI.setReleaseClass(queryUI.getRealName());
    }

    private static void updateUIFunction(FunctionObjectInfo uiFunction, String newName) {
        uiFunction.setName(newName);
    }

    private static void updateUIFunction(FunctionObjectInfo uiFunction, EntityObjectInfo entity, UIObjectInfo newEditUI) {
        int n = uiFunction.getOperation().size();
        for (int i = 0; i < n; ++i) {
            OperationInfo operation = uiFunction.getOperation().get(i);
            if (operation.getUiActionRef() != null) {
                operation.getUiActionRef().setUIObjectRef(newEditUI);
            }
            if (entity == null || operation.getEntityObjectRef() == null) continue;
            operation.setEntityObjectRef(entity);
        }
    }

    private static void updateWebUIFunction(FunctionObjectInfo uiFunction, WebUIObjectInfo oldEditUI, WebUIObjectInfo newEditUI) {
        int n = uiFunction.getOperation().size();
        for (int i = 0; i < n; ++i) {
            OperationInfo operation = uiFunction.getOperation().get(i);
            if (operation.getUiActionRef() == null) continue;
            operation.getUiActionRef().setWebUIObjectRef(newEditUI);
        }
    }

    private static void updateEntityFunction(FunctionObjectInfo entityFunction, String newName) {
        entityFunction.setName(newName);
    }

    private static void updateEntityFunction(FunctionObjectInfo entityFunction, EntityObjectInfo oldEntity, EntityObjectInfo newEntity) {
        int n = entityFunction.getOperation().size();
        for (int i = 0; i < n; ++i) {
            entityFunction.getOperation().get(i).setEntityObjectRef(newEntity);
        }
    }

    public static String getEventName(EntityObjectInfo entity, String methodName) {
        EventCollection events = entity.getEvents();
        int n = events.size();
        for (int i = 0; i < n; ++i) {
            EventInfo event = events.get(i);
            EventMethodCollection eventMethods = event.getEventMethods();
            int m = eventMethods.size();
            for (int j = 0; j < m; ++j) {
                EventMethodInfo eventMethod = eventMethods.get(j);
                if (eventMethod.getMethodRef() == null || !eventMethod.getMethodRef().getName().equalsIgnoreCase(methodName)) continue;
                return event.getName();
            }
        }
        return null;
    }

    private static void updateRelationship(RelationshipInfo relation, String newName) {
        relation.setName(newName);
    }

    public BizMethodCollection getMethodsForPermission(BizUnitInfo bizUnit) {
        BizMethodCollection bizMethods = new BizMethodCollection();
        if (bizUnit.getEntity() != null) {
            MethodCollection methods = bizUnit.getEntity().getAllMethods();
            ArrayList<String> methodNames = new ArrayList<String>();
            int n = methods.size();
            for (int i = 0; i < n; ++i) {
                MethodInfo method = methods.get(i);
                if (methodNames.contains(method.getName())) continue;
                methodNames.add(method.getName());
                BizMethodInfo bizMethod = new BizMethodInfo();
                bizMethod.setName(method.getName());
                bizMethod.setAlias(method.getAlias());
                bizMethod.setDescription(method.getDescription());
                bizMethod.setMethodName(method.getName());
                bizMethods.add(bizMethod);
            }
        }
        try {
            this.extractEditUIActions(bizUnit.getEditUI(), bizMethods, bizUnit, false);
            this.extractListUIActions(bizUnit.getListUI(), bizMethods, false);
            this.extractEditUIActions(bizUnit.getWebEditUI(), bizMethods, bizUnit, true);
            this.extractListUIActions(bizUnit.getWebListUI(), bizMethods, true);
        }
        catch (BIMException methods) {
            // empty catch block
        }
        for (int i = bizMethods.size() - 1; i >= 0; --i) {
            if (!StringUtils.isEmpty((String)bizMethods.get(i).getActionName()) || !StringUtils.isEmpty((String)bizMethods.get(i).getListActionName()) || !StringUtils.isEmpty((String)bizMethods.get(i).getWebActionName()) || !StringUtils.isEmpty((String)bizMethods.get(i).getWebListActionName())) continue;
            bizMethods.removeObject(i);
        }
        return bizMethods;
    }

    public BizMethodCollection getMethodsForLog(BizUnitInfo bizUnit) {
        BizMethodCollection bizMethods = new BizMethodCollection();
        if (bizUnit.getEntity() != null) {
            MethodCollection methods = bizUnit.getEntity().getAllMethods();
            ArrayList<String> methodNames = new ArrayList<String>();
            int n = methods.size();
            for (int i = 0; i < n; ++i) {
                MethodInfo method = methods.get(i);
                if (methodNames.contains(method.getName())) continue;
                methodNames.add(method.getName());
                BizMethodInfo bizMethod = new BizMethodInfo();
                bizMethod.setName(method.getName());
                bizMethod.setAlias(method.getAlias());
                bizMethod.setDescription(method.getDescription());
                bizMethod.setMethodName(method.getName());
                bizMethods.add(bizMethod);
            }
        }
        try {
            this.extractEditUIActions(bizUnit.getEditUI(), bizMethods, bizUnit, false);
            this.extractListUIActions(bizUnit.getListUI(), bizMethods, false);
            this.extractEditUIActions(bizUnit.getWebEditUI(), bizMethods, bizUnit, true);
            this.extractListUIActions(bizUnit.getWebListUI(), bizMethods, true);
        }
        catch (BIMException methods) {
            // empty catch block
        }
        for (int i = bizMethods.size() - 1; i >= 0; --i) {
            if (!StringUtils.isEmpty((String)bizMethods.get(i).getMethodName())) continue;
            bizMethods.removeObject(i);
        }
        return bizMethods;
    }

    public void loadAllMethods(BizUnitInfo bizUnit) throws BOSException {
        if (bizUnit == null) {
            return;
        }
        if (bizUnit.isAllLoaded()) {
            return;
        }
        Context ctx = this.getContext();
        UIObjectCtrl uiCtrl = new UIObjectCtrl(ctx);
        WebUIObjectCtrl webUICtrl = new WebUIObjectCtrl(ctx);
        EntityObjectCtrl entityCtrl = new EntityObjectCtrl(ctx);
        WebPageObjectCtrl webPageCtrl = new WebPageObjectCtrl(ctx);
        try {
            String webPagePKS;
            EntityObjectInfo entity = null;
            String entityPK = bizUnit.getString("entityPK");
            if (!StringUtils.isEmpty((String)entityPK)) {
                entity = entityCtrl.getValue(MetaDataPK.create(entityPK));
                bizUnit.setEntity(entity);
            }
            UIObjectInfo editUI = null;
            String editUIPK = bizUnit.getString("editUIPK");
            if (!StringUtils.isEmpty((String)editUIPK)) {
                editUI = uiCtrl.getAllValue(MetaDataPK.create(editUIPK));
                bizUnit.setEditUI(editUI);
            }
            UIObjectInfo listUI = null;
            String listUIPK = bizUnit.getString("listUIPK");
            if (!StringUtils.isEmpty((String)listUIPK)) {
                listUI = uiCtrl.getAllValue(MetaDataPK.create(listUIPK));
                bizUnit.setListUI(listUI);
            }
            WebUIObjectInfo webEditUI = null;
            String webEditUIPK = bizUnit.getWebEditUIPK();
            if (!StringUtils.isEmpty((String)webEditUIPK)) {
                webEditUI = webUICtrl.getAllValue(MetaDataPK.create(webEditUIPK));
                bizUnit.setWebEditUI(webEditUI);
            }
            WebUIObjectInfo webListUI = null;
            String webListUIPK = bizUnit.getWebListUIPK();
            if (!StringUtils.isEmpty((String)webListUIPK)) {
                webListUI = webUICtrl.getAllValue(MetaDataPK.create(webListUIPK));
                bizUnit.setWebListUI(webListUI);
            }
            WebPageObjectInfo webEditPage = null;
            String webEditPagePK = bizUnit.getWebEditPagePK();
            if (!StringUtils.isEmpty((String)webEditPagePK)) {
                webEditPage = webPageCtrl.getAllValue(MetaDataPK.create(webEditPagePK));
                bizUnit.setWebEditPage(webEditPage);
            }
            WebPageObjectInfo webListPage = null;
            String webListPagePK = bizUnit.getWebListPagePK();
            if (!StringUtils.isEmpty((String)webListPagePK)) {
                webListPage = webPageCtrl.getAllValue(MetaDataPK.create(webListPagePK));
                bizUnit.setWebListPage(webListPage);
            }
            WebPageObjectInfo webViewPage = null;
            String webViewPagePK = bizUnit.getWebViewPagePK();
            if (!StringUtils.isEmpty((String)webViewPagePK)) {
                webViewPage = webPageCtrl.getAllValue(MetaDataPK.create(webViewPagePK));
                bizUnit.setWebViewPage(webViewPage);
            }
            WebPageObjectInfo webBriefPage = null;
            String webBriefPagePK = bizUnit.getWebBriefPagePK();
            if (!StringUtils.isEmpty((String)webBriefPagePK)) {
                webBriefPage = webPageCtrl.getAllValue(MetaDataPK.create(webBriefPagePK));
                bizUnit.setWebBriefPage(webBriefPage);
            }
            if (!StringUtils.isEmpty((String)(webPagePKS = bizUnit.getString("webPagePKS")))) {
                WebPageObjectCollection pages = new WebPageObjectCollection();
                String[] strs = webPagePKS.split(";");
                for (int i = 0; i < strs.length; ++i) {
                    WebPageObjectInfo webPage = webPageCtrl.getAllValue(MetaDataPK.create(strs[i]));
                    if (webPage == null) continue;
                    pages.add(webPage);
                }
                bizUnit.setWebPages(pages);
            }
        }
        catch (Exception e) {
            throw new BIMException(e);
        }
        bizUnit.getMethods().clear();
        BizMethodCollection methods = this.extractBizMethods(bizUnit);
        if (methods != null) {
            int n = methods.size();
            for (int i = 0; i < n; ++i) {
                BizMethodInfo bizMethod = methods.get(i);
                if (!StringUtils.isEmpty((String)bizMethod.getActionName()) && !StringUtils.isEmpty((String)bizMethod.getListActionName())) {
                    bizMethod.setGenerateUIAction("generateAllUIAction");
                } else if (!StringUtils.isEmpty((String)bizMethod.getActionName())) {
                    bizMethod.setGenerateUIAction("generateEditUIAction");
                } else {
                    bizMethod.setGenerateUIAction("generateListUIAction");
                }
                bizUnit.getMethods().add(bizMethod);
            }
        }
    }

    public void loadAll(BizUnitInfo bizUnit) throws BOSException {
        this.loadAll(bizUnit, true);
    }

    public void loadAll(BizUnitInfo bizUnit, boolean isClearCache) throws BOSException {
        this.loadAll(bizUnit, true, false);
    }

    public void loadAllRuntime(BizUnitInfo bizUnit) throws BOSException {
        this.loadAll(bizUnit, false, true);
    }

    public void loadAll(BizUnitInfo bizUnit, boolean isClearCache, boolean isRuntime) throws BOSException {
        if (bizUnit == null) {
            return;
        }
        if (bizUnit.isAllLoaded()) {
            return;
        }
        bizUnit.setLoading(true);
        Context ctx = this.getContext();
        UIObjectCtrl uiCtrl = new UIObjectCtrl(ctx);
        WebUIObjectCtrl webUICtrl = new WebUIObjectCtrl(ctx);
        JoinQueryCtrl queryCtrl = new JoinQueryCtrl(ctx);
        FunctionObjectCtrl functionCtrl = new FunctionObjectCtrl(ctx);
        DataTableCtrl tableCtrl = new DataTableCtrl(ctx);
        EntityObjectCtrl entityCtrl = new EntityObjectCtrl(ctx);
        WebPageObjectCtrl webPageCtrl = new WebPageObjectCtrl(ctx);
        try {
            String queryPK;
            String webPagePKS;
            String relatedWebEditPagePK;
            String webBriefPagePK;
            String webViewPagePK;
            String webListPagePK;
            String webEditPagePK;
            String relatedWebEditUIPK;
            String extendListUIs;
            String extendEditUIs;
            String extendTables;
            String extendEntitys;
            String relatedEditUIPK;
            String relatedEntityPK;
            String relatedTablePK;
            ComponentCollection controls;
            String queryPK2;
            UIObjectInfo entryUI = null;
            String entryUIPK = bizUnit.getString("entryUIPK");
            if (!StringUtils.isEmpty((String)entryUIPK)) {
                entryUI = uiCtrl.getAllValue(MetaDataPK.create(entryUIPK), isClearCache);
                bizUnit.setEntryUI(entryUI);
            }
            EntityObjectInfo entity = null;
            String entityPK = bizUnit.getString("entityPK");
            if (!StringUtils.isEmpty((String)entityPK)) {
                entity = entityCtrl.getValue(MetaDataPK.create(entityPK));
                bizUnit.setEntity(entity);
                if (entity != null) {
                    bizUnit.setTable(entity.getTable());
                }
            }
            JoinQueryInfo query = null;
            if (!isRuntime && !StringUtils.isEmpty((String)(queryPK2 = bizUnit.getString("queryPK")))) {
                query = queryCtrl.getValue(MetaDataPK.create(queryPK2));
                bizUnit.setQuery(query);
            }
            UIObjectInfo editUI = null;
            String editUIPK = bizUnit.getString("editUIPK");
            if (!StringUtils.isEmpty((String)editUIPK)) {
                editUI = uiCtrl.getAllValue(MetaDataPK.create(editUIPK), isClearCache);
                bizUnit.setEditUI(editUI);
                if (editUI != null) {
                    bizUnit.setRuleSet(editUI.getRuleSet());
                }
            }
            if (!isRuntime) {
                UIObjectInfo tableEditUI = null;
                String tableEditUIPK = bizUnit.getTableEditUIPK();
                if (!StringUtils.isEmpty((String)tableEditUIPK)) {
                    tableEditUI = uiCtrl.getAllValue(MetaDataPK.create(tableEditUIPK), isClearCache);
                    bizUnit.setTableEditUI(tableEditUI);
                }
                UIObjectInfo listUI = null;
                String listUIPK = bizUnit.getString("listUIPK");
                if (!StringUtils.isEmpty((String)listUIPK)) {
                    listUI = uiCtrl.getAllValue(MetaDataPK.create(listUIPK), isClearCache);
                    bizUnit.setListUI(listUI);
                }
                FunctionObjectInfo entityFunction = null;
                String entityFunctionPK = bizUnit.getString("entityFunctionPK");
                if (!StringUtils.isEmpty((String)entityFunctionPK)) {
                    entityFunction = functionCtrl.getValue(MetaDataPK.create(entityFunctionPK));
                    bizUnit.setEntityFunction(entityFunction);
                }
                FunctionObjectInfo editUIFunction = null;
                String editUIFunctionPK = bizUnit.getString("editUIFunctionPK");
                if (!StringUtils.isEmpty((String)editUIFunctionPK)) {
                    editUIFunction = functionCtrl.getValue(MetaDataPK.create(editUIFunctionPK));
                    bizUnit.setEditUIFunction(editUIFunction);
                }
                FunctionObjectInfo listUIFunction = null;
                String listUIFunctionPK = bizUnit.getString("listUIFunctionPK");
                if (!StringUtils.isEmpty((String)listUIFunctionPK)) {
                    listUIFunction = functionCtrl.getValue(MetaDataPK.create(listUIFunctionPK));
                    bizUnit.setListUIFunction(listUIFunction);
                }
            }
            if (editUI != null && (controls = editUI.getComponents()) != null && controls.size() > 0) {
                PropertyInfo prop;
                ComponentInfo control = controls.get(0);
                Object contraint = control.getConstraint();
                bizUnit.getUnitView().setLayout(control.getLayoutInfo());
                if (contraint != null) {
                    if (contraint instanceof Rectangle) {
                        Rectangle rect = (Rectangle)contraint;
                        bizUnit.getUnitView().setWidth(rect.width);
                        bizUnit.getUnitView().setHeight(rect.height);
                    } else if (contraint instanceof KDLayoutConstraint) {
                        bizUnit.getUnitView().setAnchor(((KDLayoutConstraint)contraint).anchor);
                    }
                }
                if ((prop = control.getPropertyByName("font")) != null) {
                    bizUnit.getUnitView().setFontString(prop.getValue());
                }
                if ((prop = control.getPropertyByName("background")) != null) {
                    bizUnit.getUnitView().setBackgroundColor(prop.getValue());
                }
                if ((prop = control.getPropertyByName("foreground")) != null) {
                    bizUnit.getUnitView().setForeColor(prop.getValue());
                }
            }
            if (bizUnit.getTable() != null && !StringUtils.isEmpty((String)(relatedTablePK = bizUnit.getRelatedTablePK()))) {
                DataTableInfo relatedTable = tableCtrl.getValue(MetaDataPK.create(relatedTablePK));
                bizUnit.setRelatedTable(relatedTable);
            }
            if (bizUnit.getEntity() != null && !StringUtils.isEmpty((String)(relatedEntityPK = bizUnit.getRelatedEntityPK()))) {
                EntityObjectInfo relatedEntity = entityCtrl.getValue(MetaDataPK.create(relatedEntityPK));
                bizUnit.setRelatedEntity(relatedEntity);
            }
            if (bizUnit.getEditUI() != null && !StringUtils.isEmpty((String)(relatedEditUIPK = bizUnit.getRelatedEditUIPK()))) {
                UIObjectInfo relatedEditUI = uiCtrl.getAllValue(MetaDataPK.create(relatedEditUIPK), isClearCache);
                bizUnit.setRelatedTreeUI(relatedEditUI);
            }
            if (StringUtils.isEmpty((String)(extendEntitys = bizUnit.getString("extendEntityPKs")))) {
                extendEntitys = bizUnit.getExtendedProperty("extendEntityPKs");
            }
            if (!StringUtils.isEmpty((String)extendEntitys)) {
                int i;
                String[] extEntityPKs = StringUtils.split((String)extendEntitys, (String)";");
                EntityObjectCollection extEntityCol = bizUnit.getExtendEntities();
                extEntityCol.clear();
                int n = extEntityPKs.length;
                for (i = 0; i < n; ++i) {
                    EntityObjectInfo extEntity = entityCtrl.getValue(MetaDataPK.create(extEntityPKs[i]));
                    if (extEntity == null) continue;
                    extEntityCol.add(extEntity);
                }
                n = extEntityCol.size();
                for (i = 0; i < n; ++i) {
                    if (extEntityCol.get(i).getTable() != null) {
                        bizUnit.attach(new TableExtProxy(this.getContext(), extEntityCol.get(i).getTable()));
                    }
                    bizUnit.attach(new EntityExtProxy(this.getContext(), extEntityCol.get(i)));
                }
            }
            if (!StringUtils.isEmpty((String)(extendTables = bizUnit.getString("extendTablePKs")))) {
                String[] extTablePKs = StringUtils.split((String)extendTables, (String)";");
                DataTableCollection extTableCol = bizUnit.getExtendTables();
                extTableCol.clear();
                int n = extTablePKs.length;
                for (int i = 0; i < n; ++i) {
                    DataTableInfo extTable = tableCtrl.getValue(MetaDataPK.create(extTablePKs[i]));
                    if (extTable == null) continue;
                    extTableCol.add(extTable);
                }
            }
            if (!StringUtils.isEmpty((String)(extendEditUIs = bizUnit.getString("extendEditUIPKs")))) {
                String[] extEditUIPKs = StringUtils.split((String)extendEditUIs, (String)";");
                UIObjectCollection extEditUICol = bizUnit.getExtendEditUIs();
                extEditUICol.clear();
                int n = extEditUIPKs.length;
                for (int i = 0; i < n; ++i) {
                    UIObjectInfo extEditUI = uiCtrl.getAllValue(MetaDataPK.create(extEditUIPKs[i]), isClearCache);
                    if (extEditUI == null) continue;
                    extEditUICol.add(extEditUI);
                }
            }
            if (!StringUtils.isEmpty((String)(extendListUIs = bizUnit.getString("extendListUIPKs")))) {
                String[] extListUIPKs = StringUtils.split((String)extendListUIs, (String)";");
                UIObjectCollection extListUICol = bizUnit.getExtendListUIs();
                extListUICol.clear();
                int n = extListUIPKs.length;
                for (int i = 0; i < n; ++i) {
                    UIObjectInfo extListUI = uiCtrl.getAllValue(MetaDataPK.create(extListUIPKs[i]), isClearCache);
                    if (extListUI == null) continue;
                    extListUICol.add(extListUI);
                }
            }
            WebUIObjectInfo webEditUI = null;
            String webEditUIPK = bizUnit.getString("webEditUIPK");
            if (!StringUtils.isEmpty((String)webEditUIPK)) {
                webEditUI = webUICtrl.getAllValue(MetaDataPK.create(webEditUIPK), isClearCache);
                bizUnit.setWebEditUI(webEditUI);
            }
            WebUIObjectInfo webListUI = null;
            String webListUIPK = bizUnit.getString("webListUIPK");
            if (!StringUtils.isEmpty((String)webListUIPK)) {
                webListUI = webUICtrl.getAllValue(MetaDataPK.create(webListUIPK), isClearCache);
                bizUnit.setWebListUI(webListUI);
            }
            if (bizUnit.getWebEditUI() != null && !StringUtils.isEmpty((String)(relatedWebEditUIPK = bizUnit.getRelatedWebEditUIPK()))) {
                WebUIObjectInfo relatedWebEditUI = webUICtrl.getAllValue(MetaDataPK.create(relatedWebEditUIPK), isClearCache);
                bizUnit.setRelatedWebTreeUI(relatedWebEditUI);
            }
            if (!StringUtils.isEmpty((String)(webEditPagePK = bizUnit.getString("webEditPagePK")))) {
                WebPageObjectInfo webEditPage = webPageCtrl.getAllValue(MetaDataPK.create(webEditPagePK), isClearCache);
                bizUnit.setWebEditPage(webEditPage);
            }
            if (!StringUtils.isEmpty((String)(webListPagePK = bizUnit.getString("webListPagePK")))) {
                WebPageObjectInfo webListPage = webPageCtrl.getAllValue(MetaDataPK.create(webListPagePK), isClearCache);
                bizUnit.setWebListPage(webListPage);
            }
            if (!StringUtils.isEmpty((String)(webViewPagePK = bizUnit.getString("webViewPagePK")))) {
                WebPageObjectInfo webViewPage = webPageCtrl.getAllValue(MetaDataPK.create(webViewPagePK), isClearCache);
                bizUnit.setWebViewPage(webViewPage);
            }
            if (!StringUtils.isEmpty((String)(webBriefPagePK = bizUnit.getString("webBriefPagePK")))) {
                WebPageObjectInfo webBriefPage = webPageCtrl.getAllValue(MetaDataPK.create(webBriefPagePK), isClearCache);
                bizUnit.setWebBriefPage(webBriefPage);
            }
            if (!StringUtils.isEmpty((String)(relatedWebEditPagePK = bizUnit.getRelatedWebEditPagePK()))) {
                WebPageObjectInfo relatedWebEditPage = webPageCtrl.getAllValue(MetaDataPK.create(relatedWebEditPagePK), isClearCache);
                bizUnit.setRelatedWebEditPage(relatedWebEditPage);
            }
            if (!StringUtils.isEmpty((String)(webPagePKS = bizUnit.getString("webPagePKS")))) {
                WebPageObjectCollection pages = new WebPageObjectCollection();
                String[] strs = webPagePKS.split(";");
                for (int i = 0; i < strs.length; ++i) {
                    WebPageObjectInfo webPage = webPageCtrl.getAllValue(MetaDataPK.create(strs[i]), isClearCache);
                    if (webPage == null) continue;
                    pages.add(webPage);
                }
                bizUnit.setWebPages(pages);
            }
            JoinQueryInfo relatedRuery = null;
            if (!isRuntime && !StringUtils.isEmpty((String)(queryPK = bizUnit.getString("relatedQueryPK")))) {
                relatedRuery = queryCtrl.getValue(MetaDataPK.create(queryPK));
                bizUnit.setRelatedQuery(relatedRuery);
            }
        }
        catch (Exception e) {
            throw new BIMException(e);
        }
        bizUnit.getFields().clear();
        this.extractBizFields(bizUnit);
        BizMethodCollection methods = this.extractBizMethods(bizUnit);
        if (methods != null) {
            int n = methods.size();
            for (int i = 0; i < n; ++i) {
                BizMethodInfo bizMethod = methods.get(i);
                if (!StringUtils.isEmpty((String)bizMethod.getActionName()) && !StringUtils.isEmpty((String)bizMethod.getListActionName())) {
                    bizMethod.setGenerateUIAction("generateAllUIAction");
                } else if (!StringUtils.isEmpty((String)bizMethod.getActionName())) {
                    bizMethod.setGenerateUIAction("generateEditUIAction");
                } else {
                    bizMethod.setGenerateUIAction("generateListUIAction");
                }
                bizUnit.getMethods().add(bizMethod);
            }
        }
        bizUnit.setLoading(false);
        bizUnit.detachAll();
        bizUnit.attach(new TableProxy(this.getContext(), bizUnit.getTable()));
        bizUnit.attach(new EntityProxy(this.getContext(), bizUnit.getEntity()));
        bizUnit.attach(new QueryProxy(this.getContext(), bizUnit.getQuery()));
        bizUnit.attach(new EditUIProxy(this.getContext(), bizUnit.getEditUI()));
        bizUnit.attach(new ListUIProxy(this.getContext(), bizUnit.getListUI()));
        bizUnit.attach(new RuleSetProxy(this.getContext(), bizUnit.getRuleSet()));
        bizUnit.attach(new EntityFunctionProxy(this.getContext(), bizUnit.getEntityFunction()));
        bizUnit.attach(new EditUIFunctionProxy(this.getContext(), bizUnit.getEditUIFunction()));
        bizUnit.attach(new ListUIFunctionProxy(this.getContext(), bizUnit.getListUIFunction()));
        bizUnit.attach(new TableEditUIProxy(this.getContext(), bizUnit.getTableEditUI()));
        bizUnit.attach(new WebEditUIProxy(this.getContext(), bizUnit.getWebEditUI()));
        bizUnit.attach(new WebListUIProxy(this.getContext(), bizUnit.getWebListUI()));
        bizUnit.setBoolean("isAllLoaded", true);
    }

    private static void setUserDefined(BizGroupFieldInfo groupField, boolean isUserDefined, MetadataUDFUpdater udfUpdater) {
        EntityObjectInfo subEntity;
        if (groupField == null) {
            return;
        }
        DataTableInfo table = groupField.getTableObject();
        if (table != null) {
            udfUpdater.setUserDefined(table, isUserDefined);
        }
        if ((subEntity = groupField.getEntityObject()) != null) {
            udfUpdater.setUserDefined(subEntity, isUserDefined);
            if (subEntity.getTable() != null) {
                udfUpdater.setUserDefined(subEntity.getTable(), isUserDefined);
            }
            BizFieldCollection subFields = groupField.getFields();
            int m = subFields.size();
            for (int j = 0; j < m; ++j) {
                LinkPropertyInfo lnkProperty;
                if (subFields.get(j) instanceof BizGroupFieldInfo) {
                    AbstractBizUnitCtrl.setUserDefined((BizGroupFieldInfo)subFields.get(j), isUserDefined, udfUpdater);
                    continue;
                }
                if (subFields.get(j).getDataSource() == null || subFields.get(j).getPropertyName() == null || (lnkProperty = (LinkPropertyInfo)subEntity.getPropertyByName(subFields.get(j).getPropertyName(), false)) == null || lnkProperty.getRelationship() == null) continue;
                RelationshipInfo relation = lnkProperty.getRelationship();
                udfUpdater.setUserDefined(relation, isUserDefined);
            }
        }
    }

    private static void setUserDefined(BizUnitInfo bizUnit, boolean isUserDefined) {
        UIObjectInfo relatedEditUI;
        DataTableInfo relatedTable;
        RuleSetInfo ruleSet;
        FunctionObjectInfo listUIFunction;
        FunctionObjectInfo editUIFunction;
        FunctionObjectInfo entityFunction;
        UIObjectInfo listUI;
        UIObjectInfo editUI;
        EntityObjectInfo entity;
        MetadataUDFUpdater udfUpdater = new MetadataUDFUpdater();
        udfUpdater.setUserDefined(bizUnit, isUserDefined);
        DataTableInfo table = bizUnit.getTable();
        if (table != null) {
            udfUpdater.setUserDefined(table, isUserDefined);
        }
        if ((entity = bizUnit.getEntity()) != null) {
            udfUpdater.setUserDefined(entity, isUserDefined);
        }
        BizFieldCollection fields = bizUnit.getFields();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            if (fields.get(i).getDataSource() != null) {
                LinkPropertyInfo lnkProperty;
                if (fields.get(i).getPropertyName() == null || (lnkProperty = (LinkPropertyInfo)entity.getPropertyByName(fields.get(i).getPropertyName(), false)) == null || lnkProperty.getRelationship() == null) continue;
                RelationshipInfo relation = lnkProperty.getRelationship();
                udfUpdater.setUserDefined(relation, isUserDefined);
                continue;
            }
            if (!(fields.get(i) instanceof BizGroupFieldInfo)) continue;
            BizGroupFieldInfo groupField = (BizGroupFieldInfo)fields.get(i);
            AbstractBizUnitCtrl.setUserDefined(groupField, isUserDefined, udfUpdater);
        }
        JoinQueryInfo query = bizUnit.getQuery();
        if (query != null) {
            udfUpdater.setUserDefined(query, isUserDefined);
        }
        if ((editUI = bizUnit.getEditUI()) != null) {
            udfUpdater.setUserDefined(editUI, isUserDefined);
        }
        if ((listUI = bizUnit.getListUI()) != null) {
            udfUpdater.setUserDefined(listUI, isUserDefined);
        }
        if ((entityFunction = bizUnit.getEntityFunction()) != null) {
            udfUpdater.setUserDefined(entityFunction, isUserDefined);
        }
        if ((editUIFunction = bizUnit.getEditUIFunction()) != null) {
            udfUpdater.setUserDefined(editUIFunction, isUserDefined);
        }
        if ((listUIFunction = bizUnit.getListUIFunction()) != null) {
            udfUpdater.setUserDefined(listUIFunction, isUserDefined);
        }
        if ((ruleSet = bizUnit.getRuleSet()) != null) {
            udfUpdater.setUserDefined(ruleSet, isUserDefined);
        } else if (editUI != null && (ruleSet = editUI.getRuleSet()) != null) {
            udfUpdater.setUserDefined(ruleSet, isUserDefined);
        }
        EntityObjectInfo relatedEntity = bizUnit.getRelatedEntity();
        if (relatedEntity != null) {
            udfUpdater.setUserDefined(relatedEntity, isUserDefined);
        }
        if ((relatedTable = bizUnit.getRelatedTable()) != null) {
            udfUpdater.setUserDefined(relatedTable, isUserDefined);
        }
        if ((relatedEditUI = bizUnit.getRelatedTreeUI()) != null) {
            udfUpdater.setUserDefined(relatedEditUI, isUserDefined);
        }
    }

    private static BOSObjectType genBOSType(String name) {
        int hash = name.hashCode();
        String type = Integer.toHexString(hash).toUpperCase();
        if (type.length() > 8) {
            type = type.substring(0, 8);
        } else if (type.length() < 8) {
            int n = type.length();
            for (int i = 0; i < 8 - n; ++i) {
                type = "0" + type;
            }
        }
        return BOSObjectType.create((String)type);
    }

    public static LinkPropertyInfo createLinkProperty(EntityObjectInfo mainEntity, EntityObjectInfo subEntity) {
        LinkPropertyInfo lnkProp = new LinkPropertyInfo();
        RelationshipInfo relation = new RelationshipInfo();
        relation.setPackage(mainEntity.getRealPackage());
        relation.setName("R_" + mainEntity.getRealName() + "_" + subEntity.getRealName());
        relation.setClientObject(mainEntity);
        relation.setSupplierObject(subEntity);
        relation.setType(RelationshipType.ASSOCIATION);
        relation.setClientCardinality(CardinalityType.ONE);
        relation.setSupplierCardinality(CardinalityType.ZERO_TO_ONE);
        relation.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        lnkProp.setRelationship(relation);
        lnkProp.setName(subEntity.getRealName());
        lnkProp.setAlias(subEntity.getAlias() == null ? "" : subEntity.getAlias());
        lnkProp.setDescription(subEntity.getDescription() == null ? "" : subEntity.getDescription());
        lnkProp.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        lnkProp.getExtendedProperties().put("isAsstAcctType", String.valueOf(true));
        lnkProp.getExtendedProperties().put("tableName", subEntity.getTable().getRealName());
        lnkProp.getExtendedProperties().put("isInCode", String.valueOf(false));
        return lnkProp;
    }

    public void createEntryUI(BizUnitInfo bizUnit, BizGroupFieldInfo groupField) {
        EntityObjectInfo entity = bizUnit.getEntity();
        UIObjectInfo editUI = bizUnit.getEditUI();
        UIObjectInfo entryUI = bizUnit.getEntryUI();
        if (editUI != null && entryUI != null && entity != null && groupField.getParent() != null) {
            try {
                UIObjectInfo newEntryUI = new UIObjectCtrl(this.getContext()).getAllValue(MetaDataPK.create(entryUI.getRealFullName()));
                newEntryUI.setPackage(editUI.getRealPackage());
                newEntryUI.setName(bizUnit.getName() + groupField.getName() + "EditUI");
                String oldEntryName = "entrys1";
                String newEntryName = groupField.getPropertyName();
                AbstractBizUnitCtrl.updateEditUI(newEntryUI, (EntityObjectInfo)newEntryUI.getDataObjects().get(0).getInstance(), entity, oldEntryName, newEntryName);
                newEntryUI.setRuleSet(bizUnit.getRuleSet());
                this.extractEditUIControls(newEntryUI, bizUnit.getFields(), entity, groupField.getParent());
                int n = groupField.getFields().size();
                for (int i = 0; i < n; ++i) {
                    groupField.getFields().get(i).setObjectState(ObjectStateType.UNCHANGE);
                }
                groupField.getParent().setUIObject(newEntryUI);
            }
            catch (Exception e) {
                log.error((Object)"error", (Throwable)e);
            }
        }
    }

    protected Object cloneMetaData(AbstractMetaDataValue model) {
        return model.clone();
    }

    public boolean checkRemove(BizUnitInfo[] bizUnits) throws BOSException {
        AbstractMetaDataValue[] metadatas = AbstractBizUnitCtrl.getMetadatas(bizUnits);
        RelationManager mgr = XMLAccessEngine.getRelationManager(this.getContext());
        Ref[] refs = new Ref[metadatas.length];
        int n = metadatas.length;
        for (int i = 0; i < n; ++i) {
            refs[i] = new Ref(metadatas[i].getRealFullName(), metadatas[i].getBOSType().toString());
        }
        Collection col = mgr.relationTree().getAllLinked(refs);
        if (col.size() > 0) {
            throw new BOSException("\u4e0d\u80fd\u5220\u9664\u4e1a\u52a1\u5355\u5143\uff0c\u5b9e\u4f53\u5bf9\u8c61\u5df2\u88ab\u5176\u5b83\u5bf9\u8c61\u5f15\u7528\uff01");
        }
        return true;
    }

    private static AbstractMetaDataValue[] getMetadatas(BizUnitInfo[] bizUnits) {
        AbstractMetaDataValue[] metadatas;
        int i;
        ArrayList<AbstractMetaDataValue> list = new ArrayList<AbstractMetaDataValue>();
        int n = bizUnits.length;
        for (i = 0; i < n; ++i) {
            metadatas = AbstractBizUnitCtrl.getMetadatas(bizUnits[i]);
            int m = metadatas.length;
            for (int j = 0; j < m; ++j) {
                list.add(metadatas[j]);
            }
        }
        metadatas = new AbstractMetaDataValue[list.size()];
        n = list.size();
        for (i = 0; i < n; ++i) {
            metadatas[i] = (AbstractMetaDataValue)list.get(i);
        }
        return metadatas;
    }

    private static AbstractMetaDataValue[] getMetadatas(BizUnitInfo info) {
        RelationshipInfo relation;
        int i;
        int n;
        ArrayList<AbstractMetaDataValue> list = new ArrayList<AbstractMetaDataValue>();
        EntityObjectInfo entity = info.getEntity();
        if (entity != null) {
            if (entity.getTable() != null) {
                list.add(entity.getTable());
            }
            list.add(entity);
            BizFieldCollection fields = info.getFields();
            n = fields.size();
            for (i = 0; i < n; ++i) {
                EntityObjectInfo subEntity;
                if (fields.get(i).getDataSource() != null) {
                    LinkPropertyInfo lnkProperty;
                    String propName = fields.get(i).getPropertyName();
                    if (propName == null || (lnkProperty = (LinkPropertyInfo)entity.getPropertyByName(propName, false)) == null || lnkProperty.getRelationship() == null) continue;
                    relation = lnkProperty.getRelationship();
                    list.add(relation);
                    continue;
                }
                if (!(fields.get(i) instanceof BizGroupFieldInfo)) continue;
                BizGroupFieldInfo groupField = (BizGroupFieldInfo)fields.get(i);
                DataTableInfo table = groupField.getTableObject();
                if (table != null) {
                    list.add(table);
                }
                if ((subEntity = groupField.getEntityObject()) != null) {
                    LinkPropertyInfo lnkProperty;
                    list.add(subEntity);
                    String propName = groupField.getPropertyName();
                    if (propName != null && (lnkProperty = (LinkPropertyInfo)entity.getPropertyByName(propName, false)) != null && lnkProperty.getRelationship() != null) {
                        RelationshipInfo relation2 = lnkProperty.getRelationship();
                        list.add(relation2);
                    }
                    BizFieldCollection subFields = groupField.getFields();
                    int m = subFields.size();
                    for (int j = 0; j < m; ++j) {
                        LinkPropertyInfo lnkProperty2;
                        String subPropName;
                        if (subFields.get(j).getDataSource() == null || (subPropName = subFields.get(j).getPropertyName()) == null || (lnkProperty2 = (LinkPropertyInfo)subEntity.getPropertyByName(subPropName, false)) == null || lnkProperty2.getRelationship() == null) continue;
                        RelationshipInfo relation3 = lnkProperty2.getRelationship();
                        list.add(relation3);
                    }
                }
                if (groupField.getParent() == null || groupField.getParent().getUIObject() == null) continue;
                list.add(groupField.getParent().getUIObject());
            }
        }
        if (info.getQuery() != null) {
            list.add(info.getQuery());
        }
        if (info.getEditUI() != null) {
            list.add(info.getEditUI());
            if (info.getEditUI().getRuleSet() != null) {
                list.add(info.getEditUI().getRuleSet());
            }
        }
        if (info.getListUI() != null) {
            list.add(info.getListUI());
        }
        if (info.getEntityFunction() != null) {
            list.add(info.getEntityFunction());
        }
        if (info.getEditUIFunction() != null) {
            list.add(info.getEditUIFunction());
        }
        if (info.getListUIFunction() != null) {
            list.add(info.getListUIFunction());
        }
        if (info.getRelatedEntity() != null) {
            list.add(info.getRelatedEntity());
            PropertyCollection props = info.getRelatedEntity().getProperties();
            int n2 = props.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                LinkPropertyInfo lnkProp;
                com.kingdee.bos.metadata.entity.PropertyInfo prop = props.get(i2);
                if (!(prop instanceof LinkPropertyInfo) || (lnkProp = (LinkPropertyInfo)prop) == null || lnkProp.getRelationship() == null || (relation = lnkProp.getRelationship()).getSupplierCardinality() != CardinalityType.ZERO_TO_ONE && relation.getSupplierCardinality() != CardinalityType.ONE) continue;
                list.add(relation);
            }
        }
        if (info.getRelatedTable() != null) {
            list.add(info.getRelatedTable());
        }
        if (info.getRelatedTreeUI() != null) {
            list.add(info.getRelatedTreeUI());
        }
        list.add(info);
        AbstractMetaDataValue[] metadatas = new AbstractMetaDataValue[list.size()];
        n = list.size();
        for (i = 0; i < n; ++i) {
            metadatas[i] = (AbstractMetaDataValue)list.get(i);
        }
        return metadatas;
    }

    private static boolean setSCMBillCopyTag(BizUnitInfo bizUnit, EntityObjectInfo scmBillEntity) {
        if (bizUnit == null || scmBillEntity == null) {
            return false;
        }
        String scmPackage = scmBillEntity.getRealPackage();
        if (StringUtils.isEmpty((String)scmPackage) || scmPackage.indexOf("com.kingdee.eas.scm") >= 0) {
            bizUnit.setExtendedProperty("isCopyFromSCMBill", "true");
            return true;
        }
        return false;
    }

    public void setDepend(Project depend) {
        this.depend = depend;
    }
}

