/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizunit.parser;

import com.kingdee.bos.kscript.parser.Lexer;
import com.kingdee.bos.kscript.parser.Token;
import com.kingdee.bos.kscript.parser.TokenList;
import com.kingdee.bos.metadata.bizrule.common.AbstractExpressionInfo;
import com.kingdee.bos.metadata.bizrule.common.ExpressionType;
import com.kingdee.bos.metadata.bizrule.common.GroupExpressionInfo;
import com.kingdee.bos.metadata.bizrule.common.MethodInfo;
import com.kingdee.bos.metadata.bizrule.common.ParameterInfo;
import com.kingdee.bos.metadata.bizrule.common.PropertyInfo;
import com.kingdee.bos.metadata.bizrule.common.SimpleExpressionInfo;
import com.kingdee.bos.metadata.bizrule.util.RuleJCodeWriter;
import com.kingdee.bos.metadata.bizunit.BIMException;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizMethodInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.proxy.EntityProxy;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.bizunitproxy.UIProxyHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;

public class BizExpressionParser {
    private static final String UIRuleUtilClassName = "com.kingdee.bos.ui.face.UIRuleUtil";
    private static final String IObjectValueClassName = "com.kingdee.bos.dao.IObjectValue";
    private static ArrayList operators = new ArrayList();
    private static ArrayList javaOperators = new ArrayList();
    protected BizUnitInfo bizUnit = null;
    protected UIObjectInfo editUI = null;
    protected EntityObjectInfo entity = null;

    public BizExpressionParser(BizUnitInfo bizUnit) {
        this.bizUnit = bizUnit;
        this.editUI = bizUnit.getEditUI();
        this.entity = bizUnit.getEntity();
    }

    private AbstractExpressionInfo adjustExpressions(AbstractExpressionInfo leftExp, AbstractExpressionInfo rightExp, String operator) {
        GroupExpressionInfo groupExp = new GroupExpressionInfo();
        if (rightExp instanceof GroupExpressionInfo) {
            if (this.compareOperator(operator, ((GroupExpressionInfo)rightExp).getOperator()) > 0) {
                groupExp.setOperator(this.getOperator(((GroupExpressionInfo)rightExp).getOperator()));
                GroupExpressionInfo groupExp1 = new GroupExpressionInfo();
                groupExp1.setOperator(this.getOperator(operator));
                groupExp1.getExpressions().add(leftExp);
                groupExp1.getExpressions().add(((GroupExpressionInfo)rightExp).getExpressions().get(0));
                groupExp.getExpressions().add(groupExp1);
                groupExp.getExpressions().add(((GroupExpressionInfo)rightExp).getExpressions().get(1));
            } else {
                groupExp.setOperator(this.getOperator(operator));
                groupExp.getExpressions().add(leftExp);
                groupExp.getExpressions().add(rightExp);
            }
        } else {
            groupExp.setOperator(this.getOperator(operator));
            groupExp.getExpressions().add(leftExp);
            groupExp.getExpressions().add(rightExp);
        }
        return groupExp;
    }

    private int compareOperator(String operator1, String operator2) {
        int rightIndex;
        int leftIndex = operators.indexOf(operator1);
        if (leftIndex <= (rightIndex = operators.indexOf(operator2))) {
            return 1;
        }
        return -1;
    }

    private static ComponentInfo findControlFromEntryUI(BizUnitInfo bizUnit, String controlName) {
        BizFieldInfo bizField;
        ComponentInfo control = null;
        BizFieldCollection bizFields = bizUnit.getFields();
        int n = bizFields.size();
        for (int i = 0; i < n && ((bizField = bizFields.get(i)).getUIObject() == null || (control = UIProxyHelper.findControlByName(bizField.getUIObject(), controlName)) == null); ++i) {
        }
        return control;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SimpleExpressionInfo getPropertyExp(String exp) throws Exception {
        String owner = exp;
        String property = "";
        int dotIndex = exp.indexOf(".");
        if (dotIndex >= 0) {
            owner = exp.substring(0, dotIndex);
            property = exp.substring(dotIndex + 1);
        }
        SimpleExpressionInfo simpleExp = new SimpleExpressionInfo();
        String[] strArray = new String[2];
        BizFieldInfo bizField = this.getGroupFieldByPropertyName(this.bizUnit.getFields(), exp, strArray);
        if (bizField == null) {
            bizField = this.bizUnit.getFieldByName(owner);
        } else {
            owner = strArray[0];
            property = strArray[1];
        }
        Object propertyName = null;
        Object desType = null;
        Object srcType = null;
        String controlName = null;
        if (bizField != null) {
            UIProxyHelper.getInstance();
            ComponentInfo control = UIProxyHelper.findControlByName(this.editUI, bizField.getControlName());
            if (control != null) {
                controlName = control.getName();
            }
            if (control == null && "MBillBase".equals(this.bizUnit.getBimTemplateType()) && (control = BizExpressionParser.findControlFromEntryUI(this.bizUnit, bizField.getControlName())) != null) {
                controlName = "getTable(" + bizField.getParent().getControlName() + ")";
            }
            if (control == null) {
                if (bizField.getDataSource() != null && exp.indexOf(".") > 0) {
                    String[] temps = StringUtils.split((String)exp, (String)".");
                    int n = temps.length;
                    for (int i = 0; i < n; ++i) {
                        if (i == 0) {
                            simpleExp.setType(ExpressionType.PROPERTYACCESS);
                            simpleExp.setValueType("Unkown");
                            simpleExp.setProperty(new PropertyInfo("editData", temps[i], "Unkown"));
                            continue;
                        }
                        SimpleExpressionInfo temp = new SimpleExpressionInfo();
                        temp.setType(ExpressionType.PROPERTYACCESS);
                        if (i == temps.length - 1) {
                            String valueType = BizExpressionParser.getPropertyType(this.entity, exp);
                            temp.setValueType(valueType);
                            temp.setProperty(new PropertyInfo(simpleExp, temps[i], valueType));
                        } else {
                            temp.setValueType("Unkown");
                            temp.setProperty(new PropertyInfo(simpleExp, temps[i], "Unkown"));
                        }
                        simpleExp = temp;
                    }
                    return simpleExp;
                }
                String valueType = BizExpressionParser.getPropertyType(this.entity, exp);
                simpleExp.setType(ExpressionType.PROPERTYACCESS);
                simpleExp.setValueType(valueType);
                simpleExp.setProperty(new PropertyInfo("editData", bizField.getPropertyName(), valueType));
                return simpleExp;
            }
            com.kingdee.bos.metadata.ui.PropertyInfo prop = null;
            if (!StringUtils.isEmpty((String)property) && !control.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox")) {
                prop = UIProxyHelper.getInstance().getProperty(control.getClassType(), property);
            }
            if (control.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.kdf.table.KDTable") && StringUtils.isEmpty((String)property) && prop == null) {
                simpleExp.setType(ExpressionType.VARIANT);
                simpleExp.setValueType("Unkown");
                simpleExp.setValue(controlName);
                return simpleExp;
            } else if (control.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.kdf.table.KDTable") && !StringUtils.isEmpty((String)property) && prop == null) {
                String[] arrProps = StringUtils.split((String)property, (String)".");
                if (arrProps.length == 2 && (arrProps[1].equalsIgnoreCase("enabled") || arrProps[1].equalsIgnoreCase("visible"))) {
                    simpleExp.setType(ExpressionType.PROPERTYACCESS);
                    simpleExp.setValueType("boolean");
                    if (arrProps[1].equalsIgnoreCase("enabled")) {
                        simpleExp.setProperty(new PropertyInfo(controlName + ".getColumn(\"" + arrProps[0] + "\").getStyleAttributes()", "Locked", "boolean"));
                        return simpleExp;
                    } else {
                        simpleExp.setProperty(new PropertyInfo(controlName + ".getColumn(\"" + arrProps[0] + "\").getStyleAttributes()", "Hided", "boolean"));
                    }
                    return simpleExp;
                } else if (arrProps.length == 2 && arrProps[1].equalsIgnoreCase("precision")) {
                    String valueType = BizExpressionParser.getPropertyType(this.entity, exp);
                    if (StringUtils.isEmpty((String)valueType)) {
                        simpleExp.setType(ExpressionType.PROPERTYACCESS);
                        simpleExp.setValueType("String");
                        simpleExp.setProperty(new PropertyInfo(controlName + ".getColumn(\"" + arrProps[0] + "\").getStyleAttributes()", "numberFormat", "String"));
                        return simpleExp;
                    } else {
                        simpleExp.setType(ExpressionType.METHODINVOKE);
                        simpleExp.setValueType(valueType);
                        simpleExp.setMethod(new MethodInfo(UIRuleUtilClassName, "getProperty", "Object"));
                        SimpleExpressionInfo paramExp = new SimpleExpressionInfo();
                        paramExp.setType(ExpressionType.PROPERTYACCESS);
                        paramExp.setValueType("Object");
                        String columnName = UIProxyHelper.getTableColumnName(control, owner + "." + arrProps[0]);
                        if (StringUtils.isEmpty((String)columnName)) {
                            columnName = arrProps[0];
                        }
                        paramExp.setProperty(new PropertyInfo("(com.kingdee.bos.dao.IObjectValue)" + controlName + ".getCell(rowIndex,\"" + columnName + "\")", "value", "Object"));
                        simpleExp.getMethod().getParameters().add(new ParameterInfo(paramExp));
                        paramExp = new SimpleExpressionInfo();
                        paramExp.setType(ExpressionType.CONST);
                        paramExp.setValueType("String");
                        paramExp.setValue(arrProps[1]);
                        simpleExp.getMethod().getParameters().add(new ParameterInfo(paramExp));
                    }
                    return simpleExp;
                } else if (arrProps.length > 1) {
                    String valueType = BizExpressionParser.getPropertyType(this.entity, exp);
                    simpleExp.setType(ExpressionType.METHODINVOKE);
                    simpleExp.setValueType(valueType);
                    simpleExp.setMethod(new MethodInfo(UIRuleUtilClassName, "getProperty", "Object"));
                    SimpleExpressionInfo paramExp = new SimpleExpressionInfo();
                    paramExp.setType(ExpressionType.PROPERTYACCESS);
                    paramExp.setValueType("Object");
                    String columnName = UIProxyHelper.getTableColumnName(control, owner + "." + arrProps[0]);
                    if (StringUtils.isEmpty((String)columnName)) {
                        columnName = arrProps[0];
                    }
                    paramExp.setProperty(new PropertyInfo("(com.kingdee.bos.dao.IObjectValue)" + controlName + ".getCell(rowIndex,\"" + columnName + "\")", "value", "Object"));
                    simpleExp.getMethod().getParameters().add(new ParameterInfo(paramExp));
                    paramExp = new SimpleExpressionInfo();
                    paramExp.setType(ExpressionType.CONST);
                    paramExp.setValueType("String");
                    paramExp.setValue(property.substring(property.indexOf(".") + 1));
                    simpleExp.getMethod().getParameters().add(new ParameterInfo(paramExp));
                    return simpleExp;
                } else if ("enabled".equalsIgnoreCase(property) || "visible".equalsIgnoreCase(property)) {
                    simpleExp.setType(ExpressionType.PROPERTYACCESS);
                    simpleExp.setValueType("boolean");
                    simpleExp.setProperty(new PropertyInfo(controlName, property, "boolean"));
                    return simpleExp;
                } else {
                    String valueType = BizExpressionParser.getPropertyType(this.entity, exp);
                    simpleExp.setType(ExpressionType.PROPERTYACCESS);
                    if ("Enum".equalsIgnoreCase(valueType)) {
                        simpleExp.setValueType("Object");
                    } else if ("boolean".equalsIgnoreCase(valueType)) {
                        simpleExp.setValueType("Object");
                    } else {
                        simpleExp.setValueType(valueType);
                    }
                    String columnName = UIProxyHelper.getTableColumnName(control, owner + "." + property);
                    if (StringUtils.isEmpty((String)columnName)) {
                        columnName = property;
                    }
                    simpleExp.setProperty(new PropertyInfo(controlName + ".getCell(rowIndex,\"" + columnName + "\")", "value", "Object"));
                }
                return simpleExp;
            } else {
                String valueType = BizExpressionParser.getPropertyType(this.entity, exp);
                if ("visible".equalsIgnoreCase(property) || "enabled".equalsIgnoreCase(property)) {
                    if (control.getParent() != null && "com.kingdee.bos.ctrl.swing.KDLabelContainer".equalsIgnoreCase(control.getParent().getClassType())) {
                        control = control.getParent();
                    }
                    simpleExp.setType(ExpressionType.PROPERTYACCESS);
                    simpleExp.setValueType("boolean");
                    simpleExp.setProperty(new PropertyInfo(control.getName(), property, "boolean"));
                    return simpleExp;
                } else if (!StringUtils.isEmpty((String)property) && control.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox")) {
                    if (valueType == null) {
                        valueType = "Object";
                    }
                    simpleExp.setType(ExpressionType.METHODINVOKE);
                    simpleExp.setValueType(valueType);
                    simpleExp.setMethod(new MethodInfo(UIRuleUtilClassName, "getProperty", "Object"));
                    SimpleExpressionInfo paramExp = new SimpleExpressionInfo();
                    paramExp.setType(ExpressionType.METHODINVOKE);
                    paramExp.setValueType("Object");
                    paramExp.setMethod(new MethodInfo("(com.kingdee.bos.dao.IObjectValue)" + controlName, "getData", "Object"));
                    simpleExp.getMethod().getParameters().add(new ParameterInfo(paramExp));
                    paramExp = new SimpleExpressionInfo();
                    paramExp.setType(ExpressionType.CONST);
                    paramExp.setValueType("String");
                    paramExp.setValue(property);
                    simpleExp.getMethod().getParameters().add(new ParameterInfo(paramExp));
                    return simpleExp;
                } else {
                    if (StringUtils.isEmpty((String)property)) {
                        prop = UIProxyHelper.getInstance().getDefaultProperty(control.getClassType());
                    } else if (prop == null && control != null && "precision".equalsIgnoreCase(property)) {
                        simpleExp.setType(ExpressionType.PROPERTYACCESS);
                        simpleExp.setValueType("int");
                        simpleExp.setProperty(new PropertyInfo(control.getName(), "precision", "int"));
                        return simpleExp;
                    }
                    if (prop == null) throw new BIMException("cannot find related control's property by BizField '" + bizField.getName() + "'");
                    if ("selectedIndex".equalsIgnoreCase(prop.getName())) {
                        simpleExp.setType(ExpressionType.PROPERTYACCESS);
                        simpleExp.setValueType("Object");
                        simpleExp.setProperty(new PropertyInfo(control.getName(), "selectedItem", "Object"));
                        return simpleExp;
                    } else {
                        simpleExp.setType(ExpressionType.PROPERTYACCESS);
                        if (bizField.getBizDataType() == BizDataType.OBJECT) {
                            simpleExp.setValueType("Object");
                        } else {
                            simpleExp.setValueType(EntityProxy.getPropertyType(bizField.getBizDataType()).toString());
                        }
                        simpleExp.setProperty(new PropertyInfo(control.getName(), prop.getName(), prop.getType()));
                    }
                }
            }
            return simpleExp;
        } else {
            BizMethodInfo bizMethod = this.bizUnit.getMethodByName(owner);
            if (bizMethod != null) {
                simpleExp.setType(ExpressionType.PROPERTYACCESS);
                simpleExp.setValueType("boolean");
                simpleExp.setProperty(new PropertyInfo(StringUtils.headCharLowerCase((String)bizMethod.getActionName()), property, "boolean"));
                return simpleExp;
            } else {
                simpleExp.setType(ExpressionType.VARIANT);
                simpleExp.setValueType("Object");
                simpleExp.setValue(exp);
            }
        }
        return simpleExp;
    }

    private static String getPropertyType(EntityObjectInfo entity, String propertyName) {
        if (entity == null || StringUtils.isEmpty((String)propertyName)) {
            return null;
        }
        String[] propertys = StringUtils.split((String)propertyName, (String)".");
        com.kingdee.bos.metadata.entity.PropertyInfo prop = null;
        EntityObjectInfo subEntity = entity;
        int n = propertys.length;
        for (int i = 0; i < n && (prop = subEntity.getPropertyByName(propertys[i], true)) != null; ++i) {
            if (prop instanceof OwnPropertyInfo) {
                if (i == n - 1) break;
                prop = null;
                break;
            }
            RelationshipInfo relation = ((LinkPropertyInfo)prop).getRelationship();
            subEntity = relation.getSupplierObject();
            if (subEntity != null) continue;
            prop = null;
            break;
        }
        if (prop != null && prop instanceof OwnPropertyInfo) {
            String valueType = ((OwnPropertyInfo)prop).getDataType().toString();
            if ("boolean".equalsIgnoreCase(valueType)) {
                return "boolean";
            }
            return valueType;
        }
        return null;
    }

    protected BizGroupFieldInfo getGroupFieldByPropertyName(BizFieldCollection bizFields, String propertyName, String[] strArray) {
        int index = 0;
        String[] props = StringUtils.split((String)propertyName, (String)".");
        BizFieldCollection subFields = bizFields;
        BizGroupFieldInfo groupField = null;
        int n = props.length;
        for (int i = 0; i < n; ++i) {
            int m = subFields.size();
            for (int j = 0; j < m; ++j) {
                BizFieldInfo bizField = subFields.get(j);
                if (!props[i].equalsIgnoreCase(bizField.getPropertyName())) continue;
                if (!(bizField instanceof BizGroupFieldInfo)) break;
                groupField = (BizGroupFieldInfo)bizField;
                subFields = ((BizGroupFieldInfo)bizField).getFields();
                if (i == 0) {
                    index += props[i].length();
                    break;
                }
                index += props[i].length() + 1;
                break;
            }
            if (groupField != null) continue;
            return null;
        }
        if (groupField != null) {
            strArray[0] = propertyName.substring(0, index);
            strArray[1] = index < propertyName.length() ? propertyName.substring(index + 1) : null;
        } else {
            strArray[0] = null;
            strArray[1] = null;
        }
        return groupField;
    }

    private SimpleExpressionInfo getMethodExp(String exp) throws Exception {
        String owner = null;
        String method = exp;
        String valueType = "Unkown";
        int dotIndex = exp.lastIndexOf(".");
        if (dotIndex >= 0) {
            owner = exp.substring(0, dotIndex);
            method = exp.substring(dotIndex + 1);
        }
        if (StringUtils.isEmpty(owner)) {
            if ("isNull".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "isNull";
                valueType = "boolean";
            } else if ("isNotNull".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "isNotNull";
                valueType = "boolean";
            } else if ("abs".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "abs";
                valueType = "double";
            } else if ("len".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "len";
                valueType = "int";
            } else if ("left".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "left";
                valueType = "int";
            } else if ("right".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "right";
                valueType = "int";
            } else if ("trim".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "trim";
                valueType = "String";
            } else if ("upper".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "upper";
                valueType = "String";
            } else if ("lower".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "lower";
                valueType = "String";
            } else if ("now".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "now";
                valueType = "Date";
            } else if ("year".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "year";
                valueType = "int";
            } else if ("month".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "month";
                valueType = "int";
            } else if ("day".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "day";
                valueType = "int";
            } else if ("hour".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "hour";
                valueType = "int";
            } else if ("minute".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "minute";
                valueType = "int";
            } else if ("second".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "second";
                valueType = "int";
            } else if ("dateAdd".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "dateAdd";
                valueType = "Date";
            } else if ("dateDiff".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "dateDiff";
                valueType = "Date";
            } else if ("sum".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "sum";
                valueType = "double";
            } else if ("avg".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "avg";
                valueType = "double";
            } else if ("max".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "max";
                valueType = "double";
            } else if ("min".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "min";
                valueType = "double";
            } else if ("count".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "count";
                valueType = "int";
            } else if ("dateAdd".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "dateAdd";
                valueType = "Date";
            } else if ("dateDiff".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "dateDiff";
                valueType = "Date";
            } else if ("date".equalsIgnoreCase(method)) {
                owner = UIRuleUtilClassName;
                method = "date";
                valueType = "Date";
            } else {
                throw new BIMException("\u65e0\u6548\u7684\u65b9\u6cd5\u540d\u79f0\uff1a\"" + method + "\"");
            }
        }
        SimpleExpressionInfo simpleExp = new SimpleExpressionInfo();
        simpleExp.setType(ExpressionType.METHODINVOKE);
        simpleExp.setMethod(new MethodInfo(owner, method, valueType));
        simpleExp.setValueType(valueType);
        return simpleExp;
    }

    private SimpleExpressionInfo getExpression(Token token) throws Exception {
        SimpleExpressionInfo simpleExp = new SimpleExpressionInfo();
        if (token.type == 3) {
            simpleExp.setType(ExpressionType.CONST);
            if ("true".equalsIgnoreCase(token.value) || "false".equalsIgnoreCase(token.value)) {
                simpleExp.setValueType("Boolean");
            } else {
                simpleExp.setValueType("Object");
            }
            simpleExp.setValue(token.value);
        } else if (token.type == 6) {
            simpleExp.setType(ExpressionType.CONST);
            simpleExp.setValueType("String");
            simpleExp.setValue(token.value);
        } else if (token.type == 16) {
            simpleExp.setType(ExpressionType.CONST);
            simpleExp.setValueType("Decimal");
            simpleExp.setValue(token.value);
        } else if (token.type == 9) {
            simpleExp.setType(ExpressionType.CONST);
            simpleExp.setValueType("Float");
            simpleExp.setValue(token.value);
        } else if (token.type == 10) {
            simpleExp.setType(ExpressionType.CONST);
            simpleExp.setValueType("Double");
            simpleExp.setValue(token.value);
        } else if (token.type == 8) {
            simpleExp.setType(ExpressionType.CONST);
            simpleExp.setValueType("Int");
            simpleExp.setValue(token.value);
        } else if (token.type == 15) {
            simpleExp.setType(ExpressionType.CONST);
            simpleExp.setValueType("Long");
            simpleExp.setValue(token.value);
        } else if (token.type == 7) {
            simpleExp.setType(ExpressionType.CONST);
            simpleExp.setValueType("Char");
            simpleExp.setValue(token.value);
        } else if (token.type == 1) {
            simpleExp = this.getPropertyExp(token.value);
        }
        return simpleExp;
    }

    private AbstractExpressionInfo parseExp(TokenList tokenList) throws Exception {
        AbstractExpressionInfo exp = null;
        if (!tokenList.lookup(0).equals(Token.EOFToken)) {
            Token token = tokenList.lookup(0);
            tokenList.match();
            if (token.type == 1 || token.type == 6 || token.type == 8 || token.type == 10 || token.type == 9 || token.type == 16 || token.type == 15 || token.type == 7) {
                if (tokenList.lookup(0).equals(Token.EOFToken) || tokenList.lookup(0).equals(Token.CommaToken)) {
                    exp = "now".equalsIgnoreCase(token.value) ? this.getMethodExp("now") : this.getExpression(token);
                } else if (tokenList.lookup((int)0).type == 5) {
                    if (tokenList.lookup(0).equals(Token.PeriodToken)) {
                        SimpleExpressionInfo simpleExp;
                        String expWithDot = token.value;
                        if (token.type == 6) {
                            expWithDot = "\"" + token.value + "\"";
                        }
                        while (tokenList.lookup(0).equals(Token.PeriodToken)) {
                            tokenList.match();
                            expWithDot = expWithDot + "." + tokenList.lookup((int)0).value;
                            tokenList.match();
                        }
                        if (tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                            simpleExp = this.getMethodExp(expWithDot);
                            tokenList.match();
                            while (!tokenList.lookup(0).equals(Token.CloseBraceToken) && !tokenList.lookup(0).equals(Token.EOFToken)) {
                                ParameterInfo param = new ParameterInfo(this.parseExp(tokenList));
                                simpleExp.getMethod().getParameters().add(param);
                                if (!tokenList.lookup(0).equals(Token.CommaToken)) continue;
                                tokenList.match();
                            }
                            tokenList.match(Token.CloseBraceToken);
                        } else {
                            simpleExp = this.getPropertyExp(expWithDot);
                        }
                        if (this.isOperatorType(tokenList.lookup(0))) {
                            GroupExpressionInfo groupExp = new GroupExpressionInfo();
                            groupExp.setOperator(this.getOperator(tokenList.lookup((int)0).value));
                            groupExp.getExpressions().add(simpleExp);
                            tokenList.match();
                            groupExp.getExpressions().add(this.parseExp(tokenList));
                            exp = groupExp;
                        } else {
                            exp = simpleExp;
                        }
                    } else if (tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                        SimpleExpressionInfo simpleExp = this.getMethodExp(token.value);
                        tokenList.match();
                        while (!tokenList.lookup(0).equals(Token.CloseBraceToken) && !tokenList.lookup(0).equals(Token.EOFToken)) {
                            ParameterInfo param = new ParameterInfo(this.parseExp(tokenList));
                            simpleExp.getMethod().getParameters().add(param);
                            if (!tokenList.lookup(0).equals(Token.CommaToken)) continue;
                            tokenList.match();
                        }
                        tokenList.match(Token.CloseBraceToken);
                        if (this.isOperatorType(tokenList.lookup(0))) {
                            GroupExpressionInfo groupExp = new GroupExpressionInfo();
                            groupExp.setOperator(this.getOperator(tokenList.lookup((int)0).value));
                            groupExp.getExpressions().add(simpleExp);
                            tokenList.match();
                            groupExp.getExpressions().add(this.parseExp(tokenList));
                            exp = groupExp;
                        } else {
                            exp = simpleExp;
                        }
                    } else if (tokenList.lookup(0).equals(Token.CloseBraceToken)) {
                        exp = "now".equalsIgnoreCase(token.value) ? this.getMethodExp("now") : this.getExpression(token);
                    }
                } else if (this.isOperatorType(tokenList.lookup(0))) {
                    SimpleExpressionInfo simpleExp = this.getExpression(token);
                    GroupExpressionInfo groupExp = new GroupExpressionInfo();
                    String operator = tokenList.lookup((int)0).value;
                    tokenList.match();
                    if (tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                        groupExp.setOperator(this.getOperator(operator));
                        groupExp.getExpressions().add(simpleExp);
                        groupExp.getExpressions().add(this.parseExp(tokenList));
                        exp = groupExp;
                    } else {
                        exp = this.adjustExpressions(simpleExp, this.parseExp(tokenList), operator);
                    }
                } else if (token.type == 7 && tokenList.lookup((int)0).type == 1) {
                    throw new BIMException("invalid expression,please use \" instead of ' for String type data.");
                }
            } else if (token.type == 5) {
                if (token.equals(Token.OpenBraceToken)) {
                    exp = this.parseExp(tokenList);
                    tokenList.match(Token.CloseBraceToken);
                    while (!tokenList.lookup(0).equals(Token.EOFToken)) {
                        token = tokenList.lookup(0);
                        if (!this.isOperatorType(token)) continue;
                        GroupExpressionInfo groupExp = new GroupExpressionInfo();
                        groupExp.setOperator(this.getOperator(token.value));
                        groupExp.getExpressions().add(exp);
                        tokenList.match();
                        groupExp.getExpressions().add(this.parseExp(tokenList));
                        exp = groupExp;
                    }
                }
            } else if (token.type == 3) {
                if (!("true".equalsIgnoreCase(token.value) || "false".equalsIgnoreCase(token.value) || "null".equalsIgnoreCase(token.value))) {
                    throw new BIMException("invalid expression,can't handle Keyword " + token.value);
                }
                SimpleExpressionInfo simpleExp = this.getExpression(token);
                if (this.isOperatorType(tokenList.lookup(0))) {
                    GroupExpressionInfo groupExp = new GroupExpressionInfo();
                    groupExp.setOperator(this.getOperator(tokenList.lookup((int)0).value));
                    groupExp.getExpressions().add(simpleExp);
                    tokenList.match();
                    groupExp.getExpressions().add(this.parseExp(tokenList));
                    exp = groupExp;
                } else {
                    exp = simpleExp;
                }
            } else {
                throw new BIMException("invalid expression,can't handle " + token.typename());
            }
        }
        return exp;
    }

    private boolean isOperatorType(Token token) {
        if (token.type == 4) {
            return true;
        }
        return operators.contains(token.value);
    }

    private String getOperator(String operator) {
        return (String)javaOperators.get(operators.indexOf(operator));
    }

    public static void main(String[] args) throws Exception {
    }

    private static String formatPrecision(String expression) throws Exception {
        if (expression.indexOf(".precision") >= 0) {
            String formatedExp = expression;
            Lexer lexer = new Lexer(formatedExp);
            TokenList tokenList = new TokenList(lexer);
            Token token = tokenList.lookup(0);
            while (!token.equals(Token.EOFToken)) {
                if (tokenList.lookup(0).equals(Token.PeriodToken) && token.type == 1) {
                    String owner = "";
                    while (tokenList.lookup(0).equals(Token.PeriodToken)) {
                        owner = StringUtils.isEmpty((String)owner) ? token.value : owner + "." + token.value;
                        token = tokenList.next();
                        token = tokenList.next();
                    }
                    if ("precision".equals(token.value) && tokenList.lookup(0).equals(Token.AssignToken)) {
                        String leftExp = formatedExp.substring(0, tokenList.lookup((int)0).position - 1);
                        String rightExp = formatedExp.substring(tokenList.lookup((int)0).position + tokenList.lookup((int)0).value.length());
                        formatedExp = leftExp + " = " + UIRuleUtilClassName + ".getNumberFormat(" + rightExp + ")";
                        return formatedExp;
                    }
                }
                token = tokenList.next();
            }
            return formatedExp;
        }
        return expression;
    }

    private static String formatCase(String expression) throws Exception {
        String formatedExp = expression;
        Lexer lexer = new Lexer(formatedExp);
        TokenList tokenList = new TokenList(lexer);
        Token token = tokenList.lookup(0);
        while (!token.equals(Token.EOFToken)) {
            if (token.type == 1 && ("sum".equalsIgnoreCase(token.value) || "avg".equalsIgnoreCase(token.value) || "max".equalsIgnoreCase(token.value) || "min".equalsIgnoreCase(token.value) || "count".equalsIgnoreCase(token.value))) {
                formatedExp = formatedExp.substring(0, token.position - 1) + token.value.toLowerCase() + formatedExp.substring(token.position - 1 + token.value.length());
            }
            token = tokenList.next();
        }
        return formatedExp;
    }

    private static String formatEqualsOperator(String expression, TokenList tokenList) throws Exception {
        if (expression.indexOf("==") >= 0 || expression.indexOf("!=") >= 0) {
            String formatedExp = expression;
            Token beginToken = tokenList.lookup(0);
            Token equalToken = null;
            Token token = beginToken;
            while (!token.equals(Token.EOFToken)) {
                String rightExp;
                String leftExp;
                String postString;
                String preString;
                String temp;
                if (token.equals(Token.OpenBraceToken)) {
                    token = tokenList.next();
                    temp = BizExpressionParser.formatEqualsOperator(formatedExp, tokenList);
                    if (!formatedExp.equals(temp)) {
                        formatedExp = temp;
                        return formatedExp;
                    }
                } else if (tokenList.lookup(0).equals(Token.CloseBraceToken) || tokenList.lookup(0).equals(Token.BooleanAndToken) || tokenList.lookup(0).equals(Token.BooleanOrToken)) {
                    if (equalToken != null) {
                        preString = formatedExp.substring(0, beginToken.position - 1);
                        postString = formatedExp.substring(token.position + token.value.length() - 1);
                        leftExp = formatedExp.substring(beginToken.position - 1, equalToken.position - 1);
                        rightExp = formatedExp.substring(equalToken.position + 1, token.position + token.value.length() - 1);
                        formatedExp = equalToken.equals(Token.EqualToken) ? preString + "abs(" + leftExp + " - " + rightExp + ") < 0.0000000001" + postString : preString + "abs(" + leftExp + " - " + rightExp + ") > 0.0000000001" + postString;
                        return formatedExp;
                    }
                    token = tokenList.next();
                    temp = BizExpressionParser.formatEqualsOperator(formatedExp, tokenList);
                    if (!formatedExp.equals(temp)) {
                        formatedExp = temp;
                        return formatedExp;
                    }
                } else if (token.equals(Token.EqualToken)) {
                    equalToken = token;
                } else if (token.equals(Token.NotEqualToken)) {
                    equalToken = token;
                }
                if (tokenList.lookup(0).equals(Token.EOFToken) && equalToken != null) {
                    preString = formatedExp.substring(0, beginToken.position - 1);
                    postString = formatedExp.substring(token.position + token.value.length() - 1);
                    leftExp = formatedExp.substring(beginToken.position - 1, equalToken.position - 1);
                    rightExp = formatedExp.substring(equalToken.position + 1, token.position + token.value.length() - 1);
                    formatedExp = equalToken.equals(Token.EqualToken) ? preString + "abs(" + leftExp + " - " + rightExp + ") < 0.0000000001" + postString : preString + "abs(" + leftExp + " - " + rightExp + ") > 0.0000000001" + postString;
                }
                token = tokenList.next();
            }
            return formatedExp;
        }
        return expression;
    }

    private static String formatEqualsOperator(String expression) throws Exception {
        if (expression.indexOf("==") >= 0 || expression.indexOf("!=") >= 0) {
            String formatedExp = expression;
            Lexer lexer = new Lexer(formatedExp);
            TokenList tokenList = new TokenList(lexer);
            String temp = BizExpressionParser.formatEqualsOperator(formatedExp, tokenList);
            while (!formatedExp.equals(temp)) {
                formatedExp = temp;
                lexer = new Lexer(formatedExp);
                tokenList = new TokenList(lexer);
                temp = BizExpressionParser.formatEqualsOperator(formatedExp, tokenList);
            }
            return formatedExp;
        }
        return expression;
    }

    private String convertVisibleToHide(String expression) {
        String[] temp;
        if (expression.indexOf(".visible") > 0 && expression.indexOf("=") > 0 && (temp = StringUtils.split((String)expression, (String)"=")).length == 2) {
            temp[0] = temp[0].trim();
            temp[1] = temp[1].trim();
            BizGroupFieldInfo groupField = this.getGroupFieldByPropertyName(this.bizUnit.getFields(), temp[0], new String[2]);
            if (groupField != null && ("true".equalsIgnoreCase(temp[1]) || "false".equalsIgnoreCase(temp[1]))) {
                if ("true".equalsIgnoreCase(temp[1])) {
                    return temp[0] + "=false";
                }
                return temp[0] + "=true";
            }
        }
        return expression;
    }

    private String convertEnabledToLock(String expression) {
        String[] temp;
        if (expression.indexOf(".enabled") > 0 && expression.indexOf("=") > 0 && (temp = StringUtils.split((String)expression, (String)"=")).length == 2) {
            temp[0] = temp[0].trim();
            temp[1] = temp[1].trim();
            BizGroupFieldInfo groupField = this.getGroupFieldByPropertyName(this.bizUnit.getFields(), temp[0], new String[2]);
            if (groupField != null && ("true".equalsIgnoreCase(temp[1]) || "false".equalsIgnoreCase(temp[1]))) {
                if ("true".equalsIgnoreCase(temp[1])) {
                    return temp[0] + "=false";
                }
                return temp[0] + "=true";
            }
        }
        return expression;
    }

    private String formatExpression(String expression) throws Exception {
        String rightExp;
        String leftExp;
        int index;
        String temp = StringUtils.replace((String)expression, (String)"[", (String)"");
        temp = StringUtils.replace((String)temp, (String)"]", (String)"");
        temp = StringUtils.replace((String)temp, (String)"<>", (String)"!=");
        temp = this.convertEnabledToLock(temp);
        if ((temp = this.convertVisibleToHide(temp)).indexOf("==") >= 0 || temp.indexOf("!=") >= 0) {
            index = temp.indexOf("==") >= 0 ? temp.indexOf("==") : temp.indexOf("!=");
            leftExp = temp.substring(0, index);
            rightExp = temp.substring(index + 2);
            leftExp = leftExp.trim();
            rightExp = rightExp.trim();
            if (this.isNumeric(leftExp) || this.isNumeric(rightExp)) {
                temp = temp.indexOf("==") >= 0 ? "abs(" + leftExp + " - " + rightExp + ") < 0.0000000001" : "abs(" + leftExp + " - " + rightExp + ") > 0.0000000001";
            }
        }
        if (temp.indexOf(".precision") >= 0) {
            String owner;
            BizFieldInfo bizField;
            index = temp.indexOf(".precision");
            leftExp = temp.substring(0, index);
            rightExp = temp.substring(index + ".precision".length());
            leftExp = leftExp.trim();
            rightExp = rightExp.trim();
            if (leftExp.indexOf(".") >= 0 && rightExp.startsWith("=") && (bizField = this.bizUnit.getFieldByName(owner = leftExp.substring(0, leftExp.indexOf(".")))) != null && bizField instanceof BizGroupFieldInfo) {
                rightExp = rightExp.substring(rightExp.lastIndexOf("=") + 1);
                rightExp = "com.kingdee.bos.ui.face.UIRuleUtil.getNumberFormat(" + rightExp + ")";
                temp = leftExp + ".precision = " + rightExp;
            }
        }
        temp = this.convertSumExpression(temp);
        temp = this.convertEnumExpression(temp);
        return temp;
    }

    private String convertEnumExpression(String exp) {
        int dotIndex = exp.indexOf("=");
        if (dotIndex > 0) {
            String propertyName = exp.substring(0, dotIndex).trim();
            String propertyValue = exp.substring(dotIndex + 1).trim();
            com.kingdee.bos.metadata.entity.PropertyInfo prop = RuleJCodeWriter.getPropertyByName(this.bizUnit.getEntity(), propertyName);
            if (prop != null) {
                LinkPropertyInfo lnkProp;
                RelationshipInfo relation;
                if (prop instanceof OwnPropertyInfo) {
                    OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
                    if (ownProp.getEnumType() != null && propertyValue.startsWith("\"") && propertyValue.endsWith("\"")) {
                        return propertyName + " = " + UIRuleUtilClassName + ".getEnumValue(\"" + ownProp.getEnumType().getClassName() + "\"," + propertyValue + ");";
                    }
                } else if (prop instanceof LinkPropertyInfo && ((relation = (lnkProp = (LinkPropertyInfo)prop).getRelationship()).getSupplierCardinality() == CardinalityType.ONE || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_ONE) && propertyValue.startsWith("\"") && propertyValue.endsWith("\"")) {
                    return propertyName + " = " + UIRuleUtilClassName + ".getObjectValue(com.kingdee.bos.util.BOSObjectType.create(\"" + relation.getSupplierObject().getType().toString() + "\")," + propertyValue + ");";
                }
            }
        }
        return exp;
    }

    private String convertSumExpression(String exp) {
        int start = 0;
        String temp = exp;
        while (start != -1) {
            if (StringUtils.indexOfIgnoreCase((String)temp, (String)"sum(", (int)start) >= 0 || StringUtils.indexOfIgnoreCase((String)temp, (String)"avg(", (int)start) >= 0 || StringUtils.indexOfIgnoreCase((String)temp, (String)"count(", (int)start) >= 0 || StringUtils.indexOfIgnoreCase((String)temp, (String)"min(", (int)start) >= 0 || StringUtils.indexOfIgnoreCase((String)temp, (String)"max(", (int)start) >= 0) {
                int beginIndex = -1;
                if (StringUtils.indexOfIgnoreCase((String)temp, (String)"sum(", (int)start) >= 0) {
                    beginIndex = StringUtils.indexOfIgnoreCase((String)temp, (String)"sum(", (int)start) + "sum(".length();
                } else if (StringUtils.indexOfIgnoreCase((String)temp, (String)"avg(", (int)start) >= 0) {
                    beginIndex = StringUtils.indexOfIgnoreCase((String)temp, (String)"avg(", (int)start) + "avg(".length();
                } else if (StringUtils.indexOfIgnoreCase((String)temp, (String)"max(", (int)start) >= 0) {
                    beginIndex = StringUtils.indexOfIgnoreCase((String)temp, (String)"max(", (int)start) + "max(".length();
                } else if (StringUtils.indexOfIgnoreCase((String)temp, (String)"min(", (int)start) >= 0) {
                    beginIndex = StringUtils.indexOfIgnoreCase((String)temp, (String)"min(", (int)start) + "min(".length();
                } else if (StringUtils.indexOfIgnoreCase((String)temp, (String)"count(", (int)start) >= 0) {
                    beginIndex = StringUtils.indexOfIgnoreCase((String)temp, (String)"count(", (int)start) + "count(".length();
                }
                int endIndex = StringUtils.indexOfIgnoreCase((String)temp, (String)")", (int)beginIndex);
                if (endIndex > 0) {
                    String param = temp.substring(beginIndex, endIndex);
                    temp = StringUtils.indexOfIgnoreCase((String)temp, (String)"count(", (int)start) >= 0 ? temp.substring(0, beginIndex) + param.substring(0, param.indexOf(".")) + temp.substring(endIndex) : temp.substring(0, beginIndex) + param.substring(0, param.indexOf(".")) + ",\"" + param.substring(param.indexOf(".") + 1).trim() + "\"" + temp.substring(endIndex);
                }
                start = endIndex;
                continue;
            }
            start = -1;
        }
        return temp;
    }

    private boolean isNumeric(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return false;
        }
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            if (value.charAt(i) == '.' || value.charAt(i) >= '0' && value.charAt(i) <= '9') continue;
            return false;
        }
        return true;
    }

    public void validateExpression(String exp) throws BIMException {
        int beginIndex = 0;
        int endIndex = 0;
        while (beginIndex != -1) {
            String propertyName;
            if ((beginIndex = exp.indexOf("[", beginIndex)) < 0) continue;
            endIndex = exp.indexOf("]", beginIndex);
            if (endIndex >= 0 && this.bizUnit.getFieldByName(propertyName = exp.substring(beginIndex + 1, endIndex)) == null && RuleJCodeWriter.getPropertyByName(this.bizUnit.getEntity(), propertyName) == null) {
                throw new BIMException("\u5b57\u6bb5" + propertyName + "\u4e0d\u5b58\u5728!");
            }
            beginIndex = endIndex;
        }
    }

    public AbstractExpressionInfo parse(String expression) throws Exception {
        SimpleExpressionInfo simpleExp;
        if (StringUtils.isEmpty((String)expression)) {
            return null;
        }
        AbstractExpressionInfo exp = null;
        this.validateExpression(expression);
        Lexer lexer = new Lexer(this.formatExpression(expression));
        TokenList tokenList = new TokenList(lexer);
        exp = this.parseExp(tokenList);
        exp = BizExpressionParser.adjustExpression(exp);
        exp.setString("source", expression);
        if (exp != null && exp instanceof SimpleExpressionInfo && ExpressionType.CONST.equals((Object)(simpleExp = (SimpleExpressionInfo)exp).getType())) {
            throw new BIMException("\u4e0d\u5408\u6cd5\u7684\u8868\u8fbe\u5f0f\u5b9a\u4e49\uff01");
        }
        return exp;
    }

    public String getSource(AbstractExpressionInfo expression) {
        if (expression == null) {
            return null;
        }
        return expression.getSource();
    }

    private static AbstractExpressionInfo adjustExpression(AbstractExpressionInfo srcExp) throws Exception {
        GroupExpressionInfo groupExp;
        AbstractExpressionInfo desExp = srcExp;
        if (srcExp instanceof GroupExpressionInfo && (groupExp = (GroupExpressionInfo)srcExp).getExpressions().size() == 2) {
            groupExp.getExpressions().set(0, BizExpressionParser.adjustExpression(groupExp.getExpressions().get(0)));
            groupExp.getExpressions().set(1, BizExpressionParser.adjustExpression(groupExp.getExpressions().get(1)));
            String operator = groupExp.getOperator();
            if (operator.equals("==") || operator.equals(">") || operator.equals("<") || operator.equals(">=") || operator.equals("<=")) {
                desExp = BizExpressionParser.converToEqualsMethod(groupExp);
            }
        }
        return desExp;
    }

    private static AbstractExpressionInfo converToEqualsMethod(GroupExpressionInfo groupExp) throws Exception {
        AbstractExpressionInfo leftExp = groupExp.getExpressions().get(0);
        AbstractExpressionInfo rightExp = groupExp.getExpressions().get(1);
        String operator = groupExp.getOperator();
        if (operator.equals("==")) {
            SimpleExpressionInfo simpleExp = new SimpleExpressionInfo();
            simpleExp.setType(ExpressionType.METHODINVOKE);
            simpleExp.setValueType("Unkown");
            if ("String".equalsIgnoreCase(leftExp.getValueType()) || "String".equalsIgnoreCase(rightExp.getValueType())) {
                if (leftExp instanceof SimpleExpressionInfo && ((SimpleExpressionInfo)leftExp).getType() == ExpressionType.CONST && "String".equalsIgnoreCase(leftExp.getValueType())) {
                    simpleExp.setMethod(new MethodInfo("\"" + ((SimpleExpressionInfo)leftExp).getValue() + "\"", "equals", "boolean"));
                    simpleExp.getMethod().getParameters().add(new ParameterInfo(rightExp));
                    return simpleExp;
                }
                if (rightExp instanceof SimpleExpressionInfo && ((SimpleExpressionInfo)rightExp).getType() == ExpressionType.CONST && "String".equalsIgnoreCase(rightExp.getValueType())) {
                    simpleExp.setMethod(new MethodInfo("\"" + ((SimpleExpressionInfo)rightExp).getValue() + "\"", "equals", "boolean"));
                    simpleExp.getMethod().getParameters().add(new ParameterInfo(leftExp));
                    return simpleExp;
                }
                if (leftExp instanceof SimpleExpressionInfo) {
                    simpleExp.setMethod(new MethodInfo((SimpleExpressionInfo)leftExp, "equals", "boolean"));
                    simpleExp.getMethod().getParameters().add(new ParameterInfo(rightExp));
                    return simpleExp;
                }
                simpleExp.setMethod(new MethodInfo((SimpleExpressionInfo)rightExp, "equals", "boolean"));
                simpleExp.getMethod().getParameters().add(new ParameterInfo(leftExp));
                return simpleExp;
            }
            if ("Date".equalsIgnoreCase(leftExp.getValueType()) || "Date".equalsIgnoreCase(rightExp.getValueType())) {
                if (leftExp instanceof SimpleExpressionInfo && "Date".equalsIgnoreCase(leftExp.getValueType())) {
                    simpleExp.setMethod(new MethodInfo((SimpleExpressionInfo)leftExp, "equals", "boolean"));
                    simpleExp.getMethod().getParameters().add(new ParameterInfo(rightExp));
                    return simpleExp;
                }
                if (rightExp instanceof SimpleExpressionInfo && "Date".equalsIgnoreCase(rightExp.getValueType())) {
                    simpleExp.setMethod(new MethodInfo((SimpleExpressionInfo)rightExp, "equals", "boolean"));
                    simpleExp.getMethod().getParameters().add(new ParameterInfo(leftExp));
                    return simpleExp;
                }
                if (leftExp instanceof SimpleExpressionInfo) {
                    simpleExp.setMethod(new MethodInfo((SimpleExpressionInfo)leftExp, "equals", "boolean"));
                    simpleExp.getMethod().getParameters().add(new ParameterInfo(rightExp));
                    return simpleExp;
                }
                simpleExp.setMethod(new MethodInfo((SimpleExpressionInfo)rightExp, "equals", "boolean"));
                simpleExp.getMethod().getParameters().add(new ParameterInfo(leftExp));
                return simpleExp;
            }
            return groupExp;
        }
        if (operator.equals(">") || operator.equals("<") || operator.equals(">=") || operator.equals("<=")) {
            GroupExpressionInfo newGroupExp = new GroupExpressionInfo();
            SimpleExpressionInfo simpleExp = new SimpleExpressionInfo();
            simpleExp.setType(ExpressionType.METHODINVOKE);
            if ("String".equalsIgnoreCase(leftExp.getValueType()) || "String".equalsIgnoreCase(rightExp.getValueType())) {
                if (leftExp instanceof SimpleExpressionInfo && ((SimpleExpressionInfo)leftExp).getType() == ExpressionType.CONST && "String".equalsIgnoreCase(leftExp.getValueType())) {
                    simpleExp.setValueType("int");
                    simpleExp.setMethod(new MethodInfo("\"" + ((SimpleExpressionInfo)leftExp).getValue() + "\"", "compareTo", "int"));
                    simpleExp.getMethod().getParameters().add(new ParameterInfo(rightExp));
                    newGroupExp.getExpressions().add(simpleExp);
                    newGroupExp.setOperator(operator);
                    newGroupExp.getExpressions().add(new SimpleExpressionInfo(ExpressionType.CONST, "int", "0"));
                    return newGroupExp;
                }
                if (rightExp instanceof SimpleExpressionInfo && ((SimpleExpressionInfo)rightExp).getType() == ExpressionType.CONST && "String".equalsIgnoreCase(rightExp.getValueType())) {
                    simpleExp.setValueType("int");
                    simpleExp.setMethod(new MethodInfo("\"" + ((SimpleExpressionInfo)rightExp).getValue() + "\"", "compareTo", "int"));
                    simpleExp.getMethod().getParameters().add(new ParameterInfo(leftExp));
                    newGroupExp.getExpressions().add(simpleExp);
                    newGroupExp.setOperator(BizExpressionParser.convertOperator(operator));
                    newGroupExp.getExpressions().add(new SimpleExpressionInfo(ExpressionType.CONST, "int", "0"));
                    return newGroupExp;
                }
                if (leftExp instanceof SimpleExpressionInfo) {
                    simpleExp.setValueType("int");
                    simpleExp.setMethod(new MethodInfo("\"" + ((SimpleExpressionInfo)leftExp).getValue() + "\"", "compareTo", "int"));
                    simpleExp.getMethod().getParameters().add(new ParameterInfo(rightExp));
                    newGroupExp.getExpressions().add(simpleExp);
                    newGroupExp.setOperator(operator);
                    newGroupExp.getExpressions().add(new SimpleExpressionInfo(ExpressionType.CONST, "int", "0"));
                    return newGroupExp;
                }
                simpleExp.setValueType("int");
                simpleExp.setMethod(new MethodInfo("\"" + ((SimpleExpressionInfo)rightExp).getValue() + "\"", "compareTo", "int"));
                simpleExp.getMethod().getParameters().add(new ParameterInfo(leftExp));
                newGroupExp.getExpressions().add(simpleExp);
                newGroupExp.setOperator(BizExpressionParser.convertOperator(operator));
                newGroupExp.getExpressions().add(new SimpleExpressionInfo(ExpressionType.CONST, "int", "0"));
                return newGroupExp;
            }
            if ("Date".equalsIgnoreCase(leftExp.getValueType()) || "Date".equalsIgnoreCase(rightExp.getValueType())) {
                if (leftExp instanceof SimpleExpressionInfo && "Date".equalsIgnoreCase(leftExp.getValueType())) {
                    simpleExp.setValueType("boolean");
                    if (operator.equals(">") || operator.equals(">=")) {
                        simpleExp.setMethod(new MethodInfo(BizExpressionParser.convertReturnType((SimpleExpressionInfo)leftExp, "Date"), "after", "boolean"));
                    } else {
                        simpleExp.setMethod(new MethodInfo(BizExpressionParser.convertReturnType((SimpleExpressionInfo)leftExp, "Date"), "before", "boolean"));
                    }
                    simpleExp.getMethod().getParameters().add(new ParameterInfo(BizExpressionParser.convertReturnType((SimpleExpressionInfo)rightExp, "Date")));
                    return simpleExp;
                }
                if (rightExp instanceof SimpleExpressionInfo && "Date".equalsIgnoreCase(rightExp.getValueType())) {
                    simpleExp.setValueType("boolean");
                    if (operator.equals(">") || operator.equals(">=")) {
                        simpleExp.setMethod(new MethodInfo(BizExpressionParser.convertReturnType((SimpleExpressionInfo)rightExp, "Date"), "before", "boolean"));
                    } else {
                        simpleExp.setMethod(new MethodInfo(BizExpressionParser.convertReturnType((SimpleExpressionInfo)rightExp, "Date"), "after", "boolean"));
                    }
                    simpleExp.getMethod().getParameters().add(new ParameterInfo(BizExpressionParser.convertReturnType((SimpleExpressionInfo)leftExp, "Date")));
                    return simpleExp;
                }
                if (leftExp instanceof SimpleExpressionInfo) {
                    simpleExp.setValueType("boolean");
                    if (operator.equals(">") || operator.equals(">=")) {
                        simpleExp.setMethod(new MethodInfo(BizExpressionParser.convertReturnType((SimpleExpressionInfo)leftExp, "Date"), "after", "boolean"));
                    } else {
                        simpleExp.setMethod(new MethodInfo(BizExpressionParser.convertReturnType((SimpleExpressionInfo)leftExp, "Date"), "before", "boolean"));
                    }
                    simpleExp.getMethod().getParameters().add(new ParameterInfo(BizExpressionParser.convertReturnType((SimpleExpressionInfo)rightExp, "Date")));
                    return simpleExp;
                }
                simpleExp.setValueType("boolean");
                if (operator.equals(">") || operator.equals(">=")) {
                    simpleExp.setMethod(new MethodInfo(BizExpressionParser.convertReturnType((SimpleExpressionInfo)rightExp, "Date"), "before", "boolean"));
                } else {
                    simpleExp.setMethod(new MethodInfo(BizExpressionParser.convertReturnType((SimpleExpressionInfo)rightExp, "Date"), "after", "boolean"));
                }
                simpleExp.getMethod().getParameters().add(new ParameterInfo(BizExpressionParser.convertReturnType((SimpleExpressionInfo)leftExp, "Date")));
                return simpleExp;
            }
            return groupExp;
        }
        return groupExp;
    }

    private static SimpleExpressionInfo convertReturnType(SimpleExpressionInfo srcExp, String desType) {
        SimpleExpressionInfo desExp = new SimpleExpressionInfo();
        desExp.setType(ExpressionType.METHODINVOKE);
        desExp.setValueType(desType);
        if ("Date".equals(desType)) {
            desExp.setMethod(new MethodInfo(UIRuleUtilClassName, "getDateValue", "Object"));
            desExp.getMethod().getParameters().add(new ParameterInfo(srcExp));
            return desExp;
        }
        return srcExp;
    }

    private static String convertOperator(String operator) {
        if (operator.equals(">")) {
            return "<=";
        }
        if (operator.equals(">=")) {
            return "<";
        }
        if (operator.equals("<")) {
            return ">=";
        }
        if (operator.equals("<=")) {
            return ">";
        }
        if (operator.equals("==")) {
            return "!=";
        }
        return operator;
    }

    private static SimpleExpressionInfo converToEqualsMethod(String leftExp, AbstractExpressionInfo rightExp) throws Exception {
        SimpleExpressionInfo simpleExp = new SimpleExpressionInfo();
        simpleExp.setType(ExpressionType.METHODINVOKE);
        simpleExp.setValueType("Unkown");
        simpleExp.setMethod(new MethodInfo("\"" + leftExp + "\"", "equals", "String"));
        simpleExp.getMethod().getParameters().add(new ParameterInfo(rightExp));
        return simpleExp;
    }

    protected void validate() throws Exception {
    }

    static {
        operators.add("*");
        operators.add("/");
        operators.add("\\");
        operators.add("+");
        operators.add("-");
        operators.add("AND");
        operators.add("OR");
        operators.add("==");
        operators.add(">");
        operators.add(">=");
        operators.add("<");
        operators.add("<=");
        operators.add("!=");
        operators.add("=");
        javaOperators.add("*");
        javaOperators.add("/");
        javaOperators.add("\\");
        javaOperators.add("+");
        javaOperators.add("-");
        javaOperators.add(" && ");
        javaOperators.add(" || ");
        javaOperators.add("==");
        javaOperators.add(">");
        javaOperators.add(">=");
        javaOperators.add("<");
        javaOperators.add("<=");
        javaOperators.add("!=");
        javaOperators.add("=");
    }
}

