/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizunit.proxy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizunit.BizTemplateCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectCtrl;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.metadata.webui.WebUIObjectCtrl;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ConvertUtils {
    public static final String USER_DEFINED = "userDefined";
    public static final String IS_IN_CODE = "isInCode";
    public static final String CODING_RULE_ENABLED = "codingRuleEnabled";
    public static final String IS_FOR_MAPPING = "isForMapping";
    public static final String IS_FOR_GROUPING = "isForGrouping";
    public static final String IS_FOR_MATCHING = "isForMatching";
    public static final String IS_FOR_WRITTEN_BACK = "isForWrittenBack";
    public static final String DEFAULT_F7_QUERY = "defaultF7Query";
    public static final String DEFAULT_F7_UINAME = "defaultf7uiname";
    public static final String F7_FILTER_ITEM = "f7FilterItem";
    public static final String BILL_FORMULA_CLASS = "billFormulaClass";
    public static final String IS_SIMPLE_ENTITY = "isSimpleEntity";
    public static final String DEFAULT_DISPLAY_FIELD = "defaultDisplayField";
    public static final String IS_COMMON_QUERY_FILTER = "isCommonQueryFilter";
    public static final String IS_COMMON_QUERY_SORTER = "isCommonQuerySorter";
    public static final String IS_USING_F7 = "isUsingF7";
    public static final String DISPLAY_FORMAT = "displayFormat";
    public static final String EDITOR_FORMAT = "editFormat";
    public static final String COMMIT_FORMAT = "commitFormat";
    public static final String LIST_UI = "listUI";
    public static final String EDIT_UI = "editUI";
    public static final String WEBEDITUI = "webEditUI";
    public static final String WEBLISTUI = "webListUI";
    public static final String WEBEDITPAGE = "webEditPage";
    public static final String WEBLISTPAGE = "webListPage";
    public static final String IS_ASST_ACCT_TYPE = "isAsstAcctType";
    public static final String IS_VISIBLE_FOR_KDTABLE = "isVisibleForKDTable";
    public static final String COL_WIDTH_IN_KDTABLE = "ColWidthInKDTable";
    public static final String F7_WINDOW_TITLE = "f7WindowTitle";
    public static final String IS_PARAM_OBJECT = "isParamObject";
    public static final String BIZ_DATAFIELD = "dataField";
    public static final String WEB_SUPPORT_ONLY = "webSupportOnly";
    public static final String PERMISSION_ORGRELATION = "orgRelation";
    public static final String BIZ_DISPLAYFORMAT_DEF_VALUE = "$name$";
    public static final String BIZ_EDITFORMAT_DEF_VALUE = "$number$";
    public static final String BIZ_COMMITFORMAT_DEF_VALUE = "$number$";
    public static final String BIZ_FIELD_MAXINDEX = "maxFieldIndex";
    public static final String BIZ_RULE_MAXINDEX = "maxRuleIndex";
    public static final String BIZ_NONELIST = "noneList";
    public static final String BIZ_ORGTYPE = "OrgType";
    public static final String BIZ_MAINORGFIELDNAME = "MainOrgFieldName";
    public static final String BIZ_BIZSTATUSFIELDNAME = "BizStatusFieldName";
    public static final String BIZ_BIZSTATUSFIELDVALUE = "BizStatusFieldValue";
    public static final String BIZ_MUTIPAGE_ENUMPK = "MutiPageEnumPK";
    public static final String BIZ_ISUSECODERULE = "isUseCodeRule";
    public static final String BIZ_F7USEDLISTUICLASSNAME = "f7UsedListUIClassName";
    public static final String BIZ_F7FILTERITEMS = "f7FilterItems";
    public static final String BIZ_ENTITYINFONAME = "entityInfoName";
    public static final String BIZ_ENTITYFACTORYNAME = "entityFactoryName";
    public static final String BIZ_QUERYNAME = "queryName";
    public static final String BIZ_GROUPENTITYINFONAME = "groupEntityInfoName";
    public static final String BIZ_DETAILENTITYINFONAME = "detailEntityInfoName";
    public static final String BIZ_EDITUI = "EditUI";
    public static final String BIZ_LISTUI = "ListUI";
    public static final String BIZ_ENTRYUI = "EntryUI";
    public static final String BIZ_TABLEEDITUI = "TableEditUI";
    public static final String BIZ_BIMTEMPLATETYPE = "bimTemplateType";
    public static final String BIZ_MBILLBASE = "MBillBase";
    public static final String BIZ_BILLBASE = "BillBase";
    public static final String BIZ_DATABASE = "DataBase";
    public static final String BIZ_TREEBASE = "TreeBase";
    public static final String BIZ_TREEDETAIL = "TreeDetail";
    public static final String BIZ_MCOREBILLBASE = "MCoreBillBase";
    public static final String BIZ_TREEDETAIL4DETAIL = "TreeDetail4Detail";
    public static final String ADDEDBYBIM = "addedByBIM";
    public static final String MODE_DEV = "developeVer";
    public static final String MODE_CLIENT = "clientVer";
    public static final String BIM_BUILDDETAIL = "buildDetail";
    public static final String CONTROLLERBEANEX = "controllerBeanEx";
    public static final String ISSUMFIELD = "isSumField";
    public static final String ISCOPYFROMSCMBILL = "isCopyFromSCMBill";
    public static final String PRINTQUERY = "printQuery";
    public static final String CONFIGURED_BIZ = "configured";
    public static final String ENUM_CLASSNAME = "enumclassname";
    public static final String BIND_PROPERTY_TYPE = "bindpropertytype";
    public static final String EXTEND_FORMATXML = "extend_formatxml";
    public static final String COLUMN_ORDER = "column_order";
    private static String userDefinedValue = null;
    private static String product_mode = "developeVer";
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils");

    public static BizUnitInfo getBizUnitInfo(String bizUnitPK) {
        BizUnitInfo bizUnit = null;
        if (bizUnitPK.indexOf("com.kingdee.eas.bim.Biz") >= 0) {
            BizTemplateCtrl bizCtrl = new BizTemplateCtrl(ContextManager.getContext());
            try {
                bizUnit = bizCtrl.getValueNoClone(MetaDataPK.create(bizUnitPK));
            }
            catch (Exception e) {
                logger.warn((Object)"error:", (Throwable)e);
            }
        } else {
            BizUnitCtrl bizCtrl = new BizUnitCtrl(ContextManager.getContext());
            try {
                bizUnit = bizCtrl.getValueNoClone(MetaDataPK.create(bizUnitPK));
            }
            catch (BOSException e) {
                BizTemplateCtrl bizTemplateCtrl = new BizTemplateCtrl(ContextManager.getContext());
                try {
                    bizUnit = bizTemplateCtrl.getValueNoClone(MetaDataPK.create(bizUnitPK));
                }
                catch (Exception ee) {
                    logger.warn((Object)"error:", (Throwable)ee);
                }
            }
        }
        return bizUnit;
    }

    public static EntityObjectInfo getEntityObjectInfo(BizUnitInfo bizUnit) {
        if (bizUnit == null) {
            return null;
        }
        EntityObjectInfo entity = null;
        try {
            if (!bizUnit.isAllLoaded()) {
                EntityObjectCtrl entityCtrl = new EntityObjectCtrl(ContextManager.getContext());
                String entityPK = bizUnit.getString("entityPK");
                entity = entityCtrl.getValue(MetaDataPK.create(entityPK));
            } else {
                entity = bizUnit.getEntity();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entity;
    }

    public static String getBimTemplateType(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        String bimTemplateType = "";
        if (bizUnit != null) {
            bimTemplateType = bizUnit.getBimTemplateType();
        }
        return bimTemplateType;
    }

    public static boolean hasBizUnitUserDefineFalse(UIObjectInfo model) {
        String bizUnitPK = model.getBizUnitPK();
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return false;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        if (bizUnit == null) {
            return false;
        }
        return !ConvertUtils.isUserDefined(bizUnit);
    }

    public static boolean hasBizUnitUserDefineFalse(EntityObjectInfo model) {
        String bizUnitPK = model.getBizUnitPK();
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return false;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        if (bizUnit == null) {
            return false;
        }
        return !ConvertUtils.isUserDefined(bizUnit);
    }

    public static AbstractUIObjectInfo getEditUI(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        AbstractUIObjectInfo editUI = null;
        if (bizUnit != null) {
            String editUIPK = bizUnit.getEditUIPK();
            if (!StringUtils.isEmpty((String)editUIPK)) {
                UIObjectCtrl uiCtrl = new UIObjectCtrl(ContextManager.getContext());
                try {
                    editUI = uiCtrl.getAllValue(MetaDataPK.create(editUIPK));
                    return editUI;
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            } else {
                editUIPK = bizUnit.getWebEditUIPK();
                if (!StringUtils.isEmpty((String)editUIPK)) {
                    WebUIObjectCtrl uiCtrl = new WebUIObjectCtrl(ContextManager.getContext());
                    try {
                        editUI = uiCtrl.getAllValue(MetaDataPK.create(editUIPK));
                    }
                    catch (Exception e) {
                        logger.error((Object)e, (Throwable)e);
                    }
                }
            }
        }
        return editUI;
    }

    public static String getEditUIName(UIObjectInfo listUI) {
        BizUnitInfo bizUnit;
        if (listUI == null) {
            return null;
        }
        if (!StringUtils.isEmpty((String)listUI.getBizUnitPK()) && (bizUnit = ConvertUtils.getBizUnitInfo(listUI.getBizUnitPK())) != null) {
            if (!StringUtils.isEmpty((String)bizUnit.getTableEditUIPK()) && bizUnit.isUseTableEditUI()) {
                return bizUnit.getTableEditUIPK();
            }
            if (StringUtils.isEmpty((String)listUI.getExtendedProperty("editUIName"))) {
                return bizUnit.getString("editUIPK");
            }
        }
        return listUI.getExtendedProperty("editUIName");
    }

    public static String getWebEditUIName(WebUIObjectInfo listUI) {
        BizUnitInfo bizUnit;
        if (listUI == null) {
            return null;
        }
        if (!StringUtils.isEmpty((String)listUI.getBizUnitPK()) && (bizUnit = ConvertUtils.getBizUnitInfo(listUI.getBizUnitPK())) != null && !StringUtils.isEmpty((String)bizUnit.getWebEditUIPK())) {
            return bizUnit.getWebEditUIPK();
        }
        return listUI.getExtendedProperty("editUIName");
    }

    public static String getBimUIType(String bizUnitPK, String uiObjectPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        String bimUIType = "";
        if (bizUnit != null) {
            String editUIPK = bizUnit.getString("editUIPK");
            String listUIPK = bizUnit.getString("listUIPK");
            String entryUIPK = bizUnit.getString("entryUIPK");
            String tableEditUIPK = bizUnit.getExtendedProperty("tableEditUIPK");
            if (uiObjectPK.equalsIgnoreCase(editUIPK)) {
                bimUIType = BIZ_EDITUI;
            } else if (uiObjectPK.equalsIgnoreCase(listUIPK)) {
                bimUIType = BIZ_LISTUI;
            } else if (uiObjectPK.equalsIgnoreCase(tableEditUIPK)) {
                bimUIType = BIZ_TABLEEDITUI;
            } else if (editUIPK != null) {
                UIObjectCtrl uiCtrl = new UIObjectCtrl(ContextManager.getContext());
                try {
                    UIObjectInfo editUI = uiCtrl.getValue(MetaDataPK.create(editUIPK));
                    ComponentCollection components = editUI.getComponents();
                    int n = components.size();
                    for (int i = 0; i < n; ++i) {
                        if (!uiObjectPK.equalsIgnoreCase(components.get(i).getBimUIObjectPK())) continue;
                        bimUIType = BIZ_ENTRYUI;
                        break;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        }
        return bimUIType;
    }

    public static String getEntityClassName(String bizUnitPK, String uiObjectPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        String entityClassName = "";
        if (bizUnit != null) {
            String entityPK = uiObjectPK.equalsIgnoreCase(bizUnit.getRelatedEditUIPK()) || uiObjectPK.equalsIgnoreCase(bizUnit.getRelatedWebEditUIPK()) ? bizUnit.getRelatedEntityPK() : bizUnit.getString("entityPK");
            EntityObjectCtrl entityCtrl = new EntityObjectCtrl(ContextManager.getContext());
            try {
                EntityObjectInfo entity = entityCtrl.getValue(MetaDataPK.create(entityPK));
                entityClassName = entity.getBusinessImplName() + "Info";
            }
            catch (Exception e) {
                logger.error((Object)"error", (Throwable)e);
            }
        }
        return entityClassName;
    }

    public static String getEntityCollectionClassName(String bizUnitPK, String uiObjectPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        String entityClassName = "";
        if (bizUnit != null) {
            String entityPK = uiObjectPK.equalsIgnoreCase(bizUnit.getRelatedEditUIPK()) || uiObjectPK.equalsIgnoreCase(bizUnit.getRelatedWebEditUIPK()) ? bizUnit.getRelatedEntityPK() : bizUnit.getString("entityPK");
            EntityObjectCtrl entityCtrl = new EntityObjectCtrl(ContextManager.getContext());
            try {
                EntityObjectInfo entity = entityCtrl.getValue(MetaDataPK.create(entityPK));
                entityClassName = entity.getBusinessImplName() + "Collection";
            }
            catch (Exception e) {
                logger.error((Object)"error", (Throwable)e);
            }
        }
        return entityClassName;
    }

    public static String getEntityFactoryName(String bizUnitPK, String uiObjectPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        String entityFactoryName = "";
        if (bizUnit != null) {
            String entityPK = uiObjectPK.equalsIgnoreCase(bizUnit.getRelatedEditUIPK()) || uiObjectPK.equalsIgnoreCase(bizUnit.getRelatedWebEditUIPK()) ? bizUnit.getRelatedEntityPK() : bizUnit.getString("entityPK");
            EntityObjectCtrl entityCtrl = new EntityObjectCtrl(ContextManager.getContext());
            try {
                EntityObjectInfo entity = entityCtrl.getValue(MetaDataPK.create(entityPK));
                entityFactoryName = entity.getBusinessImplFactory();
            }
            catch (Exception e) {
                logger.error((Object)"error", (Throwable)e);
            }
        }
        return entityFactoryName;
    }

    public static String getRelatedEntityPK(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        String relatedEntityPK = "";
        if (bizUnit != null) {
            relatedEntityPK = bizUnit.getRelatedEntityPK();
        }
        return relatedEntityPK;
    }

    public static String getRelatedTablePK(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        String relatedTablePK = "";
        if (bizUnit != null) {
            relatedTablePK = bizUnit.getRelatedTablePK();
        }
        return relatedTablePK;
    }

    public static String getRelatedEditUIPK(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        String relatedEditUIPK = "";
        if (bizUnit != null) {
            relatedEditUIPK = bizUnit.getRelatedEditUIPK();
        }
        return relatedEditUIPK;
    }

    public static String getRelatedWebEditUIPK(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        String relatedWebEditUIPK = "";
        if (bizUnit != null) {
            relatedWebEditUIPK = bizUnit.getRelatedWebEditUIPK();
        }
        return relatedWebEditUIPK;
    }

    public static String getF7UsedListUIClassName(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        return bizUnit.getF7UsedListUIClassName();
    }

    public static String getBimGroupEntityName(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        String bimGroupEntityName = "";
        if (bizUnit != null) {
            String relatedEntityPK = bizUnit.getRelatedEntityPK();
            if (relatedEntityPK == null) {
                return null;
            }
            EntityObjectCtrl entityCtrl = new EntityObjectCtrl(ContextManager.getContext());
            try {
                EntityObjectInfo entity = entityCtrl.getValue(MetaDataPK.create(relatedEntityPK));
                bimGroupEntityName = entity.getBusinessImplName() + "Info";
            }
            catch (Exception e) {
                logger.error((Object)"error", (Throwable)e);
            }
        }
        return bimGroupEntityName;
    }

    public static String getBimGroupEntityFactoryName(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        String bimGroupEntityFactoryName = "";
        if (bizUnit != null) {
            String relatedEntityPK = bizUnit.getRelatedEntityPK();
            if (relatedEntityPK == null) {
                return null;
            }
            EntityObjectCtrl entityCtrl = new EntityObjectCtrl(ContextManager.getContext());
            try {
                EntityObjectInfo entity = entityCtrl.getValue(MetaDataPK.create(relatedEntityPK));
                bimGroupEntityFactoryName = entity.getBusinessImplFactory();
            }
            catch (Exception e) {
                logger.error((Object)"error", (Throwable)e);
            }
        }
        return bimGroupEntityFactoryName;
    }

    public static String getBimGroupEntityInterfaceName(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        String bimGroupEntityInterfaceName = "";
        if (bizUnit != null) {
            String relatedEntityPK = bizUnit.getRelatedEntityPK();
            if (relatedEntityPK == null) {
                return null;
            }
            EntityObjectCtrl entityCtrl = new EntityObjectCtrl(ContextManager.getContext());
            try {
                EntityObjectInfo entity = entityCtrl.getValue(MetaDataPK.create(relatedEntityPK));
                bimGroupEntityInterfaceName = entity.getBusinessInterface();
            }
            catch (Exception e) {
                logger.error((Object)"error", (Throwable)e);
            }
        }
        return bimGroupEntityInterfaceName;
    }

    public static String getBimGroupEditUIName(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        String bimGroupEditUIName = "";
        if (bizUnit != null) {
            String relatedEditUIPK = bizUnit.getRelatedEditUIPK();
            if (relatedEditUIPK == null) {
                return null;
            }
            UIObjectCtrl uiCtrl = new UIObjectCtrl(ContextManager.getContext());
            try {
                UIObjectInfo relatedEditUI = uiCtrl.getValue(MetaDataPK.create(relatedEditUIPK));
                bimGroupEditUIName = ConvertUtils.getPKFullName(relatedEditUI.getReleasePackage(), relatedEditUI.getReleaseClass());
            }
            catch (Exception e) {
                logger.error((Object)"error", (Throwable)e);
            }
        }
        return bimGroupEditUIName;
    }

    public static String getBimTreeListUIClassName(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        String bimTreeListUIClassName = "";
        if (bizUnit != null) {
            bimTreeListUIClassName = bizUnit.getF7UsedListUIClassName();
            if (!StringUtils.isEmpty((String)bimTreeListUIClassName)) {
                return bimTreeListUIClassName;
            }
            if (BIZ_TREEBASE.equalsIgnoreCase(bizUnit.getBimTemplateType()) || BIZ_TREEDETAIL.equalsIgnoreCase(bizUnit.getBimTemplateType())) {
                String listUIPK = bizUnit.getString("listUIPK");
                UIObjectCtrl uiCtrl = new UIObjectCtrl(ContextManager.getContext());
                try {
                    UIObjectInfo listUI = uiCtrl.getValueNotCache(MetaDataPK.create(listUIPK));
                    if (listUI != null) {
                        bimTreeListUIClassName = StringUtils.isEmpty((String)listUI.getReleasePackage()) ? listUI.getReleaseClass() : listUI.getReleasePackage() + "." + listUI.getReleaseClass();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        }
        return bimTreeListUIClassName;
    }

    public static String getBimDetailEntityClassName(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        String bimDetailEntityClassName = "";
        if (bizUnit != null && BIZ_BILLBASE.equalsIgnoreCase(bizUnit.getBimTemplateType())) {
            String entityPK = bizUnit.getString("entityPK");
            EntityObjectCtrl entityCtrl = new EntityObjectCtrl(ContextManager.getContext());
            try {
                EntityObjectInfo entity = entityCtrl.getValue(MetaDataPK.create(entityPK));
                PropertyCollection props = entity.getProperties();
                int n = props.size();
                for (int i = 0; i < n; ++i) {
                    RelationshipInfo relation;
                    LinkPropertyInfo lnkProp;
                    PropertyInfo prop = props.get(i);
                    if (!(prop instanceof LinkPropertyInfo) || (lnkProp = (LinkPropertyInfo)prop) == null || lnkProp.getRelationship() == null || (relation = lnkProp.getRelationship()).getSupplierCardinality() != CardinalityType.ZERO_TO_UNBOUNDED && relation.getSupplierCardinality() != CardinalityType.ONE_TO_UNBOUNDED) continue;
                    if (relation.getSupplierObject() != null) {
                        bimDetailEntityClassName = relation.getSupplierObject().getBusinessImplName() + "Info";
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.error((Object)"error", (Throwable)e);
            }
        }
        return bimDetailEntityClassName;
    }

    private static String getPKFullName(String packageName, String name) {
        if (StringUtils.isEmpty((String)packageName)) {
            return name;
        }
        return packageName + "." + name;
    }

    public static boolean isGenImplementCode(Object ov) {
        if (ov == null) {
            return false;
        }
        if (ov instanceof String) {
            return ConvertUtils.isGenImplementCode((String)ov);
        }
        if (ov instanceof EntityObjectInfo) {
            return ConvertUtils.isGenImplementCode((EntityObjectInfo)ov);
        }
        if (ov instanceof UIObjectInfo) {
            return ConvertUtils.isGenImplementCode((UIObjectInfo)ov);
        }
        if (ov instanceof FacadeInfo) {
            return ConvertUtils.isGenImplementCode((FacadeInfo)ov);
        }
        return true;
    }

    public static boolean isGenImplementCode(UIObjectInfo uiObject) {
        if (uiObject == null) {
            return false;
        }
        String genCode = uiObject.getExtendedProperty("genImplementCode");
        if (!StringUtils.isEmpty((String)genCode)) {
            return "true".equals(genCode);
        }
        if (!StringUtils.isEmpty((String)uiObject.getBizUnitPK())) {
            return ConvertUtils.isGenImplementCode(uiObject.getBizUnitPK());
        }
        return ConvertUtils.isDevMode() || ConvertUtils.isUserDefined(uiObject);
    }

    public static boolean isGenImplementCode(FacadeInfo facade) {
        if (facade == null) {
            return false;
        }
        String genCode = facade.getExtendedProperty("genImplementCode");
        if (!StringUtils.isEmpty((String)genCode)) {
            return "true".equals(genCode);
        }
        return ConvertUtils.isDevMode() || ConvertUtils.isUserDefined(facade);
    }

    public static boolean isGenImplementCode(EntityObjectInfo entity) {
        if (entity == null) {
            return false;
        }
        String genCode = entity.getExtendedProperty("genImplementCode");
        if (!StringUtils.isEmpty((String)genCode)) {
            return "true".equals(genCode);
        }
        if (!StringUtils.isEmpty((String)entity.getBizUnitPK())) {
            return ConvertUtils.isGenImplementCode(entity.getBizUnitPK());
        }
        return ConvertUtils.isDevMode() || ConvertUtils.isUserDefined(entity);
    }

    public static boolean isGenImplementCode(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return true;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        if (bizUnit != null) {
            return bizUnit.isGenImplementCode();
        }
        return true;
    }

    public static String getBizUnitOAKPK(String bizUnitPK, String pkType) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        String pkName = "";
        if (bizUnit != null) {
            if ("entityPK".equalsIgnoreCase(pkType)) {
                pkName = bizUnit.getString("entityPK");
            } else if ("queryPK".equalsIgnoreCase(pkType)) {
                pkName = bizUnit.getString("queryPK");
            } else if ("editUIPK".equalsIgnoreCase(pkType)) {
                pkName = bizUnit.getString("editUIPK");
            } else if ("listUIPK".equalsIgnoreCase(pkType)) {
                pkName = bizUnit.getString("listUIPK");
            } else if ("entryUIPK".equalsIgnoreCase(pkType)) {
                pkName = bizUnit.getString("entryUIPK");
            } else if ("entityFunctionPK".equalsIgnoreCase(pkType)) {
                pkName = bizUnit.getString("entityFunctionPK");
            } else if ("editUIFunctionPK".equalsIgnoreCase(pkType)) {
                pkName = bizUnit.getString("editUIFunctionPK");
            } else if ("listUIFunctionPK".equalsIgnoreCase(pkType)) {
                pkName = bizUnit.getString("listUIFunctionPK");
            }
        }
        return pkName;
    }

    public static boolean isUserDefined(IObjectValue info) {
        if (info instanceof AbstractMetaDataValue) {
            return ((AbstractMetaDataValue)info).isUserDefined();
        }
        String value = info.getExtendedProperty(USER_DEFINED);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public static boolean isUserDefined(AbstractMetaDataValue info) {
        return info.isUserDefined();
    }

    public static boolean isUserDefined(PackageInfo info) {
        return info.isUserDefined() || "true".equalsIgnoreCase(info.getExtendedProperty(USER_DEFINED));
    }

    public static boolean isUserDefined(MethodInfo info) {
        return info.isUserDefined();
    }

    public static List getUserDefinedCollection(AbstractObjectCollection collection) {
        ArrayList<IObjectValue> udList = new ArrayList<IObjectValue>(collection.size());
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            IObjectValue info = collection.getObject(i);
            if (!ConvertUtils.isUserDefined(info)) continue;
            udList.add(info);
        }
        return udList;
    }

    public static String getUserDefinedVaule() {
        if (userDefinedValue != null) {
            return userDefinedValue;
        }
        ConvertUtils.initUserDefinedValue("true");
        return userDefinedValue;
    }

    public static boolean getUserDefinedBooleanVaule() {
        if (userDefinedValue != null) {
            return Boolean.valueOf(userDefinedValue);
        }
        ConvertUtils.initUserDefinedValue("true");
        return Boolean.valueOf(userDefinedValue);
    }

    public static void initUserDefinedValue(String value) {
        if (userDefinedValue != null) {
            return;
        }
        userDefinedValue = value;
    }

    public static void initProductMode(String value) {
        product_mode = value;
    }

    public static String getBIMProductMode() {
        return product_mode;
    }

    public static boolean isDevMode() {
        return ConvertUtils.getBIMProductMode().equals(MODE_DEV);
    }

    public static String getQueryPK(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        if (bizUnit != null) {
            return bizUnit.getString("queryPK");
        }
        return null;
    }

    public static String getTDFileName(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        String fileName = bizUnitPK;
        String perfix = "com.kingdee.eas.";
        if (!StringUtils.isEmpty((String)perfix) && fileName.startsWith(perfix)) {
            fileName = StringUtils.replace((String)fileName, (String)perfix, (String)"");
        }
        return "/bim/" + StringUtils.replace((String)fileName, (String)".", (String)"/");
    }

    public static boolean getExtendedPropertyBooelanValue(IObjectValue ov, String extendedPropertyName) {
        if (ov == null) {
            return false;
        }
        String value = ov.getExtendedProperty(extendedPropertyName);
        if (StringUtils.isEmpty((String)value)) {
            return false;
        }
        return new Boolean(value);
    }

    public static void setExtendedPropertyBooelanValue(IObjectValue ov, String extendedPropertyName, boolean value) {
        if (ov == null || StringUtils.isEmpty((String)extendedPropertyName)) {
            return;
        }
        ov.setExtendedProperty(extendedPropertyName, String.valueOf(value));
    }

    public static boolean isSCMBill(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return false;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        return bizUnit != null && ConvertUtils.getExtendedPropertyBooelanValue(bizUnit, ISCOPYFROMSCMBILL);
    }
}

