/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizunit.proxy;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bizunit.BIMException;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizMethodCollection;
import com.kingdee.bos.metadata.bizunit.BizMethodInfo;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.bizunit.proxy.AbstractProxy;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.event.EventCollection;
import com.kingdee.bos.metadata.event.EventInfo;
import com.kingdee.bos.metadata.event.EventMethodCollection;
import com.kingdee.bos.metadata.event.EventMethodInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.util.StringUtils;

public class EntityFunctionProxy
extends AbstractProxy {
    private FunctionObjectInfo function;

    public EntityFunctionProxy(Context ctx, FunctionObjectInfo function) {
        this.function = function;
    }

    @Override
    public void update() throws BIMException {
        if (this.function == null) {
            return;
        }
        String nameExt = "Function";
        if (this.bizUnit.getObjectState() == ObjectStateType.NEW) {
            if (this.function == null) {
                throw new IllegalStateException("function can not be null");
            }
            this.function.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            this.function.setName(this.bizUnit.getName() + nameExt);
            this.function.setAlias(this.bizUnit.getAlias());
            this.function.setDescription(this.bizUnit.getDescription());
            int n = this.function.getOperation().size();
            for (int i = 0; i < n; ++i) {
                this.function.getOperation().get(i).setEntityObjectRef(this.bizUnit.getEntity());
            }
            if (this.bizUnit.getTemplate() != null && this.bizUnit.getTemplate().getEntityFunction() != null) {
                OperationCollection opers = this.bizUnit.getTemplate().getEntityFunction().getOperation();
                int n2 = opers.size();
                for (int i = 0; i < n2; ++i) {
                    this.function.getOperation().add(opers.get(i));
                }
            }
        }
        BizMethodCollection methodCol = this.bizUnit.getMethods();
        OperationCollection operCol = this.function.getOperation();
        this.syncFunctionOpersByBizField(methodCol, operCol);
    }

    private void syncFunctionOpersByBizField(BizMethodCollection methodCol, OperationCollection operCol) throws BIMException {
        int n = methodCol.size();
        for (int i = 0; i < n; ++i) {
            BizMethodInfo method = methodCol.get(i);
            ObjectStateType stateType = method.getObjectState();
            OperationInfo operation = null;
            if (stateType.equals((Object)ObjectStateType.UNCHANGE)) continue;
            if (stateType.equals((Object)ObjectStateType.NEW)) {
                operation = new OperationInfo();
                operation.getExtendedProperties().put("userDefined", ConvertUtils.getUserDefinedVaule());
                this.updateOperation(method, operation);
                operCol.add(operation);
                continue;
            }
            if (stateType.equals((Object)ObjectStateType.DELETING)) {
                operation = EntityFunctionProxy.getOperationByName(operCol, method.getMethodName());
                if (operation == null) continue;
                operCol.remove(operation);
                continue;
            }
            if (!stateType.equals((Object)ObjectStateType.CHANGED)) continue;
            operation = EntityFunctionProxy.getOperationByName(operCol, method.getMethodName());
            if (operation == null) {
                operation = new OperationInfo();
                operation.getExtendedProperties().put("userDefined", ConvertUtils.getUserDefinedVaule());
                operCol.add(operation);
            }
            this.updateOperation(method, operation);
            if (operation == null) continue;
            operCol.remove(operation);
        }
    }

    private void updateOperation(BizMethodInfo method, OperationInfo operation) throws BIMException {
        if (method == null) {
            throw new IllegalArgumentException("method can not be null");
        }
        String name = null;
        if (StringUtils.isEmpty((String)operation.getName())) {
            name = EntityFunctionProxy.generateOperationName(method, this.function.getOperation());
            method.setOperationName(name);
        } else {
            String oldName = method.getMethodName();
            if (operation.getName().equals(oldName)) {
                name = EntityFunctionProxy.generateOperationName(method, this.function.getOperation());
            }
        }
        operation.setName(name);
        operation.setAlias(method.getAlias());
        operation.setDescription(method.getDescription());
        operation.setEntityObjectRef(this.bizUnit.getEntity());
        operation.setEventMethod(method.getMethodName());
        operation.setEvent(EntityFunctionProxy.getEventName(this.bizUnit.getEntity(), method.getMethodName()));
    }

    private static String getEventName(EntityObjectInfo entity, String methodName) {
        EventCollection events = entity.getEvents();
        int n = events.size();
        for (int i = 0; i < n; ++i) {
            EventInfo event = events.get(i);
            EventMethodCollection eventMethods = event.getEventMethods();
            int m = eventMethods.size();
            for (int j = 0; j < m; ++j) {
                EventMethodInfo eventMethod = eventMethods.get(j);
                if (eventMethod.getMethodRef() == null || !eventMethod.getMethodRef().getName().equalsIgnoreCase(methodName)) continue;
                return event.getName();
            }
        }
        return null;
    }

    private MethodInfo getMethodByName(EntityObjectInfo entity, String methodName) throws BIMException {
        MethodInfo method = null;
        int n = entity.getMethods().size();
        for (int i = 0; i < n; ++i) {
            if (!StringUtils.equalsIgnoreCase((String)entity.getMethods().get(i).getName(), (String)methodName)) continue;
            method = entity.getMethods().get(i);
            break;
        }
        if (method == null) {
            throw new IllegalArgumentException("Can not found method: " + methodName + "in Entity: " + entity.getPackage() + "." + entity.getName());
        }
        return method;
    }

    public static String generateOperationName(BizMethodInfo method, OperationCollection operCol) {
        String name = method.getName();
        OperationInfo operation = EntityFunctionProxy.getOperationByName(operCol, name);
        if (operation != null) {
            int i = 0;
            while (operation != null) {
                name = method.getName() + i++;
                operation = EntityFunctionProxy.getOperationByName(operCol, name);
            }
        }
        return name;
    }

    @Override
    public void checkValid() throws BIMException {
        if (this.function == null) {
            return;
        }
        ObjectStateType stateType = this.bizUnit.getObjectState();
        if (stateType.equals((Object)ObjectStateType.DELETED) && !this.function.isUserDefined()) {
            throw new BIMException("can not delete system defined table");
        }
        BizFieldCollection bfCol = this.bizUnit.getFields();
        OperationCollection operCol = this.function.getOperation();
        int n = bfCol.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bf = bfCol.get(i);
            stateType = bf.getObjectState();
            OperationInfo operation = EntityFunctionProxy.getOperationByName(operCol, bf.getColumnName());
            if (stateType.equals((Object)ObjectStateType.DELETED)) {
                if (operation == null || ConvertUtils.isUserDefined(operation)) continue;
                throw new BIMException("can not delete system defined function");
            }
            if (!stateType.equals((Object)ObjectStateType.CHANGED) || operation == null || ConvertUtils.isUserDefined(operation)) continue;
            throw new BIMException("can not change system defined column");
        }
    }

    public static OperationInfo getOperationByName(OperationCollection operCol, String operName) {
        OperationInfo operation = null;
        int n = operCol.size();
        for (int i = 0; i < n; ++i) {
            if (StringUtils.isEmpty((String)operCol.get(i).getName()) || !operCol.get(i).getName().equals(operName)) continue;
            operation = operCol.get(i);
            break;
        }
        return operation;
    }
}

