/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizunit.proxy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizunit.BIMException;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizMethodCollection;
import com.kingdee.bos.metadata.bizunit.BizMethodInfo;
import com.kingdee.bos.metadata.bizunit.BizType;
import com.kingdee.bos.metadata.bizunit.DataSourceType;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.bizunit.proxy.AbstractProxy;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.bizunit.proxy.TableProxy;
import com.kingdee.bos.metadata.bo.AccessLevel;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.bo.SubClassingMode;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DAOFunction;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectCtrl;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.event.EventCollection;
import com.kingdee.bos.metadata.event.EventInfo;
import com.kingdee.bos.metadata.event.EventMethodCollection;
import com.kingdee.bos.metadata.event.EventMethodInfo;
import com.kingdee.bos.metadata.event.FormalParameterInfo;
import com.kingdee.bos.metadata.event.ParameterMappingInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import org.apache.log4j.Logger;

public class EntityProxy
extends AbstractProxy {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.bizunit.proxy.EntityProxy");
    private EntityObjectInfo entity;

    public EntityProxy(Context ctx, EntityObjectInfo entity) {
        this.entity = entity;
    }

    @Override
    public void update() throws BIMException {
        if (this.entity == null) {
            return;
        }
        if (this.bizUnit.getObjectState().equals((Object)ObjectStateType.CHANGED)) {
            this.entity.setAlias(this.bizUnit.getAlias() == null ? "" : this.bizUnit.getAlias());
            this.entity.setDescription(this.bizUnit.getDescription() == null ? "" : this.bizUnit.getDescription());
            this.entity.setExtendedProperty("enableFieldPermission", String.valueOf(this.bizUnit.isEnableFieldPermission()));
        }
        BizFieldCollection bfCol = this.bizUnit.getFields();
        PropertyCollection propCol = this.entity.getProperties();
        this.syncPropertyByBizField(bfCol, propCol, this.entity);
        BizMethodCollection bmCol = this.bizUnit.getMethods();
        MethodCollection methodCol = this.entity.getMethods();
        this.syncMethodByBizMethod(bmCol, methodCol, this.entity);
    }

    private boolean ignoreBizField(BizFieldInfo bf) {
        BizDataType dataType = bf.getBizDataType();
        return dataType == null || dataType.equals((Object)BizDataType.PANEL) || dataType.equals((Object)BizDataType.TABFOLDER) || dataType.equals((Object)BizDataType.LABEL) || dataType.equals((Object)BizDataType.BUTTON) || dataType.equals((Object)BizDataType.BUTTONGROUP) || dataType.equals((Object)BizDataType.KDSEPARATOR) || dataType.equals((Object)BizDataType.RADIOBUTTON);
    }

    private void syncMethodByBizMethod(BizMethodCollection bmCol, MethodCollection methodCol, EntityObjectInfo entityInfo) throws BIMException {
        int n = bmCol.size();
        for (int i = 0; i < n; ++i) {
            String oldName;
            BizMethodInfo bizMethod = bmCol.get(i);
            ObjectStateType state = bizMethod.getObjectState();
            MethodInfo method = null;
            if (state.equals((Object)ObjectStateType.NEW)) {
                method = new MethodInfo();
                method.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
                method.setString("innerID", Uuid.create().toString());
                method.setName(bizMethod.getName());
                method.setAlias(bizMethod.getAlias());
                method.setAccessLevel(AccessLevel.PUBLIC);
                method.setSubClassingMode(SubClassingMode.NORMAL);
                if (bizMethod.getBizStatusFieldValue() != null) {
                    method.setExtendedProperty("BizStatusFieldValue", bizMethod.getBizStatusFieldValue().getName());
                }
                ParameterInfo parameter = new ParameterInfo();
                parameter.setName("model");
                parameter.setDataType("ObjectValue");
                parameter.setMetadataRef(this.entity.getFullName());
                method.getParameters().add(parameter);
                this.entity.getMethods().add(method);
                bizMethod.setMethodName(method.getName());
                EntityProxy.addEventForMethod(this.entity, method);
                if (!method.isUserDefined()) continue;
                entityInfo.setExtendedProperty("controllerBeanEx", entityInfo.getBusinessControllerBean() + "Ex");
                continue;
            }
            if (state.equals((Object)ObjectStateType.CHANGED)) {
                oldName = bizMethod.getMethodName();
                method = EntityProxy.getMethodByName(this.entity.getMethods(), oldName);
                if (method == null) continue;
                method.setName(bizMethod.getName());
                method.setAlias(bizMethod.getAlias());
                bizMethod.setMethodName(method.getName());
                if (bizMethod.getBizStatusFieldValue() != null) {
                    method.setExtendedProperty("BizStatusFieldValue", bizMethod.getBizStatusFieldValue().getName());
                    continue;
                }
                if (StringUtils.isEmpty((String)method.getExtendedProperty("BizStatusFieldValue"))) continue;
                method.removeExtendedProperty("BizStatusFieldValue");
                continue;
            }
            if (!state.equals((Object)ObjectStateType.DELETING)) continue;
            oldName = bizMethod.getMethodName();
            method = EntityProxy.getMethodByName(this.entity.getMethods(), oldName);
            if (method == null) continue;
            EntityProxy.removeEventForMethod(this.entity, method);
            this.entity.getMethods().remove(method);
        }
    }

    private void syncPropertyByBizField(BizFieldCollection bfCol, PropertyCollection propCol, EntityObjectInfo entityInfo) throws BIMException {
        int n = bfCol.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bf = bfCol.get(i);
            ObjectStateType stateType = bf.getObjectState();
            if (this.ignoreBizField(bf)) continue;
            if (stateType.equals((Object)ObjectStateType.UNCHANGE)) {
                if (!(bf instanceof BizGroupFieldInfo)) continue;
                BizGroupFieldInfo group = (BizGroupFieldInfo)bf;
                this.updateEntryEntity(group, entityInfo);
                continue;
            }
            if (stateType.equals((Object)ObjectStateType.NEW)) {
                if (bf instanceof BizGroupFieldInfo) {
                    this.createEntryEntity((BizGroupFieldInfo)bf, entityInfo);
                    continue;
                }
                if (DataSourceType.BASEDATAEXT.equals((Object)bf.getDataSourceType()) && !bf.isNeedSave()) continue;
                if (BizDataType.OBJECT.equals((Object)bf.getBizDataType()) && bf.getDataSource() != null) {
                    LinkPropertyInfo lkprop = this.createLinkProperty(bf, entityInfo);
                    propCol.add(lkprop);
                    continue;
                }
                if ("seq".equals(bf.getName()) && entityInfo.getPropertyByName(bf.getName()) instanceof OwnPropertyInfo) continue;
                OwnPropertyInfo ownprop = this.createOwnProperty(bf, entityInfo);
                propCol.add(ownprop);
                continue;
            }
            if (stateType.equals((Object)ObjectStateType.DELETING)) {
                PropertyInfo prop;
                if (bf instanceof BizGroupFieldInfo) {
                    if (bf.isSaved() || (prop = entityInfo.getPropertyByName(bf.getPropertyName())) == null) continue;
                    propCol.remove(prop);
                    continue;
                }
                if (BizDataType.OBJECT.equals((Object)bf.getBizDataType()) && bf.getDataSource() != null && bf.isSaved() || (prop = entityInfo.getPropertyByName(bf.getPropertyName())) == null) continue;
                propCol.remove(prop);
                continue;
            }
            if (!stateType.equals((Object)ObjectStateType.CHANGED) || StringUtils.isEmpty((String)bf.getPropertyName()) || EntityProxy.getPropertyByName(propCol, bf.getPropertyName()) == null) continue;
            if (bf instanceof BizGroupFieldInfo) {
                this.updateEntryEntity((BizGroupFieldInfo)bf, entityInfo);
                continue;
            }
            if (BizDataType.OBJECT.equals((Object)bf.getBizDataType()) && bf.getDataSource() != null) {
                this.updateLinkProperty(bf, entityInfo);
                continue;
            }
            this.updateOwnProperty(bf, entityInfo);
        }
    }

    @Override
    public void checkValid() throws BIMException {
        if (this.entity == null) {
            return;
        }
        ObjectStateType stateType = this.bizUnit.getObjectState();
        if (stateType.equals((Object)ObjectStateType.DELETED) && !this.entity.isUserDefined()) {
            throw new BIMException("\u4e0d\u80fd\u5220\u9664\u7cfb\u7edf\u5b9a\u4e49\u7684\u5b9e\u4f53\u5b57\u6bb5!");
        }
        BizFieldCollection bfCol = this.bizUnit.getFields();
        this.checkValid(bfCol, this.entity);
    }

    private void checkValid(BizFieldCollection bfCol, EntityObjectInfo entityInfo) throws BIMException {
        int n = bfCol.size();
        for (int i = 0; i < n; ++i) {
            PropertyInfo property;
            BizFieldInfo bf = bfCol.get(i);
            if (this.ignoreBizField(bf)) continue;
            ObjectStateType stateType = bf.getObjectState();
            if (stateType.equals((Object)ObjectStateType.UNCHANGE)) {
                if (!(bf instanceof BizGroupFieldInfo)) continue;
                BizGroupFieldInfo group = (BizGroupFieldInfo)bf;
                this.checkValid(group.getFields(), group.getEntityObject());
                continue;
            }
            boolean isParentProperty = false;
            if (bf.getPropertyName() == null || entityInfo == null) {
                property = null;
            } else {
                property = entityInfo.getPropertyByName(bf.getPropertyName());
                boolean bl = isParentProperty = !entityInfo.getProperties().contains(property);
            }
            if (stateType.equals((Object)ObjectStateType.CHANGED)) {
                EntityObjectInfo oldEntity;
                if (property != null && isParentProperty && !this.canChange(bf, property)) {
                    throw new BIMException("\u4e0d\u80fd\u6539\u53d8\u7236\u5b9e\u4f53\u7684\u5c5e\u6027 " + property.getName());
                }
                if (bf instanceof BizGroupFieldInfo) {
                    BizGroupFieldInfo group = (BizGroupFieldInfo)bf;
                    String oldName = (String)bf.getOldValue("name");
                    if (group.getName() == null || !group.getName().equals(oldName) && oldName != null) {
                        throw new BIMException("\u4e0d\u80fd\u6539\u53d8\u5206\u5f55\u4f53\u7684\u540d\u79f0!");
                    }
                    oldEntity = (EntityObjectInfo)group.getOldValue("entityObject");
                    if (oldEntity != null && group.getEntityObject() != null && !group.getEntityObject().getFullName().equals(oldEntity.getFullName())) {
                        throw new BIMException("\u4e0d\u80fd\u6539\u53d8\u5206\u5f55\u4f53\u5f15\u7528\u7684\u5b9e\u4f53\uff01");
                    }
                    if (group.getEntityObject() == null) continue;
                    this.checkValid(group.getFields(), group.getEntityObject());
                    continue;
                }
                if (BizDataType.OBJECT.equals((Object)bf.getBizDataType()) && bf.getDataSource() != null) {
                    EntityObjectInfo oldEntity2 = (EntityObjectInfo)bf.getOldValue("dataSource");
                    EntityObjectInfo currentEntity = bf.getDataSource();
                    if (currentEntity == null) {
                        throw new BIMException("\u5173\u8054\u5b57\u6bb5\u7684\u5f15\u7528\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (oldEntity2 == null || currentEntity.getFullName().equals(oldEntity2.getFullName())) continue;
                    throw new BIMException("\u4e0d\u80fd\u6539\u53d8\u5173\u8054\u5b57\u6bb5\u7684\u5f15\u7528\u5bf9\u8c61");
                }
                boolean oldPersistence = false;
                Object obj = bf.getOldValue("persistence");
                if (obj instanceof Integer) {
                    int value = (Integer)obj;
                    oldPersistence = value == 1;
                }
                if ((oldEntity = (EntityObjectInfo)bf.getOldValue("dataSource")) == null) continue;
                throw new BIMException("\u4e0d\u80fd\u6539\u53d8\u5173\u8054\u5b57\u6bb5\u7684\u5f15\u7528\u5bf9\u8c61\uff01");
            }
            if (stateType.equals((Object)ObjectStateType.NEW)) {
                property = entityInfo == null ? null : entityInfo.getPropertyByName(bf.getName());
                if (property != null) {
                    throw new BIMException("\u5b57\u6bb5\u5df2\u7ecf\u5b58\u5728:" + bf.getName());
                }
                if (bf instanceof BizGroupFieldInfo) {
                    BizGroupFieldInfo group = (BizGroupFieldInfo)bf;
                    this.checkValid(group.getFields(), group.getEntityObject());
                    continue;
                }
                if (!BizDataType.OBJECT.equals((Object)bf.getBizDataType()) || bf.getDataSource() == null) continue;
                continue;
            }
            if (!stateType.equals((Object)ObjectStateType.DELETING) || ConvertUtils.isDevMode() || property == null) continue;
            if (!property.isUserDefined()) {
                throw new BIMException("\u4e0d\u80fd\u5220\u9664\u7cfb\u7edf\u5b9a\u4e49\u7684\u5b57\u6bb5: " + property.getName());
            }
            if (!isParentProperty) continue;
            throw new BIMException("\u4e0d\u80fd\u6539\u53d8\u7236\u5b9e\u4f53\u7684\u5b57\u6bb5: " + property.getName());
        }
    }

    private boolean canChange(BizFieldInfo bf, PropertyInfo property) throws BIMException {
        if (property instanceof LinkPropertyInfo) {
            return !bf.isPropertyChanged("bizDataType") && !bf.isPropertyChanged("dataSource");
        }
        OwnPropertyInfo ownprop = (OwnPropertyInfo)property;
        String name = bf.getName();
        if (!name.equals(property.getName())) {
            return false;
        }
        BizDataType dt = bf.getBizDataType();
        return !bf.isPropertyChanged("bizDataType") || EntityProxy.getPropertyType(dt).equals(ownprop.getDataType());
    }

    private OwnPropertyInfo createOwnProperty(BizFieldInfo bf, EntityObjectInfo entityInfo) throws BIMException {
        OwnPropertyInfo prop = new OwnPropertyInfo();
        prop.setName(EntityProxy.generatePropertyName(bf, entityInfo));
        bf.setPropertyName(prop.getName());
        prop.setDataType(EntityProxy.getPropertyType(bf.getBizDataType()));
        prop.getExtendedProperties().put("bizDataType", bf.getBizDataType().getName());
        if (bf.getBizDataType().equals((Object)BizDataType.ENUM)) {
            BizEnumInfo bizenum = bf.getEnumType();
            if (bizenum == null) {
                throw new BIMException("bizData has enum type, but without enum info");
            }
            prop.setMetadataRef(bizenum.getFullName());
        }
        prop.setPrecision(bf.getPrecision());
        prop.setDecimalDigits(bf.getScale());
        if (bf.getDefaultValue() != null) {
            prop.setDefaultValue(bf.getDefaultValue());
        }
        prop.setLength(bf.getLength());
        if (bf.isPersistence()) {
            ColumnInfo column = TableProxy.getColumnByName(entityInfo.getTable().getColumns(), bf.getColumnName());
            prop.setMappingField(column);
        }
        prop.setAlias(bf.getAlias() == null ? "" : bf.getAlias());
        prop.setDescription(bf.getDescription() == null ? "" : bf.getDescription());
        if (bf.getDataSourceType() != null && bf.getDataSourceType().equals((Object)DataSourceType.BASEDATAEXT)) {
            prop.getExtendedProperties().put("DataSourceType", bf.getDataSourceType().toString());
            prop.getExtendedProperties().put("DataField", bf.getDataField());
        }
        this.setPropExtendedProperties(prop, bf);
        if (DataType.DECIMAL.equals(prop.getDataType()) || DataType.DOUBLE.equals(prop.getDataType()) || DataType.FLOAT.equals(prop.getDataType()) || DataType.INTEGER.equals(prop.getDataType()) || DataType.LONG.equals(prop.getDataType()) || DataType.SHORT.equals(prop.getDataType())) {
            prop.setExtendedProperty("isForWrittenBack", "true");
        }
        prop.setExtendedProperty("enableFieldPermission", String.valueOf(bf.isEnableFieldPermission()));
        if (bf.isNeedSum() || !StringUtils.isEmpty((String)prop.getExtendedProperty("needSum"))) {
            ConvertUtils.setExtendedPropertyBooelanValue(prop, "needSum", bf.isNeedSum());
        }
        if (bf.isNeedSumInListUI() || !StringUtils.isEmpty((String)prop.getExtendedProperty("needSumInListUI"))) {
            ConvertUtils.setExtendedPropertyBooelanValue(prop, "needSumInListUI", bf.isNeedSumInListUI());
        }
        if (!bf.isSupportConfigure() || !StringUtils.isEmpty((String)prop.getExtendedProperty("isSupportConfigure"))) {
            ConvertUtils.setExtendedPropertyBooelanValue(prop, "isSupportConfigure", bf.isSupportConfigure());
        }
        if (bf.getConfigureProperty() != 111) {
            prop.setExtendedProperty("configureProperty", bf.getConfigureProperty() + "");
        } else {
            prop.removeExtendedProperty("configureProperty");
        }
        return prop;
    }

    private void updateOwnProperty(BizFieldInfo bf, EntityObjectInfo entityInfo) throws BIMException {
        String propName = bf.getPropertyName();
        if (StringUtils.isEmpty((String)propName)) {
            return;
        }
        OwnPropertyInfo prop = (OwnPropertyInfo)EntityProxy.getPropertyByName(entityInfo.getProperties(), propName);
        if (prop == null) {
            return;
        }
        if (!bf.getName().equals(propName)) {
            prop.setName(EntityProxy.generatePropertyName(bf, this.entity));
            bf.setPropertyName(prop.getName());
        }
        prop.getExtendedProperties().put("bizDataType", bf.getBizDataType().getName());
        if (bf.getBizDataType().equals((Object)BizDataType.ENUM)) {
            BizEnumInfo bizenum = bf.getEnumType();
            if (bizenum == null) {
                throw new BIMException("bizData has enum type, but without enum info");
            }
            prop.setMetadataRef(bizenum.getFullName());
            if (!StringUtils.isEmpty((String)bf.getDefaultValue()) || !StringUtils.isEmpty((String)prop.getExtendedProperty("defaultValue"))) {
                prop.setExtendedProperty("defaultValue", bf.getDefaultValue());
            }
        }
        prop.setPrecision(bf.getPrecision());
        prop.setDecimalDigits(bf.getScale());
        if (bf.getDefaultValue() != null) {
            prop.setDefaultValue(bf.getDefaultValue());
        }
        prop.setLength(bf.getLength());
        if (bf.isPersistence()) {
            ColumnInfo column = TableProxy.getColumnByName(entityInfo.getTable().getColumns(), bf.getColumnName());
            prop.setMappingField(column);
        }
        prop.setAlias(bf.getAlias() == null ? "" : bf.getAlias());
        prop.setDescription(bf.getDescription() == null ? "" : bf.getDescription());
        if (bf.getDataSourceType() != null && bf.getDataSourceType().equals((Object)DataSourceType.BASEDATAEXT)) {
            prop.getExtendedProperties().put("DataSourceType", bf.getDataSourceType().toString());
            prop.getExtendedProperties().put("DataField", bf.getDataField());
        }
        prop.setExtendedProperty("ColWidthInKDTable", bf.getExtendedProperty("ColWidthInKDTable") == null ? "50" : bf.getExtendedProperty("ColWidthInKDTable"));
        prop.setExtendedProperty("enableFieldPermission", String.valueOf(bf.isEnableFieldPermission()));
        if (!(prop == null || StringUtils.isEmpty((String)bf.getRequiredPrompt()) && StringUtils.isEmpty((String)prop.getExtendedProperty("requiredPrompt")))) {
            prop.setExtendedProperty("requiredPrompt", bf.getRequiredPrompt());
        }
        if (bf.isNeedSum() || !StringUtils.isEmpty((String)prop.getExtendedProperty("needSum"))) {
            ConvertUtils.setExtendedPropertyBooelanValue(prop, "needSum", bf.isNeedSum());
        }
        if (bf.isNeedSumInListUI() || !StringUtils.isEmpty((String)prop.getExtendedProperty("needSumInListUI"))) {
            ConvertUtils.setExtendedPropertyBooelanValue(prop, "needSumInListUI", bf.isNeedSumInListUI());
        }
        if (!bf.isSupportConfigure() || !StringUtils.isEmpty((String)prop.getExtendedProperty("isSupportConfigure"))) {
            ConvertUtils.setExtendedPropertyBooelanValue(prop, "isSupportConfigure", bf.isSupportConfigure());
        }
        if (bf.getConfigureProperty() != 111) {
            prop.setExtendedProperty("configureProperty", bf.getConfigureProperty() + "");
        } else {
            prop.removeExtendedProperty("configureProperty");
        }
    }

    private LinkPropertyInfo createLinkProperty(BizFieldInfo bf, EntityObjectInfo entityInfo) throws BIMException {
        LinkPropertyInfo linkprop = new LinkPropertyInfo();
        linkprop.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        if (bf.getDataField() != null) {
            linkprop.getExtendedProperties().put("dataField", bf.getDataField());
        }
        linkprop.setName(EntityProxy.generatePropertyName(bf, entityInfo));
        bf.setPropertyName(linkprop.getName());
        RelationshipInfo relation = new RelationshipInfo();
        relation.setPackage(this.bizUnit.getEntity().getPackage());
        String relationName = "R_" + entityInfo.getName() + "_" + bf.getDataSource().getName() + "_" + bf.getName();
        relation.setName(relationName);
        relation.setType(RelationshipType.ASSOCIATION);
        relation.setClientCardinality(CardinalityType.ONE);
        relation.setSupplierCardinality(CardinalityType.ZERO_TO_ONE);
        relation.setClientObject(entityInfo);
        relation.setSupplierObject(bf.getDataSource());
        relation.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        linkprop.setRelationship(relation);
        EntityViewInfo defaultView = entityInfo.getDefaultView();
        if (defaultView == null) {
            defaultView = new EntityViewInfo();
            entityInfo.setDefaultView(defaultView);
        }
        ColumnInfo column = TableProxy.getColumnByName(entityInfo.getTable().getColumns(), bf.getColumnName());
        linkprop.setMappingField(column);
        bf.setPropertyName(linkprop.getName());
        linkprop.setAlias(bf.getAlias() == null ? "" : bf.getAlias());
        linkprop.setDescription(bf.getDescription() == null ? "" : bf.getDescription());
        this.setPropExtendedProperties(linkprop, bf);
        return linkprop;
    }

    private void setPropExtendedProperties(PropertyInfo prop, BizFieldInfo bf) {
        prop.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        if (BizType.BaseData.equals((Object)this.bizUnit.getBizType())) {
            prop.setExtendedProperty("isInCode", "false");
        } else if ("true".equalsIgnoreCase(bf.getExtendedProperty("isInCode"))) {
            prop.setExtendedProperty("isInCode", "true");
        } else {
            prop.setExtendedProperty("isInCode", "false");
        }
        if (BizType.BaseData.equals((Object)this.bizUnit.getBizType())) {
            prop.setExtendedProperty("isForMapping", "false");
        } else if ("false".equalsIgnoreCase(bf.getExtendedProperty("isForMapping"))) {
            prop.setExtendedProperty("isForMapping", "false");
        } else {
            prop.setExtendedProperty("isForMapping", "true");
        }
        if (BizType.BaseData.equals((Object)this.bizUnit.getBizType())) {
            prop.setExtendedProperty("isForGrouping", "false");
        } else if ("true".equalsIgnoreCase(bf.getExtendedProperty("isForGrouping"))) {
            prop.setExtendedProperty("isForGrouping", "true");
        } else {
            prop.setExtendedProperty("isForGrouping", "false");
        }
        if (BizType.BaseData.equals((Object)this.bizUnit.getBizType())) {
            prop.setExtendedProperty("isForMatching", "false");
        } else if ("true".equalsIgnoreCase(bf.getExtendedProperty("isForMatching"))) {
            prop.setExtendedProperty("isForMatching", "true");
        } else {
            prop.setExtendedProperty("isForMatching", "false");
        }
        if (BizType.BaseData.equals((Object)this.bizUnit.getBizType())) {
            prop.setExtendedProperty("isForWrittenBack", "false");
        } else if ("true".equalsIgnoreCase(bf.getExtendedProperty("isForWrittenBack"))) {
            prop.setExtendedProperty("isForWrittenBack", "true");
        } else {
            prop.setExtendedProperty("isForWrittenBack", "false");
        }
        if (BizType.BaseData.equals((Object)this.bizUnit.getBizType())) {
            if ("true".equalsIgnoreCase(this.bizUnit.getExtendedProperty("isAsstAcctType"))) {
                prop.setExtendedProperty("isAsstAcctType", "true");
            } else {
                prop.setExtendedProperty("isAsstAcctType", "false");
            }
        } else {
            this.bizUnit.setExtendedProperty("isAsstAcctType", "false");
        }
        prop.setExtendedProperty("isVisibleForKDTable", String.valueOf(bf.getFieldView().isListVisible()));
        prop.setExtendedProperty("ColWidthInKDTable", bf.getExtendedProperty("ColWidthInKDTable") == null ? "50" : bf.getExtendedProperty("ColWidthInKDTable"));
    }

    private void updateLinkProperty(BizFieldInfo bf, EntityObjectInfo entityInfo) throws BIMException {
        String propName = bf.getPropertyName();
        LinkPropertyInfo prop = (LinkPropertyInfo)EntityProxy.getPropertyByName(entityInfo.getProperties(), propName);
        if (!bf.getName().equals(propName)) {
            prop.setName(EntityProxy.generatePropertyName(bf, this.entity));
            bf.setPropertyName(prop.getName());
        }
        prop.setAlias(bf.getAlias());
        prop.setDescription(bf.getDescription());
        if (!(prop == null || StringUtils.isEmpty((String)bf.getF7FilterItems()) && StringUtils.isEmpty((String)prop.getExtendedProperty("f7FilterItems")))) {
            prop.setExtendedProperty("f7FilterItems", bf.getF7FilterItems());
        }
        if (!(prop == null || StringUtils.isEmpty((String)bf.getF7ListUIClassName()) && StringUtils.isEmpty((String)prop.getExtendedProperty("f7ListUIClassName")))) {
            prop.setExtendedProperty("f7ListUIClassName", bf.getF7ListUIClassName());
        }
        if (!(prop == null || StringUtils.isEmpty((String)bf.getConsignType()) && StringUtils.isEmpty((String)prop.getExtendedProperty("consignType")))) {
            prop.setExtendedProperty("consignType", bf.getConsignType());
        }
        if (!(prop == null || StringUtils.isEmpty((String)bf.getRequiredPrompt()) && StringUtils.isEmpty((String)prop.getExtendedProperty("requiredPrompt")))) {
            prop.setExtendedProperty("requiredPrompt", bf.getRequiredPrompt());
        }
        if (bf.getDataField() != null) {
            prop.getExtendedProperties().put("dataField", bf.getDataField());
        }
        if (!StringUtils.isEmpty((String)bf.getDefaultValue()) || !StringUtils.isEmpty((String)prop.getExtendedProperty("defaultValue"))) {
            prop.setExtendedProperty("defaultValue", bf.getDefaultValue());
        }
        if (!bf.isSupportConfigure() || !StringUtils.isEmpty((String)prop.getExtendedProperty("isSupportConfigure"))) {
            ConvertUtils.setExtendedPropertyBooelanValue(prop, "isSupportConfigure", bf.isSupportConfigure());
        }
        if (bf.getConfigureProperty() != 111) {
            prop.setExtendedProperty("configureProperty", bf.getConfigureProperty() + "");
        } else {
            prop.removeExtendedProperty("configureProperty");
        }
    }

    private EntityObjectInfo createEntryEntity(BizGroupFieldInfo group, EntityObjectInfo parent) throws BIMException {
        String packageWithDot;
        LogicalKeyInfo lk;
        EntityObjectInfo entry = new EntityObjectInfo();
        try {
            EntityObjectCtrl entityCtrl = new EntityObjectCtrl(ContextManager.getContext());
            entry.setBaseEntity(entityCtrl.getValue(MetaDataPK.create("com.kingdee.eas.framework.app", "CoreBillEntryBase")));
        }
        catch (BOSException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        entry.setPackage(this.bizUnit.getEntity().getPackage());
        String name = group.getName();
        if (name.endsWith("ies")) {
            name = name.substring(0, name.length() - 3) + "y";
        } else if (name.endsWith("s")) {
            name = name.substring(0, name.length() - 1);
        }
        name = parent.getName() + name;
        entry.setName(name);
        entry.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        entry.setAlias(group.getAlias() == null ? "" : group.getAlias());
        entry.setDescription(group.getDescription() == null ? "" : group.getDescription());
        OwnPropertyInfo id = (OwnPropertyInfo)entry.getPropertyByName("ID", true);
        if (id == null) {
            id = new OwnPropertyInfo();
            id.setName("ID");
            id.setDataType(DataType.BOSUUID);
            id.setUserDefined(false);
            entry.getProperties().add(id);
        }
        if ((lk = entry.getLogicalKey()) == null) {
            lk = new LogicalKeyInfo();
            lk.setName("id");
            if (!lk.getKeyPropertys().contains(id)) {
                lk.getKeyPropertys().add(id);
            }
            entry.setLogicalKey(lk);
        }
        if (entry.getTable() == null) {
            entry.setTable(group.getTableObject());
            ColumnInfo fid = TableProxy.getColumnByName(entry.getTable().getColumns(), "FID");
            id.setMappingField(fid);
        }
        packageWithDot = StringUtils.isEmpty((String)(packageWithDot = entry.getPackage())) ? "" : packageWithDot + ".";
        entry.setBusinessControllerName(packageWithDot + entry.getName() + "Controller");
        if (packageWithDot.endsWith(".app.")) {
            entry.setBusinessImplName(packageWithDot.substring(0, packageWithDot.length() - 4) + entry.getName());
        } else {
            entry.setBusinessImplName(packageWithDot + entry.getName());
        }
        MethodCollection mc = DAOFunction.getDAOMethods(entry);
        int n = mc.size();
        for (int i = 0; i < n; ++i) {
            MethodInfo method = mc.get(i);
            entry.getMethods().add(method);
        }
        RelationshipInfo relation = new RelationshipInfo();
        relation.setPackage(this.bizUnit.getEntity().getPackage());
        relation.setName("R_" + parent.getName() + "_" + entry.getName());
        relation.setType(RelationshipType.COMPOSITION);
        relation.setClientObject(parent);
        relation.setSupplierObject(entry);
        relation.setClientCardinality(CardinalityType.ONE);
        relation.setSupplierCardinality(CardinalityType.ZERO_TO_UNBOUNDED);
        relation.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        LinkPropertyInfo parentLinkProperty = new LinkPropertyInfo();
        parentLinkProperty.setName(group.getName());
        parentLinkProperty.setRelationship(relation);
        parent.getProperties().add(parentLinkProperty);
        parentLinkProperty.setAlias(group.getAlias() == null ? "" : group.getAlias());
        parentLinkProperty.setDescription(group.getDescription() == null ? "" : group.getDescription());
        parentLinkProperty.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        group.setPropertyName(parentLinkProperty.getName());
        LinkPropertyInfo entryLinkProperty = new LinkPropertyInfo();
        entryLinkProperty.setName(this.createParentPropertyName(parent));
        entryLinkProperty.setRelationship(relation);
        entry.getProperties().add(entryLinkProperty);
        entry.setTable(group.getTableObject());
        ColumnInfo column = TableProxy.getColumnByName(entry.getTable().getColumns(), "FPARENTID");
        entryLinkProperty.setMappingField(column);
        this.syncPropertyByBizField(group.getFields(), entry.getProperties(), entry);
        group.setEntityObject(entry);
        return entry;
    }

    private String createParentPropertyName(EntityObjectInfo parent) {
        String parentPropertyName = "parent";
        if (parent.getPropertyByName(parentPropertyName, true) != null) {
            int i = 1;
            parentPropertyName = "parent" + i;
            while (parent.getPropertyByName(parentPropertyName, true) != null) {
                parentPropertyName = "parent" + ++i;
            }
        }
        return parentPropertyName;
    }

    private void updateEntryEntity(BizGroupFieldInfo group, EntityObjectInfo parent) throws BIMException {
        EntityObjectInfo entry = group.getEntityObject();
        if (entry == null) {
            return;
        }
        entry.setAlias(group.getAlias());
        entry.setDescription(group.getDescription());
        String propName = group.getPropertyName();
        PropertyInfo prop = EntityProxy.getPropertyByName(parent.getProperties(), propName);
        if (prop != null) {
            prop.setAlias(group.getAlias());
            prop.setDescription(group.getDescription());
        }
        this.syncPropertyByBizField(group.getFields(), entry.getProperties(), entry);
    }

    public static DataType getPropertyType(BizDataType bizType) throws BIMException {
        DataType dataType = null;
        if (bizType.equals((Object)BizDataType.STRING)) {
            dataType = DataType.STRING;
        } else if (bizType.equals((Object)BizDataType.DATE)) {
            dataType = DataType.DATE;
        } else if (bizType.equals((Object)BizDataType.INTEGER)) {
            dataType = DataType.INTEGER;
        } else if (bizType.equals((Object)BizDataType.QUANTITY)) {
            dataType = DataType.DECIMAL;
        } else if (bizType.equals((Object)BizDataType.AMOUNT)) {
            dataType = DataType.DECIMAL;
        } else if (bizType.equals((Object)BizDataType.PRICE)) {
            dataType = DataType.DECIMAL;
        } else if (bizType.equals((Object)BizDataType.NOTE)) {
            dataType = DataType.STRING;
        } else if (bizType.equals((Object)BizDataType.BOOLEAN)) {
            dataType = DataType.BOOLEAN;
        } else if (bizType.equals((Object)BizDataType.DECIMAL)) {
            dataType = DataType.DECIMAL;
        } else if (bizType.equals((Object)BizDataType.IMAGE)) {
            dataType = DataType.BYTEARRAY;
        } else if (bizType.equals((Object)BizDataType.ENUM)) {
            dataType = DataType.ENUM;
        } else if (bizType.equals((Object)BizDataType.TIME)) {
            dataType = DataType.TIME;
        } else {
            dataType = DataType.STRING;
            Exception ex = new Exception("\u672a\u77e5\u7684\u4e1a\u52a1\u7c7b\u578b\uff1a" + (Object)((Object)bizType));
            logger.error((Object)ex, (Throwable)ex);
        }
        return dataType;
    }

    public static PropertyInfo getPropertyByName(PropertyCollection propCol, String name) {
        PropertyInfo property = null;
        int n = propCol.size();
        for (int i = 0; i < n; ++i) {
            if (!propCol.get(i).getName().equals(name)) continue;
            property = propCol.get(i);
            break;
        }
        return property;
    }

    public static MethodInfo getMethodByName(MethodCollection methodCol, String name) {
        MethodInfo method = null;
        int n = methodCol.size();
        for (int i = 0; i < n; ++i) {
            if (!methodCol.get(i).getName().equals(name)) continue;
            method = methodCol.get(i);
            break;
        }
        return method;
    }

    public static String generatePropertyName(BizFieldInfo bf, EntityObjectInfo entityInfo) {
        String name = bf.getName();
        PropertyInfo property = entityInfo.getPropertyByName(name);
        if (property != null) {
            int i = 0;
            while (property != null) {
                name = bf.getName() + i++;
                property = entityInfo.getPropertyByName(name);
            }
        }
        return name;
    }

    private static EventInfo addEventForMethod(EntityObjectInfo entity, MethodInfo method) {
        String methodInnerID = method.getInnerID();
        EventCollection eventCol = entity.getEvents();
        int n = eventCol.size();
        for (int i = 0; i < n; ++i) {
            EventInfo event = eventCol.get(i);
            EventMethodCollection eventMethodCol = event.getEventMethods();
            if (eventMethodCol.get(methodInnerID) == null) continue;
            return event;
        }
        EventInfo event = new EventInfo();
        event.setName(method.getName() + "Event");
        event.setAlias(method.getAlias() + "\u4e8b\u4ef6");
        EventMethodInfo eventMethod = new EventMethodInfo();
        eventMethod.setName(methodInnerID);
        eventMethod.setEntityMethod(method);
        int n2 = method.getParameters().size();
        for (int j = 0; j < n2; ++j) {
            ParameterInfo cloneParam = (ParameterInfo)method.getParameters().get(j).clone();
            FormalParameterInfo fp = new FormalParameterInfo();
            fp.setParameter(cloneParam);
            event.getFormalParameters().add(fp);
            ParameterMappingInfo paramMapping = new ParameterMappingInfo();
            paramMapping.setActualParameterIndex(j);
            paramMapping.setFormalParameterInnerID(fp.getInnerID());
            if (j == 0) {
                paramMapping.setBOPK(true);
            }
            eventMethod.getParameterMappings().add(paramMapping);
        }
        event.getEventMethods().add(eventMethod);
        entity.getEvents().add(event);
        return event;
    }

    private static void removeEventForMethod(EntityObjectInfo entity, MethodInfo method) {
        String methodInnerID = method.getInnerID();
        EventCollection eventCol = entity.getEvents();
        int n = eventCol.size();
        block0: for (int i = 0; i < n; ++i) {
            EventInfo event = eventCol.get(i);
            EventMethodCollection eventMethodCol = event.getEventMethods();
            for (int j = 0; j < eventMethodCol.size(); ++j) {
                EventMethodInfo info = eventMethodCol.get(j);
                if (!methodInnerID.equals(info.getName())) continue;
                eventCol.remove(event);
                continue block0;
            }
        }
    }
}

