/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizunit.proxy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizunit.BIMException;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.DataSourceType;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.bizunit.proxy.AbstractProxy;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.bizunit.proxy.QueryProxyHelper;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.query.util.JoinType;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.Token;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class QueryProxy
extends AbstractProxy
implements Serializable {
    private JoinQueryInfo joinQuery;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.bizunit.proxy.QueryProxy");

    public QueryProxy(Context ctx, JoinQueryInfo query) {
        this.joinQuery = query;
    }

    @Override
    public void update() throws BIMException {
        if (this.joinQuery == null) {
            return;
        }
        this.joinQuery.setExtendedProperty("f7WindowTitle", this.bizUnit.getAlias());
        BizFieldCollection bfCol = this.bizUnit.getFields();
        PropertyUnitCollection propCol = this.joinQuery.getUnits();
        this.syncQueryFieldByBizField(bfCol, propCol, this.joinQuery);
    }

    private void addSubObject(JoinQueryInfo query, JoinQueryInfo baseQuery) throws BIMException {
        try {
            SubObjectCollection subObjs = baseQuery.getSubObjects();
            int n = subObjs.size();
            for (int i = 0; i < n; ++i) {
                SubEntityInfo subEntity;
                if (!(subObjs.get(i) instanceof SubEntityInfo) || StringUtils.equalsIgnoreCase((String)(subEntity = (SubEntityInfo)subObjs.get(i)).getName(), (String)baseQuery.getMainObject().getName())) continue;
                subEntity.setQuery(query);
                query.getSubObjects().add(subEntity);
            }
        }
        catch (BOSException e) {
            throw new BIMException(e);
        }
    }

    private void addPropertyInfo(JoinQueryInfo query, JoinQueryInfo baseQuery, String newName) throws BIMException {
        try {
            PropertyUnitCollection props = baseQuery.getUnits();
            String baseQueryMainObjectName = baseQuery.getMainObject().getName();
            int n = props.size();
            for (int i = 0; i < n; ++i) {
                SubEntityInfo subEntity;
                PropertyUnitInfo prop = props.get(i);
                if (prop != null && prop.getPropertyRefs().size() == 1 && StringUtils.equalsIgnoreCase((String)(subEntity = prop.getPropertyRefs().get(0).getSubEntity()).getName(), (String)baseQueryMainObjectName)) {
                    subEntity.setName(newName);
                }
                if (prop == null) continue;
                prop.setQuery(query);
                query.getUnits().add(prop);
            }
        }
        catch (BOSException e) {
            throw new BIMException(e);
        }
    }

    private void addJoin(JoinQueryInfo query, JoinQueryInfo baseQuery, String newName) throws BIMException {
        try {
            JoinCollection joins = baseQuery.getJoins();
            String baseQueryMainObjectName = baseQuery.getMainObject().getName();
            int n = joins.size();
            for (int i = 0; i < n; ++i) {
                SubObjectInfo subObj;
                JoinInfo join = joins.get(i);
                if (join != null && join.getLeftObject() != null && StringUtils.equalsIgnoreCase((String)(subObj = join.getLeftObject()).getName(), (String)baseQueryMainObjectName)) {
                    subObj.setName(newName);
                }
                if (join == null) continue;
                join.setQuery(query);
                query.getJoins().add(join);
            }
        }
        catch (BOSException e) {
            throw new BIMException(e);
        }
    }

    private void addFilter(JoinQueryInfo baseQuery) throws BIMException {
    }

    private void addSorter(JoinQueryInfo baseQuery) throws BIMException {
    }

    private void syncQueryFieldByBizField(BizFieldCollection bfCol, PropertyUnitCollection propCol, JoinQueryInfo query) throws BIMException {
        int n = bfCol.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bf = bfCol.get(i);
            if (bf instanceof BizGroupFieldInfo) {
                if (this.bizUnit.getEntryUI() == null) {
                    this.updatePropertyUnit(bf, propCol, this.bizUnit.getEntity(), query, null);
                }
            } else {
                ObjectStateType stateType = bf.getObjectState();
                if (stateType.equals((Object)ObjectStateType.UNCHANGE)) continue;
                if (ObjectStateType.NEW.equals((Object)stateType)) {
                    if (bf.isPersistence()) {
                        if (DataSourceType.BASEDATAEXT.equals((Object)bf.getDataSourceType()) && !bf.isNeedSave()) continue;
                        this.addPropertyUnit(bf, propCol, this.bizUnit.getEntity(), query, null);
                    }
                } else if (ObjectStateType.DELETING.equals((Object)stateType)) {
                    this.deletePropertyUnit(bf, propCol, query);
                } else if (ObjectStateType.CHANGED.equals((Object)stateType)) {
                    this.updatePropertyUnit(bf, propCol, this.bizUnit.getEntity(), query, null);
                }
            }
            if (BizDataType.OBJECT.equals((Object)bf.getBizDataType()) && bf.getDataSource() != null && DataSourceType.BASEDATA.equals((Object)bf.getDataSourceType())) {
                bf.setExtendedProperty("isUsingF7", "true");
                continue;
            }
            bf.setExtendedProperty("isUsingF7", "false");
        }
        QueryProxyHelper.processQueryPK(query.getQueryPK(), propCol);
    }

    private int getGroupFieldCount() {
        BizFieldCollection bfCol = this.bizUnit.getFields();
        int count = 0;
        int n = bfCol.size();
        for (int i = 0; i < n; ++i) {
            if (!(bfCol.get(i) instanceof BizGroupFieldInfo)) continue;
            ++count;
        }
        return count;
    }

    private void updatePropertyUnit(BizFieldInfo bf, PropertyUnitCollection propCol, EntityObjectInfo entity, JoinQueryInfo query, BizGroupFieldInfo bizGroupField) throws BIMException {
        PropertyUnitInfo prop = null;
        if (bf instanceof BizGroupFieldInfo) {
            BizGroupFieldInfo groupField = (BizGroupFieldInfo)bf;
            if (ObjectStateType.NEW.equals((Object)bf.getObjectState())) {
                if (this.getGroupFieldCount() == 1) {
                    this.addPropertyUnit(bf, propCol, entity, query, null);
                }
                if ("TreeDetail4Detail".equalsIgnoreCase(this.bizUnit.getBimTemplateType()) && groupField.getEntityObject() != null) {
                    MetaDataPK subQueryPK = MetaDataPK.create(groupField.getEntityObject().getPackage(), groupField.getEntityObject().getName() + "Query");
                    try {
                        JoinQueryInfo subQuery = QueryProxyHelper.createSubQueryByEntity(entity, groupField.getPropertyName(), subQueryPK);
                        groupField.setQuery(subQuery);
                    }
                    catch (BOSException e) {
                        throw new BIMException("\u6dfb\u52a0\u5b50\u67e5\u8be2\u5bf9\u8c61\u51fa\u9519\uff01", e);
                    }
                }
            } else if (ObjectStateType.DELETING.equals((Object)bf.getObjectState())) {
                this.deletePropertyUnit(bf, propCol, query);
            } else if (((BizGroupFieldInfo)bf).getEntityObject() != null) {
                boolean isExistSubEntity = this.existSubEntity(((BizGroupFieldInfo)bf).getEntityObject().getName(), query);
                BizFieldCollection bfCol = ((BizGroupFieldInfo)bf).getFields();
                int n = bfCol.size();
                for (int i = 0; i < n; ++i) {
                    ObjectStateType stateType;
                    BizFieldInfo subField = bfCol.get(i);
                    if (subField instanceof BizGroupFieldInfo || (stateType = subField.getObjectState()).equals((Object)ObjectStateType.UNCHANGE)) continue;
                    if (ObjectStateType.NEW.equals((Object)stateType)) {
                        if (!subField.isPersistence() || DataSourceType.BASEDATAEXT.equals((Object)subField.getDataSourceType()) && !subField.isNeedSave()) continue;
                        if (isExistSubEntity) {
                            this.addPropertyUnit(subField, propCol, ((BizGroupFieldInfo)bf).getEntityObject(), query, groupField);
                        }
                        if (!"TreeDetail4Detail".equalsIgnoreCase(this.bizUnit.getBimTemplateType()) || groupField.getQuery() == null) continue;
                        this.addPropertyUnit(subField, groupField.getQuery().getUnits(), ((BizGroupFieldInfo)bf).getEntityObject(), groupField.getQuery(), groupField);
                        continue;
                    }
                    if (ObjectStateType.DELETING.equals((Object)stateType)) {
                        if (isExistSubEntity) {
                            this.deletePropertyUnit(subField, propCol, query);
                        }
                        if (!"TreeDetail4Detail".equalsIgnoreCase(this.bizUnit.getBimTemplateType()) || groupField.getQuery() == null) continue;
                        this.deletePropertyUnit(subField, groupField.getQuery().getUnits(), groupField.getQuery());
                        continue;
                    }
                    if (!ObjectStateType.CHANGED.equals((Object)stateType)) continue;
                    if (isExistSubEntity) {
                        this.updatePropertyUnit(subField, propCol, ((BizGroupFieldInfo)bf).getEntityObject(), query, bizGroupField);
                    }
                    if (!"TreeDetail4Detail".equalsIgnoreCase(this.bizUnit.getBimTemplateType()) || groupField.getQuery() == null) continue;
                    this.updatePropertyUnit(subField, groupField.getQuery().getUnits(), ((BizGroupFieldInfo)bf).getEntityObject(), groupField.getQuery(), bizGroupField);
                }
            }
        } else {
            prop = QueryProxy.getPropertyUnitByName(propCol, bf.getQueryFieldName());
            if (bf.isPersistence() && (bf.getDataSource() == null || BizDataType.OBJECT.equals((Object)bf.getBizDataType()) && bf.getDataSource() != null && !StringUtils.isEmpty((String)bf.getDataField()))) {
                this.updateQueryField(bf, prop, entity, query, false, bizGroupField);
            }
            if (!bf.isPersistence() && prop != null) {
                propCol.remove(prop);
            }
        }
    }

    private void addPropertyUnit(BizFieldInfo bf, PropertyUnitCollection propCol, EntityObjectInfo entity, JoinQueryInfo query, BizGroupFieldInfo groupField) throws BIMException {
        QueryFieldInfo prop = null;
        if (bf instanceof BizGroupFieldInfo) {
            BizGroupFieldInfo group = (BizGroupFieldInfo)bf;
            EntityObjectInfo groupEntity = group.getEntityObject();
            if (groupEntity != null) {
                this.addSubEntityToQuery(group, groupEntity, query);
                int n = group.getFields().size();
                for (int i = 0; i < n; ++i) {
                    if (ObjectStateType.DELETING.equals((Object)group.getFields().get(i).getObjectState()) || ObjectStateType.DELETED.equals((Object)group.getFields().get(i).getObjectState()) || !group.getFields().get(i).isPersistence() || !group.getFields().get(i).isNeedSave()) continue;
                    this.addPropertyUnit(group.getFields().get(i), propCol, group.getEntityObject(), query, group);
                }
                LinkPropertyInfo lnkProp = (LinkPropertyInfo)entity.getPropertyByName(group.getPropertyName());
                this.processJoin(lnkProp, query);
            }
        } else if (bf.getBizDataType().equals((Object)BizDataType.OBJECT)) {
            EntityObjectInfo subEntity = bf.getDataSource();
            String lnkPropertyName = bf.getDataField();
            if (!StringUtils.isEmpty((String)lnkPropertyName)) {
                if (subEntity == null) {
                    throw new BIMException("BizGroupField: " + bf.getName() + "'s entity is null,Please check BizGroupField!");
                }
                this.addSubEntityToQuery(bf, subEntity, query, groupField);
                LinkPropertyInfo lnkProp = (LinkPropertyInfo)entity.getPropertyByName(bf.getPropertyName());
                String displayName = this.getDisplayName(lnkPropertyName);
                if (!StringUtils.isEmpty((String)displayName)) {
                    QueryFieldInfo field = this.newQueryField(bf, subEntity, (OwnPropertyInfo)subEntity.getPropertyByName(displayName), query, groupField);
                    query.getUnits().add(field);
                    if (StringUtils.isEmpty((String)bf.getQueryFieldName())) {
                        bf.setQueryFieldName(field.getName());
                    }
                    if ("false".equalsIgnoreCase(bf.getExtendedProperty("isCommonQueryFilter"))) {
                        field.setExtendedProperty("isCommonQueryFilter", "false");
                    } else {
                        field.setExtendedProperty("isCommonQueryFilter", "true");
                    }
                    if ("false".equalsIgnoreCase(bf.getExtendedProperty("isCommonQuerySorter"))) {
                        field.setExtendedProperty("isCommonQuerySorter", "false");
                    } else {
                        field.setExtendedProperty("isCommonQuerySorter", "true");
                    }
                    if (BizDataType.OBJECT.equals((Object)bf.getBizDataType()) && bf.getDataSource() != null && DataSourceType.BASEDATA.equals((Object)bf.getDataSourceType())) {
                        field.setExtendedProperty("isUsingF7", "true");
                    } else {
                        field.setExtendedProperty("isUsingF7", "false");
                    }
                } else {
                    throw new BIMException("The propertyInfo is not a LinkPropertyInfo!");
                }
                this.processJoin(bf, lnkProp, query, groupField);
            }
        } else {
            prop = new QueryFieldInfo(query);
            prop.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            this.updateQueryField(bf, prop, entity, query, true, groupField);
        }
        if (prop != null) {
            propCol.add(prop);
        }
    }

    private String getDisplayName(String name) {
        String displayName = "";
        if (!StringUtils.isEmpty((String)name)) {
            int iPos = name.indexOf("+");
            displayName = iPos > 0 ? name.substring(0, iPos).trim() : name;
        }
        return displayName;
    }

    private QueryFieldInfo newQueryField(EntityObjectInfo entity, OwnPropertyInfo prop, JoinQueryInfo query, BizGroupFieldInfo groupField) throws BIMException {
        if (prop != null) {
            QueryFieldInfo field = new QueryFieldInfo(query);
            if (this.isMainEntity(entity, query)) {
                field.setName(prop.getName());
            } else {
                field.setName(this.findSubEntityName(entity, query) + "." + prop.getName());
            }
            field.setReturnType(QueryUtil.getConstDataType(prop.getDataType()));
            field.setDisplayName(prop.getAlias());
            field.setFormulaString("#0");
            field.setIsSelector(true);
            field.setIsFilter(true);
            field.setIsSorter(true);
            field.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            PropertyRefInfo ref = groupField != null ? new PropertyRefInfo(field, this.getSubEntity(entity.getName(), query), entity.getPropertyByName(prop.getName())) : new PropertyRefInfo(field, this.getSubEntity(entity.getName(), query), entity.getPropertyByName(prop.getName()));
            field.getPropertyRefs().add(ref);
            return field;
        }
        throw new BIMException("The propertyinfo is not a OwnPropertyInfo!");
    }

    private QueryFieldInfo newQueryField(BizFieldInfo bf, EntityObjectInfo entity, OwnPropertyInfo prop, JoinQueryInfo query, BizGroupFieldInfo groupField) throws BIMException {
        if (prop != null) {
            QueryFieldInfo field = new QueryFieldInfo(query);
            if (this.isMainEntity(entity, query)) {
                field.setName(prop.getName());
            } else if (BizDataType.OBJECT.equals((Object)bf.getBizDataType()) && bf.getDataSource() != null) {
                BizFieldInfo parentField = this.bizUnit.getParentField(bf);
                if (parentField != null) {
                    field.setName(parentField.getName() + "." + bf.getName() + "." + prop.getName());
                } else {
                    field.setName(bf.getName() + "." + prop.getName());
                }
            } else {
                field.setName(this.findSubEntityName(entity, query) + "." + prop.getName());
            }
            field.setReturnType(QueryUtil.getConstDataType(prop.getDataType()));
            field.setDisplayName(bf.getAlias());
            field.setFormulaString("#0");
            field.setIsSelector(true);
            field.setIsFilter(true);
            field.setIsSorter(true);
            field.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            PropertyRefInfo ref = new PropertyRefInfo(field, this.getMultiSubEntity(bf.getName(), entity.getName(), query, groupField), entity.getPropertyByName(prop.getName()));
            field.getPropertyRefs().add(ref);
            return field;
        }
        throw new BIMException("The propertyinfo is not a OwnPropertyInfo!");
    }

    private void processJoin(BizFieldInfo bf, LinkPropertyInfo lnkProp, JoinQueryInfo query, BizGroupFieldInfo groupField) throws BIMException {
        if (lnkProp != null) {
            SubEntityInfo left = this.getSubEntity(lnkProp.getRelationship().getClientObject().getName(), query);
            SubEntityInfo right = this.getMultiSubEntity(bf.getName(), lnkProp.getRelationship().getSupplierObject().getName(), query, groupField);
            String leftSubEntityName = left.getName();
            String rightSubEntityName = right.getName();
            try {
                JoinType type = this.getJoinType(lnkProp.getRelationship());
                JoinInfo join = query.getJoinWithEntities(left, right, type, lnkProp);
                left.setName(leftSubEntityName);
                right.setName(rightSubEntityName);
                query.getJoins().add(join);
            }
            catch (BOSException e) {
                throw new BIMException(e);
            }
        } else {
            throw new BIMException("The propertyInfo is not a LinkPropertyInfo!");
        }
    }

    private JoinType getJoinType(RelationshipInfo rel) {
        JoinType type = JoinType.INNERJOIN;
        if (rel.getClientCardinality().equals((Object)CardinalityType.ONE)) {
            if (rel.getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_ONE) || rel.getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) {
                // empty if block
            }
            type = JoinType.LEFTJOIN;
        } else if (rel.getClientCardinality().equals((Object)CardinalityType.ZERO_TO_ONE) || rel.getClientCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) {
            type = JoinType.RIGHTJOIN;
        } else if (rel.getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_ONE)) {
            type = JoinType.LEFTJOIN;
        }
        return type;
    }

    private void processJoin(LinkPropertyInfo lnkProp, JoinQueryInfo query) throws BIMException {
        if (lnkProp != null) {
            SubEntityInfo left = this.getSubEntity(lnkProp.getRelationship().getClientObject().getName(), query);
            SubEntityInfo right = this.getSubEntity(lnkProp.getRelationship().getSupplierObject().getName(), query);
            try {
                JoinInfo join = query.getJoinWithEntities(lnkProp.getRelationship(), left, right);
                query.getJoins().add(join);
            }
            catch (BOSException e) {
                throw new BIMException(e);
            }
        } else {
            throw new BIMException("The propertyInfo is not a LinkPropertyInfo!");
        }
    }

    private void addSubEntityToQuery(BizFieldInfo bf, EntityObjectInfo entity, JoinQueryInfo query, BizGroupFieldInfo groupField) {
        SubEntityInfo subEntity = new SubEntityInfo(query, entity);
        if (BizDataType.OBJECT.equals((Object)bf.getBizDataType()) && bf.getDataSource() != null) {
            if (groupField != null) {
                subEntity.setName(groupField.getName() + "_" + bf.getName());
            } else {
                subEntity.setName(bf.getName());
            }
        }
        boolean isExists = false;
        int n = query.getSubObjects().size();
        for (int i = 0; i < n; ++i) {
            EntityObjectInfo eo;
            SubEntityInfo se;
            if (!(query.getSubObjects().get(i) instanceof SubEntityInfo) || !(se = (SubEntityInfo)query.getSubObjects().get(i)).getName().equals(subEntity.getName()) || !(eo = se.getEntityRef()).getFullName().equals(entity.getFullName())) continue;
            isExists = true;
            break;
        }
        if (!isExists) {
            query.getSubObjects().add(subEntity);
        }
    }

    private void addSubEntityToQuery(BizGroupFieldInfo bf, EntityObjectInfo entity, JoinQueryInfo query) {
        boolean isExists = false;
        int n = query.getSubObjects().size();
        for (int i = 0; i < n; ++i) {
            SubEntityInfo subEntity;
            if (!(query.getSubObjects().get(i) instanceof SubEntityInfo) || !(subEntity = (SubEntityInfo)query.getSubObjects().get(i)).getName().equals(bf.getName()) || !subEntity.getEntityRef().getFullName().equals(entity.getFullName())) continue;
            isExists = true;
            break;
        }
        if (!isExists) {
            SubEntityInfo subEntity = new SubEntityInfo(query, entity);
            subEntity.setName(bf.getName());
            query.getSubObjects().add(subEntity);
        }
    }

    private boolean existSubEntity(String subEntityName, JoinQueryInfo query) {
        try {
            SubEntityInfo subEntity = this.getSubEntity(subEntityName, query);
            return subEntity != null;
        }
        catch (BIMException e) {
            return false;
        }
    }

    private SubEntityInfo getSubEntity(String subEntityName, JoinQueryInfo query) throws BIMException {
        SubObjectInfo obj = null;
        SubEntityInfo subEntity = null;
        SubEntityInfo returnEntity = null;
        int n = query.getSubObjects().size();
        for (int i = 0; i < n; ++i) {
            EntityObjectInfo entity;
            obj = query.getSubObjects().get(i);
            if (!(obj instanceof SubEntityInfo) || !StringUtils.equalsIgnoreCase((String)(entity = (subEntity = (SubEntityInfo)obj).getEntityRef()).getName().trim(), (String)subEntityName.trim())) continue;
            returnEntity = subEntity;
            break;
        }
        if (returnEntity != null) {
            return returnEntity;
        }
        throw new BIMException("Can't found SubEntity: [" + subEntityName + "] in Query :" + query.getPackage() + "." + query.getName());
    }

    private SubEntityInfo getMultiSubEntity(String subEntityName, String entityName, JoinQueryInfo query, BizGroupFieldInfo groupField) throws BIMException {
        SubObjectInfo obj = null;
        SubEntityInfo subEntity = null;
        SubEntityInfo returnEntity = null;
        String subEntityName1 = subEntityName;
        if (groupField != null) {
            subEntityName1 = groupField.getName() + "_" + subEntityName;
        }
        int n = query.getSubObjects().size();
        for (int i = 0; i < n; ++i) {
            obj = query.getSubObjects().get(i);
            if (!(obj instanceof SubEntityInfo)) continue;
            subEntity = (SubEntityInfo)obj;
            EntityObjectInfo entity = subEntity.getEntityRef();
            if (!StringUtils.equalsIgnoreCase((String)subEntity.getName().trim(), (String)subEntityName1.trim()) || !StringUtils.equalsIgnoreCase((String)entity.getName().trim(), (String)entityName.trim())) continue;
            returnEntity = subEntity;
            break;
        }
        if (returnEntity != null) {
            return returnEntity;
        }
        throw new BIMException("Can't found SubEntity: [" + subEntityName + "] in Query :" + query.getPackage() + "." + query.getName());
    }

    private void deleteSubObject(BizFieldInfo bf, PropertyUnitCollection fields, JoinQueryInfo query) throws BIMException {
        boolean isDelete = false;
        String subEntityName = bf.getName();
        try {
            int n = query.getSubObjects().size();
            for (int i = 0; i < n; ++i) {
                String fieldName;
                if (!(query.getSubObjects().get(i) instanceof SubEntityInfo)) continue;
                SubEntityInfo subEntity = (SubEntityInfo)query.getSubObjects().get(i);
                EntityObjectInfo entity = null;
                if (bf instanceof BizGroupFieldInfo) {
                    entity = ((BizGroupFieldInfo)bf).getEntityObject();
                    if (entity == null || !entity.equals(subEntity.getEntityRef())) continue;
                    isDelete = true;
                    subEntityName = subEntity.getName();
                    break;
                }
                if (!bf.getBizDataType().equals((Object)BizDataType.OBJECT) || ObjectStateType.DELETED.equals((Object)bf.getObjectState()) || StringUtils.isEmpty((String)(fieldName = bf.getQueryFieldName())) || !fields.contains(fieldName)) continue;
                isDelete = true;
                subEntityName = fields.get(fieldName).getPropertyRefs().get(0).getSubEntity().getName();
                break;
            }
            if (isDelete) {
                query.removeSubObject(subEntityName);
            }
        }
        catch (BOSException e) {
            throw new BIMException(e);
        }
    }

    private void deletePropertyUnit(BizFieldInfo bf, PropertyUnitCollection propCol, JoinQueryInfo query) throws BIMException {
        if (bf instanceof BizGroupFieldInfo) {
            BizGroupFieldInfo group = (BizGroupFieldInfo)bf;
            int m = group.getFields().size();
            for (int j = 0; j < m; ++j) {
                BizFieldInfo subField = group.getFields().get(j);
                if (subField instanceof BizGroupFieldInfo) {
                    this.deletePropertyUnit(subField, propCol, query);
                    continue;
                }
                if (!BizDataType.OBJECT.equals((Object)subField.getBizDataType()) || subField.getDataSource() == null) continue;
                this.deleteSubObject(subField, propCol, query);
            }
            this.deleteSubObject(bf, propCol, query);
        } else if (bf.getBizDataType() != null && bf.getBizDataType().equals((Object)BizDataType.OBJECT)) {
            this.deleteSubObject(bf, propCol, query);
        } else {
            PropertyUnitInfo prop = null;
            prop = QueryProxy.getPropertyUnitByName(propCol, bf.getQueryFieldName());
            if (prop != null) {
                propCol.remove(prop);
            }
        }
    }

    private String findSubEntityName(EntityObjectInfo entity, JoinQueryInfo query) {
        int n = query.getSubObjects().size();
        for (int i = 0; i < n; ++i) {
            SubEntityInfo subEntity;
            if (!(query.getSubObjects().get(i) instanceof SubEntityInfo) || (subEntity = (SubEntityInfo)query.getSubObjects().get(i)).getEntityRef() == null || !subEntity.getEntityRef().equals(entity)) continue;
            return subEntity.getName();
        }
        return entity.getName();
    }

    private PropertyUnitInfo updateQueryField(BizFieldInfo bf, PropertyUnitInfo field, EntityObjectInfo entity, JoinQueryInfo query, boolean isNew, BizGroupFieldInfo groupField) throws BIMException {
        if (field == null) {
            field = new QueryFieldInfo(query);
            field.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        }
        if (StringUtils.isEmpty((String)field.getName())) {
            String name = QueryProxy.generatePropName(bf, query.getUnits());
            if (this.isMainEntity(entity, query)) {
                field.setName(name);
            } else {
                field.setName(this.findSubEntityName(entity, query) + "." + name);
            }
        }
        if (StringUtils.isEmpty((String)bf.getQueryFieldName())) {
            bf.setQueryFieldName(field.getName());
        }
        ConstDataType type = ConstDataType.STRING;
        if (BizDataType.OBJECT.equals((Object)bf.getBizDataType()) && bf.getDataSource() != null) {
            PropertyInfo prop = bf.getDataSource().getPropertyByName(this.getDisplayName(bf.getDataField()), true);
            if (prop != null && prop instanceof OwnPropertyInfo) {
                type = QueryUtil.getConstDataType(((OwnPropertyInfo)prop).getDataType());
            }
        } else {
            type = QueryProxy.getQueryType(bf.getBizDataType());
            if (bf.getBizDataType() == BizDataType.ENUM && bf.getEnumType() != null) {
                type = QueryProxy.getQueryType(bf.getEnumType().getDataType());
            }
        }
        if (isNew) {
            field.setReturnType(type);
            field.setDisplayName(bf.getAlias());
            if (type == ConstDataType.UNKNOWN) {
                field.setIsSelector(false);
            } else {
                field.setIsSelector(true);
            }
            field.setIsFilter(true);
            field.setIsSorter(true);
            PropertyRefInfo ref = null;
            field.getPropertyRefs().clear();
            if (BizDataType.OBJECT.equals((Object)bf.getBizDataType()) && bf.getDataSource() != null) {
                String[] data = this.parseStrToDisplayField(bf.getDataField());
                ref = new PropertyRefInfo(field, this.getMultiSubEntity(bf.getName(), bf.getDataSource().getName(), query, groupField), bf.getDataSource().getPropertyByName(data[0].trim(), true));
                field.getPropertyRefs().add(ref);
                if (!StringUtils.isEmpty((String)data[1])) {
                    ref = new PropertyRefInfo(field, this.getMultiSubEntity(bf.getName(), bf.getDataSource().getName(), query, groupField), bf.getDataSource().getPropertyByName(data[1].trim(), true));
                    field.getPropertyRefs().add(ref);
                }
                field.setFormulaString(data[2]);
                field.setExtendedProperty("defaultF7Query", "");
                field.setExtendedProperty("displayFormat", "");
                field.setExtendedProperty("editFormat", "");
                field.setExtendedProperty("commitFormat", "");
            } else {
                ref = new PropertyRefInfo(field, this.getSubEntity(entity.getName(), query), entity.getPropertyByName(bf.getPropertyName()));
                field.getPropertyRefs().add(ref);
                field.setFormulaString("#0");
            }
        }
        if ("false".equalsIgnoreCase(bf.getExtendedProperty("isCommonQueryFilter"))) {
            field.setExtendedProperty("isCommonQueryFilter", "false");
        } else {
            field.setExtendedProperty("isCommonQueryFilter", "true");
        }
        if ("false".equalsIgnoreCase(bf.getExtendedProperty("isCommonQuerySorter"))) {
            field.setExtendedProperty("isCommonQuerySorter", "false");
        } else {
            field.setExtendedProperty("isCommonQuerySorter", "true");
        }
        if (bf.isNeedSumInListUI() || !StringUtils.isEmpty((String)field.getExtendedProperty("isSumField"))) {
            if (bf.isNeedSumInListUI()) {
                field.setExtendedProperty("isSumField", "true");
            } else {
                field.setExtendedProperty("isSumField", "false");
            }
        }
        return field;
    }

    private String[] parseStrToDisplayField(String sDisField) {
        String[] data = new String[3];
        StringBuffer formual = new StringBuffer();
        String strFirst = "";
        String strLeft = "";
        String strSecond = "";
        String strRight = "";
        String strTemp = "";
        if (StringUtils.isEmpty((String)sDisField)) {
            return data;
        }
        int iPos = sDisField.indexOf("+");
        if (iPos > 0) {
            data[0] = strFirst = sDisField.substring(0, iPos).trim();
            formual.append("#0");
            strTemp = sDisField.substring(iPos + 2);
            if (sDisField.trim().length() > iPos && strTemp.trim().length() > 0 && (iPos = strTemp.indexOf("+")) > 0) {
                strLeft = strTemp.substring(0, iPos);
                if (!StringUtils.isEmpty((String)(strLeft = strLeft.replaceAll("\"", "")))) {
                    formual.append(" || '" + strLeft + "'");
                }
                if (strTemp.trim().length() > iPos + 1 && (strTemp = strTemp.substring(iPos + 2)).trim().length() > 0 && (iPos = strTemp.indexOf("+")) > 0) {
                    data[1] = strSecond = strTemp.substring(0, iPos);
                    formual.append(" || #1");
                    if (strTemp.length() > iPos + 1) {
                        strRight = strTemp.substring(iPos + 2);
                        if (!StringUtils.isEmpty((String)(strRight = strRight.replaceAll("\"", "")))) {
                            formual.append(" || '" + strRight + "'");
                        }
                    }
                }
            }
            data[2] = this.replaceFormula(formual.toString(), "||", "&");
        } else {
            data[0] = strFirst = sDisField.trim();
            data[2] = "#0";
        }
        return data;
    }

    private String replaceFormula(String formula, String oldKey, String newKey) {
        Lexer lexer = new Lexer(formula);
        StringBuffer buff = new StringBuffer();
        boolean flag = false;
        try {
            while (true) {
                Token token = lexer.next();
                if (token.type != 12) {
                    if (flag) {
                        buff.append(' ');
                    }
                    if (token.type == 4 && token.value.equals(oldKey)) {
                        buff.append(newKey);
                    } else {
                        token.output(buff);
                    }
                    flag = true;
                    continue;
                }
                break;
            }
        }
        catch (ParserException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        return buff.toString();
    }

    private boolean isMainEntity(EntityObjectInfo entity, JoinQueryInfo query) {
        try {
            EntityObjectInfo mainEntity;
            SubObjectInfo subObj = query.getMainObject();
            return subObj instanceof SubEntityInfo && (mainEntity = ((SubEntityInfo)subObj).getEntityRef()) != null && mainEntity.equals(entity);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void checkValid() throws BIMException {
        if (this.joinQuery == null) {
            return;
        }
        ObjectStateType stateType = this.bizUnit.getObjectState();
        if (stateType.equals((Object)ObjectStateType.DELETED) && !this.joinQuery.isUserDefined()) {
            throw new BIMException("can not delete system defined query");
        }
        BizFieldCollection bfCol = this.bizUnit.getFields();
        if (this.joinQuery == null) {
            return;
        }
        PropertyUnitCollection propCol = this.joinQuery.getUnits();
        int n = bfCol.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bf = bfCol.get(i);
            stateType = bf.getObjectState();
            PropertyUnitInfo prop = QueryProxy.getPropertyUnitByName(propCol, bf.getQueryFieldName());
            if (ConvertUtils.isDevMode()) continue;
            if (stateType.equals((Object)ObjectStateType.DELETED)) {
                if (prop == null || prop.isUserDefined()) continue;
                throw new BIMException("can not delete system defined queryfield");
            }
            if (!stateType.equals((Object)ObjectStateType.CHANGED) || prop == null || prop.isUserDefined() || !bf.isPropertyChanged("name")) continue;
            throw new BIMException("can not change system defined queryfield");
        }
    }

    public static ConstDataType getQueryType(BizDataType bizType) {
        ConstDataType queryType = null;
        queryType = bizType.equals((Object)BizDataType.STRING) ? ConstDataType.STRING : (bizType.equals((Object)BizDataType.DATE) ? ConstDataType.DATE : (bizType.equals((Object)BizDataType.DECIMAL) ? ConstDataType.NUMBER : (bizType.equals((Object)BizDataType.INTEGER) ? ConstDataType.INT : (bizType.equals((Object)BizDataType.QUANTITY) ? ConstDataType.NUMBER : (bizType.equals((Object)BizDataType.AMOUNT) ? ConstDataType.NUMBER : (bizType.equals((Object)BizDataType.PRICE) ? ConstDataType.NUMBER : (bizType.equals((Object)BizDataType.NOTE) ? ConstDataType.STRING : (bizType.equals((Object)BizDataType.BOOLEAN) ? ConstDataType.BOOLEAN : (bizType.equals((Object)BizDataType.OBJECT) ? ConstDataType.OBJECT : (bizType.equals((Object)BizDataType.TIME) ? ConstDataType.TIME : ConstDataType.UNKNOWN))))))))));
        return queryType;
    }

    public static String generatePropName(BizFieldInfo bf, PropertyUnitCollection propCol) {
        String name = bf.getName();
        PropertyUnitInfo prop = QueryProxy.getPropertyUnitByName(propCol, name);
        if (prop != null) {
            int i = 0;
            while (prop != null) {
                name = bf.getName() + i++;
                prop = QueryProxy.getPropertyUnitByName(propCol, name);
            }
        }
        return name;
    }

    public static String generateLinkPropName(BizFieldInfo bf, PropertyUnitCollection propCol) {
        String name = bf.getName() + "." + bf.getDataField();
        PropertyUnitInfo prop = QueryProxy.getPropertyUnitByName(propCol, name);
        if (prop != null) {
            int i = 0;
            while (prop != null) {
                name = bf.getName() + i++;
                prop = QueryProxy.getPropertyUnitByName(propCol, name);
            }
        }
        return name;
    }

    public static PropertyUnitInfo getPropertyUnitByName(PropertyUnitCollection propCol, String propName) {
        PropertyUnitInfo prop = null;
        int n = propCol.size();
        for (int i = 0; i < n; ++i) {
            if (!propCol.get(i).getName().equals(propName)) continue;
            prop = propCol.get(i);
            break;
        }
        return prop;
    }

    public static ConstDataType getQueryType(BizEnumValueType enumValueType) {
        if (enumValueType == BizEnumValueType.DOUBLE || enumValueType == BizEnumValueType.LONG || enumValueType == BizEnumValueType.FLOAT) {
            return ConstDataType.NUMBER;
        }
        if (enumValueType == BizEnumValueType.INTEGER) {
            return ConstDataType.INT;
        }
        if (enumValueType == BizEnumValueType.STRING) {
            return ConstDataType.STRING;
        }
        return ConstDataType.UNKNOWN;
    }
}

