/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizunit.proxy;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bizunit.BIMException;
import com.kingdee.bos.metadata.bizunit.BIMNameFactory;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.DataSourceType;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.bizunit.proxy.AbstractProxy;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.FKColumnPairCollection;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyCollection;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;

public class TableExtProxy
extends AbstractProxy
implements Serializable {
    private DataTableInfo dataTable;

    public TableExtProxy(Context ctx, DataTableInfo dataTable) {
        this.dataTable = dataTable;
    }

    @Override
    public void update() throws BIMException {
        if (this.dataTable == null) {
            return;
        }
        BizFieldCollection bfCol = this.bizUnit.getFields();
        ColumnCollection columnCol = this.dataTable.getColumns();
        this.syncColumnsByBizFields(bfCol, columnCol, this.dataTable);
    }

    private void syncColumnsByBizFields(BizFieldCollection bfCol, ColumnCollection columnCol, DataTableInfo tableInfo) throws BIMException {
        int n = bfCol.size();
        for (int i = 0; i < n; ++i) {
            ColumnInfo column;
            BizFieldInfo bf = bfCol.get(i);
            ObjectStateType stateType = bf.getObjectState();
            if (stateType.equals((Object)ObjectStateType.UNCHANGE)) {
                if (!(bf instanceof BizGroupFieldInfo)) continue;
                continue;
            }
            if (stateType.equals((Object)ObjectStateType.NEW)) {
                if (bf instanceof BizGroupFieldInfo || !bf.isPersistence() || DataSourceType.BASEDATAEXT.equals((Object)bf.getDataSourceType()) && !bf.isNeedSave()) continue;
                columnCol.add(this.createColumnByBizField(bf, tableInfo));
                continue;
            }
            if (stateType.equals((Object)ObjectStateType.DELETING)) {
                if (bf instanceof BizGroupFieldInfo || StringUtils.isEmpty((String)bf.getColumnName()) || (column = TableExtProxy.getColumnByName(columnCol, bf.getColumnName())) == null) continue;
                TableExtProxy.removeForeignKey(tableInfo, column);
                columnCol.remove(column);
                continue;
            }
            if (!stateType.equals((Object)ObjectStateType.CHANGED) || bf instanceof BizGroupFieldInfo || !bf.isPersistence() || StringUtils.isEmpty((String)bf.getColumnName()) || (column = TableExtProxy.getColumnByName(columnCol, bf.getColumnName())) == null) continue;
            this.updateColumnByBizField(bf, column);
        }
    }

    private void updateColumnByBizField(BizFieldInfo bf, ColumnInfo column) throws BIMException {
        if (bf.getDataSource() != null && bf.getBizDataType().equals((Object)BizDataType.OBJECT)) {
            EntityObjectInfo relationEntity = bf.getDataSource();
            if (bf.isPropertyChanged("name")) {
                column.setName("F" + StringUtils.headCharUpperCase((String)relationEntity.getName()));
            }
            column.setTypeName(SQLType.VARCHAR);
            column.setLength(44);
        } else {
            String oldName = column.getName();
            if (!("F" + bf.getName()).equalsIgnoreCase(oldName)) {
                String name = TableExtProxy.generateColumnName(bf, this.dataTable.getColumns());
                column.setName(name);
            }
            if (bf.getBizDataType().equals((Object)BizDataType.ENUM)) {
                BizEnumInfo bizenum = bf.getEnumType();
                TableExtProxy.updateColumnByEnum(column, bizenum);
            }
        }
        column.setAlias(bf.getAlias() == null ? "" : bf.getAlias());
        column.setDescription(bf.getDescription() == null ? "" : bf.getDescription());
    }

    private ColumnInfo createColumnByBizField(BizFieldInfo bf, DataTableInfo tableInfo) throws BIMException {
        ColumnInfo column = new ColumnInfo();
        column.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        if (!"id".equalsIgnoreCase(bf.getName())) {
            column.setNullable(true);
        }
        if (bf.getDataSource() != null && bf.getBizDataType().equals((Object)BizDataType.OBJECT)) {
            String name = "F" + StringUtils.headCharUpperCase((String)bf.getName()) + "ID";
            if (name.length() > 18) {
                name = name.substring(0, 18);
            }
            column.setName(name);
            column.setTypeName(SQLType.VARCHAR);
            column.setLength(44);
            DataTableInfo refTable = bf.getDataSource().getTable();
            if (refTable != null && refTable.getPrimaryKey() != null && refTable.getPrimaryKey().getPKColumns().size() == 1) {
                ForeignKeyInfo fk = new ForeignKeyInfo();
                fk.setName(BIMNameFactory.createTableFKName(this.bizUnit.getPackage(), tableInfo.getName(), refTable.getName(), bf.getName(), true));
                fk.setRefTable(refTable);
                FKColumnPairInfo fkColumnPair = new FKColumnPairInfo();
                fkColumnPair.setPrimaryKeyColumn(refTable.getPrimaryKey().getPKColumns().get(0).getColumn());
                fkColumnPair.setForeignKeyColumn(column);
                fk.getFKColumnPairs().add(fkColumnPair);
                tableInfo.getForeignKeys().add(fk);
            }
        } else {
            String name = TableExtProxy.generateColumnName(bf, tableInfo.getColumns());
            column.setName(name);
            if (bf.getBizDataType().equals((Object)BizDataType.ENUM)) {
                BizEnumInfo bizenum = bf.getEnumType();
                TableExtProxy.updateColumnByEnum(column, bizenum);
            } else {
                column.setTypeName(TableExtProxy.getColumnType(bf.getBizDataType()));
                column.setPrecision(bf.getPrecision());
                column.setScale(bf.getScale());
                column.setLength(bf.getLength());
            }
        }
        column.setAlias(bf.getAlias() == null ? "" : bf.getAlias());
        column.setDescription(bf.getDescription() == null ? "" : bf.getDescription());
        return column;
    }

    @Override
    public void checkValid() throws BIMException {
        if (this.dataTable == null) {
            return;
        }
        ObjectStateType stateType = this.bizUnit.getObjectState();
        if (stateType.equals((Object)ObjectStateType.DELETING) && !this.dataTable.isUserDefined()) {
            throw new BIMException("can not delete system defined table");
        }
        BizFieldCollection bfCol = this.bizUnit.getFields();
        ColumnCollection columnCol = this.dataTable.getColumns();
        int n = bfCol.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bf = bfCol.get(i);
            stateType = bf.getObjectState();
            ColumnInfo column = TableExtProxy.getColumnByName(columnCol, bf.getColumnName());
            if (bf.isPersistence()) {
                BizDataType bizDataType = bf.getBizDataType();
                if (bizDataType == null) {
                    throw new BIMException("bizField:" + bf.getName() + " is persistence, but it's bizDataType is null");
                }
                if (bizDataType.equals((Object)BizDataType.LABEL) || bizDataType.equals((Object)BizDataType.PANEL) || bizDataType.equals((Object)BizDataType.TABFOLDER) || bizDataType.equals((Object)BizDataType.BUTTON) || bizDataType.equals((Object)BizDataType.BUTTONGROUP) || bizDataType.equals((Object)BizDataType.RADIOBUTTON) || bizDataType.equals((Object)BizDataType.KDSEPARATOR)) {
                    throw new BIMException("bizField:" + bf.getName() + " is persistence, but has invalid bizDataType " + bizDataType.getName());
                }
            }
            if (stateType.equals((Object)ObjectStateType.DELETING)) {
                if (ConvertUtils.isDevMode() || column == null || column.isUserDefined()) continue;
                throw new BIMException("\u4e0d\u80fd\u5220\u9664\u7cfb\u7edf\u5b9a\u4e49\u7684\u6570\u636e\u8868\u5b57\u6bb5!");
            }
            if (!stateType.equals((Object)ObjectStateType.CHANGED)) continue;
        }
    }

    public static SQLType getColumnType(BizDataType bizType) throws BIMException {
        SQLType sqlType = null;
        if (bizType.equals((Object)BizDataType.STRING)) {
            sqlType = SQLType.NVARCHAR;
        } else if (bizType.equals((Object)BizDataType.DATE)) {
            sqlType = SQLType.DATETIME;
        } else if (bizType.equals((Object)BizDataType.DECIMAL)) {
            sqlType = SQLType.NUMERIC;
        } else if (bizType.equals((Object)BizDataType.INTEGER)) {
            sqlType = SQLType.INT;
        } else if (bizType.equals((Object)BizDataType.QUANTITY)) {
            sqlType = SQLType.NUMERIC;
        } else if (bizType.equals((Object)BizDataType.AMOUNT)) {
            sqlType = SQLType.NUMERIC;
        } else if (bizType.equals((Object)BizDataType.PRICE)) {
            sqlType = SQLType.NUMERIC;
        } else if (bizType.equals((Object)BizDataType.NOTE)) {
            sqlType = SQLType.NVARCHAR;
        } else if (bizType.equals((Object)BizDataType.BOOLEAN)) {
            sqlType = SQLType.INT;
        } else if (bizType.equals((Object)BizDataType.TIME)) {
            sqlType = SQLType.DATETIME;
        } else if (bizType.equals((Object)BizDataType.IMAGE)) {
            sqlType = SQLType.BLOB;
        } else if (bizType.equals((Object)BizDataType.ENUM)) {
            sqlType = SQLType.NVARCHAR;
        } else {
            throw new BIMException("unknow bizType");
        }
        return sqlType;
    }

    public static void updateColumnByEnum(ColumnInfo column, BizEnumInfo bizenum) throws BIMException {
        BizEnumValueType enumType = bizenum.getDataType();
        SQLType sqlType = null;
        if (enumType.equals((Object)BizEnumValueType.STRING)) {
            sqlType = SQLType.VARCHAR;
            column.setTypeName(sqlType);
            column.setLength(100);
        } else if (enumType.equals((Object)BizEnumValueType.INTEGER)) {
            sqlType = SQLType.INT;
            column.setTypeName(sqlType);
        } else if (enumType.equals((Object)BizEnumValueType.DOUBLE)) {
            sqlType = SQLType.NUMERIC;
            column.setTypeName(sqlType);
        } else if (enumType.equals((Object)BizEnumValueType.FLOAT)) {
            sqlType = SQLType.NUMERIC;
            column.setTypeName(sqlType);
        } else if (enumType.equals((Object)BizEnumValueType.LONG)) {
            sqlType = SQLType.NUMERIC;
            column.setTypeName(sqlType);
        } else {
            throw new BIMException("unknow enumType");
        }
    }

    public static String generateColumnName(BizFieldInfo bf, ColumnCollection columnCol) {
        String name = bf.getName();
        name = StringUtils.headCharUpperCase((String)name);
        name = "F" + name;
        ColumnInfo column = TableExtProxy.getColumnByName(columnCol, name);
        if (column != null) {
            int i = 0;
            while (column != null) {
                name = "F" + StringUtils.headCharUpperCase((String)name) + i++;
                column = TableExtProxy.getColumnByName(columnCol, name);
            }
        }
        return name;
    }

    public static ColumnInfo getColumnByName(ColumnCollection columnCol, String name) {
        ColumnInfo column = null;
        int n = columnCol.size();
        for (int i = 0; i < n; ++i) {
            if (!columnCol.get(i).getName().equalsIgnoreCase(name)) continue;
            column = columnCol.get(i);
            break;
        }
        return column;
    }

    private static void removeForeignKey(DataTableInfo table, ColumnInfo column) {
        if (StringUtils.isEmpty((String)column.getName())) {
            return;
        }
        ForeignKeyCollection fkCol = table.getForeignKeys();
        block0: for (int i = fkCol.size() - 1; i >= 0; --i) {
            FKColumnPairCollection fkColumnPairCol = fkCol.get(i).getFKColumnPairs();
            int m = fkColumnPairCol.size();
            for (int j = 0; j < m; ++j) {
                if (!column.getName().equalsIgnoreCase(fkColumnPairCol.get(j).getForeignKeyColumn().getName())) continue;
                fkCol.removeObject(i);
                continue block0;
            }
        }
    }
}

