/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizunit.proxy;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataOptions;
import com.kingdee.bos.metadata.bizunit.BIMException;
import com.kingdee.bos.metadata.bizunit.BIMNameFactory;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.DataSourceType;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.bizunit.proxy.AbstractProxy;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.FKColumnPairCollection;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyCollection;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.PKColumnInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class TableProxy
extends AbstractProxy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(TableProxy.class);
    private DataTableInfo dataTable;

    public TableProxy(Context ctx, DataTableInfo dataTable) {
        this.dataTable = dataTable;
    }

    @Override
    public void update() throws BIMException {
        if (this.dataTable == null) {
            return;
        }
        if (this.bizUnit.getObjectState().equals((Object)ObjectStateType.CHANGED)) {
            this.dataTable.setAlias(this.bizUnit.getAlias() == null ? "" : this.bizUnit.getAlias());
            this.dataTable.setDescription(this.bizUnit.getDescription() == null ? "" : this.bizUnit.getDescription());
        }
        BizFieldCollection bfCol = this.bizUnit.getFields();
        ColumnCollection columnCol = this.dataTable.getColumns();
        this.syncColumnsByBizFields(bfCol, columnCol, this.dataTable);
    }

    private void syncColumnsByBizFields(BizFieldCollection bfCol, ColumnCollection columnCol, DataTableInfo tableInfo) throws BIMException {
        int n = bfCol.size();
        for (int i = 0; i < n; ++i) {
            ColumnInfo column;
            BizFieldInfo bf = bfCol.get(i);
            ObjectStateType stateType = bf.getObjectState();
            if (stateType.equals((Object)ObjectStateType.UNCHANGE)) {
                if (!(bf instanceof BizGroupFieldInfo)) continue;
                BizGroupFieldInfo group = (BizGroupFieldInfo)bf;
                this.updateEntryTable(group, tableInfo);
                continue;
            }
            if (stateType.equals((Object)ObjectStateType.NEW)) {
                if (bf instanceof BizGroupFieldInfo) {
                    this.createEntryTable((BizGroupFieldInfo)bf, tableInfo);
                    continue;
                }
                if (!bf.isPersistence() || DataSourceType.BASEDATAEXT.equals((Object)bf.getDataSourceType()) && !bf.isNeedSave()) continue;
                columnCol.add(this.createColumnByBizField(bf, tableInfo));
                continue;
            }
            if (stateType.equals((Object)ObjectStateType.DELETING)) {
                if (bf instanceof BizGroupFieldInfo) {
                    BizGroupFieldInfo groupField = (BizGroupFieldInfo)bf;
                    int m = groupField.getFields().size();
                    for (int j = 0; j < m; ++j) {
                        if (!(groupField.getFields().get(j) instanceof BizGroupFieldInfo)) continue;
                        groupField.getFields().get(j).setObjectState(ObjectStateType.DELETING);
                    }
                    if (groupField.getEntityObject() == null || groupField.getEntityObject().getTable() == null) continue;
                    DataTableInfo subTable = groupField.getEntityObject().getTable();
                    this.syncColumnsByBizFields(groupField.getFields(), subTable.getColumns(), subTable);
                    continue;
                }
                if (StringUtils.isEmpty((String)bf.getColumnName()) || (column = TableProxy.getColumnByName(columnCol, bf.getColumnName())) == null) continue;
                TableProxy.removeForeignKey(tableInfo, column);
                columnCol.remove(column);
                continue;
            }
            if (!stateType.equals((Object)ObjectStateType.CHANGED)) continue;
            if (bf instanceof BizGroupFieldInfo) {
                this.updateEntryTable((BizGroupFieldInfo)bf, tableInfo);
                continue;
            }
            if (!bf.isPersistence() || StringUtils.isEmpty((String)bf.getColumnName()) || (column = TableProxy.getColumnByName(columnCol, bf.getColumnName())) == null) continue;
            this.updateColumnByBizField(bf, column);
        }
    }

    private void updateColumnByBizField(BizFieldInfo bf, ColumnInfo column) throws BIMException {
        if ((bf.getDataSource() == null || !bf.getBizDataType().equals((Object)BizDataType.OBJECT)) && bf.getBizDataType().equals((Object)BizDataType.ENUM)) {
            BizEnumInfo bizenum = bf.getEnumType();
            TableProxy.updateColumnByEnum(column, bizenum);
        }
        column.setAlias(bf.getAlias() == null ? "" : bf.getAlias());
        column.setDescription(bf.getDescription() == null ? "" : bf.getDescription());
        bf.setColumnName(column.getName());
    }

    private ColumnInfo createColumnByBizField(BizFieldInfo bf, DataTableInfo tableInfo) throws BIMException {
        ColumnInfo column = new ColumnInfo();
        column.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        if (!"id".equalsIgnoreCase(bf.getName())) {
            column.setNullable(true);
        }
        if (bf.getDataSource() != null && bf.getBizDataType().equals((Object)BizDataType.OBJECT)) {
            String name = (MetaDataOptions.isDevelopVersion() ? "F" : "CF") + StringUtils.headCharUpperCase((String)bf.getName()) + "ID";
            if (name.length() > 18) {
                name = name.substring(0, 18);
            }
            column.setName(name);
            column.setTypeName(SQLType.VARCHAR);
            column.setLength(44);
            DataTableInfo refTable = bf.getDataSource().getTable();
            if (refTable != null && refTable.getPrimaryKey() != null && refTable.getPrimaryKey().getPKColumns().size() == 1) {
                ForeignKeyInfo fk = new ForeignKeyInfo();
                fk.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
                fk.setName(BIMNameFactory.createTableFKName(this.bizUnit.getPackage(), tableInfo.getName(), refTable.getName(), bf.getName(), true));
                fk.setRefTable(refTable);
                FKColumnPairInfo fkColumnPair = new FKColumnPairInfo();
                fkColumnPair.setPrimaryKeyColumn(refTable.getPrimaryKey().getPKColumns().get(0).getColumn());
                fkColumnPair.setForeignKeyColumn(column);
                fk.getFKColumnPairs().add(fkColumnPair);
                tableInfo.getForeignKeys().add(fk);
            }
        } else {
            String name = TableProxy.generateColumnName(bf, tableInfo.getColumns());
            column.setName(name);
            if (bf.getBizDataType().equals((Object)BizDataType.ENUM)) {
                BizEnumInfo bizenum = bf.getEnumType();
                TableProxy.updateColumnByEnum(column, bizenum);
            } else {
                column.setTypeName(TableProxy.getColumnType(bf.getBizDataType()));
                column.setPrecision(bf.getPrecision());
                column.setScale(bf.getScale());
                column.setLength(bf.getLength());
            }
        }
        column.setAlias(bf.getAlias() == null ? "" : bf.getAlias());
        column.setDescription(bf.getDescription() == null ? "" : bf.getDescription());
        bf.setColumnName(column.getName());
        return column;
    }

    private DataTableInfo createEntryTable(BizGroupFieldInfo group, DataTableInfo parent) throws BIMException {
        String idName = "FID";
        String seqName = "FSeq";
        String parentName = "FParentID";
        DataTableInfo entry = new DataTableInfo();
        entry.setPackage(this.bizUnit.getEntity().getPackage());
        entry.setAlias(group.getAlias() == null ? "" : group.getAlias());
        entry.setDescription(group.getDescription() == null ? "" : group.getDescription());
        String name = parent.getName().toUpperCase();
        name = BIMNameFactory.createEntryTableName(this.bizUnit.getEntity().getPackage(), this.bizUnit.getName(), this.bizUnit.getName() + group.getName());
        entry.setName(name);
        entry.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        ColumnInfo fid = new ColumnInfo();
        fid.setName(idName);
        fid.setTypeName(SQLType.VARCHAR);
        fid.setLength(44);
        fid.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        entry.getColumns().add(fid);
        ColumnInfo fseq = new ColumnInfo();
        fseq.setName(seqName);
        fseq.setTypeName(SQLType.INT);
        fseq.setLength(4);
        fseq.setScale(0);
        fseq.setPrecision(4);
        fseq.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        entry.getColumns().add(fseq);
        ColumnInfo fparentId = new ColumnInfo();
        fparentId.setName(parentName);
        fparentId.setTypeName(SQLType.VARCHAR);
        fparentId.setLength(44);
        fparentId.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        entry.getColumns().add(fparentId);
        PrimaryKeyInfo pk = new PrimaryKeyInfo();
        String packageName = entry.getPackage() == null ? "" : entry.getPackage();
        String[] splitArray = StringUtils.split((String)packageName, (String)".");
        if (splitArray.length != 0) {
            packageName = splitArray[splitArray.length - 1];
        }
        String pkName = BIMNameFactory.createTablePKName(entry.getPackage(), name, idName, true);
        pk.setName(StringUtils.replace((String)pkName, (String)".", (String)"_"));
        PKColumnInfo pkColumn = new PKColumnInfo();
        pkColumn.setColumn(fid);
        pk.getPKColumns().add(pkColumn);
        entry.setPrimaryKey(pk);
        this.syncColumnsByBizFields(group.getFields(), entry.getColumns(), entry);
        group.setTableObject(entry);
        return entry;
    }

    private void updateEntryTable(BizGroupFieldInfo group, DataTableInfo parent) throws BIMException {
        DataTableInfo entry = group.getTableObject();
        if (entry == null) {
            return;
        }
        entry.setAlias(group.getAlias() == null ? "" : group.getAlias());
        entry.setDescription(group.getDescription() == null ? "" : group.getDescription());
        this.syncColumnsByBizFields(group.getFields(), entry.getColumns(), entry);
    }

    @Override
    public void checkValid() throws BIMException {
        if (this.dataTable == null) {
            return;
        }
        ObjectStateType stateType = this.bizUnit.getObjectState();
        if (stateType.equals((Object)ObjectStateType.DELETING) && !this.dataTable.isUserDefined()) {
            throw new BIMException("can not delete system defined table");
        }
        BizFieldCollection bfCol = this.bizUnit.getFields();
        ColumnCollection columnCol = this.dataTable.getColumns();
        int n = bfCol.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bf = bfCol.get(i);
            stateType = bf.getObjectState();
            ColumnInfo column = TableProxy.getColumnByName(columnCol, bf.getColumnName());
            if (bf.isPersistence()) {
                BizDataType bizDataType = bf.getBizDataType();
                if (bizDataType == null) {
                    throw new BIMException("bizField:" + bf.getName() + " is persistence, but it's bizDataType is null");
                }
                if (bizDataType.equals((Object)BizDataType.LABEL) || bizDataType.equals((Object)BizDataType.PANEL) || bizDataType.equals((Object)BizDataType.TABFOLDER) || bizDataType.equals((Object)BizDataType.BUTTON) || bizDataType.equals((Object)BizDataType.BUTTONGROUP) || bizDataType.equals((Object)BizDataType.RADIOBUTTON) || bizDataType.equals((Object)BizDataType.KDSEPARATOR)) {
                    throw new BIMException("bizField:" + bf.getName() + " is persistence, but has invalid bizDataType " + bizDataType.getName());
                }
            }
            if (stateType.equals((Object)ObjectStateType.DELETING)) {
                if (ConvertUtils.isDevMode() || column == null || column.isUserDefined()) continue;
                throw new BIMException("\u4e0d\u80fd\u5220\u9664\u7cfb\u7edf\u5b9a\u4e49\u7684\u6570\u636e\u8868\u5b57\u6bb5!");
            }
            if (!stateType.equals((Object)ObjectStateType.CHANGED)) continue;
        }
    }

    public static SQLType getColumnType(BizDataType bizType) throws BIMException {
        SQLType sqlType = null;
        if (bizType.equals((Object)BizDataType.STRING)) {
            sqlType = SQLType.NVARCHAR;
        } else if (bizType.equals((Object)BizDataType.DATE)) {
            sqlType = SQLType.DATETIME;
        } else if (bizType.equals((Object)BizDataType.DECIMAL)) {
            sqlType = SQLType.NUMERIC;
        } else if (bizType.equals((Object)BizDataType.INTEGER)) {
            sqlType = SQLType.INT;
        } else if (bizType.equals((Object)BizDataType.QUANTITY)) {
            sqlType = SQLType.NUMERIC;
        } else if (bizType.equals((Object)BizDataType.AMOUNT)) {
            sqlType = SQLType.NUMERIC;
        } else if (bizType.equals((Object)BizDataType.PRICE)) {
            sqlType = SQLType.NUMERIC;
        } else if (bizType.equals((Object)BizDataType.NOTE)) {
            sqlType = SQLType.NVARCHAR;
        } else if (bizType.equals((Object)BizDataType.BOOLEAN)) {
            sqlType = SQLType.INT;
        } else if (bizType.equals((Object)BizDataType.TIME)) {
            sqlType = SQLType.DATETIME;
        } else if (bizType.equals((Object)BizDataType.IMAGE)) {
            sqlType = SQLType.BLOB;
        } else if (bizType.equals((Object)BizDataType.ENUM)) {
            sqlType = SQLType.NVARCHAR;
        } else {
            sqlType = SQLType.NVARCHAR;
            Exception ex = new Exception("\u672a\u77e5\u7684\u4e1a\u52a1\u7c7b\u578b\uff1a" + sqlType);
            logger.error((Object)ex, (Throwable)ex);
        }
        return sqlType;
    }

    public static void updateColumnByEnum(ColumnInfo column, BizEnumInfo bizenum) throws BIMException {
        BizEnumValueType enumType = bizenum.getDataType();
        SQLType sqlType = null;
        if (enumType.equals((Object)BizEnumValueType.STRING)) {
            sqlType = SQLType.VARCHAR;
            column.setTypeName(sqlType);
            column.setLength(100);
        } else if (enumType.equals((Object)BizEnumValueType.INTEGER)) {
            sqlType = SQLType.INT;
            column.setTypeName(sqlType);
        } else if (enumType.equals((Object)BizEnumValueType.DOUBLE)) {
            sqlType = SQLType.NUMERIC;
            column.setTypeName(sqlType);
        } else if (enumType.equals((Object)BizEnumValueType.FLOAT)) {
            sqlType = SQLType.NUMERIC;
            column.setTypeName(sqlType);
        } else if (enumType.equals((Object)BizEnumValueType.LONG)) {
            sqlType = SQLType.NUMERIC;
            column.setTypeName(sqlType);
        } else {
            throw new BIMException("unknow enumType");
        }
    }

    public static String generateColumnName(BizFieldInfo bf, ColumnCollection columnCol) {
        String prefix = MetaDataOptions.isDevelopVersion() ? "F" : "CF";
        String name = bf.getName();
        name = StringUtils.headCharUpperCase((String)name);
        name = prefix + name;
        ColumnInfo column = TableProxy.getColumnByName(columnCol, name);
        if (column != null) {
            int i = 0;
            while (column != null) {
                name = prefix + StringUtils.headCharUpperCase((String)name) + i++;
                column = TableProxy.getColumnByName(columnCol, name);
            }
        }
        return name;
    }

    public static ColumnInfo getColumnByName(ColumnCollection columnCol, String name) {
        ColumnInfo column = null;
        int n = columnCol.size();
        for (int i = 0; i < n; ++i) {
            if (!columnCol.get(i).getName().equalsIgnoreCase(name)) continue;
            column = columnCol.get(i);
            break;
        }
        return column;
    }

    private static void removeForeignKey(DataTableInfo table, ColumnInfo column) {
        if (StringUtils.isEmpty((String)column.getName())) {
            return;
        }
        ForeignKeyCollection fkCol = table.getForeignKeys();
        block0: for (int i = fkCol.size() - 1; i >= 0; --i) {
            FKColumnPairCollection fkColumnPairCol = fkCol.get(i).getFKColumnPairs();
            int m = fkColumnPairCol.size();
            for (int j = 0; j < m; ++j) {
                if (!column.getName().equalsIgnoreCase(fkColumnPairCol.get(j).getForeignKeyColumn().getName())) continue;
                fkCol.removeObject(i);
                continue block0;
            }
        }
    }
}

