/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.DeployException;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.IEntityObjectCtrl;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.metadata.resource.IBizEnumCtrl;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class TypeReference {
    private static Logger logger = Logger.getLogger(TypeReference.class);
    public static final String VOID = "void";
    public String metaDataRef = null;
    private BizEnumValueType enumtype = null;
    private BizEnumInfo enumInfo = null;
    private boolean isenumtype = false;
    private String baseType;
    private TypeReference arrayElementType;
    private int arrayDimension;
    private boolean isvoid = false;

    public static TypeReference getReturnType(BusinessObjectInfo bo, MethodInfo method) {
        return TypeReference.getTypeReference(bo, method.getDataType(), method.getMetaDataRef());
    }

    public static TypeReference getParameterType(BusinessObjectInfo bo, ParameterInfo param) {
        return TypeReference.getTypeReference(bo, param.getDataType(), param.getMetaDataRef());
    }

    private static TypeReference getTypeReference(BusinessObjectInfo bo, String dataType, String metaDataRef) {
        DataType dt;
        if (bo instanceof EntityObjectInfo && (metaDataRef == null || bo.getFullName().equals(metaDataRef)) && (dt = DataType.getEnum(dataType)) != null) {
            if (dt.equals(DataType.OBJECTVALUE)) {
                return new TypeReference(((EntityObjectInfo)bo).getObjectValueClass());
            }
            if (dt.equals(DataType.OBJECTCOLLECTION)) {
                return new TypeReference(((EntityObjectInfo)bo).getObjectCollectionClass());
            }
        }
        return new TypeReference(dataType, metaDataRef);
    }

    public TypeReference(String typeName, String ref) {
        this.setTypeNameRef(typeName, ref);
    }

    public TypeReference(String typeName) {
        this(typeName, "");
    }

    public TypeReference(TypeReference arrayType, int dimension) {
        this.baseType = "";
        this.arrayDimension = dimension;
        this.arrayElementType = arrayType;
    }

    private void getElementTypeName(String typeName) {
        int count = 0;
        String className = "";
        for (int i = 0; i < typeName.length(); ++i) {
            if (typeName.charAt(i) == '[') {
                ++count;
                continue;
            }
            className = className + typeName.charAt(i);
        }
        if (className.length() == 1) {
            switch (className.toCharArray()[0]) {
                case 'B': {
                    className = "byte";
                    break;
                }
                case 'C': {
                    className = "char";
                    break;
                }
                case 'D': {
                    className = "double";
                    break;
                }
                case 'F': {
                    className = "float";
                    break;
                }
                case 'I': {
                    className = "int";
                    break;
                }
                case 'J': {
                    className = "long";
                    break;
                }
                case 'S': {
                    className = "short";
                    break;
                }
                case 'Z': {
                    className = "boolean";
                    break;
                }
                case 'V': {
                    className = VOID;
                    break;
                }
                default: {
                    className = "";
                    break;
                }
            }
        } else {
            className = className.substring(count);
        }
        this.arrayDimension = count;
        this.arrayElementType = new TypeReference(className);
    }

    public TypeReference(Class type) {
        if (type.isArray()) {
            this.getElementTypeName(type.getName());
            this.baseType = "";
        } else {
            this.baseType = type.getName();
            this.arrayElementType = null;
            this.arrayDimension = 0;
        }
    }

    public TypeReference(String baseType, int dimension) {
        this.baseType = "";
        this.arrayDimension = dimension;
        this.arrayElementType = new TypeReference(baseType);
    }

    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public TypeReference getArrayElementType() {
        return this.arrayElementType;
    }

    public void setArrayElementType(TypeReference arrayElementType) {
        this.arrayElementType = arrayElementType;
    }

    public int getArrayDimension() {
        return this.arrayDimension;
    }

    public void setArrayDimension(int arrayDimension) {
        this.arrayDimension = arrayDimension;
    }

    public String toString() {
        String ts = this.baseType;
        if ("String".equalsIgnoreCase(ts)) {
            ts = "java.lang.String";
        }
        if (this.arrayDimension != 0) {
            ts = this.arrayElementType.baseType;
            for (int i = 1; i <= this.arrayDimension; ++i) {
                ts = ts + "[]";
            }
        }
        return ts;
    }

    public boolean isSimpleType() {
        if (this.arrayDimension == 0) {
            return this.simpleCompare(this.baseType);
        }
        return this.simpleCompare(this.arrayElementType.baseType);
    }

    public boolean isObjectValueType() {
        try {
            if (this.arrayDimension == 0) {
                return AbstractObjectValue.class.isAssignableFrom(Class.forName(this.baseType));
            }
            return AbstractObjectValue.class.isAssignableFrom(Class.forName(this.arrayElementType.baseType));
        }
        catch (Exception err) {
            return false;
        }
    }

    public BizEnumValueType getEnumValueType() {
        return this.enumtype;
    }

    public BizEnumInfo getEnumInfo() {
        return this.enumInfo;
    }

    public boolean isBizEnumType() {
        return this.isenumtype;
    }

    public boolean isVoidType() {
        return this.isvoid;
    }

    private boolean simpleCompare(String type) {
        return type.equals("byte") || type.equals("char") || type.equals("double") || type.equals("float") || type.equals("int") || type.equals("long") || type.equals("short") || type.equals("boolean");
    }

    private EntityObjectInfo getEntityObject(String fullName) throws DeployException, BOSException {
        return (EntityObjectInfo)this.get(MetaDataTypeList.ENTITY, fullName);
    }

    private BizEnumInfo getBizEnum(String fullName) throws DeployException, BOSException {
        return (BizEnumInfo)this.get(MetaDataTypeList.BIZENUM, fullName);
    }

    protected IObjectValue get(BOSObjectType bosType, String fullName) throws DeployException, BOSException {
        MetaDataPK pk = MetaDataPK.create(MetaDataUtils.getPackageName(fullName), MetaDataUtils.getClassName(fullName));
        if (bosType.equals((Object)MetaDataTypeList.BIZENUM)) {
            IBizEnumCtrl bizEnumCtrl = (IBizEnumCtrl)BOSObjectFactory.createBOSObject(ContextManager.getContext(), MetaDataTypeList.BIZENUM);
            return bizEnumCtrl.getValue(pk);
        }
        if (bosType.equals((Object)MetaDataTypeList.ENTITY)) {
            IEntityObjectCtrl enCtrl = (IEntityObjectCtrl)BOSObjectFactory.createBOSObject(ContextManager.getContext(), MetaDataTypeList.ENTITY);
            return enCtrl.getValue(pk);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TypeReference)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        TypeReference ref = (TypeReference)obj;
        return ref.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    TypeReference() {
    }

    protected void setTypeNameRef(String typeName, String ref) {
        boolean flag;
        DataType type;
        this.metaDataRef = ref;
        if (typeName == null || typeName.length() == 0) {
            typeName = Void.TYPE.getName();
        }
        if ((type = DataType.getEnum(typeName)) != null) {
            if (!StringUtils.isEmpty((String)this.metaDataRef)) {
                EntityObjectInfo entity;
                String temp = this.metaDataRef;
                if (type.equals(DataType.ENUM)) {
                    try {
                        BizEnumInfo bizEnumInfo = this.getBizEnum(temp);
                        this.isenumtype = true;
                        this.enumtype = bizEnumInfo.getDataType();
                        this.enumInfo = bizEnumInfo;
                        typeName = bizEnumInfo.getClassName();
                    }
                    catch (BOSException e) {
                        logger.error((Object)e, (Throwable)e);
                        typeName = "";
                    }
                } else if (type.equals(DataType.OBJECTVALUE)) {
                    try {
                        entity = null;
                        entity = this.getEntityObject(temp);
                        typeName = entity.getObjectValueClass();
                    }
                    catch (BOSException e) {
                        logger.error((Object)e, (Throwable)e);
                        typeName = "";
                    }
                } else if (type.equals(DataType.OBJECTCOLLECTION)) {
                    try {
                        entity = null;
                        entity = this.getEntityObject(temp);
                        typeName = entity.getObjectCollectionClass();
                    }
                    catch (BOSException e) {
                        logger.error((Object)e, (Throwable)e);
                        typeName = "";
                    }
                }
            } else {
                typeName = type.getJavaTypeName();
            }
        } else if (typeName.equals(VOID)) {
            typeName = VOID;
            this.isvoid = true;
        } else {
            typeName = typeName.trim();
            this.isvoid = false;
        }
        int left = typeName.indexOf(91);
        int right = typeName.lastIndexOf(93);
        boolean bl = left < 0 || right != typeName.length() - 1 ? false : (flag = left < right);
        if (flag) {
            this.baseType = null;
            int count = 0;
            for (int i = 0; i < typeName.length(); ++i) {
                if (typeName.charAt(i) != '[') continue;
                ++count;
            }
            this.arrayDimension = count;
            this.arrayElementType = new TypeReference(typeName.substring(0, left));
        } else {
            this.baseType = typeName;
            this.arrayDimension = 0;
            this.arrayElementType = null;
        }
    }
}

