/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bo;

import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.metadata.bo.TypeReferenceRuntime;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;

public class TypeReferenceFactory {
    private final MDHostType host;
    private final Project.Projects projects;

    public static TypeReferenceFactory getInstance(MDHostType host) {
        return new TypeReferenceFactory(host);
    }

    public static TypeReferenceFactory getInstance(Project.Projects projects) {
        return new TypeReferenceFactory(projects);
    }

    private TypeReferenceFactory(MDHostType host) {
        this.host = host;
        this.projects = null;
    }

    private TypeReferenceFactory(Project.Projects projects) {
        this.host = MDHostType.RUNTIME;
        this.projects = projects;
    }

    public TypeReference getReturnType(BusinessObjectInfo bo, MethodInfo method) {
        return this.getTypeReference(bo, method.getDataType(), method.getMetaDataRef());
    }

    public TypeReference getParameterType(BusinessObjectInfo bo, ParameterInfo param) {
        return this.getTypeReference(bo, param.getDataType(), param.getMetaDataRef());
    }

    private TypeReference getTypeReference(BusinessObjectInfo bo, String dataType, String metaDataRef) {
        DataType dt;
        if (bo instanceof EntityObjectInfo && (metaDataRef == null || bo.getFullName().equals(metaDataRef)) && (dt = DataType.getEnum(dataType)) != null) {
            if (dt.equals(DataType.OBJECTVALUE)) {
                return this.createTypeReference(((EntityObjectInfo)bo).getObjectValueClass());
            }
            if (dt.equals(DataType.OBJECTCOLLECTION)) {
                return this.createTypeReference(((EntityObjectInfo)bo).getObjectCollectionClass());
            }
        }
        return this.createTypeReference(dataType, metaDataRef);
    }

    public TypeReference createTypeReference(String typeName, String ref) {
        if (MDHostType.DESIGN.equals(this.host)) {
            return new TypeReference(typeName, ref);
        }
        TypeReferenceRuntime tp = this.projects != null ? new TypeReferenceRuntime(typeName, ref, this.projects) : new TypeReferenceRuntime(typeName, ref);
        return tp;
    }

    public TypeReference createTypeReference(String typeName) {
        if (MDHostType.DESIGN.equals(this.host)) {
            return new TypeReference(typeName);
        }
        TypeReferenceRuntime tp = new TypeReferenceRuntime(typeName);
        if (this.projects != null) {
            tp.setProjects(this.projects);
        }
        return tp;
    }

    public TypeReference createTypeReference(Class type) {
        if (MDHostType.DESIGN.equals(this.host)) {
            return new TypeReference(type);
        }
        TypeReferenceRuntime tp = new TypeReferenceRuntime(type);
        if (this.projects != null) {
            tp.setProjects(this.projects);
        }
        return tp;
    }
}

