/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.clientprefetch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.xml.impl.MDLoader;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.clientprefetch.Message;
import com.kingdee.bos.metadata.clientprefetch.Prefetcher;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import org.apache.log4j.Logger;

public class PreLoader
implements Prefetcher.Loader {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.clientprefetch.PreLoader");

    @Override
    public void load(Message message) {
        MetaDataPK2 pk2 = new MetaDataPK2(message.pk);
        AbstractMetaDataValue m = MDLoader.getInstance().preFetchMD(pk2);
        if (m instanceof EntityObjectInfo) {
            EntityObjectInfo entity = (EntityObjectInfo)m;
            this.loadEntity(entity);
        } else if (m instanceof QueryInfo) {
            QueryInfo query = (QueryInfo)m;
            this.loadQuery(query);
        }
        m.getStateManager().getStateValue("alias");
    }

    private void loadEntity(EntityObjectInfo entity) {
        entity.getProperties();
        entity.getExtendedProperties();
    }

    private void loadQuery(QueryInfo query) {
        query.getQueryPK();
        query.getExtendedProperties();
        try {
            SubObjectInfo sub = query.getMainObject();
            if (sub instanceof SubEntityInfo) {
                SubEntityInfo subEntity = (SubEntityInfo)sub;
                this.loadEntity(subEntity.getEntityRef());
            } else if (sub instanceof SubQueryInfo) {
                SubQueryInfo subQuery = (SubQueryInfo)sub;
                this.loadQuery(subQuery.getQueryRef());
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }
}

