/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.clientprefetch;

import com.kingdee.bos.metadata.clientprefetch.Message;
import com.kingdee.bos.metadata.clientprefetch.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class Prefetcher {
    private static final Logger logger = Logger.getLogger(Prefetcher.class);
    Reader reader;
    private int threadCount;
    ExecutorService threadPool;
    Loader loader;
    private final Object lock = new Object();
    private List<Message> messages;

    Prefetcher(Reader reader, Loader loader, int threadCount) {
        this.reader = reader;
        this.threadCount = threadCount;
        this.loader = loader;
    }

    public List<Message> getMessages() {
        if (this.messages == null) {
            this.messages = Collections.emptyList();
        }
        return this.messages;
    }

    private void safeReturn() {
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.reader.isInitialized()) {
            return;
        }
        this.threadPool = Executors.newFixedThreadPool(this.threadCount);
        Callback callback = new Callback();
        this.threadPool.execute(this.getReaderRunnable(callback));
        while (this.messages == null) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.wait(1000L);
                }
            }
            catch (Throwable e) {
                this.safeReturn();
                return;
            }
        }
        if (this.messages.isEmpty()) {
            this.safeReturn();
            return;
        }
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
        for (Message message : this.messages) {
            tasks.add(Executors.callable(this.getRunnable(message)));
        }
        try {
            List futures = this.threadPool.invokeAll(tasks);
            Iterator iterator = this.lock;
            synchronized (iterator) {
                this.lock.wait(1000L);
            }
            for (Future future : futures) {
                if (!future.isDone() && future.isCancelled()) continue;
            }
        }
        catch (InterruptedException e) {
            logger.info((Object)"Error on prefetcher thread.", (Throwable)e);
        }
        this.safeReturn();
    }

    private Runnable getReaderRunnable(final Callback callback) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                callback.setResult(Prefetcher.this.reader.getMessages());
                Object object = Prefetcher.this.lock;
                synchronized (object) {
                    Prefetcher.this.lock.notifyAll();
                }
            }
        };
    }

    private Runnable getRunnable(final Message message) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Prefetcher.this.loader.load(message);
                Object object = Prefetcher.this.lock;
                synchronized (object) {
                    Prefetcher.this.lock.notifyAll();
                }
            }
        };
    }

    static interface Loader {
        public void load(Message var1);
    }

    class Callback {
        Callback() {
        }

        void setResult(List<Message> result) {
            Prefetcher.this.messages = result;
        }
    }
}

