/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.clientprefetch;

import com.kingdee.bos.metadata.clientprefetch.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class Queue {
    private AddPolicy policy;
    private int limit;
    private int capacity;

    Queue(int limit, int capacity) {
        this.limit = limit;
        this.capacity = capacity;
        this.policy = new SequenceAddPolicy(limit, capacity);
    }

    public void addMessage(Message message) {
        this.policy.addMessage(message);
    }

    public int getLimit() {
        return this.limit;
    }

    public List getSnap() {
        ArrayList result;
        Collection collection = this.policy.getMessages();
        if (collection.size() < this.limit) {
            int len = collection.size();
            result = new ArrayList(len);
            result.addAll(collection);
        } else {
            int len = this.limit;
            result = new ArrayList(len);
            int index = 0;
            Iterator iter = collection.iterator();
            while (iter.hasNext() && index++ < len) {
                result.add(iter.next());
            }
        }
        return result;
    }

    static class SequenceAddPolicy
    implements AddPolicy {
        HashMap map;
        TreeMap sortMap = new TreeMap(this.getComparator());
        int limit;
        int capacity;

        SequenceAddPolicy(int limit, int capacity) {
            this.map = new HashMap();
            this.limit = limit;
            this.capacity = capacity;
        }

        private Comparator getComparator() {
            return new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    Message m1 = (Message)arg0;
                    Message m2 = (Message)arg1;
                    int ret = m1.visitTime - m2.visitTime;
                    if (ret == 0) {
                        return m1.pk.compareTo(m2.pk);
                    }
                    return ret;
                }
            };
        }

        @Override
        public synchronized void addMessage(Message message) {
            if (this.sortMap.size() < this.capacity) {
                if (!this.map.containsKey(message)) {
                    this.map.put(message, message);
                    this.sortMap.put(message, message);
                } else {
                    Message m1 = (Message)this.map.get(message);
                    m1.inc();
                }
            } else {
                Message m0 = (Message)this.sortMap.lastKey();
                if (m0.visitTime < message.visitTime) {
                    this.sortMap.remove(m0);
                    this.sortMap.put(message, message);
                    this.map.remove(m0);
                    this.map.put(message, message);
                }
            }
        }

        @Override
        public Collection getMessages() {
            return this.sortMap.values();
        }
    }

    static interface AddPolicy {
        public void addMessage(Message var1);

        public Collection getMessages();
    }
}

