/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.clientprefetch;

import com.kingdee.bos.metadata.clientprefetch.Constants;
import com.kingdee.bos.metadata.clientprefetch.Message;
import com.kingdee.bos.metadata.clientprefetch.Queue;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.apache.log4j.Logger;

public class Writer
implements Constants {
    private static final Logger logger = Logger.getLogger(Writer.class);
    private int interval;
    private Queue queue;
    private List lastMessages;
    private boolean initialized = false;
    private String fileName;
    Thread thread;
    Thread hook = null;
    private boolean closed = false;

    public Writer(String root, String user, int interval, Queue queue, List lastMessages) {
        this.interval = interval;
        this.queue = queue;
        this.lastMessages = lastMessages;
        this.fileName = this.getFile(root, user);
        if (this.fileName == null) {
            return;
        }
        this.initialize();
    }

    private void initialize() {
        this.thread = new Thread(this.getRunnable());
        this.thread.setName("MetaData.Prefetch.Outputer");
        this.thread.setDaemon(true);
        this.initialized = true;
        this.hook = this.getHook();
        Runtime.getRuntime().addShutdownHook(this.hook);
    }

    private Thread getHook() {
        return new Thread(){

            @Override
            public void run() {
                Writer.this.output();
            }
        };
    }

    public void start() {
        if (this.initialized) {
            this.thread.start();
        }
    }

    private Runnable getRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(Writer.this.interval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (Writer.this.closed) break;
                    Writer.this.output();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void output() {
        List messages = this.queue.getSnap();
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(this.fileName, false);
        }
        catch (IOException e) {
            logger.info((Object)("Can't write file " + this.fileName));
            logger.error((Object)e);
            return;
        }
        PrintWriter writer = new PrintWriter(fileWriter);
        if (messages.size() < this.queue.getLimit()) {
            List subList = null;
            subList = this.lastMessages.size() > this.queue.getLimit() - messages.size() ? this.lastMessages.subList(0, this.queue.getLimit() - messages.size()) : this.lastMessages;
            for (Object o : subList) {
                if (messages.contains(o)) continue;
                messages.add(o);
            }
        }
        try {
            for (Message message : messages) {
                writer.println(message.doSerialize());
            }
            writer.flush();
            writer.close();
        }
        catch (Throwable t) {
            logger.error((Object)t);
        }
        finally {
            writer.close();
        }
    }

    private String getFile(String root, String user) {
        File file = new File(root);
        if (!file.exists() && !file.mkdir()) {
            logger.info((Object)("Can't mkdir " + root));
            return null;
        }
        String uri = root + "mdprefetch";
        file = new File(uri);
        if (!file.exists() && !file.mkdir()) {
            logger.info((Object)("Can't mkdir " + uri));
            return null;
        }
        file = new File(uri = uri + "/" + user);
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    logger.info((Object)("Can't create file " + uri));
                    return null;
                }
            }
            catch (IOException e) {
                logger.info((Object)("Can't create file " + uri + ":" + e));
                return null;
            }
        }
        return uri;
    }

    public void close() {
        this.closed = true;
        if (this.hook != null) {
            Runtime.getRuntime().removeShutdownHook(this.hook);
        }
    }
}

