/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.metadata.code.CodeWriterBase;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.IEntityObjectCtrl;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.metadata.resource.IBizEnumCtrl;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.util.StringUtils;
import java.util.HashMap;

public class AbstractInfoCodeWriter
extends CodeWriterBase {
    private EntityObjectInfo entity;
    private static final String imp1 = "import java.io.Serializable";
    private static final String imp2 = "import com.kingdee.bos.dao.AbstractObjectValue";
    private static final String imp3 = "import java.util.Locale";
    private static final String imp4 = "import com.kingdee.util.TypeConversionUtils";
    private static final String imp5 = "import com.kingdee.bos.util.BOSObjectType";
    private static final String normalBase = "AbstractObjectValue";
    private HashMap setMap;
    private HashMap getMap;
    private HashMap mulLinkMap;
    private Context ctx = null;

    public AbstractInfoCodeWriter(EntityObjectInfo en) {
        this.entity = en;
        this.initSetMap();
        this.initGetMap();
        this.initMulLinkPropMap();
        this.ctx = ContextManager.getContext();
    }

    private void initSetMap() {
        this.setMap = new HashMap();
        this.setMap.put(DataType.BOSUUID, "setBOSUuid");
        this.setMap.put(DataType.UUID, "setUuid");
        this.setMap.put(DataType.STRING, "setString");
        this.setMap.put(DataType.DECIMAL, "setBigDecimal");
        this.setMap.put(DataType.BOOLEAN, "setBoolean");
        this.setMap.put(DataType.BYTE, "setByte");
        this.setMap.put(DataType.SHORT, "setShort");
        this.setMap.put(DataType.INTEGER, "setInt");
        this.setMap.put(DataType.LONG, "setLong");
        this.setMap.put(DataType.FLOAT, "setFloat");
        this.setMap.put(DataType.DOUBLE, "setDouble");
        this.setMap.put(DataType.DATE, "setDate");
        this.setMap.put(DataType.TIME, "setTime");
        this.setMap.put(DataType.TIMESTAMP, "setTimestamp");
    }

    private void initGetMap() {
        this.getMap = new HashMap();
        this.getMap.put(DataType.BOSUUID, "getBOSUuid");
        this.getMap.put(DataType.UUID, "getUuid");
        this.getMap.put(DataType.STRING, "getString");
        this.getMap.put(DataType.DECIMAL, "getBigDecimal");
        this.getMap.put(DataType.BOOLEAN, "getBoolean");
        this.getMap.put(DataType.BYTE, "getByte");
        this.getMap.put(DataType.SHORT, "getShort");
        this.getMap.put(DataType.INTEGER, "getInt");
        this.getMap.put(DataType.LONG, "getLong");
        this.getMap.put(DataType.FLOAT, "getFloat");
        this.getMap.put(DataType.DOUBLE, "getDouble");
        this.getMap.put(DataType.DATE, "getDate");
        this.getMap.put(DataType.TIME, "getTime");
        this.getMap.put(DataType.TIMESTAMP, "getTimestamp");
    }

    private void initMulLinkPropMap() {
        this.mulLinkMap = new HashMap();
        PropertyCollection props = this.entity.getProperties();
        for (int i = 0; i < props.size(); ++i) {
            RelationshipInfo rel;
            PropertyInfo prop = props.get(i);
            if (!(prop instanceof LinkPropertyInfo) || (rel = ((LinkPropertyInfo)prop).getRelationship()) == null || rel.getSupplierCardinality() == null || !rel.getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED) && !rel.getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) continue;
            this.mulLinkMap.put(prop.getName(), prop);
        }
    }

    @Override
    public void write(StringBuffer in) {
        this.out = in;
        this.writePackage();
        this.writeClass();
        this.writeBegin();
        this.writeConstructor();
        this.writePkConstructor();
        this.writeProperties();
        this.writeBosType();
        this.writeEnd();
    }

    @Override
    public StringBuffer write() {
        this.write(this.out);
        return this.out;
    }

    @Override
    public String getClassName() {
        return "Abstract" + this.getClassName(this.entity.getObjectValueClass());
    }

    private void writePackage() {
        String pa = this.getPackageName(this.entity.getObjectValueClass());
        if (pa.length() != 0) {
            this.out.append("package");
            this.out.append(this.addBlank(pa) + ';' + '\n');
            this.out.append('\n');
        }
        this.out.append("import java.io.Serializable;\n");
        this.out.append("import com.kingdee.bos.dao.AbstractObjectValue;\n");
        this.out.append("import java.util.Locale;\n");
        this.out.append("import com.kingdee.util.TypeConversionUtils;\n");
        this.out.append("import com.kingdee.bos.util.BOSObjectType;\n\n");
    }

    private void writeProperties() {
        PropertyCollection props = this.entity.getProperties();
        this.tabAdd();
        for (int i = 0; i < props.size(); ++i) {
            PropertyInfo prop = props.get(i);
            if (prop instanceof OwnPropertyInfo) {
                this.writeOwnerProp((OwnPropertyInfo)prop);
                continue;
            }
            if (!(prop instanceof LinkPropertyInfo)) continue;
            this.writeLinkProp((LinkPropertyInfo)prop);
        }
        this.tabSub();
    }

    private void writeBosType() {
        this.tabAdd();
        this.out.append(this.tab + "public" + this.addBlank("BOSObjectType") + "getBOSType" + '(' + ')' + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return" + this.addBlank("new") + "BOSObjectType" + '(' + '\"' + this.entity.getType().toString() + '\"' + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
        this.tabSub();
    }

    private void writeOwnerProp(OwnPropertyInfo prop) {
        IEntityObjectCtrl enCtrl;
        DataType dtype = prop.getDataType();
        String type = "";
        String temp = prop.getMetaDataRef();
        if (dtype.equals(DataType.ENUM)) {
            if (!StringUtils.isEmpty((String)temp)) {
                try {
                    IBizEnumCtrl bizEnumCtrl = (IBizEnumCtrl)BOSObjectFactory.createBOSObject(this.ctx, MetaDataTypeList.BIZENUM);
                    type = bizEnumCtrl.getValue(MetaDataPK.create(this.getPackageName(temp), this.getClassName(temp))).getClassName();
                }
                catch (BOSException e) {
                    type = "";
                }
            }
        } else if (dtype.equals(DataType.OBJECTVALUE)) {
            if (!StringUtils.isEmpty((String)temp)) {
                try {
                    enCtrl = (IEntityObjectCtrl)BOSObjectFactory.createBOSObject(this.ctx, MetaDataTypeList.ENTITY);
                    type = enCtrl.getValue(MetaDataPK.create(this.getPackageName(temp), this.getClassName(temp))).getObjectValueClass();
                }
                catch (BOSException e) {
                    type = "";
                }
            }
        } else if (dtype.equals(DataType.OBJECTCOLLECTION)) {
            if (!StringUtils.isEmpty((String)temp)) {
                try {
                    enCtrl = (IEntityObjectCtrl)BOSObjectFactory.createBOSObject(this.ctx, MetaDataTypeList.ENTITY);
                    type = enCtrl.getValue(MetaDataPK.create(MetaDataUtils.getPackageName(temp), MetaDataUtils.getClassName(temp))).getObjectCollectionClass();
                }
                catch (BOSException e) {
                    type = "";
                }
            }
        } else {
            type = dtype.getJavaTypeName();
        }
        String name = prop.getName();
        this.out.append(this.writeNote("Object:" + this.entity.getAlias() + "'s " + prop.getAlias() + "property", new String[0], ""));
        this.out.append(this.getProperty(name, type, prop.getDataType().equals(DataType.BOOLEAN)));
        this.writeBegin();
        this.tabAdd();
        this.writeGetPropertyBody(prop);
        this.tabSub();
        this.writeEnd();
        this.out.append(this.setProperty(name, type));
        this.writeBegin();
        this.tabAdd();
        this.writeSetPropertyBody(prop);
        this.tabSub();
        this.writeEnd();
        if (prop.isMultilingual() && prop.getDataType().equals(DataType.STRING)) {
            this.writeMultiProperty(prop);
        }
    }

    private void writeMultiProperty(OwnPropertyInfo prop) {
        this.out.append(this.tab + "public" + this.addBlank("String") + "get" + this.upcastName(prop.getName()));
        this.out.append("(Locale local)\n");
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return" + ' ' + "TypeConversionUtils.objToString" + '(' + "get" + '(' + '\"' + prop.getName() + '\"' + ',' + "local" + ')' + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
        this.out.append(this.tab + "public" + this.addBlank("void") + "set" + this.upcastName(prop.getName()));
        this.out.append("(String item,Locale local)\n");
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "put" + '(' + '\"' + prop.getName() + '\"' + ',' + "item" + ',' + "local" + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private String getGetMethod(DataType type) {
        if (!this.getMap.containsKey(type)) {
            return "get";
        }
        return (String)this.getMap.get(type);
    }

    private String getSetMethod(DataType type) {
        if (!this.setMap.containsKey(type)) {
            return "put";
        }
        return (String)this.setMap.get(type);
    }

    private void writeSetEnum(OwnPropertyInfo prop) {
        if (!prop.getDataType().equals(DataType.ENUM)) {
            return;
        }
        TypeReference et = new TypeReference(prop.getDataType().getName(), prop.getMetaDataRef());
        if (et == null || et.getEnumValueType() == null) {
            return;
        }
        String method = "put";
        String getName = "getValue";
        if (et.getEnumValueType().equals((Object)BizEnumValueType.DOUBLE)) {
            method = this.getSetMethod(DataType.DOUBLE);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.FLOAT)) {
            method = this.getSetMethod(DataType.FLOAT);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.INTEGER)) {
            method = this.getSetMethod(DataType.INTEGER);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.LONG)) {
            method = this.getSetMethod(DataType.LONG);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.STRING)) {
            method = this.getSetMethod(DataType.STRING);
        }
        this.out.append(this.tab + method + '(' + '\"' + prop.getName() + '\"' + ',' + "item" + '.' + getName + '(' + ')' + ')');
    }

    private void writeGetEnum(OwnPropertyInfo prop) {
        if (!prop.getDataType().equals(DataType.ENUM)) {
            return;
        }
        TypeReference et = new TypeReference(prop.getDataType().getName(), prop.getMetaDataRef());
        if (et == null || et.getEnumValueType() == null) {
            return;
        }
        String method = "get";
        String getName = "getEnum";
        if (et.getEnumValueType().equals((Object)BizEnumValueType.DOUBLE)) {
            method = this.getGetMethod(DataType.DOUBLE);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.FLOAT)) {
            method = this.getGetMethod(DataType.FLOAT);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.INTEGER)) {
            method = this.getGetMethod(DataType.INTEGER);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.LONG)) {
            method = this.getGetMethod(DataType.LONG);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.STRING)) {
            method = this.getGetMethod(DataType.STRING);
        }
        this.out.append(this.tab + "return" + ' ' + et.toString() + '.' + getName + '(' + method + '(' + '\"' + prop.getName() + '\"' + ')' + ')');
    }

    private void writeSetPropertyBody(OwnPropertyInfo prop) {
        boolean isEnum;
        DataType dtype = prop.getDataType();
        String type = dtype.getJavaTypeName();
        String name = prop.getName();
        boolean bl = isEnum = dtype == DataType.ENUM;
        if (!isEnum) {
            String method = this.getSetMethod(dtype);
            this.out.append(this.tab + method + '(' + '\"' + name + '\"' + ',');
            if (dtype == DataType.CHAR) {
                this.out.append("new Character(item))");
            } else {
                this.out.append("item)");
            }
        } else {
            this.writeSetEnum(prop);
        }
        this.out.append(";\n");
    }

    private void writeGetPropertyBody(OwnPropertyInfo prop) {
        boolean isEnum;
        DataType dtype = prop.getDataType();
        String type = dtype.getJavaTypeName();
        String name = prop.getName();
        boolean bl = isEnum = dtype != DataType.ENUM;
        if (isEnum) {
            String method = this.getGetMethod(dtype);
            this.out.append(this.tab + "return" + ' ');
            if (dtype == DataType.CHAR) {
                this.out.append("((Character)" + method + '(' + '\"' + name + '\"' + ')' + ").charValue()");
            } else if (dtype == DataType.BYTEARRAY) {
                this.out.append("(byte[])" + method + '(' + '\"' + name + '\"' + ')');
            } else {
                this.out.append(method + '(' + '\"' + name + '\"' + ')');
            }
        } else {
            this.writeGetEnum(prop);
        }
        this.out.append(";\n");
    }

    private boolean isClient(LinkPropertyInfo prop) {
        RelationshipInfo rel = prop.getRelationship();
        if (rel.getSupplierObject() == null || rel.getClientObject() == null) {
            return false;
        }
        return rel.getClientObject().getFullName().equals(this.entity.getFullName());
    }

    private void writeLinkProp(LinkPropertyInfo prop) {
        RelationshipInfo rel = prop.getRelationship();
        if (rel.getSupplierObject() == null || rel.getClientObject() == null) {
            return;
        }
        boolean isMulti = false;
        EntityObjectInfo se = this.isClient(prop) ? rel.getSupplierObject() : rel.getClientObject();
        String name = prop.getName();
        if (se == null) {
            return;
        }
        String type = "";
        type = (rel.getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || rel.getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) && this.isClient(prop) ? se.getObjectCollectionClass() : se.getObjectValueClass();
        isMulti = this.isCross(prop);
        if (isMulti) {
            type = se.getObjectCollectionClass();
        }
        se.getObjectValueClass();
        this.out.append(this.writeNote("Object: " + this.entity.getAlias() + " 's " + prop.getAlias() + " property", new String[0], ""));
        this.out.append(this.getProperty(name, type, false));
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return" + " (" + type + ")get(\"" + name + "\")" + ';' + '\n');
        this.tabSub();
        this.writeEnd();
        if (!(rel.getSupplierCardinality() != CardinalityType.ZERO_TO_ONE && rel.getSupplierCardinality() != CardinalityType.ONE && this.isClient(prop) || isMulti)) {
            this.out.append(this.setProperty(name, type));
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + "put(\"" + name + "\",item)" + ';' + '\n');
            this.tabSub();
            this.writeEnd();
        }
    }

    private void writeClass() {
        String subMode;
        String accLevel = this.entity.getAccessLevel() == null ? "public" : this.entity.getAccessLevel().getName();
        String string = subMode = this.entity.getSubClassingMode() == null ? "" : this.entity.getSubClassingMode().getName();
        if (subMode.equals("normal")) {
            subMode = "";
        }
        if (subMode.length() != 0) {
            this.out.append(subMode + ' ');
        }
        this.out.append(accLevel + ' ' + "class" + ' ');
        this.out.append(this.getClassName() + ' ');
        this.writeExtend();
        this.out.append("implements");
        this.out.append(this.addBlank("Serializable") + '\n');
    }

    private void writeConstructor() {
        this.tabAdd();
        this.out.append(this.tab + "public" + ' ' + this.getClassName() + '(' + ')' + '\n');
        this.writeBegin();
        this.tabAdd();
        String keyName = this.getKeyPropertyName();
        if (keyName.length() != 0) {
            this.out.append(this.tab + "this" + '(' + '\"' + keyName + '\"' + ')' + ';' + '\n');
        }
        this.tabSub();
        this.writeEnd();
        this.tabSub();
    }

    private boolean isAvalibleLink(LinkPropertyInfo prop) {
        boolean isAvali = prop.getRelationship().getClientObject() != null && prop.getRelationship().getClientObject().getFullName().equals(this.entity.getFullName());
        return isAvali && this.isMulti(prop) || this.isCross(prop);
    }

    private boolean isMulti(LinkPropertyInfo prop) {
        return !(!prop.getRelationship().getClientCardinality().equals((Object)CardinalityType.ZERO_TO_ONE) && !prop.getRelationship().getClientCardinality().equals((Object)CardinalityType.ONE) || !prop.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) && !prop.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED));
    }

    private boolean isCross(LinkPropertyInfo prop) {
        return !(!prop.getRelationship().getClientCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) && !prop.getRelationship().getClientCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || !prop.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) && !prop.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED));
    }

    private void writePkConstructor() {
        this.tabAdd();
        this.out.append(this.tab + "protected" + ' ' + this.getClassName() + '(' + "String pkField" + ')' + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "super" + '(' + "pkField" + ')' + ';' + '\n');
        if (this.mulLinkMap.size() != 0) {
            for (LinkPropertyInfo lnkProp : this.mulLinkMap.values()) {
                if (!this.isAvalibleLink(lnkProp)) continue;
                EntityObjectInfo sel = null;
                if (this.isMulti(lnkProp)) {
                    sel = lnkProp.getRelationship().getSupplierObject();
                } else if (this.isCross(lnkProp)) {
                    sel = this.isClient(lnkProp) ? lnkProp.getRelationship().getSupplierObject() : lnkProp.getRelationship().getClientObject();
                }
                if (sel == null) continue;
                this.out.append(this.tab + "put" + '(' + '\"' + lnkProp.getName() + '\"' + ',' + "new" + ' ' + sel.getObjectCollectionClass() + '(' + ')' + ')' + ';' + '\n');
            }
        }
        this.tabSub();
        this.writeEnd();
        this.tabSub();
    }

    private String getKeyPropertyName() {
        int i;
        PropertyCollection props = this.entity.getInheritedNoDuplicatedProperties();
        if (this.entity.getLogicalKey() == null && this.entity.getLogicalKey().getKeyPropertys().size() != 1) {
            return "";
        }
        PropertyCollection ps = this.entity.getLogicalKey().getKeyPropertys();
        HashMap pcm = new HashMap(ps.size());
        for (i = 0; i < ps.size(); ++i) {
            pcm.put(ps.get(i).getName(), null);
        }
        for (i = 0; i < props.size(); ++i) {
            OwnPropertyInfo ow;
            PropertyInfo prop = props.get(i);
            if (!(prop instanceof OwnPropertyInfo) || (ow = (OwnPropertyInfo)prop).getDataType() == null || !ow.getDataType().equals(DataType.BOSUUID) || !pcm.containsKey(ow.getName())) continue;
            return ow.getName();
        }
        return "";
    }

    private void writeExtend() {
        EntityObjectInfo base = this.entity.getBaseEntity();
        if (base == null) {
            this.out.append("extends");
            this.out.append(this.addBlank(normalBase));
        } else {
            this.out.append("extends");
            this.out.append(this.addBlank(base.getObjectValueClass()));
        }
    }

    private String getProperty(String name, String type, boolean isBoolean) {
        String get = this.tab + "public";
        get = get + this.addBlank(type);
        name = this.upcastName(name);
        name = isBoolean ? "is" + name : "get" + name;
        get = get + this.addBracket(name, "");
        return get;
    }

    private String setProperty(String name, String type) {
        String set = this.tab + "public" + this.addBlank("void");
        name = this.upcastName(name);
        name = "set" + name;
        this.addBlank(type);
        type = type + this.addBlank("item");
        set = set + this.addBracket(name, type);
        return set;
    }
}

