/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.dao.AbstractBaseObjectCollection;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.SubClassingMode;
import com.kingdee.bos.metadata.bo.TransactionAttribute;
import com.kingdee.bos.metadata.code.AbstractBeanCodeWriter;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.resource.BizExceptionCollection;
import com.kingdee.bos.metadata.resource.BizExceptionInfo;
import java.util.Vector;

public class CodeUtil {
    private static final int METHOD_NUMBER = 3;
    private static final String ValueMethod = "getValue";
    private static final String CollectionMethod = "getCollection";

    public static MethodCollection getAllMethod(BusinessObjectInfo bo) {
        AbstractBeanCodeWriter abc = new AbstractBeanCodeWriter(bo);
        MethodCollection methods = abc.getAllClassMethods();
        return methods;
    }

    public static MethodCollection getInheritedNoDuplicatedMethod(BusinessObjectInfo bo) {
        MethodCollection methods = CodeUtil.getAllMethod(bo);
        MethodCollection inheritedMethods = new MethodCollection();
        CodeUtil.getSuperMethods(bo, inheritedMethods);
        for (int i = 0; i < inheritedMethods.size(); ++i) {
            MethodInfo method = inheritedMethods.get(i);
            if (CodeUtil.containMethod(methods, method)) continue;
            methods.add(method);
        }
        return methods;
    }

    public static void getSuperMethods(BusinessObjectInfo bo, MethodCollection inheritedMethods) {
        FacadeInfo facade;
        if (bo instanceof EntityObjectInfo) {
            EntityObjectInfo en = (EntityObjectInfo)bo;
            if (en.getBaseEntity() != null) {
                EntityObjectInfo superEn = en.getBaseEntity();
                MethodCollection superMethods = superEn.getMethods();
                if (superMethods != null) {
                    for (int i = 0; i < superMethods.size(); ++i) {
                        inheritedMethods.add(superMethods.get(i));
                    }
                }
                CodeUtil.getSuperMethods(superEn, inheritedMethods);
            }
        } else if (bo instanceof FacadeInfo && (facade = (FacadeInfo)bo).getBaseFacade() != null) {
            FacadeInfo superFacade = facade.getBaseFacade();
            MethodCollection superMethods = superFacade.getMethods();
            if (superMethods != null) {
                for (int i = 0; i < superMethods.size(); ++i) {
                    inheritedMethods.add(superMethods.get(i));
                }
            }
            CodeUtil.getSuperMethods(superFacade, inheritedMethods);
        }
    }

    public static boolean containMethod(MethodCollection methods, MethodInfo method) {
        if (methods != null) {
            for (int i = 0; i < methods.size(); ++i) {
                MethodInfo thisMethod = methods.get(i);
                if (!thisMethod.equals2(method)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containMethodForNormal(MethodCollection methods, MethodInfo method) {
        if (methods != null) {
            for (int i = 0; i < methods.size(); ++i) {
                MethodInfo thisMethod = methods.get(i);
                if (!thisMethod.equals2(method) || thisMethod.getSubClassingMode() == SubClassingMode.ABSTRACT) continue;
                return true;
            }
        }
        return false;
    }

    public static Vector getSuperCollectionMethodException(EntityObjectInfo superEntity) {
        Vector vec = new Vector(0);
        MethodCollection collectionMethods = new MethodCollection();
        CodeUtil.getSuperCollectionMethod(superEntity, collectionMethods, null);
        if (collectionMethods != null) {
            int n = collectionMethods.size();
            for (int i = 0; i < n; ++i) {
                CodeUtil.getAddedExceptionName(vec, superEntity, collectionMethods.get(i));
            }
        }
        return vec;
    }

    public static void getSuperCollectionMethod(EntityObjectInfo superEntity, MethodCollection collectionMethods, Vector collectionEntities) {
        if (superEntity != null) {
            MethodCollection thisSuperMethods = superEntity.getMethods();
            if (thisSuperMethods != null) {
                int n = thisSuperMethods.size();
                for (int i = 0; i < n; ++i) {
                    if (!thisSuperMethods.get(i).getName().equalsIgnoreCase(CollectionMethod)) continue;
                    collectionMethods.add(thisSuperMethods.get(i));
                    if (collectionEntities == null) continue;
                    collectionEntities.add(superEntity);
                }
            }
            CodeUtil.getSuperCollectionMethod(superEntity.getBaseEntity(), collectionMethods, collectionEntities);
        }
    }

    public static void getSuperValueMethod(EntityObjectInfo superEntity, MethodCollection valueMethods) {
        MethodCollection thisSuperMethods = superEntity.getMethods();
        if (thisSuperMethods != null) {
            for (int i = 0; i < thisSuperMethods.size(); ++i) {
                if (!thisSuperMethods.get(i).getName().equalsIgnoreCase(ValueMethod)) continue;
                valueMethods.add(thisSuperMethods.get(i));
            }
        }
        if (valueMethods.size() < 3) {
            valueMethods.clear();
            EntityObjectInfo baseEn = superEntity.getBaseEntity();
            if (baseEn != null) {
                CodeUtil.getSuperValueMethod(baseEn, valueMethods);
            }
        }
    }

    public static boolean needAddColletionMethod(EntityObjectInfo entity) {
        int number = 0;
        MethodCollection methods = entity.getMethods();
        if (methods != null) {
            for (int i = 0; i < methods.size(); ++i) {
                if (!methods.get(i).getName().equalsIgnoreCase(CollectionMethod)) continue;
                ++number;
            }
        }
        return number < 3;
    }

    public static boolean needAddValueMethod(EntityObjectInfo entity) {
        int number = 0;
        MethodCollection methods = entity.getMethods();
        if (methods != null) {
            for (int i = 0; i < methods.size(); ++i) {
                if (!methods.get(i).getName().equalsIgnoreCase(ValueMethod)) continue;
                ++number;
            }
        }
        return number < 3;
    }

    public static void addCollectionMethod(BusinessObjectInfo bo, MethodCollection methods, MethodCollection collectionMethods) {
        if (bo instanceof EntityObjectInfo) {
            EntityObjectInfo entity = (EntityObjectInfo)bo;
            if (collectionMethods != null) {
                for (int i = 0; i < collectionMethods.size(); ++i) {
                    MethodInfo collectionMethod = collectionMethods.get(i);
                    MethodInfo method = new MethodInfo();
                    method.setName(collectionMethod.getName());
                    method.setSubClassingMode(SubClassingMode.NORMAL);
                    method.getParameters().addObjectCollection(collectionMethod.getParameters());
                    method.getBizExceptions().addObjectCollection(collectionMethod.getBizExceptions());
                    method.setDataType(DataType.OBJECTCOLLECTION.getName());
                    method.setMetadataRef(bo.getFullName());
                    method.setTransactionAttribute(TransactionAttribute.SUPPORTS);
                    if (CodeUtil.containMethod(methods, method)) continue;
                    CodeUtil.addExceptionToMethod(entity.getBaseEntity(), method);
                    methods.add(method);
                }
            }
        }
    }

    public static void addValueMethod(BusinessObjectInfo bo, MethodCollection valueMethods) {
        if (bo instanceof EntityObjectInfo) {
            EntityObjectInfo entity = (EntityObjectInfo)bo;
            MethodCollection methods = entity.getMethods();
            if (valueMethods != null) {
                for (int i = 0; i < valueMethods.size(); ++i) {
                    MethodInfo valueMethod = valueMethods.get(i);
                    MethodInfo method = new MethodInfo();
                    method.setName(valueMethod.getName());
                    method.setSubClassingMode(SubClassingMode.NORMAL);
                    method.getParameters().addObjectCollection(valueMethod.getParameters());
                    method.getBizExceptions().addObjectCollection(valueMethod.getBizExceptions());
                    method.setDataType(DataType.OBJECTVALUE.getName());
                    method.setMetadataRef(bo.getFullName());
                    method.setTransactionAttribute(TransactionAttribute.SUPPORTS);
                    if (CodeUtil.containMethod(methods, method)) continue;
                    methods.add(method);
                }
            }
        }
    }

    public static Vector getAddedExceptionsName(BusinessObjectInfo bo) {
        Vector vec = new Vector(0);
        MethodCollection methods = (MethodCollection)bo.getMethods().clone();
        if (methods != null) {
            int n = methods.size();
            for (int i = 0; i < n; ++i) {
                CodeUtil.getAddedExceptionName(vec, bo, methods.get(i));
            }
        }
        return vec;
    }

    public static MethodCollection addExceptionToMethods(BusinessObjectInfo bo) {
        MethodCollection methods = (MethodCollection)bo.getMethods().clone();
        if (methods != null) {
            int n = methods.size();
            for (int i = 0; i < n; ++i) {
                CodeUtil.addExceptionToMethod(bo, methods.get(i));
            }
        }
        return methods;
    }

    public static MethodCollection addExceptionToAllMethods(BusinessObjectInfo bo) {
        MethodCollection methods = (MethodCollection)bo.getAllMethods().clone();
        if (methods != null) {
            int n = methods.size();
            for (int i = 0; i < n; ++i) {
                CodeUtil.addExceptionToMethod(bo, methods.get(i));
            }
        }
        return methods;
    }

    public static void getAddedExceptionName(Vector vec, BusinessObjectInfo bo, MethodInfo method) {
        FacadeInfo facade;
        boolean haveSuper = false;
        BusinessObjectInfo superBo = null;
        AbstractBaseObjectCollection superMethods = null;
        if (bo instanceof EntityObjectInfo) {
            EntityObjectInfo en = (EntityObjectInfo)bo;
            if (en.getBaseEntity() != null) {
                EntityObjectInfo superEn;
                superBo = superEn = en.getBaseEntity();
                if (superEn.getBaseEntity() != null) {
                    haveSuper = true;
                }
                superMethods = superEn.getMethods();
            }
        } else if (bo instanceof FacadeInfo && (facade = (FacadeInfo)bo).getBaseFacade() != null) {
            FacadeInfo superFacade = facade.getBaseFacade();
            superBo = superFacade;
            if (superFacade.getBaseFacade() != null) {
                haveSuper = true;
            }
            superMethods = superFacade.getMethods();
        }
        if (superMethods != null) {
            for (int i = 0; i < superMethods.size(); ++i) {
                if (!method.equals2(((MethodCollection)superMethods).get(i))) continue;
                BizExceptionCollection thisExceptions = method.getBizExceptions();
                BizExceptionCollection superExceptions = ((MethodCollection)superMethods).get(i).getBizExceptions();
                if (superExceptions == null) continue;
                int n = superExceptions.size();
                for (int j = 0; j < n; ++j) {
                    if (CodeUtil.containBizException(thisExceptions, superExceptions.get(j))) continue;
                    vec.add(superExceptions.get(j).getClassName());
                }
            }
        }
        if (superBo != null) {
            CodeUtil.getAddedExceptionName(vec, superBo, method);
        }
    }

    public static void addExceptionToMethod(BusinessObjectInfo bo, MethodInfo method) {
        FacadeInfo facade;
        boolean haveSuper = false;
        BusinessObjectInfo superBo = null;
        AbstractBaseObjectCollection superMethods = null;
        if (bo instanceof EntityObjectInfo) {
            EntityObjectInfo en = (EntityObjectInfo)bo;
            if (en.getBaseEntity() != null) {
                EntityObjectInfo superEn;
                superBo = superEn = en.getBaseEntity();
                if (superEn.getBaseEntity() != null) {
                    haveSuper = true;
                }
                superMethods = superEn.getMethods();
            }
        } else if (bo instanceof FacadeInfo && (facade = (FacadeInfo)bo).getBaseFacade() != null) {
            FacadeInfo superFacade = facade.getBaseFacade();
            superBo = superFacade;
            if (superFacade.getBaseFacade() != null) {
                haveSuper = true;
            }
            superMethods = superFacade.getMethods();
        }
        if (superMethods != null) {
            for (int i = 0; i < superMethods.size(); ++i) {
                if (!method.equals2(((MethodCollection)superMethods).get(i))) continue;
                BizExceptionCollection thisExceptions = method.getBizExceptions();
                BizExceptionCollection superExceptions = ((MethodCollection)superMethods).get(i).getBizExceptions();
                if (superExceptions == null) continue;
                int n = superExceptions.size();
                for (int j = 0; j < n; ++j) {
                    if (CodeUtil.containBizException(thisExceptions, superExceptions.get(j))) continue;
                    thisExceptions.add(superExceptions.get(j));
                }
            }
        }
        if (superBo != null) {
            CodeUtil.addExceptionToMethod(superBo, method);
        }
        CodeUtil.resetBizException(method);
    }

    public static boolean containBizException(BizExceptionCollection exceptions, BizExceptionInfo exception) {
        int n = exceptions.size();
        for (int i = 0; i < n; ++i) {
            if (!exception.equals2(exceptions.get(i))) continue;
            return true;
        }
        return false;
    }

    public static void resetBizException(MethodInfo method) {
        BizExceptionCollection exceptions = method.getBizExceptions();
        if (exceptions == null || exceptions.size() <= 0) {
            return;
        }
        int n = exceptions.size();
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (!CodeUtil.isSubException(exceptions.get(i), exceptions.get(j))) continue;
                exceptions.swap(i, j);
            }
        }
    }

    public static boolean isSubException(BizExceptionInfo masterException, BizExceptionInfo targetException) {
        Vector vec = new Vector(0);
        CodeUtil.getAllSuperException(vec, targetException);
        int n = vec.size();
        for (int i = 0; i < n; ++i) {
            BizExceptionInfo exception = (BizExceptionInfo)vec.elementAt(i);
            if (!exception.equals2(masterException)) continue;
            return true;
        }
        return false;
    }

    public static void getAllSuperException(Vector vec, BizExceptionInfo exception) {
        if (exception.getBaseException() != null) {
            vec.addElement(exception.getBaseException());
            CodeUtil.getAllSuperException(vec, exception.getBaseException());
        }
    }

    public static boolean haveUserDefinedMethod(BusinessObjectInfo bo) {
        MethodCollection methods = bo.getMethods();
        if (methods != null) {
            int n = methods.size();
            for (int i = 0; i < n; ++i) {
                MethodInfo method = methods.get(i);
                if (!ConvertUtils.isUserDefined(method)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isUserDefinedMethod(MethodInfo method) {
        return method.isUserDefined();
    }

    public static String getMethodName(MethodInfo method, BusinessObjectInfo bo) {
        String name = method.getName();
        if (bo instanceof EntityObjectInfo && bo.isSystemMethod(method) && (CodeUtil.isValue(name) || CodeUtil.isCollection(name))) {
            EntityObjectInfo parent = (EntityObjectInfo)bo;
            if ((parent = parent.getBaseEntity()) != null) {
                if (CodeUtil.isCollection(name)) {
                    return "get" + CodeUtil.getClassName(((EntityObjectInfo)bo).getObjectCollectionClass());
                }
                return "get" + CodeUtil.getClassName(((EntityObjectInfo)bo).getObjectValueClass());
            }
        }
        return name;
    }

    private static boolean isValue(String methodName) {
        return methodName.equals(ValueMethod);
    }

    protected static boolean isCollection(String methodName) {
        return methodName.equals(CollectionMethod);
    }

    protected static String getClassName(String fullName) {
        return MetaDataUtils.getClassName(fullName);
    }
}

