/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.metadata.code.CodeWriterBase;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueType;

public class EnumCodeWriter
extends CodeWriterBase {
    private BizEnumInfo bizEnumInfo;

    public EnumCodeWriter(BizEnumInfo bizEnInfo) {
        this.bizEnumInfo = bizEnInfo;
    }

    private void writePackage() {
        this.out.append(this.writeNote("output package name", new String[0], ""));
        this.out.append("package ");
        this.out.append(this.getPackageName(this.bizEnumInfo.getClassName()) + ';' + '\n');
        this.out.append('\n');
        this.out.append("import java.util.Map;\n");
        this.out.append("import java.util.List;\n");
        this.out.append("import java.util.Iterator;\n");
        this.out.append("import com.kingdee.util.enums.");
        this.out.append(this.upcastName(this.getInheritType(this.bizEnumInfo)));
        this.out.append("Enum;\n");
        this.out.append('\n');
    }

    private void writeClass() {
        this.out.append(this.writeNote("output class name", new String[0], ""));
        this.out.append("public" + this.addBlank("class"));
        this.out.append(this.getClassName(this.bizEnumInfo.getClassName()));
        this.out.append(this.addBlank("extends"));
        this.out.append(this.upcastName(this.getInheritType(this.bizEnumInfo)));
        this.out.append("Enum");
        this.out.append('\n');
    }

    private void writeEnumValue() {
        BizEnumValueCollection enumCol = this.bizEnumInfo.getEnumValue();
        int length = enumCol.size();
        for (int i = 0; i < length; ++i) {
            BizEnumValueType type = this.bizEnumInfo.getDataType();
            this.out.append(this.tab + "public" + this.addBlank("static") + "final");
            if (type.equals((Object)BizEnumValueType.STRING)) {
                this.out.append(this.addBlank(this.upcastName(this.getInheritType(this.bizEnumInfo))));
            } else {
                this.out.append(this.addBlank(this.getInheritType(this.bizEnumInfo)));
            }
            this.out.append(enumCol.get(i).getName().toUpperCase() + "_VALUE");
            this.out.append(this.addBlank("="));
            String value = "";
            value = type.equals((Object)BizEnumValueType.LONG) ? Long.toString(enumCol.get(i).getLong()) : (type.equals((Object)BizEnumValueType.FLOAT) ? Float.toString(enumCol.get(i).getFloat()) + "f" : (type.equals((Object)BizEnumValueType.DOUBLE) ? Double.toString(enumCol.get(i).getDouble()) : (type.equals((Object)BizEnumValueType.INTEGER) ? Integer.toString(enumCol.get(i).getInt()) : this.addMark(enumCol.get(i).getString()))));
            this.out.append(value + ';');
            this.out.append('\n');
        }
        this.out.append('\n');
    }

    private void writeVariable() {
        BizEnumValueCollection enumCol = this.bizEnumInfo.getEnumValue();
        if (enumCol != null) {
            int length = enumCol.size();
            for (int i = 0; i < length; ++i) {
                this.out.append(this.tab + "public" + this.addBlank("static") + "final");
                this.out.append(this.addBlank(this.getClassName(this.bizEnumInfo.getClassName())));
                this.out.append(enumCol.get(i).getName());
                this.out.append(this.addBlank("=") + "new" + ' ');
                this.out.append(this.addBracketMethod(this.getClassName(this.bizEnumInfo.getClassName()), this.addMark(enumCol.get(i).getName()) + ',' + enumCol.get(i).getName().toUpperCase() + "_VALUE") + ';');
                this.out.append('\n');
            }
        }
        this.out.append('\n');
    }

    private void writeConstruct() {
        String[] params = this.bizEnumInfo.getDataType() == BizEnumValueType.STRING ? new String[]{this.upcastName(this.bizEnumInfo.getDataType().getName().toLowerCase()) + ' ' + this.locastName(this.getClassName(this.bizEnumInfo.getClassName()))} : new String[]{this.bizEnumInfo.getDataType().getName().toLowerCase() + ' ' + this.locastName(this.getClassName(this.bizEnumInfo.getClassName()))};
        this.out.append(this.writeNote("construct function", params, ""));
        this.out.append(this.tab + "private" + ' ');
        if (this.bizEnumInfo.getDataType() == BizEnumValueType.STRING) {
            this.out.append(this.addBracket(this.getClassName(this.bizEnumInfo.getClassName()), "String name," + this.upcastName(this.getInheritType(this.bizEnumInfo)) + ' ' + this.locastName(this.getClassName(this.bizEnumInfo.getClassName()))));
        } else {
            this.out.append(this.addBracket(this.getClassName(this.bizEnumInfo.getClassName()), "String name," + this.getInheritType(this.bizEnumInfo) + ' ' + this.locastName(this.getClassName(this.bizEnumInfo.getClassName()))));
        }
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + this.addBracketMethod("super", "name," + this.locastName(this.getClassName(this.bizEnumInfo.getClassName()))));
        this.out.append(';');
        this.out.append('\n');
        this.tabSub();
        this.writeEnd();
        this.out.append('\n');
    }

    private void writeFunction(String arguments) {
        String[] params = new String[]{"String arguments"};
        this.out.append(this.writeNote("getEnum function", params, ""));
        this.out.append(this.tab + "public" + this.addBlank("static"));
        this.out.append(this.getClassName(this.bizEnumInfo.getClassName()));
        this.out.append(' ' + this.addBracket("getEnum", arguments + ' ' + this.locastName(this.getClassName(this.bizEnumInfo.getClassName()))));
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return" + ' ' + '(' + this.getClassName(this.bizEnumInfo.getClassName()) + ')');
        this.out.append(' ' + this.addBracketMethod("getEnum", this.getClassName(this.bizEnumInfo.getClassName()) + '.' + "class" + ',' + ' ' + this.locastName(this.getClassName(this.bizEnumInfo.getClassName()))));
        this.out.append(";\n");
        this.tabSub();
        this.writeEnd();
        this.out.append('\n');
    }

    public void writeMapFunction() {
        this.out.append(this.writeNote("getEnumMap function", new String[0], ""));
        this.out.append(this.tab + "public" + this.addBlank("static"));
        this.out.append("Map " + this.addBracketMethod("getEnumMap", "") + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + this.addBlank("return") + this.addBracketMethod("getEnumMap", this.getClassName(this.bizEnumInfo.getClassName()) + '.' + "class"));
        this.out.append(";\n");
        this.tabSub();
        this.writeEnd();
        this.out.append('\n');
    }

    public void writeListFunction() {
        this.out.append(this.writeNote("getEnumList function", new String[0], ""));
        this.out.append(this.tab + "public" + this.addBlank("static"));
        this.out.append("List " + this.addBracketMethod("getEnumList", "") + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + this.addBlank("return") + this.addBracketMethod("getEnumList", this.getClassName(this.bizEnumInfo.getClassName()) + '.' + "class"));
        this.out.append(";\n");
        this.tabSub();
        this.writeEnd();
        this.out.append('\n');
    }

    public void writeIterator() {
        this.out.append(this.writeNote("getIterator function", new String[0], ""));
        this.out.append(this.tab + "public" + this.addBlank("static"));
        this.out.append("Iterator " + this.addBracketMethod("iterator", "") + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + this.addBlank("return") + this.addBracketMethod("iterator", this.getClassName(this.bizEnumInfo.getClassName()) + '.' + "class"));
        this.out.append(";\n");
        this.tabSub();
        this.writeEnd();
        this.out.append('\n');
    }

    @Override
    public void write(StringBuffer in) {
        this.out = in;
        this.writePackage();
        this.writeClass();
        this.writeBegin();
        this.tabAdd();
        this.writeEnumValue();
        this.writeVariable();
        this.writeConstruct();
        this.writeFunction("String");
        if (this.bizEnumInfo.getDataType() != BizEnumValueType.STRING) {
            this.writeFunction(this.getInheritType(this.bizEnumInfo));
        }
        this.writeMapFunction();
        this.writeListFunction();
        this.writeIterator();
        this.tabSub();
        this.writeEnd();
    }

    @Override
    public StringBuffer write() {
        this.write(this.out);
        return this.out;
    }

    @Override
    protected String getClassName() {
        return this.getClassName(this.bizEnumInfo.getClassName());
    }

    private String getInheritType(BizEnumInfo bizEnumInfo) {
        String prefix = "";
        prefix = bizEnumInfo.getDataType() == BizEnumValueType.INTEGER ? bizEnumInfo.getDataType().getName().toLowerCase().substring(0, 3) : bizEnumInfo.getDataType().getName().toLowerCase();
        return prefix;
    }
}

