/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.code.CodeWriterBase;

public class LocalCtrlCodeWriter
extends CodeWriterBase {
    private String controllerClassName = "";
    protected BusinessObjectInfo bo;
    private final String imp1 = "import javax.ejb.*";

    public LocalCtrlCodeWriter(BusinessObjectInfo bo) {
        this.bo = bo;
    }

    @Override
    public void write(StringBuffer in) {
        this.writePackage();
        this.writeClass();
        this.writeBegin();
        this.writeEnd();
    }

    protected void writePackage() {
        String pa = this.getPackageName(this.getFullName());
        if (pa.length() != 0) {
            this.out.append("package");
            this.out.append(this.addBlank(pa) + ';' + '\n');
            this.out.append("\n");
        }
        this.out.append("import javax.ejb.*;\n\n");
    }

    protected void writeClass() {
        this.out.append("public ");
        this.out.append("interface");
        this.out.append(this.addBlank(this.getClassName()));
        this.out.append("extends");
        this.out.append(this.addBlank(this.getExtendsName()) + ',');
        this.out.append(this.getControlName() + '\n');
    }

    public String getControlName() {
        return this.bo.getBusinessControllerName() == null ? "" : this.getClassName(this.bo.getBusinessControllerName());
    }

    public String getFullName() {
        return this.bo.getBusinessControllerLocal() == null ? "" : this.bo.getBusinessControllerLocal();
    }

    @Override
    public String getClassName() {
        return this.getClassName(this.getFullName());
    }

    private String getExtendsName() {
        String extName = this.getProxyType().equalsIgnoreCase("Local") ? this.getProxyType() : "";
        return "EJB" + extName + "Object";
    }

    @Override
    public String getProxyType() {
        return "Local";
    }
}

