/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.code.CodeWriterBase;

public class LocalHomeCodeWriter
extends CodeWriterBase {
    protected BusinessObjectInfo bo;
    private static final String imp1 = "import javax.ejb.*";
    private static final String imp2 = "import java.rmi.RemoteException";
    private static final String function = "create";
    private static final String ex1 = "CreateException";
    private static final String ex2 = "RemoteException";
    private static final String suffix = "Home";

    public LocalHomeCodeWriter(BusinessObjectInfo bo) {
        this.bo = bo;
    }

    @Override
    public void write(StringBuffer in) {
        this.writePackage();
        this.writeClass();
        this.writeBegin();
        this.tabAdd();
        this.writeCreateMethod();
        this.tabSub();
        this.writeEnd();
    }

    private void writePackage() {
        String pa = this.getPackageName(this.getFullName());
        if (pa.length() != 0) {
            this.out.append("package");
            this.out.append(this.addBlank(pa) + ';' + '\n');
            this.out.append("\n");
        }
        this.out.append("import javax.ejb.*;\n");
        this.out.append("import java.rmi.RemoteException;\n\n");
    }

    private void writeClass() {
        this.out.append("public ");
        this.out.append("interface");
        this.out.append(this.addBlank(this.getClassName()));
        this.out.append("extends");
        this.out.append(this.addBlank(this.getExtendName()) + '\n');
    }

    private void writeCreateMethod() {
        this.out.append(this.tab + this.getCtrlName());
        this.out.append(" create()");
        this.out.append("throws ");
        this.out.append(ex1);
        if (this.isRemote()) {
            this.out.append(",RemoteException");
        }
        this.out.append(";\n");
    }

    private String getExtendName() {
        String extendName = this.isRemote() ? "" : "Local";
        return "EJB" + extendName + suffix;
    }

    protected String getCtrlName() {
        return this.bo.getBusinessControllerLocal() == null ? "" : this.getClassName(this.bo.getBusinessControllerLocal());
    }

    protected String getFullName() {
        return this.bo.getBusinessControllerLocaleHome() == null ? "" : this.bo.getBusinessControllerLocaleHome();
    }

    @Override
    public String getClassName() {
        return this.getClassName(this.getFullName());
    }

    protected boolean isRemote() {
        return false;
    }
}

