/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.jdt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.code.jdt.AbstractJdtCodeWriter;
import com.kingdee.bos.metadata.code.jdt.IJdtCodeWriter;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class JdtAbstractInfoCodeWriter
extends AbstractJdtCodeWriter
implements IJdtCodeWriter {
    private EntityObjectInfo entity;

    public JdtAbstractInfoCodeWriter(BusinessObjectInfo bo) throws BOSException {
        super(bo);
        this.entity = (EntityObjectInfo)bo;
        this.isInterface = false;
    }

    @Override
    public void appendPackageDeclaration() {
        PackageDeclaration packageDeclaration = this.ast.newPackageDeclaration();
        String fullPackage = this.entity.getPackage();
        String[] packageNames = StringUtils.split((String)fullPackage, (String)".");
        Object packageName = null;
        packageName = packageNames != null && packageNames.length > 1 ? this.ast.newName(packageNames) : (!StringUtils.isEmpty((String)fullPackage) ? this.ast.newSimpleName(this.entity.getPackage()) : this.ast.newSimpleName("default"));
        packageDeclaration.setName((Name)packageName);
        this.unit.setPackage(packageDeclaration);
    }

    @Override
    public void appendTypeDeclaration() {
        TypeDeclaration tp = this.ast.newTypeDeclaration();
        tp.setInterface(this.isInterface);
        tp.setModifiers(this.getModifiers(this.entity.getAccessLevel(), this.entity.getSubClassingMode()));
        tp.setName(this.ast.newSimpleName(this.getFileName()));
        EntityObjectInfo baseEntity = this.entity.getBaseEntity();
        if (baseEntity != null) {
            String baseName = baseEntity.getObjectValueClass();
            String[] baseNames = StringUtils.split((String)baseName, (int)46);
            tp.setSuperclass(this.ast.newName(baseNames));
        }
        this.appendConstructor(tp);
        this.unit.types().add(tp);
    }

    public void appendConstructor(TypeDeclaration tp) {
        MethodDeclaration method = this.ast.newMethodDeclaration();
        method.setConstructor(true);
        method.setModifiers(1);
        method.setName(this.ast.newSimpleName(this.getFileName()));
        Block body = this.ast.newBlock();
        SuperConstructorInvocation scst = this.ast.newSuperConstructorInvocation();
        String keyName = this.getKeyPropertyName();
        StringLiteral lt = this.ast.newStringLiteral();
        lt.setLiteralValue('\"' + keyName + '\"');
        scst.arguments().add(lt);
        body.statements().add(scst);
        ArrayList methods = this.getConstructInitExpress();
        for (int i = 0; i < methods.size(); ++i) {
            body.statements().add(methods.get(i));
        }
        method.setBody(body);
        tp.bodyDeclarations().add(method);
        method = this.ast.newMethodDeclaration();
        method.setConstructor(true);
        method.setModifiers(4);
        method.setName(this.ast.newSimpleName(this.getFileName()));
        tp.bodyDeclarations().add(method);
    }

    @Override
    public String getFileName() {
        return MetaDataUtils.upcastName("abstract") + MetaDataUtils.getClassName(this.entity.getObjectValueClass());
    }

    public static String getFileName(EntityObjectInfo en) {
        return MetaDataUtils.upcastName("abstract") + MetaDataUtils.getClassName(en.getObjectValueClass());
    }

    private ArrayList getConstructInitExpress() {
        ArrayList<Object> methods = new ArrayList<Object>();
        Object method = null;
        PropertyCollection props = this.entity.getEntityProperties();
        for (int i = 0; i < props.size(); ++i) {
            LinkPropertyInfo lnkProp;
            if (!(props.get(i) instanceof LinkPropertyInfo) || !this.isAvalibleLink(lnkProp = (LinkPropertyInfo)props.get(i))) continue;
            EntityObjectInfo sel = null;
            if (this.isMulti(lnkProp)) {
                sel = lnkProp.getRelationship().getSupplierObject();
            } else if (this.isCross(lnkProp)) {
                sel = this.isClient(lnkProp) ? lnkProp.getRelationship().getSupplierObject() : lnkProp.getRelationship().getClientObject();
            }
            if (sel == null) continue;
            StringLiteral lt = this.ast.newStringLiteral();
            lt.setEscapedValue('\"' + lnkProp.getName() + '\"');
            ClassInstanceCreation cic = this.ast.newClassInstanceCreation();
            cic.setName(this.ast.newName(StringUtils.split((String)sel.getObjectCollectionClass(), (int)46)));
            methods.add(method);
        }
        return methods;
    }

    private boolean isClient(LinkPropertyInfo prop) {
        RelationshipInfo rel = prop.getRelationship();
        if (rel.getSupplierObject() == null || rel.getClientObject() == null) {
            return false;
        }
        return rel.getClientObject().getFullName().equals(this.entity.getFullName());
    }

    private String getKeyPropertyName() {
        int i;
        PropertyCollection props = this.entity.getProperties();
        if (this.entity.getLogicalKey() == null && this.entity.getLogicalKey().getKeyPropertys().size() != 1) {
            return "";
        }
        PropertyCollection ps = this.entity.getLogicalKey().getKeyPropertys();
        HashMap pcm = new HashMap(ps.size());
        for (i = 0; i < ps.size(); ++i) {
            pcm.put(ps.get(i).getName(), null);
        }
        for (i = 0; i < props.size(); ++i) {
            OwnPropertyInfo ow;
            PropertyInfo prop = props.get(i);
            if (!(prop instanceof OwnPropertyInfo) || (ow = (OwnPropertyInfo)prop).getDataType() == null || !ow.getDataType().equals(DataType.BOSUUID) || !pcm.containsKey(ow.getName())) continue;
            return ow.getName();
        }
        return "";
    }

    private boolean isAvalibleLink(LinkPropertyInfo prop) {
        boolean isAvali = prop.getRelationship().getClientObject() != null && prop.getRelationship().getClientObject().getFullName().equals(this.entity.getFullName());
        return isAvali && this.isMulti(prop) || this.isCross(prop);
    }

    private boolean isMulti(LinkPropertyInfo prop) {
        return !(!prop.getRelationship().getClientCardinality().equals((Object)CardinalityType.ZERO_TO_ONE) && !prop.getRelationship().getClientCardinality().equals((Object)CardinalityType.ONE) || !prop.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) && !prop.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED));
    }

    private boolean isCross(LinkPropertyInfo prop) {
        return !(!prop.getRelationship().getClientCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) && !prop.getRelationship().getClientCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || !prop.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) && !prop.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED));
    }
}

