/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.templates.compiled;

import com.kingdee.util.StringUtils;
import java.util.Map;
import java.util.Properties;

public class WebUIResourceGenerator {
    protected static String nl;
    protected final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "";
    protected final String TEXT_2 = "=";
    private static String specialSaveChars;
    private static final char[] hexDigit;

    public static synchronized WebUIResourceGenerator create(String lineSeparator) {
        nl = lineSeparator;
        WebUIResourceGenerator result = new WebUIResourceGenerator();
        nl = null;
        return result;
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    private static String saveConvert(String theString, boolean escapeSpace) {
        if (StringUtils.isEmpty((String)theString)) {
            return "";
        }
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(WebUIResourceGenerator.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(WebUIResourceGenerator.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(WebUIResourceGenerator.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(WebUIResourceGenerator.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] args = (Object[])argument;
        Properties p = (Properties)args[0];
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            stringBuffer.append("");
            stringBuffer.append(WebUIResourceGenerator.saveConvert(key, true));
            stringBuffer.append("=");
            stringBuffer.append(WebUIResourceGenerator.saveConvert(value, true));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    static {
        specialSaveChars = "=: \t\r\n\f#!";
        hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

