/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.translate;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.code.internal.ASTFlattener;
import com.kingdee.bos.metadata.code.translate.JdtBosTranslator;
import com.kingdee.bos.metadata.code.translate.TranslateException;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import xjavadoc.XClass;
import xjavadoc.XDoc;
import xjavadoc.XField;
import xjavadoc.XTag;
import xjavadoc.filesystem.AbstractFile;

public class EnumTranslator
extends JdtBosTranslator {
    private Type fieldType;
    private XClass xClass;

    @Override
    protected AbstractMetaDataValue getMetaData(CompilationUnit unit) {
        BizEnumInfo bizEnum = new BizEnumInfo();
        bizEnum = this.assignEnum(unit, bizEnum);
        return bizEnum;
    }

    @Override
    public String transBos2Jdt(AbstractMetaDataValue metaData) throws TranslateException {
        BizEnumInfo bizEnum = null;
        String result = "";
        if (!(metaData instanceof BizEnumInfo)) {
            return result;
        }
        bizEnum = (BizEnumInfo)metaData;
        try {
            CompilationUnit unit = this.constructClass(bizEnum);
            ASTFlattener flattener = new ASTFlattener();
            flattener.visit(unit);
            result = flattener.getFormattedResult(0, "\r\n");
        }
        catch (TranslateException se) {
            throw se;
        }
        catch (Exception e) {
            throw new TranslateException(e);
        }
        return result;
    }

    private BizEnumInfo assignEnum(CompilationUnit unit, BizEnumInfo bizEnum) {
        List types = unit.types();
        if (types.isEmpty()) {
            return null;
        }
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        if (typeDeclaration == null) {
            return null;
        }
        this.packageName = this.getPackageName(unit);
        bizEnum.setPackage(this.packageName);
        this.imports = unit.imports();
        this.assignClass(typeDeclaration, bizEnum);
        this.assignFields(typeDeclaration, bizEnum);
        if (this.fieldType != null) {
            BizEnumValueType valueType = BizEnumValueType.INTEGER;
            if (this.fieldType.isPrimitiveType()) {
                if (PrimitiveType.toCode((String)this.fieldType.toString()).equals(PrimitiveType.INT)) {
                    valueType = BizEnumValueType.INTEGER;
                } else if (PrimitiveType.toCode((String)this.fieldType.toString()).equals(PrimitiveType.LONG)) {
                    valueType = BizEnumValueType.LONG;
                } else if (PrimitiveType.toCode((String)this.fieldType.toString()).equals(PrimitiveType.FLOAT)) {
                    valueType = BizEnumValueType.FLOAT;
                } else if (PrimitiveType.toCode((String)this.fieldType.toString()).equals(PrimitiveType.DOUBLE)) {
                    valueType = BizEnumValueType.DOUBLE;
                }
            } else {
                valueType = BizEnumValueType.STRING;
            }
            bizEnum.setDataType(valueType);
        }
        return bizEnum;
    }

    private void assignClass(TypeDeclaration typeDeclaration, BizEnumInfo bizEnum) {
        SimpleName typeName = typeDeclaration.getName();
        bizEnum.setName(typeName.toString());
        bizEnum.setClassName(this.packageName + "." + typeName.toString());
        String qName = this.packageName + "." + typeName.getIdentifier();
        super.getXJavaDoc().reset(false);
        super.getXJavaDoc().addAbstractFile(qName, (AbstractFile)this.xJavadocFile);
        this.xClass = super.getXJavaDoc().getXClass(qName);
        XDoc xDoc = this.xClass.getDoc();
        String comment = xDoc.getCommentText();
        if (comment != null) {
            bizEnum.setDescription(comment);
        }
        for (XTag xTag : xDoc.getTags()) {
            String name = xTag.getName();
            String value = xTag.getValue();
            if (name.equalsIgnoreCase("alias")) {
                bizEnum.setAlias(value);
                continue;
            }
            if (name.equalsIgnoreCase("stereotype")) continue;
            bizEnum.setExtendedProperty("[Javadoc]" + name, value);
        }
    }

    private void assignFields(TypeDeclaration typeDeclaration, BizEnumInfo bizEnum) {
        FieldDeclaration[] fields = typeDeclaration.getFields();
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                FieldDeclaration field = fields[i];
                int fieldModifier = field.getModifiers();
                this.fieldType = field.getType();
                List fieldNames = field.fragments();
                if (fieldNames.isEmpty()) continue;
                for (VariableDeclarationFragment var : fieldNames) {
                    XField xField;
                    String fieldName = var.getName().toString();
                    int dimension = var.getExtraDimensions();
                    Expression initializer = var.getInitializer();
                    BizEnumValueInfo valueInfo = new BizEnumValueInfo();
                    if (this.xClass != null && fieldName != null && (xField = this.xClass.getField(fieldName)) != null) {
                        XDoc xDoc = xField.getDoc();
                        for (XTag xTag : xDoc.getTags()) {
                            String name = xTag.getName();
                            String value = xTag.getValue();
                            if (!name.equalsIgnoreCase("alias")) continue;
                            valueInfo.setAlias(value);
                        }
                    }
                    valueInfo.setName(fieldName);
                    try {
                        String value = initializer.toString();
                        if (this.fieldType.isPrimitiveType()) {
                            valueInfo.setValue(value);
                        } else {
                            valueInfo.setValue(value.substring(1, value.length() - 1));
                        }
                        bizEnum.getEnumValue().add(valueInfo);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private CompilationUnit constructClass(BizEnumInfo bizEnum) throws TranslateException {
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("org.eclipse.jdt.core.compiler.source", "1.4");
            AST ast = new AST(m);
            CompilationUnit unit = ast.newCompilationUnit();
            PackageDeclaration packageDeclaration = ast.newPackageDeclaration();
            String[] packageNames = StringUtils.split((String)bizEnum.getPackage(), (String)".");
            Object packageName = null;
            packageName = packageNames != null && packageNames.length > 1 ? ast.newName(packageNames) : (!bizEnum.getPackage().equals("") ? ast.newSimpleName(bizEnum.getPackage()) : ast.newSimpleName("default"));
            packageDeclaration.setName(packageName);
            unit.setPackage(packageDeclaration);
            TypeDeclaration type = ast.newTypeDeclaration();
            type.setInterface(false);
            type.setModifiers(1);
            type.setName(ast.newSimpleName(bizEnum.getName()));
            BizEnumValueCollection items = bizEnum.getEnumValue();
            Iterator it = items.iterator();
            while (it.hasNext()) {
                BizEnumValueInfo itemInfo = (BizEnumValueInfo)it.next();
                this.addField(type, bizEnum, itemInfo);
            }
            Javadoc topComment = ast.newJavadoc();
            topComment.setComment(this.getTypeJavadoc(bizEnum));
            type.setJavadoc(topComment);
            unit.types().add(type);
            return unit;
        }
        catch (TranslateException se) {
            throw se;
        }
        catch (Exception e) {
            throw new TranslateException(e);
        }
    }

    private void addField(TypeDeclaration type, BizEnumInfo bizEnum, BizEnumValueInfo itemInfo) throws TranslateException {
        try {
            AST ast = type.getAST();
            VariableDeclarationFragment variableDeclarationFragment = ast.newVariableDeclarationFragment();
            variableDeclarationFragment.setName(ast.newSimpleName(itemInfo.getName()));
            FieldDeclaration fieldDeclaration = ast.newFieldDeclaration(variableDeclarationFragment);
            PrimitiveType fieldType = ast.newPrimitiveType(PrimitiveType.INT);
            BizEnumValueType valueType = bizEnum.getDataType();
            if (valueType != null) {
                if (valueType.equals((Object)BizEnumValueType.INTEGER)) {
                    fieldType = ast.newPrimitiveType(PrimitiveType.INT);
                } else if (valueType.equals((Object)BizEnumValueType.LONG)) {
                    fieldType = ast.newPrimitiveType(PrimitiveType.LONG);
                } else if (valueType.equals((Object)BizEnumValueType.FLOAT)) {
                    fieldType = ast.newPrimitiveType(PrimitiveType.FLOAT);
                } else if (valueType.equals((Object)BizEnumValueType.DOUBLE)) {
                    fieldType = ast.newPrimitiveType(PrimitiveType.DOUBLE);
                } else if (valueType.equals((Object)BizEnumValueType.STRING)) {
                    fieldType = ast.newSimpleType((Name)ast.newSimpleName("String"));
                }
            }
            fieldDeclaration.setType((Type)fieldType);
            fieldDeclaration.setModifiers(25);
            if (fieldType.isPrimitiveType()) {
                variableDeclarationFragment.setInitializer((Expression)ast.newNumberLiteral(itemInfo.getValue().toString()));
            } else {
                StringLiteral literal = ast.newStringLiteral();
                literal.setLiteralValue(itemInfo.getValue().toString());
                variableDeclarationFragment.setInitializer((Expression)literal);
            }
            if (itemInfo.getAlias() != null && itemInfo.getAlias().length() > 0) {
                StringBuffer comment = new StringBuffer("\n\n/**");
                comment.append("\n* @alias ").append(itemInfo.getAlias());
                comment.append("\n*").append("\n*/");
                Javadoc javaDoc = ast.newJavadoc();
                javaDoc.setComment(comment.toString());
                fieldDeclaration.setJavadoc(javaDoc);
            }
            type.bodyDeclarations().add(fieldDeclaration);
        }
        catch (IllegalArgumentException e) {
            TranslateException se = new TranslateException("\u53c2\u6570\u9519\u8bef");
            throw se;
        }
    }
}

