/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.translate;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.code.internal.ASTFlattener;
import com.kingdee.bos.metadata.code.translate.JdtBosTranslator;
import com.kingdee.bos.metadata.code.translate.TranslateException;
import com.kingdee.bos.metadata.resource.BizExceptionInfo;
import com.kingdee.bos.metadata.resource.BizExceptionSubItemCollection;
import com.kingdee.bos.metadata.resource.BizExceptionSubItemInfo;
import com.kingdee.util.StringUtils;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import xjavadoc.XClass;
import xjavadoc.XDoc;
import xjavadoc.XTag;
import xjavadoc.filesystem.AbstractFile;

public class ExceptionTranslator
extends JdtBosTranslator {
    private XClass xClass;

    @Override
    protected AbstractMetaDataValue getMetaData(CompilationUnit unit) {
        BizExceptionInfo bizException = new BizExceptionInfo();
        bizException = this.assignException(unit, bizException);
        return bizException;
    }

    @Override
    public String transBos2Jdt(AbstractMetaDataValue metaData) throws TranslateException {
        BizExceptionInfo bizException = null;
        String result = "";
        if (!(metaData instanceof BizExceptionInfo)) {
            return result;
        }
        bizException = (BizExceptionInfo)metaData;
        try {
            CompilationUnit unit = this.constructClass(bizException);
            ASTFlattener flattener = new ASTFlattener();
            flattener.visit(unit);
            result = flattener.getFormattedResult(0, "\r\n");
        }
        catch (TranslateException se) {
            throw se;
        }
        catch (Exception e) {
            throw new TranslateException(e);
        }
        return result;
    }

    private BizExceptionInfo assignException(CompilationUnit unit, BizExceptionInfo bizException) {
        List types = unit.types();
        if (types.isEmpty()) {
            return null;
        }
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        if (typeDeclaration == null) {
            return null;
        }
        this.packageName = this.getPackageName(unit);
        bizException.setPackage(this.packageName);
        this.imports = unit.imports();
        this.assignClass(typeDeclaration, bizException);
        this.assignFields(typeDeclaration, bizException);
        return bizException;
    }

    private void assignClass(TypeDeclaration typeDeclaration, BizExceptionInfo bizException) {
        SimpleName typeName = typeDeclaration.getName();
        bizException.setName(typeName.toString());
        bizException.setClassName(this.packageName + "." + typeName.toString());
        String qName = this.packageName + "." + typeName.getIdentifier();
        super.getXJavaDoc().reset(false);
        super.getXJavaDoc().addAbstractFile(qName, (AbstractFile)this.xJavadocFile);
        this.xClass = super.getXJavaDoc().getXClass(qName);
        XDoc xDoc = this.xClass.getDoc();
        String comment = xDoc.getCommentText();
        if (comment != null) {
            bizException.setDescription(comment);
        }
        for (XTag xTag : xDoc.getTags()) {
            String name = xTag.getName();
            String value = xTag.getValue();
            if (name.equalsIgnoreCase("alias")) {
                bizException.setAlias(value);
                continue;
            }
            if (name.equalsIgnoreCase("stereotype")) continue;
            bizException.setExtendedProperty("[Javadoc]" + name, value);
        }
        SecureRandom random = new SecureRandom();
        int mainCode = random.nextInt(99);
        if (mainCode < 10) {
            bizException.setMainCode("0" + Integer.toString(mainCode));
        } else {
            bizException.setMainCode(Integer.toString(mainCode));
        }
        Name superName = typeDeclaration.getSuperclass();
        BizExceptionInfo base = new BizExceptionInfo();
        if (superName != null) {
            String sName = superName.toString();
            if (sName.indexOf(".") > 0) {
                base.setName(sName.substring(sName.lastIndexOf(".")));
                base.setPackage(sName.substring(0, sName.lastIndexOf(".")));
            } else {
                base.setName(sName);
                if (!this.imports.isEmpty()) {
                    for (ImportDeclaration importDeclaration : this.imports) {
                        String importName = importDeclaration.getName().toString();
                        if (importName.indexOf(sName) <= 0) continue;
                        base.setPackage(importName.substring(0, importName.length() - sName.length() - 1));
                    }
                }
            }
            bizException.setBaseException(base);
        }
    }

    private void assignFields(TypeDeclaration typeDeclaration, BizExceptionInfo bizException) {
        FieldDeclaration[] fields = typeDeclaration.getFields();
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                FieldDeclaration field = fields[i];
                int fieldModifier = field.getModifiers();
                Type fieldType = field.getType();
                Javadoc javaDoc = field.getJavadoc();
                List fieldNames = field.fragments();
                if (fieldNames.isEmpty()) continue;
                for (VariableDeclarationFragment var : fieldNames) {
                    String fieldName = var.getName().toString();
                    int dimension = var.getExtraDimensions();
                    Expression initializer = var.getInitializer();
                    BizExceptionSubItemInfo subItemInfo = new BizExceptionSubItemInfo();
                    subItemInfo.setName(fieldName);
                    try {
                        String subCode = initializer.toString();
                        if (subCode.length() < 2) {
                            subCode = "00" + subCode;
                        } else if (subCode.length() < 3) {
                            subCode = "0" + subCode;
                        }
                        subItemInfo.setSubCode(subCode);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    bizException.getBizExceptionSubItems().add(subItemInfo);
                }
            }
        }
    }

    private CompilationUnit constructClass(BizExceptionInfo bizException) throws TranslateException {
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("org.eclipse.jdt.core.compiler.source", "1.4");
            AST ast = new AST(m);
            CompilationUnit unit = ast.newCompilationUnit();
            PackageDeclaration packageDeclaration = ast.newPackageDeclaration();
            String[] packageNames = StringUtils.split((String)bizException.getPackage(), (String)".");
            Object packageName = null;
            packageName = packageNames != null && packageNames.length > 1 ? ast.newName(packageNames) : (!bizException.getPackage().equals("") ? ast.newSimpleName(bizException.getPackage()) : ast.newSimpleName("default"));
            packageDeclaration.setName(packageName);
            unit.setPackage(packageDeclaration);
            TypeDeclaration type = ast.newTypeDeclaration();
            type.setInterface(false);
            type.setModifiers(1);
            type.setName(ast.newSimpleName(bizException.getName()));
            BizExceptionInfo base = bizException.getBaseException();
            if (base != null) {
                if (base.getName().indexOf(".") > 0) {
                    String[] baseNames = StringUtils.split((String)base.getName(), (String)".");
                    type.setSuperclass(ast.newName(baseNames));
                } else {
                    type.setSuperclass((Name)ast.newSimpleName(base.getName()));
                }
            }
            BizExceptionSubItemCollection items = bizException.getBizExceptionSubItems();
            Iterator it = items.iterator();
            while (it.hasNext()) {
                BizExceptionSubItemInfo itemInfo = (BizExceptionSubItemInfo)it.next();
                this.addField(type, itemInfo);
            }
            Javadoc topComment = ast.newJavadoc();
            topComment.setComment(this.getTypeJavadoc(bizException));
            type.setJavadoc(topComment);
            unit.types().add(type);
            return unit;
        }
        catch (TranslateException se) {
            throw se;
        }
        catch (Exception e) {
            throw new TranslateException(e);
        }
    }

    private void addField(TypeDeclaration type, BizExceptionSubItemInfo itemInfo) throws TranslateException {
        try {
            AST ast = type.getAST();
            VariableDeclarationFragment variableDeclarationFragment = ast.newVariableDeclarationFragment();
            variableDeclarationFragment.setName(ast.newSimpleName(itemInfo.getName()));
            FieldDeclaration fieldDeclaration = ast.newFieldDeclaration(variableDeclarationFragment);
            fieldDeclaration.setType((Type)ast.newPrimitiveType(PrimitiveType.INT));
            fieldDeclaration.setModifiers(25);
            variableDeclarationFragment.setInitializer((Expression)ast.newNumberLiteral(itemInfo.getSubCode()));
            if (itemInfo.getMessage() != null && itemInfo.getMessage().length() > 0) {
                StringBuffer comment = new StringBuffer("\n\n/**");
                comment.append("\n* @alias ").append(itemInfo.getMessage());
                comment.append("\n*").append("\n*/");
                Javadoc javaDoc = ast.newJavadoc();
                javaDoc.setComment(comment.toString());
                fieldDeclaration.setJavadoc(javaDoc);
            }
            type.bodyDeclarations().add(fieldDeclaration);
        }
        catch (IllegalArgumentException e) {
            TranslateException se = new TranslateException("\u53c2\u6570\u9519\u8bef");
            throw se;
        }
    }
}

