/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.translate;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.code.translate.IJdtBosTranslator;
import com.kingdee.bos.metadata.code.translate.TranslateException;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizExceptionInfo;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Type;
import xjavadoc.XJavaDoc;
import xjavadoc.filesystem.XJavadocFile;

public abstract class JdtBosTranslator
implements IJdtBosTranslator {
    protected static final String JAVADOC_PREFIX = "[Javadoc]";
    protected String packageName;
    protected List imports;
    private static XJavaDoc xJavaDoc;
    protected XJavadocFile xJavadocFile;

    public XJavaDoc getXJavaDoc() {
        if (xJavaDoc == null) {
            xJavaDoc = new XJavaDoc();
        }
        return xJavaDoc;
    }

    @Override
    public AbstractMetaDataValue transJdt2Bos(IFile javaFile) throws TranslateException {
        CompilationUnit unit = this.getUnit(javaFile);
        AbstractMetaDataValue amdv = this.getMetaData(unit);
        this.xJavadocFile = null;
        xJavaDoc = null;
        return amdv;
    }

    protected CompilationUnit getUnit(IFile javaFile) throws TranslateException {
        try {
            this.xJavadocFile = new XJavadocFile(javaFile.getLocation().toFile());
            ICompilationUnit iUnit = JavaCore.createCompilationUnitFrom((IFile)javaFile);
            CompilationUnit unit = AST.parseCompilationUnit((ICompilationUnit)iUnit, (boolean)false);
            return unit;
        }
        catch (Exception e) {
            throw new TranslateException(e);
        }
    }

    protected abstract AbstractMetaDataValue getMetaData(CompilationUnit var1);

    @Override
    public abstract String transBos2Jdt(AbstractMetaDataValue var1) throws TranslateException;

    protected int getModifiers(String accessLevel, String subClassingMode) {
        int modifiers = 0;
        if (accessLevel == null) {
            accessLevel = "";
        }
        if (subClassingMode == null) {
            subClassingMode = "";
        }
        if (accessLevel.equalsIgnoreCase("public")) {
            ++modifiers;
        } else if (accessLevel.equalsIgnoreCase("private")) {
            modifiers += 2;
        } else if (accessLevel.equalsIgnoreCase("protected")) {
            modifiers += 4;
        }
        if (subClassingMode.equalsIgnoreCase("abstract")) {
            modifiers += 1024;
        } else if (subClassingMode.equalsIgnoreCase("final")) {
            modifiers += 16;
        }
        return modifiers;
    }

    protected Type getType(String type, AST ast) {
        Object returnType = null;
        if (type == null || type.equals("")) {
            type = "void";
        }
        String baseType = type;
        int position = type.indexOf("[");
        boolean isArray = false;
        if (position > 0) {
            baseType = type.substring(0, position);
            isArray = true;
        }
        returnType = baseType.equals("boolean") ? ast.newPrimitiveType(PrimitiveType.BOOLEAN) : (baseType.equals("byte") ? ast.newPrimitiveType(PrimitiveType.BYTE) : (baseType.equals("short") ? ast.newPrimitiveType(PrimitiveType.SHORT) : (baseType.equals("int") ? ast.newPrimitiveType(PrimitiveType.INT) : (baseType.equals("long") ? ast.newPrimitiveType(PrimitiveType.LONG) : (baseType.equals("char") ? ast.newPrimitiveType(PrimitiveType.CHAR) : (baseType.equals("float") ? ast.newPrimitiveType(PrimitiveType.FLOAT) : (baseType.equals("double") ? ast.newPrimitiveType(PrimitiveType.DOUBLE) : (baseType.equals("void") ? ast.newPrimitiveType(PrimitiveType.VOID) : ast.newSimpleType(ast.newName(baseType))))))))));
        if (isArray) {
            int dimension = 1;
            while (type.indexOf("[", position + 1) > 0) {
                position = type.indexOf("[", position + 1) + 1;
                ++dimension;
            }
            for (int i = 0; i < dimension; ++i) {
                returnType = ast.newArrayType((Type)returnType);
            }
        }
        return returnType;
    }

    protected String constructDataTypeArray(Type dataType, int dimension) {
        if (dimension == 0) {
            return dataType.toString();
        }
        StringBuffer newType = new StringBuffer(dataType.toString());
        for (int i = 0; i < dimension; ++i) {
            newType.append("[]");
        }
        return newType.toString();
    }

    protected String getAccessLevel(int modifier) {
        String accessLevel = "friendly";
        if (Modifier.isPublic((int)modifier)) {
            accessLevel = "public";
        } else if (Modifier.isPrivate((int)modifier)) {
            accessLevel = "private";
        } else if (Modifier.isProtected((int)modifier)) {
            accessLevel = "protected";
        }
        return accessLevel;
    }

    protected String getSubClassingMode(int modifier) {
        String subClassingMode = "normal";
        if (Modifier.isAbstract((int)modifier)) {
            subClassingMode = "abstract";
        } else if (Modifier.isFinal((int)modifier)) {
            subClassingMode = "final";
        }
        return subClassingMode;
    }

    protected String getPackageName(CompilationUnit unit) {
        PackageDeclaration packageDeclaration = unit.getPackage();
        String packageName = "default";
        if (packageDeclaration != null) {
            packageName = packageDeclaration.getName().toString();
        }
        return packageName;
    }

    protected String getTypeJavadoc(AbstractMetaDataValue metaData) {
        StringBuffer comment = new StringBuffer("\n\n/**\n* \u6b64\u7c7b\u7531Kingdee BOS Studio\u81ea\u52a8\u751f\u6210\n*");
        String description = metaData.getDescription();
        if (description != null && description.length() > 0) {
            StringTokenizer st = new StringTokenizer(description);
            while (st.hasMoreTokens()) {
                comment.append("\n* ").append(st.nextToken());
            }
        }
        StringBuffer today = new StringBuffer();
        GregorianCalendar calendar = new GregorianCalendar();
        today.append(calendar.get(1)).append("/");
        today.append(calendar.get(2)).append("/");
        today.append(calendar.get(5));
        comment.append("\n*\n* @author BOS Studio date:").append(today.toString());
        comment.append("\t<p>");
        comment.append("\n* @stereotype ");
        if (metaData instanceof EntityObjectInfo) {
            comment.append("entity");
        } else if (metaData instanceof FacadeInfo) {
            comment.append("control");
        } else if (metaData instanceof BizExceptionInfo) {
            comment.append("exception");
        } else if (metaData instanceof BizEnumInfo) {
            comment.append("enumeration");
        }
        String alias = metaData.getAlias();
        if (alias != null && alias.length() > 0) {
            comment.append("\n* @alias ").append(alias);
        }
        for (String key : metaData.getExtendedProperties().keySet()) {
            if (!key.startsWith(JAVADOC_PREFIX) || key.indexOf("_") != -1) continue;
            String tag = key.substring(JAVADOC_PREFIX.length());
            String value = (String)metaData.getExtendedProperties().get(key);
            comment.append("\n* @").append(tag).append(" ").append(value);
        }
        comment.append("\n* @version");
        comment.append("\n* @see");
        comment.append("\n*\n*/");
        String aComment = comment.toString();
        comment = null;
        return aComment;
    }

    protected StringBuffer getMethodJavadocHeader(MethodInfo methodInfo) {
        String alias;
        StringBuffer comment = new StringBuffer("\n\n/**");
        String description = methodInfo.getDescription();
        if (description != null && description.length() > 0) {
            StringTokenizer st = new StringTokenizer(description);
            while (st.hasMoreTokens()) {
                comment.append("\n* ").append(st.nextToken());
            }
        }
        if ((alias = methodInfo.getAlias()) != null && alias.length() > 0) {
            comment.append("\n* @alias ").append(alias);
        }
        return comment;
    }
}

