/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.translate;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.code.translate.EntityTranslator;
import com.kingdee.bos.metadata.code.translate.EnumTranslator;
import com.kingdee.bos.metadata.code.translate.ExceptionTranslator;
import com.kingdee.bos.metadata.code.translate.FacadeTranslator;
import com.kingdee.bos.metadata.code.translate.IJdtBosTranslator;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizExceptionInfo;
import org.eclipse.core.resources.IFile;
import xjavadoc.XClass;
import xjavadoc.XDoc;
import xjavadoc.XJavaDoc;
import xjavadoc.XTag;
import xjavadoc.filesystem.AbstractFile;
import xjavadoc.filesystem.XJavadocFile;

public class JdtTranslatorFactory {
    private static JdtTranslatorFactory factory;
    private static EntityTranslator entityTranslator;
    private static ExceptionTranslator exceptionTranslator;
    private static EnumTranslator enumTranslator;
    private static FacadeTranslator facadeTranslator;
    private static XJavaDoc xJavaDoc;

    private JdtTranslatorFactory() {
    }

    public static JdtTranslatorFactory getInstance() {
        if (factory == null) {
            factory = new JdtTranslatorFactory();
        }
        return factory;
    }

    public IJdtBosTranslator getTranslator(AbstractMetaDataValue metaData) {
        if (metaData instanceof EntityObjectInfo) {
            if (entityTranslator == null) {
                entityTranslator = new EntityTranslator();
            }
            return entityTranslator;
        }
        if (metaData instanceof BizExceptionInfo) {
            if (exceptionTranslator == null) {
                exceptionTranslator = new ExceptionTranslator();
            }
            return exceptionTranslator;
        }
        if (metaData instanceof BizEnumInfo) {
            if (enumTranslator == null) {
                enumTranslator = new EnumTranslator();
            }
            return enumTranslator;
        }
        if (metaData instanceof FacadeInfo) {
            if (facadeTranslator == null) {
                facadeTranslator = new FacadeTranslator();
            }
            return facadeTranslator;
        }
        return null;
    }

    public XJavaDoc getXJavaDoc() {
        if (xJavaDoc == null) {
            xJavaDoc = new XJavaDoc();
        }
        return xJavaDoc;
    }

    public IJdtBosTranslator getTranslator(IFile javaFile) {
        XJavadocFile xJavadocFile = new XJavadocFile(javaFile.getLocation().toFile());
        this.getXJavaDoc().reset(false);
        this.getXJavaDoc().addAbstractFile(javaFile.getName(), (AbstractFile)xJavadocFile);
        XClass xClass = this.getXJavaDoc().getXClass(javaFile.getName());
        XDoc xDoc = xClass.getDoc();
        for (XTag xTag : xDoc.getTags()) {
            String name = xTag.getName();
            String value = xTag.getValue();
            if (!name.equalsIgnoreCase("stereotype")) continue;
            if (value.equalsIgnoreCase("entity")) {
                if (entityTranslator == null) {
                    entityTranslator = new EntityTranslator();
                }
                return entityTranslator;
            }
            if (value.equalsIgnoreCase("exception")) {
                if (exceptionTranslator == null) {
                    exceptionTranslator = new ExceptionTranslator();
                }
                return exceptionTranslator;
            }
            if (value.equalsIgnoreCase("enumeration")) {
                if (enumTranslator == null) {
                    enumTranslator = new EnumTranslator();
                }
                return enumTranslator;
            }
            if (!value.equalsIgnoreCase("control")) continue;
            if (facadeTranslator == null) {
                facadeTranslator = new FacadeTranslator();
            }
            return facadeTranslator;
        }
        return null;
    }
}

