/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.webui;

import com.kingdee.bos.metadata.code.CodeFactory;
import com.kingdee.bos.metadata.code.webui.CodeWriter;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;

public class BaseWebUIEntryGenerator
extends CodeWriter {
    protected EntityObjectInfo childInfo;
    protected String packageName;
    protected String className;
    protected String fullClassName;
    protected String shortPackage;
    protected String shortClassName;
    protected String rootPackage;
    protected String rootUrl;

    public BaseWebUIEntryGenerator(WebUIObjectInfo model, Object[] argument) {
        EntityObjectInfo entityInfo = (EntityObjectInfo)argument[0];
        String billEntry = (String)argument[1];
        model = (WebUIObjectInfo)argument[2];
        this.childInfo = BaseWebUIEntryGenerator.getOne2ManyEntryType(entityInfo, billEntry);
        this.rootPackage = BaseWebUIEntryGenerator.rootPackage(entityInfo);
        this.packageName = model.getReleasePackage();
        this.className = this.childInfo.getName() + "Bean";
        this.fullClassName = this.packageName + "." + this.className;
        this.rootUrl = BaseWebUIEntryGenerator.rootUrl(this.rootPackage);
        this.shortPackage = CodeFactory.getWebUIShortPackage(this.packageName);
        this.shortClassName = this.shortPackage + "." + this.className;
    }

    @Override
    public String generate() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.genPackage() + "\n");
        sb.append(this.genImport() + "\n");
        sb.append(this.genClassDeclarationStart() + "\n");
        sb.append(this.genClassDeclarationEnd() + "\n");
        return sb.toString();
    }

    protected String genPackage() {
        return "package " + this.packageName + ";" + "\n";
    }

    protected String genImport() {
        StringBuffer sb = new StringBuffer();
        sb.append("import org.operamasks.faces.annotation.ManagedBean;\n");
        sb.append("import org.operamasks.faces.annotation.ManagedBeanScope;\n");
        sb.append("import com.kingdee.bos.util.BOSUuid;\n");
        sb.append("import com.kingdee.bos.waf.winlet.edit.BillEntryBean;\n");
        sb.append("import com.kingdee.eas.framework.CoreBaseInfo;\n");
        sb.append("import " + BaseWebUIEntryGenerator.getInfoClass(this.childInfo) + ";" + "\n");
        return sb.toString();
    }

    protected String genClassDeclarationStart() {
        return "public abstract class Abstract" + this.className + " extends BillEntryBean {" + "\n";
    }

    protected String genClassDeclarationEnd() {
        return "}\n";
    }
}

