/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.configure;

import com.kingdee.bos.dao.xml.impl.ConfigureResourceLoader;
import com.kingdee.bos.metadata.configure.DownloadList;
import com.kingdee.bos.metadata.configure.IConfigMDDownloader;
import com.kingdee.bos.metadata.configure.MetadataStoreUtil;
import com.kingdee.bos.metadata.configure.UpdateDoc;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.util.XMLParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;
import org.jdom2.Document;

public class ConfigMDDownloader
extends ORMObject
implements IConfigMDDownloader {
    private static Logger logger = Logger.getLogger(ConfigMDDownloader.class);
    private static Map aisToCmd;
    private static Map aisToDL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init() throws Exception {
        Map loaders = ConfigureResourceLoader.getAllLoaders();
        if (loaders == null || loaders.size() == 0) {
            return;
        }
        aisToCmd = new HashMap(8);
        aisToDL = new HashMap(8);
        for (Map.Entry me : loaders.entrySet()) {
            String ais = (String)me.getKey();
            ConfigureResourceLoader loader = (ConfigureResourceLoader)me.getValue();
            File file = new File(loader.getConfigureJar());
            if (file.exists()) {
                HashMap<String, UpdateDoc> temp = new HashMap<String, UpdateDoc>();
                JarFile jf = null;
                try {
                    jf = new JarFile(file);
                    Enumeration<JarEntry> enume = jf.entries();
                    while (enume.hasMoreElements()) {
                        String name;
                        JarEntry entry = enume.nextElement();
                        if (entry.isDirectory() || !MetadataStoreUtil.acceptSuffix(name = entry.getName())) continue;
                        InputStream is = jf.getInputStream(entry);
                        Document doc = XMLParser.parseXML((InputStream)is);
                        is.close();
                        String sizeTime = entry.getSize() + "_" + entry.getTime();
                        UpdateDoc ud = new UpdateDoc(name, doc, sizeTime);
                        temp.put(name, ud);
                    }
                }
                finally {
                    try {
                        if (jf != null) {
                            jf.close();
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)"close JarFile error!", (Throwable)e);
                    }
                }
                jf.close();
                long time = file.lastModified();
                ConfigMD cmd = new ConfigMD();
                cmd.time = time;
                cmd.pkToUd = temp;
                aisToCmd.put(ais, cmd);
                DownloadList all = new DownloadList(temp.values().toArray(new UpdateDoc[0]), null, time);
                aisToDL.put(ais, all);
                logger.info((Object)(ais + "ConfigMD DownloaderList size: " + temp.size()));
                continue;
            }
            logger.info((Object)(file + " not exists."));
        }
    }

    @Override
    public Map downloadAll(Map aisToPkToSizeTime) {
        if (aisToPkToSizeTime == null || aisToPkToSizeTime.size() == 0) {
            return aisToDL;
        }
        HashMap<String, DownloadList> rtv = new HashMap<String, DownloadList>(8);
        for (Map.Entry me : aisToPkToSizeTime.entrySet()) {
            Map pkToSizeTime;
            String ais = (String)me.getKey();
            DownloadList dl = this.download(ais, pkToSizeTime = (Map)me.getValue());
            if (dl == null) continue;
            rtv.put(ais, dl);
        }
        return rtv;
    }

    @Override
    public synchronized DownloadList download(String ais, Map pkToSizeTime) {
        UpdateDoc ud;
        if (aisToCmd == null) {
            return null;
        }
        ConfigMD cmd = (ConfigMD)aisToCmd.get(ais);
        if (cmd == null) {
            return null;
        }
        if (pkToSizeTime == null) {
            return (DownloadList)aisToDL.get(ais);
        }
        ArrayList<UpdateDoc> updates = new ArrayList<UpdateDoc>();
        ArrayList deletes = new ArrayList();
        for (Map.Entry entry : pkToSizeTime.entrySet()) {
            if (cmd.pkToUd == null || !cmd.pkToUd.keySet().contains(entry.getKey())) {
                deletes.add(entry.getKey());
                continue;
            }
            ud = (UpdateDoc)cmd.pkToUd.get(entry.getKey());
            if (entry.getValue().equals(ud.getsizeTime())) continue;
            updates.add(ud);
        }
        if (cmd.pkToUd != null) {
            for (Map.Entry entry : cmd.pkToUd.entrySet()) {
                if (pkToSizeTime.containsKey(entry.getKey())) continue;
                ud = (UpdateDoc)entry.getValue();
                updates.add(ud);
            }
        }
        UpdateDoc[] uds = updates.toArray(new UpdateDoc[0]);
        String[] dls = deletes.toArray(new String[0]);
        DownloadList dl = new DownloadList(uds, dls, cmd.time);
        return dl;
    }

    @Override
    public DownloadList download(Map pkToSizeTime) {
        return null;
    }

    static {
        try {
            ConfigMDDownloader.init();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private static class ConfigMD
    implements Serializable {
        Map pkToUd;
        long time = 0L;

        ConfigMD() {
        }

        ConfigMD(Map map, long t) {
            this.pkToUd = map;
            this.time = t;
        }
    }
}

