/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.configure;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.impl.DBConfigureResourceLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.IDBConfigMDDownloader;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DBConfigMDDownloader
extends ORMObject
implements IDBConfigMDDownloader {
    private static Logger logger = Logger.getLogger(DBConfigMDDownloader.class);
    public static final String DBCMDD_MINSIZE = "DBConfigMDDownloader.minSize";
    public static final String DBCMDD_MAXSIZE = "DBConfigMDDownloader.maxSize";
    private static Map aisToCache = new HashMap(8);
    private static int minSize = 300;
    private static int maxSize = 1000;
    private static int count = 0;
    private static Map aisToPksAMV = new HashMap(8);

    public static int getMinSize() {
        return minSize;
    }

    public static void setMinSize(int minSize) {
        DBConfigMDDownloader.minSize = minSize;
    }

    public static int getMaxSize() {
        return maxSize;
    }

    public static void setMaxSize(int maxSize) {
        DBConfigMDDownloader.maxSize = maxSize;
    }

    @Override
    public List getResource(IMetaDataPK pk, BOSObjectType type) throws BOSException {
        return DBConfigMDDownloader.getResource0(pk, type, null);
    }

    static synchronized List getResource0(IMetaDataPK pk, BOSObjectType type, Project.Projects depends) throws BOSException {
        if (pk == null || type == null) {
            return null;
        }
        String key = (depends = Project.Projects.getProjects(depends)).getKey();
        key = key == null ? pk.toString() : pk.toString() + key;
        String ais2 = ConfigMDUtil.getAIS();
        InnerCache cache = (InnerCache)aisToCache.get(ais2);
        if (cache != null && cache.resToOdmi.containsKey(key)) {
            return (List)cache.resToOdmi.get(key);
        }
        ArrayList orderedDmi = DBConfigureResourceLoader.getDynamicMetadatas(pk, type, depends);
        if (orderedDmi == null) {
            orderedDmi = new ArrayList();
        }
        if (count + orderedDmi.size() > maxSize) {
            count = 0;
            for (String ais2 : aisToCache.keySet()) {
                List temp;
                cache = (InnerCache)aisToCache.get(ais2);
                InnerCache nic = new InnerCache();
                int n = 0;
                for (int i = 0; i < cache.resNames.size() && n < minSize / aisToCache.size() + 1; n += temp.size(), ++i) {
                    String s = (String)cache.resNames.get(cache.resNames.size() - 1 - i);
                    temp = (List)cache.resToOdmi.get(s);
                    nic.add(s, temp);
                }
                aisToCache.put(ais2, nic);
                count += n;
            }
        }
        if (cache == null) {
            cache = new InnerCache();
            aisToCache.put(ais2, cache);
        }
        cache.add(key, orderedDmi);
        count += orderedDmi.size();
        return orderedDmi;
    }

    @Override
    public Map getMetaDataPKs() throws BOSException {
        return this.getMetaDataPKs(null);
    }

    @Override
    public Map getMetaDataPKs(Project.Projects depends) throws BOSException {
        return DBConfigMDDownloader.getMetaDataPKs0(depends);
    }

    static Map getMetaDataPKs0(Project.Projects depends) throws BOSException {
        return MDContextFactory.getSystemMDContext().pkIndexs.getMetaDataPKsFromDB(depends);
    }

    @Override
    public Map getMetaDataPKsAffectMdbview() throws BOSException {
        return DBConfigMDDownloader.getMetaDataPKsAffectMdbview0(null);
    }

    @Override
    public Map getMetaDataPKsAffectMdbview(Project.Projects depends) throws BOSException {
        return DBConfigMDDownloader.getMetaDataPKsAffectMdbview0(depends);
    }

    static Map getMetaDataPKsAffectMdbview0(Project.Projects depends) throws BOSException {
        String key = Project.Projects.getKey(depends);
        Map pks = (Map)aisToPksAMV.get(key);
        if (pks == null) {
            pks = DBConfigureResourceLoader.getMetaDataPKsAffectMdbview(depends);
            aisToPksAMV.put(key, pks);
        }
        return pks;
    }

    public static synchronized void clear() {
        DBConfigMDDownloader.clear(ConfigMDUtil.getAIS());
    }

    public static synchronized void clear(Context ctx) {
        DBConfigMDDownloader.clear(ConfigMDUtil.getAIS(ctx));
    }

    public static synchronized void clear(String ais) {
        InnerCache ic = (InnerCache)aisToCache.remove(ais);
        if (ic != null) {
            count -= ic.resNames.size();
        }
        aisToPksAMV.remove(ais);
        Iterator iterator = aisToPksAMV.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!key.startsWith(ais + "_")) continue;
            iterator.remove();
        }
    }

    @Override
    public List getResource(IMetaDataPK pk, BOSObjectType type, Project.Projects depends) throws BOSException {
        return DBConfigMDDownloader.getResource0(pk, type, depends);
    }

    @Override
    public String getResource(Project p, IMetaDataPK pk, BOSObjectType type) throws Exception {
        return DBConfigureResourceLoader.getResource(p, pk, type);
    }

    @Override
    public void deleteMetadata(Project p, IMetaDataPK pk, BOSObjectType type) throws Exception {
        DBConfigureResourceLoader.deleteMetadata(p, pk, type);
        MDContextFactory.getSystemMDContext().clear();
    }

    @Override
    public void saveResource(Project p, IMetaDataPK pk, BOSObjectType type, String xml) throws Exception {
        DBConfigureResourceLoader.saveResource(p, pk, type, xml);
        MDContextFactory.getSystemMDContext().clear();
    }

    static {
        String s = System.getProperty(DBCMDD_MAXSIZE);
        int i = -1;
        try {
            if (!StringUtils.isEmpty((String)s) && (i = Integer.parseInt(s)) >= 0 && i < 10000) {
                maxSize = i;
            }
            if (!StringUtils.isEmpty((String)(s = System.getProperty(DBCMDD_MINSIZE))) && (i = Integer.parseInt(s)) >= 0 && i <= maxSize) {
                minSize = i;
            }
        }
        catch (Exception e) {
            logger.warn((Object)e, (Throwable)e);
        }
    }

    private static class InnerCache {
        List resNames = new ArrayList();
        Map resToOdmi = new HashMap();

        InnerCache() {
        }

        InnerCache(List res, Map resToOdmi) {
            this.resNames = res;
            this.resToOdmi = resToOdmi;
        }

        void add(String resName, List orderedDmi) {
            this.resToOdmi.put(resName, orderedDmi);
            this.resNames.add(resName);
        }
    }
}

