/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.configure;

import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class Project
implements Serializable {
    private static final long serialVersionUID = 2340769775401844896L;
    public static final String ALWAYS_ON = "always_on";
    public static final String PZPT_UPGRADE = "pzpt_upgrade";
    private String id;
    private List<Project> depend;

    public Project() {
    }

    public Project(String id) {
        this.setId(id);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setDepend(List<Project> depend) {
        this.depend = depend;
    }

    public List<Project> getDepend() {
        return this.depend;
    }

    public void addDepend(Project p) {
        if (this.depend == null) {
            this.depend = new ArrayList<Project>();
        }
        this.depend.add(p);
    }

    boolean isDepend(Project[] prjs, int index) {
        if (index < 0 || this.depend == null || this.depend.size() <= 0) {
            return false;
        }
        for (int i = 0; i < this.depend.size(); ++i) {
            boolean parentDepend;
            Project d = this.depend.get(i);
            int dindex = Project.getIndex(prjs, d);
            if (dindex == index) {
                return true;
            }
            if (dindex < index || !(parentDepend = d.isDepend(prjs, index))) continue;
            return true;
        }
        return false;
    }

    private static int getIndex(Project[] prjs, Project p) {
        if (prjs != null) {
            for (int i = 0; i < prjs.length; ++i) {
                if (prjs[i] != p) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Project)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Project p = (Project)obj;
        if (this.id != null) {
            return this.id.equals(p.id);
        }
        return p.id == null;
    }

    public int hashCode() {
        if (this.id != null) {
            return this.id.hashCode();
        }
        return 0;
    }

    public String toString() {
        return this.id;
    }

    public static List<Project> getOrderedProjects(Project[] ps) {
        if (ps == null) {
            return null;
        }
        ArrayList<Project> psList = new ArrayList<Project>();
        for (int i = 0; i < ps.length; ++i) {
            Project.getOrderedProjects(ps[i], psList);
        }
        return psList;
    }

    private static void getOrderedProjects(Project p, List<Project> psList) {
        if (p.getId() == null) {
            return;
        }
        List<Project> depend = p.getDepend();
        if (depend != null && depend.size() > 0) {
            for (int i = 0; i < depend.size(); ++i) {
                Project pi = depend.get(i);
                if (psList.contains(pi)) continue;
                Project.getOrderedProjects(pi, psList);
            }
        }
        if (!psList.contains(p)) {
            psList.add(p);
        }
    }

    public static class Projects
    implements Serializable {
        private static final long serialVersionUID = 4376172127117831685L;
        private final Project[] virgin;
        private Project[] assart;
        private static final AtomicLong reAssartVersion = new AtomicLong(0L);
        private final String excludeProjectID;
        private long assartVersion;
        private String key4Ais = null;

        public boolean isExluedeAwaysOn() {
            return Project.ALWAYS_ON.equals(this.excludeProjectID);
        }

        static void reAssart(String ais) {
            reAssartVersion.getAndIncrement();
        }

        private Projects(Project[] virgin, String excludeProjectID) {
            this.virgin = virgin == null || virgin.length == 0 ? virgin : Project.getOrderedProjects(virgin).toArray(new Project[0]);
            this.assart = null;
            this.excludeProjectID = excludeProjectID;
            this.assartVersion = reAssartVersion.get();
        }

        public Project[] getValue() {
            Project[] prjs = this.getVirginValue();
            if (prjs != null && prjs.length > 0 && !StringUtils.isEmpty((String)this.excludeProjectID)) {
                prjs = this.exclude(prjs, this.excludeProjectID);
            }
            return prjs;
        }

        public Project[] getVirginValue() {
            return this.virgin;
        }

        private Project[] exclude(Project[] prjs, String excludeProjectID) {
            Project[] newprjs = new Project[prjs.length];
            int j = 0;
            int index = -1;
            for (int i = 0; i < prjs.length; ++i) {
                if (excludeProjectID.equals(prjs[i].getId())) {
                    index = i;
                    continue;
                }
                if (prjs[i].isDepend(prjs, index)) continue;
                newprjs[j] = prjs[i];
                ++j;
            }
            if (j == prjs.length) {
                return prjs;
            }
            try {
                Project[] ps = new Project[j];
                System.arraycopy(newprjs, 0, ps, 0, j);
                return ps;
            }
            catch (Exception exception) {
                return prjs;
            }
        }

        public Project[] getAssartValue() {
            long v = reAssartVersion.get();
            if (this.assart == null || this.assartVersion != v) {
                this.assartVersion = v;
                List<Project> ops = ConfigMDUtil.getOrderedProjects();
                if (ops == null || ops.size() == 0) {
                    this.assart = this.getValue();
                    return this.assart;
                }
                if (this.virgin == null && this.excludeProjectID == null) {
                    this.assart = ops.toArray(new Project[0]);
                    return this.assart;
                }
                boolean isAdd = false;
                if (this.virgin != null) {
                    for (int i = 0; i < this.virgin.length; ++i) {
                        if (ops.contains(this.virgin[i])) continue;
                        if (!isAdd) {
                            ops = new ArrayList<Project>(ops);
                        }
                        ops.add(this.virgin[i]);
                        isAdd = true;
                    }
                }
                this.assart = ops.toArray(new Project[0]);
                if (isAdd) {
                    this.assart = Project.getOrderedProjects(this.assart).toArray(new Project[0]);
                }
                if (this.excludeProjectID != null) {
                    this.assart = this.exclude(this.assart, this.excludeProjectID);
                }
                return this.assart;
            }
            return this.assart;
        }

        public String getKey() {
            if (!Projects.isNeedHandle(this)) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            Project[] pros = this.getVirginValue();
            if (pros != null) {
                for (int i = 0; i < pros.length; ++i) {
                    sb.append(pros[i].getId());
                    sb.append("_");
                }
            }
            if (!StringUtils.isEmpty((String)this.excludeProjectID)) {
                sb.append("!");
                sb.append(this.excludeProjectID);
            }
            return "_" + sb.toString();
        }

        private String getKey4Ais() {
            if (this.key4Ais != null) {
                return this.key4Ais;
            }
            if (!ConfigMDUtil.checkAIS()) {
                return null;
            }
            String ais = ConfigMDUtil.getAIS();
            String key = this.getKey();
            this.key4Ais = key != null ? ais + key : ais;
            return this.key4Ais;
        }

        public static String getKey(Projects depends) {
            if (!ConfigMDUtil.checkAIS()) {
                return null;
            }
            if (depends == null) {
                return ConfigMDUtil.getAIS();
            }
            return depends.getKey4Ais();
        }

        private boolean isEmpty() {
            return Projects.isEmpty(this.virgin);
        }

        private boolean existExclude() {
            return !StringUtils.isEmpty((String)this.excludeProjectID);
        }

        public static boolean isNeedHandle(Projects p) {
            return !p.isEmpty() || p.existExclude();
        }

        public static boolean isEmpty(Project[] prjs) {
            return prjs == null || prjs.length <= 0;
        }

        public static Project[] getProjects(String[] pids) {
            Project[] depends = null;
            if (pids != null) {
                depends = new Project[pids.length];
                for (int i = 0; i < depends.length; ++i) {
                    depends[i] = new Project(pids[i]);
                }
            }
            return depends;
        }

        public static Projects getProjects(String[] pids, String excludePID) {
            return Projects.getProjects(Projects.getProjects(pids), excludePID);
        }

        public static Projects getProjects(Project[] ps) {
            return Projects.getProjects(ps, null);
        }

        public static Projects getProjects(Project[] ps, String excludePID) {
            return new Projects(ps, excludePID);
        }

        public static Projects getProjects(Project project) {
            if (project == null) {
                return new Projects(null, null);
            }
            return Projects.getProjects(new Project[]{project});
        }

        public static Projects getProjects(Projects ps) {
            if (ps == null) {
                ps = new Projects(null, null);
            }
            return ps;
        }
    }
}

