/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.data;

import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.validate.IValidate;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.io.Serializable;

public class ColumnInfo
extends AbstractMDElement
implements Serializable,
IValidate {
    private static final BOSObjectType BOS_TYPE = BOSObjectType.create((String)"coln");
    public static final String _STATE_ = "_state_";
    private transient String name = null;
    private transient SQLType sqlType = null;
    private static final ColumnInfo NULL = new ColumnInfo();

    public ColumnInfo() {
        this.init();
    }

    @Override
    protected void clearVariableWhenValueChanged(String key) {
        super.clearVariableWhenValueChanged(key);
        if ("name".equals(key)) {
            this.name = null;
            return;
        }
        if ("sqlType".equals(key)) {
            this.sqlType = null;
            return;
        }
        if ("isMultilingual".equals(key) && "FName".equalsIgnoreCase(this.getName()) && !this.isMultilingual()) {
            return;
        }
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getString("name");
        }
        return this.name;
    }

    public void setName(String name) {
        this.setString("name", name);
    }

    public String getAlias() {
        return this.getString("alias");
    }

    public void setAlias(String alias) {
        this.setString("alias", alias);
    }

    public String getDescription() {
        return this.getString("description");
    }

    public void setDescription(String description) {
        this.setString("description", description);
    }

    public boolean isMultilingual() {
        return this.getBoolean("isMultilingual");
    }

    public void setMultilingual(boolean multilingual) {
        this.setBoolean("isMultilingual", multilingual);
    }

    public void setDefaultValue(String defaultValue) {
        this.put("defaultValue", defaultValue);
    }

    public boolean isEncoded() {
        return this.getBoolean("isEncoded");
    }

    public void setEncoded(boolean encoded) {
        this.setBoolean("isEncoded", encoded);
    }

    public SQLType getTypeName() {
        if (this.sqlType == null) {
            this.sqlType = SQLType.getEnum(this.getString("sqlType"));
            if (this.sqlType == null) {
                this.sqlType = SQLType.VARCHAR;
            }
        }
        return this.sqlType;
    }

    public void setTypeName(SQLType type) {
        if (type != null) {
            this.setString("sqlType", type.getName());
        }
    }

    public int getSQLType() {
        return this.getTypeName().getSQLType();
    }

    public int getLength() {
        return this.getInt("length");
    }

    public void setLength(int len) {
        this.setInt("length", len);
    }

    public int getPrecision() {
        return this.getInt("precision");
    }

    public void setPrecision(int precision) {
        this.setInt("precision", precision);
    }

    public int getScale() {
        return this.getInt("scale");
    }

    public void setScale(int scale) {
        this.setInt("scale", scale);
    }

    public boolean isNullable() {
        return this.getBoolean("isNullable");
    }

    public void setNullable(boolean b) {
        this.setBoolean("isNullable", b);
    }

    @Override
    public ValidateList validate() {
        ValidateMetaData vld = new ValidateMetaData();
        DrSQLFormater formater = new DrSQLFormater();
        if (!formater.isValidateColumnName(this.getName())) {
            vld.addError("invalid name of column :" + this.getName());
        }
        if (!StringUtils.isEmpty((String)this.getDefaultValue())) {
            try {
                TypeConversionUtils.stringToObject((int)this.getSQLType(), (String)this.getDefaultValue());
            }
            catch (IllegalConversionException ice) {
                vld.addError("Invalid default value of column " + this.getName() + ": '" + this.getDefaultValue() + "'");
            }
        }
        if (!this.isNullable() && this.isMultilingual()) {
            vld.addError("Column " + this.getName() + ": not-nullable and multilingual.");
        }
        if (this.getTypeName().equals(SQLType.CHAR)) {
            if (this.getLength() > 254 || this.getLength() <= 0) {
                vld.addError("Invalid length of column " + this.getName() + ": " + this.getLength());
            }
        } else if (this.getTypeName().equals(SQLType.NCHAR)) {
            if (this.getLength() > 254 || this.getLength() <= 0) {
                vld.addError("Invalid length of column " + this.getName() + ": " + this.getLength());
            }
        } else if (this.getTypeName().equals(SQLType.VARCHAR)) {
            if (this.getLength() > 4000 || this.getLength() <= 0) {
                vld.addError("Invalid length of column " + this.getName() + ": " + this.getLength());
            }
        } else if (this.getTypeName().equals(SQLType.NVARCHAR)) {
            if (this.getLength() > 2000 || this.getLength() <= 0) {
                vld.addError("Invalid length of column " + this.getName() + ": " + this.getLength());
            }
        } else if (this.getTypeName().equals(SQLType.CLOB)) {
            if (this.getLength() > 0x40000000 || this.getLength() <= 0) {
                vld.addError("Invalid length of column " + this.getName() + ": " + this.getLength());
            }
        } else if (this.getTypeName().equals(SQLType.BINARY) || this.getTypeName().equals(SQLType.VARBINARY)) {
            if (this.getLength() > 2000 || this.getLength() <= 0) {
                vld.addError("Invalid length of column " + this.getName() + ": " + this.getLength());
            }
        } else if (this.getTypeName().equals(SQLType.BLOB)) {
            if (this.getLength() > Integer.MAX_VALUE || this.getLength() <= 0) {
                vld.addError("Invalid length of column " + this.getName() + ": " + this.getLength());
            }
        } else if (this.getTypeName().equals(SQLType.NUMERIC)) {
            if (this.getPrecision() > 38 || this.getPrecision() <= 0) {
                vld.addError("Invalid precision of column " + this.getName() + ": " + this.getPrecision());
            }
            if (this.getScale() > this.getPrecision() || this.getScale() < 0) {
                vld.addError("Invalid scale of column " + this.getName() + ": " + this.getScale());
            }
        }
        return vld.getValidateList();
    }

    public boolean equalsName(Object that) {
        if (that == this) {
            return true;
        }
        if (!(that instanceof ColumnInfo)) {
            return false;
        }
        ColumnInfo c1 = (ColumnInfo)that;
        if (this.getName() == null) {
            return false;
        }
        return this.getName().equalsIgnoreCase(c1.getName());
    }

    public boolean equals3(Object that) {
        return this.equalsDB(that);
    }

    public boolean equals2(Object that) {
        return this.equalsName(that);
    }

    public boolean equals1(Object that) {
        return this.equalsDB(that);
    }

    public boolean equalsDB(Object that) {
        if (!this.equalsName(that)) {
            return false;
        }
        ColumnInfo c1 = (ColumnInfo)that;
        if (!this.getTypeName().equals(c1.getTypeName())) {
            return false;
        }
        this.adjustCol();
        c1.adjustCol();
        if (this.getDefaultValue() == null ? c1.getDefaultValue() != null : !this.getDefaultValue().equals(c1.getDefaultValue())) {
            return false;
        }
        if (this.isNullable() != c1.isNullable()) {
            return false;
        }
        if (this.isMultilingual() != c1.isMultilingual()) {
            return false;
        }
        SQLType name = this.getTypeName();
        return !(SQLType.CHAR.equals(name) || SQLType.VARCHAR.equals(name) || SQLType.NCHAR.equals(name) || SQLType.NVARCHAR.equals(name) ? this.getLength() != c1.getLength() : SQLType.NUMERIC.equals(name) && (this.getPrecision() != c1.getPrecision() || this.getScale() != c1.getScale()));
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOS_TYPE;
    }

    public void setUserDefined(boolean isUserDefined) {
        this.put("userDefined", isUserDefined);
    }

    public boolean isUserDefined() {
        return this.getBoolean("userDefined");
    }

    public static final ColumnInfo cnulls(ColumnInfo col) {
        return col == null ? NULL : col;
    }

    public final ColumnInfo cvalue() {
        return this == NULL ? null : this;
    }

    public boolean isConfigured() {
        return "true".equalsIgnoreCase(this.getExtendedProperty("configured"));
    }

    public void setConfigured(boolean configured) {
        super.setExtendedProperty("configured", String.valueOf(configured));
    }

    public String getDefaultValue() {
        this.adjustCol();
        return this.getString("defaultValue");
    }

    private void adjustCol() {
        SQLType type = this.getTypeName();
        if (SQLType.BLOB.equals(type) || SQLType.BINARY.equals(type) || SQLType.VARBINARY.equals(type) || SQLType.CLOB.equals(type) || SQLType.NCLOB.equals(type) || SQLType.BLOB.equals(type)) {
            this.setNullable(true);
        }
        this.setDefaultValue(this.innerGetDefaultValue());
    }

    private String innerGetDefaultValue() {
        SQLType type = this.getTypeName();
        String value = this.getString("defaultValue");
        if (value == null) {
            if (this.isNullable()) {
                return null;
            }
            if (SQLType.NCHAR.equals(type) || SQLType.NVARCHAR.equals(type) || SQLType.NCLOB.equals(type) || SQLType.CHAR.equals(type) || SQLType.VARCHAR.equals(type)) {
                return "''";
            }
            if (SQLType.NUMERIC.equals(type) || SQLType.INT.equals(type)) {
                return "0";
            }
            if (SQLType.DATETIME.equals(type)) {
                return null;
            }
            return null;
        }
        value = value.trim();
        if (SQLType.NCHAR.equals(type) || SQLType.NVARCHAR.equals(type) || SQLType.NCLOB.equals(type) || SQLType.CHAR.equals(type) || SQLType.VARCHAR.equals(type)) {
            String prefix = null;
            String suffix = null;
            if (value.endsWith("')")) {
                if (value.startsWith("('")) {
                    prefix = "('";
                } else if (value.startsWith("(N'")) {
                    prefix = "(N'";
                } else if (value.startsWith("(n'")) {
                    prefix = "(n'";
                }
                if (prefix != null) {
                    suffix = "')";
                }
            } else if (value.endsWith("'")) {
                if (value.startsWith("'")) {
                    prefix = "'";
                } else if (value.startsWith("N'")) {
                    prefix = "N'";
                } else if (value.startsWith("n'")) {
                    prefix = "n'";
                }
                if (prefix != null) {
                    suffix = "'";
                }
            }
            if (prefix != null && suffix != null) {
                value = value.substring(prefix.length(), value.length() - suffix.length());
            }
            value = StringUtils.replace((String)value, (String)"'", (String)"''");
            if (SQLType.CHAR.equals(type) || SQLType.VARCHAR.equals(type)) {
                return "'" + value + "'";
            }
            return "N'" + value + "'";
        }
        if (SQLType.BLOB.equals(type) || SQLType.BINARY.equals(type) || SQLType.VARBINARY.equals(type) || SQLType.NUMERIC.equals(type) || SQLType.INT.equals(type)) {
            if (value.startsWith("(") && value.endsWith(")")) {
                value = value.substring(1, value.length() - 1);
            }
            return value;
        }
        if (SQLType.DATETIME.equals(type)) {
            return null;
        }
        return value;
    }

    @Override
    public String toString() {
        String str = "Metadata Element " + this.getClass().getName();
        str = str + ", name:" + this.getName();
        str = str + ", alias:" + this.getAlias();
        str = str + ", type:" + this.getTypeName().getName();
        str = str + ", length:" + this.getLength();
        str = str + ", isMultilingual:" + this.isMultilingual();
        str = str + ", isNullable:" + this.isNullable();
        return str;
    }
}

