/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.deployfile;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.DynamicMetaDataCtrl;
import com.kingdee.bos.metadata.IMetaDataContainer;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectCollection;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.SubClassingMode;
import com.kingdee.bos.metadata.code.CodeUtil;
import com.kingdee.bos.metadata.deployfile.ApusicDeployFileGenerator;
import com.kingdee.bos.metadata.deployfile.DeployFileGenerateException;
import com.kingdee.bos.metadata.deployfile.EarInfo;
import com.kingdee.bos.metadata.deployfile.EjbMethodInfo;
import com.kingdee.bos.metadata.deployfile.EjbModuleInfo;
import com.kingdee.bos.metadata.deployfile.IDeployFileGenerator;
import com.kingdee.bos.metadata.deployfile.SessionBeanInfo;
import com.kingdee.bos.metadata.deployfile.WebLogicDeployFileGenerator;
import com.kingdee.bos.metadata.deployfile.WebModuleInfo;
import com.kingdee.bos.metadata.deployfile.WebSphereDeployFileGenerator;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.management.DeployOptionInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.management.TargetAppServerType;
import com.kingdee.bos.metadata.management.application.MetaDataCollection;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.service.netfile.NetFile;
import com.kingdee.bos.service.netfile.NetFileFactory;
import com.kingdee.bos.service.netfile.NetFileHelper;
import com.kingdee.bos.service.netfile.NetFileSource;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DeployFileFactory {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.deployfile.DeployFileFactory");

    private DeployFileFactory() {
    }

    public static void generateBOIndex(Context ctx, MetaDataCollection metas, DeployOptionInfo option) throws DeployFileGenerateException {
        if (metas == null || metas.size() == 0) {
            return;
        }
        MetaDataCollection bos = new MetaDataCollection();
        int len = metas.size();
        for (int i = 0; i < len; ++i) {
            MetaDataInfo meta = metas.get(i);
            if (!MetaDataTypeList.ENTITY.toString().equalsIgnoreCase(meta.getMetaDataType()) && !MetaDataTypeList.FACADE.toString().equalsIgnoreCase(meta.getMetaDataType())) continue;
            bos.add(meta);
        }
        DeployFileFactory.generateEntityFacadePKMappingFile(ctx, DeployFileFactory.getAllBizObjects(ctx, bos), option);
    }

    public static void generate(Context ctx, MetaDataCollection metas, DeployOptionInfo option) throws DeployFileGenerateException {
        if (metas == null || metas.size() == 0) {
            return;
        }
        BusinessObjectCollection bizObjects = null;
        MetaDataCollection bos = new MetaDataCollection();
        int len = metas.size();
        for (int i = 0; i < len; ++i) {
            MetaDataInfo meta = metas.get(i);
            if (!MetaDataTypeList.ENTITY.toString().equalsIgnoreCase(meta.getMetaDataType()) && !MetaDataTypeList.FACADE.toString().equalsIgnoreCase(meta.getMetaDataType())) continue;
            bos.add(meta);
        }
        bizObjects = DeployFileFactory.getBizObjects(ctx, bos);
        if (bizObjects.size() <= 0) {
            return;
        }
        DeployFileFactory.generate(ctx, bizObjects, option);
    }

    public static void generate(Context ctx, IMetaDataContainer container, DeployOptionInfo option) throws DeployFileGenerateException {
        try {
            int i;
            BusinessObjectCollection bizObjects = null;
            MetaDataCollection entities = container.getMetaDatasByType(MetaDataTypeList.ENTITY);
            MetaDataCollection facades = container.getMetaDatasByType(MetaDataTypeList.FACADE);
            MetaDataCollection bos = new MetaDataCollection();
            int n = entities.size();
            for (i = 0; i < n; ++i) {
                bos.add(entities.get(i));
            }
            n = facades.size();
            for (i = 0; i < n; ++i) {
                bos.add(facades.get(i));
            }
            bizObjects = DeployFileFactory.getBizObjects(ctx, bos);
            if (bizObjects.size() <= 0) {
                return;
            }
            DeployFileFactory.generate(ctx, bizObjects, option);
        }
        catch (Exception e) {
            throw new DeployFileGenerateException(e);
        }
    }

    public static void generate(Context ctx, BusinessObjectCollection bizObjects, DeployOptionInfo option) throws DeployFileGenerateException {
        EarInfo earInfo = DeployFileFactory.getEarInfo(ctx, bizObjects);
        if (TargetAppServerType.isApusic(option.getTargetAppServer())) {
            DeployFileFactory.getDeployFileGenerator(1, earInfo, option.getJ2eeOutputDir() + File.pathSeparator + "apusic", option.isOverrideDeployFile()).generate();
        }
        if (TargetAppServerType.isWebLogic(option.getTargetAppServer())) {
            DeployFileFactory.getDeployFileGenerator(4, earInfo, option.getJ2eeOutputDir() + File.pathSeparator + "weblogic", option.isOverrideDeployFile()).generate();
        }
        if (TargetAppServerType.isWebSphere(option.getTargetAppServer())) {
            DeployFileFactory.getDeployFileGenerator(2, earInfo, option.getJ2eeOutputDir() + File.pathSeparator + "websphere", option.isOverrideDeployFile()).generate();
        }
    }

    private static void generateEntityFacadePKMappingFile(Context ctx, BusinessObjectCollection bizObjects, DeployOptionInfo option) throws DeployFileGenerateException {
        NetFileFactory fileFactory = null;
        try {
            fileFactory = NetFileHelper.getNetFileFactory((NetFileSource)new NetFileSource(new File(option.getMetaDataRepository()).toURL().toString()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalidate netfile src [" + option.getMetaDataRepository() + "]");
        }
        Properties entityMaps = new Properties();
        Properties facadeMaps = new Properties();
        NetFile entityMappingFile = fileFactory.createNetFile("entity_pkmapping.properties");
        NetFile facadeMappingFile = fileFactory.createNetFile("facade_pkmapping.properties");
        try {
            if (entityMappingFile.exists()) {
                InputStream entityIS = fileFactory.createNetFileInputStream(entityMappingFile);
                entityMaps.load(entityIS);
                entityIS.close();
            }
        }
        catch (Exception entityIS) {
            // empty catch block
        }
        try {
            if (facadeMappingFile.exists()) {
                InputStream facadeIS = fileFactory.createNetFileInputStream(facadeMappingFile);
                facadeMaps.load(facadeIS);
                facadeIS.close();
            }
        }
        catch (Exception facadeIS) {
            // empty catch block
        }
        for (int i = 0; i < bizObjects.size(); ++i) {
            String pkName;
            BusinessObjectInfo bo = bizObjects.get(i);
            String string = pkName = bo.getPackage() == null ? "" : bo.getPackage() + "." + bo.getName();
            if (bo instanceof EntityObjectInfo) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("add entity[" + bo.getType() + ", " + pkName + "] to entityIndex!"));
                }
                entityMaps.put(bo.getType().toString(), pkName);
                continue;
            }
            if (!(bo instanceof FacadeInfo)) continue;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("add entity[" + bo.getType() + ", " + pkName + "] to facadeIndex!"));
            }
            facadeMaps.put(bo.getType().toString(), pkName);
        }
        try {
            OutputStream entityOS = fileFactory.createNetFileOutputStream(entityMappingFile);
            entityMaps.store(entityOS, "Entity pk <==> bosType");
            entityOS.close();
            OutputStream facadeOS = fileFactory.createNetFileOutputStream(facadeMappingFile);
            facadeMaps.store(facadeOS, "Facade pk <==> bosType");
            facadeOS.close();
        }
        catch (FileNotFoundException fne) {
            throw new DeployFileGenerateException(fne);
        }
        catch (IOException ioe) {
            throw new DeployFileGenerateException(ioe);
        }
    }

    protected static IDeployFileGenerator getDeployFileGenerator(int appServerType, EarInfo earInfo, String j2eeOutputDir, boolean isOverride) throws DeployFileGenerateException {
        if (j2eeOutputDir == null || earInfo == null) {
            throw new NullPointerException("J2EEDeployOutputDir or EarInfo cannot be null");
        }
        try {
            if (appServerType == 1) {
                return new ApusicDeployFileGenerator(earInfo, j2eeOutputDir, isOverride);
            }
            if (appServerType == 4) {
                return new WebLogicDeployFileGenerator(earInfo, j2eeOutputDir, isOverride);
            }
            if (appServerType == 2) {
                return new WebSphereDeployFileGenerator(earInfo, j2eeOutputDir, isOverride);
            }
            assert (false);
            return null;
        }
        catch (BOSException bose) {
            throw new DeployFileGenerateException(bose);
        }
    }

    private static BusinessObjectCollection getAllBizObjects(Context ctx, MetaDataCollection bizObjectPKs) throws DeployFileGenerateException {
        BusinessObjectCollection bizObjects = new BusinessObjectCollection();
        try {
            int n = bizObjectPKs.size();
            MetaDataInfo meta = null;
            BusinessObjectInfo bo = null;
            for (int i = 0; i < n; ++i) {
                meta = bizObjectPKs.get(i);
                bo = (BusinessObjectInfo)DynamicMetaDataCtrl.getMetadataCtrl(ctx, BOSObjectType.create((String)meta.getMetaDataType())).getValue(MetaDataPK.create(meta.getFullName()));
                bizObjects.add(bo);
            }
        }
        catch (Exception e) {
            throw new DeployFileGenerateException(e);
        }
        return bizObjects;
    }

    private static BusinessObjectCollection getBizObjects(Context ctx, MetaDataCollection bizObjectPKs) throws DeployFileGenerateException {
        BusinessObjectCollection bizObjects = new BusinessObjectCollection();
        try {
            int n = bizObjectPKs.size();
            MetaDataInfo meta = null;
            BusinessObjectInfo bo = null;
            for (int i = 0; i < n; ++i) {
                meta = bizObjectPKs.get(i);
                bo = (BusinessObjectInfo)DynamicMetaDataCtrl.getMetadataCtrl(ctx, BOSObjectType.create((String)meta.getMetaDataType())).getValue(MetaDataPK.create(meta.getFullName()));
                if (StringUtils.isEmpty((String)bo.getBusinessControllerBean()) || bo.getSubClassingMode().equals((Object)SubClassingMode.ABSTRACT)) continue;
                bizObjects.add(bo);
            }
        }
        catch (Exception e) {
            throw new DeployFileGenerateException(e);
        }
        return bizObjects;
    }

    private static EarInfo getEarInfo(Context ctx, BusinessObjectCollection bizObjects) throws DeployFileGenerateException {
        EarInfo ear = new EarInfo();
        ear.setDescription("ear.ear");
        ear.setDisplayName("ear.ear");
        BusinessObjectCollection userDefineBizObjects = new BusinessObjectCollection();
        int n = bizObjects.size();
        for (int i = n - 1; i >= 0; --i) {
            BusinessObjectInfo bizObj = bizObjects.get(i);
            if (!bizObj.isUserDefined()) continue;
            userDefineBizObjects.add(bizObj);
            bizObjects.remove(bizObj);
        }
        if (userDefineBizObjects.size() != 0) {
            ear.addEjbModule(DeployFileFactory.getEjbModuleInfo(ctx, userDefineBizObjects, "userDefined"));
        }
        if (bizObjects.size() != 0) {
            ear.addEjbModule(DeployFileFactory.getEjbModuleInfo(ctx, bizObjects, "ejb"));
        }
        ear.addWebModule(DeployFileFactory.getWebModuleInfo());
        return ear;
    }

    private static EjbModuleInfo getEjbModuleInfo(Context ctx, BusinessObjectCollection bizObjects, String moduleName) throws DeployFileGenerateException {
        String slnName = null;
        try {
            slnName = ((SolutionInfo)DynamicMetaDataCtrl.getMetadataCtrl(ctx, MetaDataTypeList.SOLUTION).getValue(null)).getName();
        }
        catch (Exception e) {
            throw new DeployFileGenerateException(e);
        }
        EjbModuleInfo ejbModule = new EjbModuleInfo();
        ejbModule.setEjbUri(moduleName);
        ejbModule.setDescription(moduleName + ".jar");
        ejbModule.setDisplayName(moduleName + ".jar");
        int size = bizObjects.size();
        BusinessObjectInfo boInfo = null;
        SessionBeanInfo sbInfo = null;
        for (int i = 0; i < size; ++i) {
            boInfo = bizObjects.get(i);
            if (boInfo.getSubClassingMode().equals((Object)SubClassingMode.ABSTRACT) || boInfo.getBusinessControllerName() == null) continue;
            sbInfo = new SessionBeanInfo();
            sbInfo.setDescription(boInfo.getBusinessControllerName());
            sbInfo.setDisplayName(boInfo.getBusinessControllerName());
            sbInfo.setEjbName(boInfo.getBusinessControllerName().replace('.', '_'));
            sbInfo.setEjbClass(boInfo.getBusinessControllerBean());
            sbInfo.setHome(boInfo.getBusinessControllerHome());
            sbInfo.setJndiLocalName("ejb/" + slnName + "/" + boInfo.getBusinessControllerLocaleHome().replace('.', '_'));
            sbInfo.setJndiRemoteName("ejb/" + slnName + "/" + boInfo.getBusinessControllerHome().replace('.', '_'));
            sbInfo.setLocal(boInfo.getBusinessControllerLocal());
            sbInfo.setLocalHome(boInfo.getBusinessControllerLocaleHome());
            sbInfo.setRemote(boInfo.getBusinessControllerRemote());
            MethodCollection methods = CodeUtil.getInheritedNoDuplicatedMethod(boInfo);
            MethodInfo method = null;
            EjbMethodInfo ejbMethod = null;
            int methodSize = methods.size();
            for (int j = 0; j < methodSize; ++j) {
                method = methods.get(j);
                ejbMethod = new EjbMethodInfo();
                ejbMethod.setEjbUri(method.getName());
                ejbMethod.setTsAtt(method.getTransactionAttribute());
                ParameterCollection params = method.getParameters();
                ejbMethod.addParameter("com.kingdee.bos.Context");
                int paramSize = params.size();
                String tmp = null;
                for (int k = 0; k < paramSize; ++k) {
                    tmp = params.get(k).getParameterType().toString();
                    ejbMethod.addParameter(tmp);
                }
                sbInfo.addMethod(ejbMethod);
            }
            ejbModule.addEjb(sbInfo);
        }
        return ejbModule;
    }

    private static WebModuleInfo getWebModuleInfo() {
        WebModuleInfo webModule = new WebModuleInfo();
        webModule.setDescription("web.war");
        webModule.setDisplayName("web.war");
        webModule.setContextRoot("/eas");
        webModule.setWebUri("web");
        return webModule;
    }
}

