/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class CommonEntityManager {
    private static Logger logger = Logger.getLogger(CommonEntityManager.class);
    private static Map ces = new HashMap();
    private static Map cebi = new HashMap();
    private static Map cebc = new HashMap();
    public static final String COMMONCONTROLLERNAME = "commonControllerName";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Configuration config;
        ConfigurationItem ci;
        block18: {
            String configPath = System.getProperty("DynamicConfig.path");
            if (StringUtils.isEmpty((String)configPath)) {
                String home = System.getProperty("EAS_HOME");
                configPath = ConfigMDUtil.isClient() ? home + "/client/deploy/client/" + "DynamicConfig.xml" : home + "/server/properties/" + "DynamicConfig.xml";
            }
            if (new File(configPath).exists()) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(configPath);
                    Document doc = XMLParser.parseXML((InputStream)fis);
                    Element root = doc.getRootElement();
                    List cis = root.getChildren("configitem", root.getNamespace());
                    if (cis == null || cis.size() <= 0) break block18;
                    for (int i = 0; i < cis.size(); ++i) {
                        Element ci2 = (Element)cis.get(i);
                        String name = ci2.getAttributeValue("name");
                        if (!"commonEntities".equals(name)) continue;
                        List atts = ci2.getChildren("attribute", root.getNamespace());
                        if (atts != null && atts.size() > 0) {
                            for (int j = 0; j < atts.size(); ++j) {
                                Element att = (Element)atts.get(j);
                                if (att == null) continue;
                                String key = att.getAttributeValue("key");
                                String value = att.getAttributeValue("value");
                                ces.put(key, value);
                            }
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)e, (Throwable)e);
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)"close FileInputStream error!", (Throwable)e);
                    }
                }
            }
        }
        if ((ci = (config = Configuration.getInstance()).getConfigItem("commonEntities")) == null) {
            logger.info((Object)"Can't find commonEntities configItem");
            return;
        }
        Map map = ci.getProperties();
        ces.putAll(map);
    }

    public static synchronized void register(String entityName, String commonEntityName) {
        ces.put(entityName, commonEntityName);
    }

    public static synchronized void register(EntityObjectInfo entity, String commonEntityName) {
        CommonEntityManager.register(entity.getFullName(), commonEntityName);
    }

    public static String getCommonBusinessImplName(EntityObjectInfo entity) {
        String bin = entity.getExtendedProperty(COMMONCONTROLLERNAME);
        if (!StringUtils.isEmpty((String)bin)) {
            int i = bin.lastIndexOf(".app.");
            if (i > 0) {
                bin = bin.substring(0, i) + bin.substring(i + 4);
            }
            return bin;
        }
        String ce = (String)ces.get(entity.getFullName());
        if (ce != null) {
            bin = (String)cebi.get(ce);
            if (bin == null) {
                EntityObjectInfo commonEntity = MetaDataLoaderFactory.getMetaDataLoader(ConfigMDUtil.getContext()).getEntity(MetaDataPK.create(ce));
                bin = commonEntity.getBusinessImplName();
                cebi.put(ce, bin);
            }
            return bin;
        }
        return CommonEntityManager.getCommonBusinessImplName0(entity);
    }

    private static String getCommonBusinessImplName0(EntityObjectInfo entity) {
        EntityObjectInfo base = entity.getBaseEntity();
        if (base != null) {
            String ce = (String)ces.get(base.getFullName());
            if (ce != null) {
                String bin = (String)cebi.get(ce);
                if (bin == null) {
                    EntityObjectInfo commonEntity = MetaDataLoaderFactory.getMetaDataLoader(ConfigMDUtil.getContext()).getEntity(MetaDataPK.create(ce));
                    bin = commonEntity.getBusinessImplName();
                    cebi.put(ce, bin);
                }
                return bin;
            }
            return CommonEntityManager.getCommonBusinessImplName0(base);
        }
        return null;
    }

    public static String getCommonControllerName(EntityObjectInfo entity) {
        String bcn = entity.getExtendedProperty(COMMONCONTROLLERNAME);
        if (!StringUtils.isEmpty((String)bcn)) {
            return bcn + "Controller";
        }
        String ce = (String)ces.get(entity.getFullName());
        if (ce != null) {
            bcn = (String)cebc.get(ce);
            if (bcn == null) {
                EntityObjectInfo commonEntity = MetaDataLoaderFactory.getMetaDataLoader(ConfigMDUtil.getContext()).getEntity(MetaDataPK.create(ce));
                bcn = commonEntity.getBusinessControllerName();
                cebc.put(ce, bcn);
            }
            return bcn;
        }
        return CommonEntityManager.getCommonControllerName0(entity);
    }

    private static String getCommonControllerName0(EntityObjectInfo entity) {
        EntityObjectInfo base = entity.getBaseEntity();
        if (base != null) {
            String ce = (String)ces.get(base.getFullName());
            if (ce != null) {
                String bcn = (String)cebc.get(ce);
                if (bcn == null) {
                    EntityObjectInfo commonEntity = MetaDataLoaderFactory.getMetaDataLoader(ConfigMDUtil.getContext()).getEntity(MetaDataPK.create(ce));
                    bcn = commonEntity.getBusinessControllerName();
                    cebc.put(ce, bcn);
                }
                return bcn;
            }
            return CommonEntityManager.getCommonControllerName0(base);
        }
        return null;
    }

    static {
        try {
            CommonEntityManager.init();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

