/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.metadata.entity.CompartKeyWord;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.StringReader;
import com.kingdee.bos.sql.parser.Token;
import com.kingdee.bos.sql.parser.TokenList;
import java.util.ArrayList;

public class CompartExprParser {
    private final TokenList _tokenList;

    public CompartExprParser(TokenList tokList) {
        this._tokenList = tokList;
    }

    public CompartExprParser(Lexer lexer) throws ParserException {
        this._tokenList = new TokenList(lexer);
    }

    public CompartExprParser(String text) throws ParserException {
        Lexer lexer = new Lexer(text);
        this._tokenList = new TokenList(lexer);
    }

    private boolean checkTokenType(Token token) {
        return token != null && !token.equals(Token.PeriodToken) && !token.equals(Token.CommaToken) && token.type != 4;
    }

    public final ArrayList build() throws ParserException {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        Token token = null;
        Token prevToken = null;
        while ((token = this._tokenList.lookup(0)) != null) {
            if (token.type == 3) {
                list.add(sb.toString());
                sb = new StringBuffer();
            } else {
                if (token.type == 12) {
                    list.add(sb.toString());
                    break;
                }
                if (this.checkTokenType(token) && this.checkTokenType(prevToken)) {
                    sb.append(" ");
                }
                sb.append(token.toString());
            }
            prevToken = token;
            this._tokenList.match();
            token = this._tokenList.lookup(0);
        }
        return list;
    }

    public static void main(String[] args) {
        try {
            String s = "select t1.a,t2.b,\"df_&4\" as \"te\" where (t1.a=10) and (t2.b='CompareKey' or t3.c='COMPARTKEY' and t3.c * 10 < -180 and t3.t + 10 != (-6 / 15) ) CompartKey aaa=111 COMPARTKEY ccc=112";
            System.out.println(s);
            StringReader strReader = new StringReader(s);
            Lexer lexer = new Lexer(CompartKeyWord.instance, null, strReader);
            TokenList tokList = new TokenList(lexer);
            CompartExprParser parser = new CompartExprParser(tokList);
            ArrayList list = parser.build();
            System.out.println("size=" + list.size());
            for (int i = 0; i < list.size(); ++i) {
                System.out.println("   " + i + " : " + list.get(i));
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
    }
}

