/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.InvalidMetaDataException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BIMNameFactory;
import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.IAbstractTableCtrl;
import com.kingdee.bos.metadata.data.PKColumnInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.TablePrefixInfo;
import com.kingdee.bos.metadata.resource.BizDataTypeInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.util.StringUtils;
import java.util.List;

public class EntityToTable {
    public static final String tablePrefix = "T";
    public static final String pkPrefix = "PK";
    public static final String fkPrefix = "FK";
    public static final String columnPrefix = "F";
    public static final String linkColumnSuffix = "ID";
    public static final char sepChar = '_';

    public static DataTableInfo CreateDataTable(EntityObjectInfo entity, IMetaDataPK metaDataPK, TablePrefixInfo info) throws BOSException {
        AbstractTableInfo table = null;
        if (metaDataPK != null) {
            IAbstractTableCtrl dtCtrl = (IAbstractTableCtrl)BOSObjectFactory.createBOSObject(ContextManager.getContext(), MetaDataTypeList.ABSTRACTTABLE);
            table = (DataTableInfo)dtCtrl.getValue(metaDataPK);
        }
        if (table == null) {
            table = new DataTableInfo();
            table.setName(info.genTableName(entity.getPackage(), entity.getName()));
            table.setPackage(entity.getPackage());
        } else {
            table.getForeignKeys().clear();
            table.getIndexes().clear();
            table.getColumns().clear();
        }
        entity.setTable((DataTableInfo)table);
        EntityObjectInfo parent = (EntityObjectInfo)entity.getParent();
        PropertyCollection pc = parent != null && parent.isAbstract() ? entity.getInheritedNoDuplicatedProperties() : entity.getProperties();
        PropertyCollection selProp = entity.getProperties();
        for (int i = 0; i < pc.size(); ++i) {
            PropertyInfo prop = pc.get(i);
            ColumnInfo col = null;
            if (!info.isIgroneMapping() || !selProp.contains(prop)) {
                col = prop.getMappingField();
            }
            if (col == null) {
                RelationshipInfo relation;
                if (prop instanceof OwnPropertyInfo) {
                    col = new ColumnInfo();
                    col.setName(info.genColumnName(prop.getName(), false));
                    col.setDescription(prop.getDescription());
                } else if (prop instanceof LinkPropertyInfo && ((relation = ((LinkPropertyInfo)prop).getRelationship()).getChildCardinality(entity).equals((Object)CardinalityType.ONE) || relation.getChildCardinality(entity).equals((Object)CardinalityType.ZERO_TO_ONE))) {
                    col = new ColumnInfo();
                    col.setName(info.genColumnName(prop.getName(), true));
                    col.setDescription(prop.getDescription());
                }
            }
            if (col == null || EntityToTable.containtsColumn((DataTableInfo)table, col.getName())) continue;
            prop.setMappingField(col);
            col.setDescription(prop.getDescription());
            table.getColumns().add(col);
            EntityToTable.setColumnInfo(col, entity, prop);
        }
        ColumnCollection cc = table.getColumns();
        for (int i = 0; i < cc.size(); ++i) {
            ColumnInfo colInfo = cc.get(i);
            if (colInfo.getName().equalsIgnoreCase("fid") && info.isUpperFID()) {
                colInfo.setName("FID");
            }
            if ((colInfo.getName().equalsIgnoreCase("fnumber") || colInfo.getName().equalsIgnoreCase("fsimplename")) && colInfo.getTypeName().equals(SQLType.VARCHAR)) {
                colInfo.setTypeName(SQLType.NVARCHAR);
            }
            if (!colInfo.isMultilingual()) continue;
            if (colInfo.getTypeName().equals(SQLType.CHAR)) {
                colInfo.setTypeName(SQLType.NCHAR);
            }
            if (colInfo.getTypeName().equals(SQLType.VARCHAR)) {
                colInfo.setTypeName(SQLType.NVARCHAR);
            }
            if (!colInfo.getTypeName().equals(SQLType.CLOB)) continue;
            colInfo.setTypeName(SQLType.NCLOB);
        }
        PrimaryKeyInfo pk = EntityToTable.createPrimaryKey(entity, info);
        if (pk == null) {
            throw new InvalidMetaDataException("\u6ca1\u6709\u5b9a\u4e49\u903b\u8f91\u952e\u6216\u8005\u903b\u8f91\u952e\u5b9a\u4e49\u9519\u8bef");
        }
        table.setPrimaryKey(pk);
        return table;
    }

    public static DataTableInfo CreateDataTable(EntityObjectInfo entity, IMetaDataPK metaDataPK) throws BOSException {
        return EntityToTable.CreateDataTable(entity, metaDataPK, new TablePrefixInfo());
    }

    private static PrimaryKeyInfo createPrimaryKey(EntityObjectInfo entity, TablePrefixInfo prefixInfo) {
        PrimaryKeyInfo pk = null;
        LogicalKeyInfo key = entity.getLogicalKey();
        if (!key.getKeyPropertys().isEmpty()) {
            pk = new PrimaryKeyInfo();
            pk.setName(prefixInfo.genPKName(entity.getName()));
            for (int i = 0; i < key.getKeyPropertys().size(); ++i) {
                PropertyInfo keyProp = key.getKeyPropertys().get(i);
                PKColumnInfo pkcol = new PKColumnInfo();
                pkcol.setSortType(SortType.ASCEND);
                ColumnInfo colInfo = null;
                for (int j = 0; j < entity.getEntityProperties().size(); ++j) {
                    if (!entity.getEntityProperties().get(j).getName().equals(keyProp.getName())) continue;
                    colInfo = entity.getEntityProperties().get(j).getMappingField();
                }
                pkcol.setColumn(colInfo);
                pk.getPKColumns().add(pkcol);
            }
        } else {
            EntityObjectInfo parent = entity.getBaseEntity();
            if (parent != null && parent.isAbstract()) {
                pk = EntityToTable.createPrimaryKey(parent, prefixInfo);
            }
        }
        return pk;
    }

    private static boolean containtsColumn(DataTableInfo table, String columnName) {
        for (int i = 0; i < table.getColumns().size(); ++i) {
            if (!table.getColumns().get(i).getName().equalsIgnoreCase(columnName)) continue;
            return true;
        }
        return false;
    }

    private static void setColumnInfo(ColumnInfo col, EntityObjectInfo entity, PropertyInfo prop) throws BOSException {
        if (prop instanceof OwnPropertyInfo) {
            EntityToTable.setOwnPropColumnInfo(col, (OwnPropertyInfo)prop, false);
        } else {
            LinkPropertyInfo lnkProp = (LinkPropertyInfo)prop;
            RelationshipInfo relation = lnkProp.getRelationship();
            if (relation.getSupplierProperty() == null) {
                throw new InvalidMetaDataException("\u65e0\u6cd5\u83b7\u5f97SupplierProperty,\u53ef\u80fd\u662f\u5173\u7cfb\u65b9\u5411\u5b9a\u4e49\u9519\u8bef. Relation name: " + relation.getFullName());
            }
            PropertyInfo otherProp = relation.getClientPropertyDesignTime();
            if (otherProp != null) {
                if (otherProp.getMappingField() != null) {
                    ColumnInfo otherCol = otherProp.getMappingField();
                    col.setTypeName(otherCol.getTypeName());
                    col.setTypeName(SQLType.VARCHAR);
                    col.setLength(otherCol.getLength());
                    if (col.getLength() == 0) {
                        col.setLength(44);
                    }
                    col.setNullable(true);
                    col.setPrecision(otherCol.getPrecision());
                    col.setScale(otherCol.getScale());
                } else if (otherProp instanceof OwnPropertyInfo) {
                    EntityToTable.setOwnPropColumnInfo(col, (OwnPropertyInfo)otherProp, true);
                } else {
                    throw new InvalidMetaDataException("invalid relationship. SupplierProperty can't be LinkProperty. Relationship name: " + relation.getFullName());
                }
            }
        }
    }

    private static void setOwnPropColumnInfo(ColumnInfo col, OwnPropertyInfo prop, boolean isLink) {
        BizDataTypeInfo biztype = prop.getBizDataType();
        DataType dataType = DataType.STRING;
        dataType = biztype != null && biztype.getDataType() != null ? biztype.getDataType() : prop.getDataType();
        col.setDefaultValue(prop.getDefaultValue());
        if (!StringUtils.isEmpty((String)prop.getAlias())) {
            col.setAlias(prop.getAlias());
        }
        if (!StringUtils.isEmpty((String)prop.getDescription())) {
            col.setDescription(prop.getDescription());
        }
        if (dataType.equals(DataType.BOOLEAN)) {
            EntityToTable.setColumnInt(col);
            col.setLength(1);
            col.setPrecision(1);
            if ("true".equalsIgnoreCase(col.getDefaultValue())) {
                col.setDefaultValue("1");
            } else if ("false".equalsIgnoreCase(col.getDefaultValue())) {
                col.setDefaultValue("0");
            }
        } else if (dataType.equals(DataType.BOSUUID)) {
            EntityToTable.setColumnBOSUuid(col, isLink);
        } else if (dataType.equals(DataType.BYTE)) {
            EntityToTable.setColumnBinary(col);
        } else if (dataType.equals(DataType.CHAR)) {
            if (prop.isMultilingual()) {
                EntityToTable.setColumnLingualChar(col);
            } else {
                EntityToTable.setColumnChar(col);
            }
        } else if (dataType.equals(DataType.DATE)) {
            EntityToTable.setColumnDateTime(col);
        } else if (dataType.equals(DataType.DECIMAL)) {
            EntityToTable.setColumnNumeric(col);
            col.setPrecision(21);
            col.setScale(8);
            col.setLength(prop.getLength());
            col.setPrecision(prop.getPrecision());
            col.setScale(prop.getDecimalDigits());
        } else if (dataType.equals(DataType.DOUBLE)) {
            EntityToTable.setColumnNumeric(col);
        } else if (dataType.equals(DataType.ENUM)) {
            if (prop.getEnumType() == null) {
                EntityToTable.setColumnVarChar(col, 100);
            } else if (prop.getEnumType().getDataType().equals((Object)BizEnumValueType.STRING)) {
                EntityToTable.setColumnVarChar(col, 100);
            } else if (prop.getEnumType().getDataType().equals((Object)BizEnumValueType.DOUBLE) || prop.getEnumType().getDataType().equals((Object)BizEnumValueType.FLOAT)) {
                EntityToTable.setColumnNumeric(col);
            } else if (prop.getEnumType().getDataType().equals((Object)BizEnumValueType.INTEGER) || prop.getEnumType().getDataType().equals((Object)BizEnumValueType.LONG)) {
                EntityToTable.setColumnInt(col);
            }
        } else if (dataType.equals(DataType.FLOAT)) {
            EntityToTable.setColumnNumeric(col);
        } else if (dataType.equals(DataType.INTEGER)) {
            EntityToTable.setColumnInt(col);
        } else if (dataType.equals(DataType.LONG)) {
            EntityToTable.setColumnInt(col);
        } else if (dataType.equals(DataType.SHORT)) {
            EntityToTable.setColumnInt(col);
        } else if (dataType.equals(DataType.STRING)) {
            if (prop.isMultilingual()) {
                EntityToTable.setColumnLingualVarChar(col);
            } else {
                EntityToTable.setColumnVarChar(col, prop.getLength());
            }
        } else if (dataType.equals(DataType.TIME)) {
            EntityToTable.setColumnDateTime(col);
        } else if (dataType.equals(DataType.TIMESTAMP)) {
            EntityToTable.setColumnDateTime(col);
        } else if (dataType.equals(DataType.UUID)) {
            EntityToTable.setColumnUuid(col);
        } else if (dataType.equals(DataType.BYTEARRAY)) {
            if (prop.isMultilingual()) {
                EntityToTable.setColumnLingualCLOB(col);
            } else {
                EntityToTable.setColumnCLOB(col);
            }
        }
        if ("fid".equalsIgnoreCase(col.getName())) {
            col.setNullable(false);
        } else {
            col.setNullable(!prop.isNullable());
        }
    }

    private static void setColumnNumeric(ColumnInfo col) {
        col.setTypeName(SQLType.NUMERIC);
        col.setLength(13);
        col.setNullable(true);
        col.setPrecision(28);
        col.setScale(10);
    }

    private static void setColumnInt(ColumnInfo col) {
        col.setTypeName(SQLType.INT);
        col.setLength(4);
        col.setNullable(true);
        col.setPrecision(4);
        col.setScale(0);
    }

    private static void setColumnChar(ColumnInfo col) {
        col.setTypeName(SQLType.CHAR);
        col.setLength(1);
        col.setNullable(true);
        col.setPrecision(1);
        col.setScale(0);
    }

    private static void setColumnLingualChar(ColumnInfo col) {
        col.setTypeName(SQLType.NCHAR);
        col.setMultilingual(true);
        col.setLength(1);
        col.setNullable(true);
        col.setPrecision(1);
        col.setScale(0);
    }

    private static void setColumnVarChar(ColumnInfo col, int length) {
        col.setTypeName(SQLType.VARCHAR);
        col.setLength(length);
        col.setNullable(true);
        col.setPrecision(length);
        col.setScale(0);
    }

    private static void setColumnNVarChar(ColumnInfo col, int length) {
        col.setTypeName(SQLType.NVARCHAR);
        if (length <= 0) {
            col.setLength(80);
        } else {
            col.setLength(length);
        }
        col.setMultilingual(false);
        col.setNullable(true);
        col.setPrecision(length);
        col.setScale(0);
    }

    private static void setColumnLingualVarChar(ColumnInfo col) {
        col.setTypeName(SQLType.NVARCHAR);
        col.setMultilingual(true);
        col.setLength(255);
        col.setNullable(true);
        col.setPrecision(255);
        col.setScale(0);
    }

    private static void setColumnCLOB(ColumnInfo col) {
        col.setTypeName(SQLType.CLOB);
        col.setLength(1024);
        col.setNullable(true);
        col.setPrecision(1024);
        col.setScale(0);
    }

    private static void setColumnLingualCLOB(ColumnInfo col) {
        col.setTypeName(SQLType.NCLOB);
        col.setMultilingual(true);
        col.setLength(1024);
        col.setNullable(true);
        col.setPrecision(1024);
        col.setScale(0);
    }

    private static void setColumnDateTime(ColumnInfo col) {
        col.setTypeName(SQLType.DATETIME);
        col.setLength(8);
        col.setNullable(true);
        col.setPrecision(8);
        col.setScale(0);
    }

    private static void setColumnBOSUuid(ColumnInfo col, boolean isLink) {
        col.setTypeName(SQLType.VARCHAR);
        col.setLength(44);
        if (isLink) {
            col.setNullable(true);
        } else {
            col.setNullable(false);
        }
        col.setPrecision(44);
        col.setScale(0);
    }

    private static void setColumnUuid(ColumnInfo col) {
        col.setTypeName(SQLType.CHAR);
        col.setLength(36);
        col.setNullable(true);
        col.setPrecision(36);
        col.setScale(0);
    }

    private static void setColumnBinary(ColumnInfo col) {
        col.setTypeName(SQLType.BINARY);
        col.setLength(1);
        col.setNullable(true);
        col.setPrecision(1);
        col.setScale(0);
    }

    public static void autoCreateForeignKey(EntityObjectInfo entity, DataTableInfo table, List list) throws BOSException {
        table.getForeignKeys().clear();
        for (int i = 0; i < entity.getEntityProperties().size(); ++i) {
            PropertyInfo prop = entity.getEntityProperties().get(i);
            if (!(prop instanceof LinkPropertyInfo)) continue;
            RelationshipInfo relation = ((LinkPropertyInfo)prop).getRelationship();
            if (relation.getSupplierObject().getFullName().equals(relation.getClientObject().getFullName())) {
                PropertyCollection keys = entity.getLogicalKey().getKeyPropertys();
                if (keys == null || keys.size() != 1) {
                    throw new BOSException("\u672c\u5b9e\u4f53\u5b9a\u4e49\u4e86\u81ea\u5173\u8054\uff0c\u4f46\u903b\u8f91\u952e\u4e0d\u5b58\u5728\u6216\u8005\u903b\u8f91\u952e\u4e0d\u552f\u4e00");
                }
                ForeignKeyInfo fk = EntityToTable.createForeignKey(table, prop, entity.getTable(), keys.get(0).getMappingField());
                list.add("\u5916\u952e" + fk.getName() + "\u521b\u5efa\u6210\u529f");
                continue;
            }
            if (!relation.getChildCardinality(entity).equals((Object)CardinalityType.ONE) && !relation.getChildCardinality(entity).equals((Object)CardinalityType.ZERO_TO_ONE)) continue;
            if (relation.getChildObject(entity).getTable() != null) {
                PropertyInfo tmpProp = relation.getChildProperty(entity);
                EntityObjectInfo tmpEntity = null;
                tmpEntity = relation.isReverseLink(entity) ? relation.getClientObject() : relation.getSupplierObject();
                tmpProp = tmpEntity.getPropertyByNameRuntime(tmpProp.getName());
                ForeignKeyInfo fk = EntityToTable.createForeignKey(table, prop, relation.getChildObject(entity).getTable(), tmpProp.getMappingField());
                list.add("\u5916\u952e" + fk.getName() + "\u521b\u5efa\u6210\u529f");
                continue;
            }
            list.add("\u7531\u4e8e\u5f15\u7528\u7684\u8868\u4e0d\u5b58\u5728\uff0c\u5728'" + prop.getMappingField() + "'\u521b\u5efa\u5916\u952e\u5931\u8d25");
        }
    }

    private static ForeignKeyInfo createForeignKey(DataTableInfo table, PropertyInfo prop, AbstractTableInfo refedTable, ColumnInfo refedColumn) {
        ForeignKeyInfo fk = new ForeignKeyInfo();
        String fkName = BIMNameFactory.createTableFKName(table.getPackage(), table.getName(), refedTable.getName(), prop.getName());
        fk.setName(EntityToTable.getValidKeyName(table, fkName));
        fk.setRefTable(refedTable);
        FKColumnPairInfo fkpair = new FKColumnPairInfo();
        fkpair.setForeignKeyColumn(prop.getMappingField());
        fkpair.setPrimaryKeyColumn(refedColumn);
        fk.getFKColumnPairs().add(fkpair);
        table.getForeignKeys().add(fk);
        return fk;
    }

    private static String getValidLengthKeyName(String key) {
        if (key != null && key.length() > 18) {
            return key.substring(0, 18);
        }
        return key;
    }

    private static String getValidKeyName(DataTableInfo table, String key) {
        String tmpKey = EntityToTable.getValidLengthKeyName(key);
        int i = 2;
        String keyName = tmpKey;
        while (EntityToTable.existsForeignKey(table, keyName)) {
            keyName = tmpKey.length() == 18 ? tmpKey.substring(0, 17) + i : tmpKey + i;
            ++i;
        }
        return keyName;
    }

    private static boolean existsForeignKey(DataTableInfo table, String keyName) {
        int size = table.getForeignKeys().size();
        for (int i = 0; i < size; ++i) {
            ForeignKeyInfo key = table.getForeignKeys().get(i);
            if (!key.getName().equalsIgnoreCase(keyName)) continue;
            return true;
        }
        return false;
    }
}

