/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.entity.CompartExprParser;
import com.kingdee.bos.metadata.entity.CompartKeyWord;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.OQLKeyWord;
import com.kingdee.bos.metadata.entity.RTQueryJoinCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.parser.KeyWord;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.bos.sql.parser.StringReader;
import com.kingdee.bos.sql.parser.Token;
import com.kingdee.bos.sql.parser.TokenList;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public class EntityViewInfo
extends AbstractMDElement
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4471483834420233404L;
    public static final String QUERY_SORTER = "sorter";
    public static final String QUERY_SELECTOR = "selector";
    public static final String QUERY_FILTER = "filter";
    private FilterCollection entryFilters = null;
    private RTQueryJoinCollection rtJoins = null;
    private int topCount = 0;
    private int offset = 0;
    private boolean ingorePreOrders = false;
    private boolean appendSelectors = false;
    private boolean removeEntry = false;
    private boolean entryPermCol = false;
    private boolean baseOnSelector = false;
    private static final BOSObjectType BOS_TYPE = BOSObjectType.create((String)"dfvw");

    public EntityViewInfo() {
        this.put(QUERY_SORTER, new SorterItemCollection());
    }

    public EntityViewInfo(String oqlExpr) throws ParserException {
        this();
        this.decode(oqlExpr);
    }

    private void initOQL(String oqlExpr) throws ParserException {
        StringReader strReader = new StringReader(oqlExpr);
        Lexer lexer = new Lexer(OQLKeyWord.instance, null, strReader);
        TokenList tokList = new TokenList(lexer);
        SqlExprParser parser = new SqlExprParser(tokList);
        if (tokList.lookup((int)0).value.equalsIgnoreCase("select")) {
            tokList.match();
            this.getSelector().decode(tokList);
        }
        if (!(tokList.lookup(0).equals(Token.EOFToken) || tokList.lookup((int)0).value.equalsIgnoreCase("where") || tokList.lookup((int)0).value.equalsIgnoreCase("entryWhere") || tokList.lookup((int)0).value.equalsIgnoreCase("entryAllWhere") || tokList.lookup((int)0).value.equalsIgnoreCase("entryAnyWhere") || tokList.lookup((int)0).value.equalsIgnoreCase("order") || tokList.lookup((int)0).value.equalsIgnoreCase("removeEntry"))) {
            throw new ParserException("Invalid OQL format. The OQL is:" + oqlExpr);
        }
        if (tokList.lookup((int)0).value.equalsIgnoreCase("where")) {
            tokList.match();
            parser.setInSubQueryKeyword(KeyWord.instance);
            SqlExpr whereExpr = parser.expr();
            this.setFilter(whereExpr);
        }
        this.processEntryFilter(tokList, parser, EntryFilterType.NORMAL);
        this.processEntryFilter(tokList, parser, EntryFilterType.ENTRYALLWHERE);
        this.processEntryFilter(tokList, parser, EntryFilterType.ENTRYANYWHERE);
        if (tokList.lookup((int)0).value.equalsIgnoreCase("order")) {
            tokList.match();
            if (tokList.lookup((int)0).value.equalsIgnoreCase("by")) {
                tokList.match();
                StringBuffer sb = new StringBuffer();
                sb.append("order by ");
                Token prev = null;
                while (!(tokList.lookup(0) == null || tokList.lookup(0).equals(Token.EOFToken) || tokList.lookup((int)0).value.equals("") || tokList.lookup((int)0).value.equalsIgnoreCase("removeEntry"))) {
                    if (prev != null && EntityViewInfo.isNeedSpaceOut(prev, tokList.lookup(0))) {
                        sb.append(" ");
                    }
                    sb.append(tokList.lookup(0));
                    prev = tokList.lookup(0);
                    tokList.match();
                }
                this.getSorter().parse(sb.toString());
            } else {
                throw new ParserException("Invalid OQL format. The OQL is:" + oqlExpr);
            }
        }
        if (tokList.lookup((int)0).value.equalsIgnoreCase("removeEntry")) {
            tokList.match();
            this.removeEntry = true;
        }
    }

    private void processEntryFilter(TokenList tokList, SqlExprParser parser, EntryFilterType entryFilterType) throws ParserException {
        String entryFilterTypeName = this.getEntryFilterTypeName(entryFilterType);
        while (entryFilterTypeName.equalsIgnoreCase(tokList.lookup((int)0).value)) {
            tokList.match();
            SqlExpr whereExpr = parser.expr();
            if (!"on".equalsIgnoreCase(tokList.lookup((int)0).value)) {
                throw new ParserException("invalid entryWhere syntax.");
            }
            tokList.match();
            String entryName = tokList.lookup((int)0).value;
            tokList.match();
            while (".".equalsIgnoreCase(tokList.lookup((int)0).value)) {
                tokList.match();
                entryName = entryName + "." + tokList.lookup((int)0).value;
                tokList.match();
            }
            FilterInfo filterInfo = new FilterInfo(whereExpr, entryName);
            filterInfo.setEntryilterType(entryFilterType);
            this.getEntryFilters().add(filterInfo);
        }
    }

    private static boolean isNeedSpaceOut(Token prev, Token curr) {
        return !prev.equals(Token.PeriodToken) && !curr.equals(Token.PeriodToken) && !prev.equals(Token.OpenBraceToken) && !curr.equals(Token.OpenBraceToken) && !curr.equals(Token.CloseBraceToken);
    }

    public static EntityViewInfo getInstance(FilterInfo filter, SelectorItemCollection selector, SorterItemCollection sorter) {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(selector);
        view.setSorter(sorter);
        return view;
    }

    private void initRTJoin(String rtJoinExpr) throws ParserException {
        this.getRTQueryJoins().decode(rtJoinExpr);
    }

    public boolean isIncludeExpressFilter() {
        int n = this.getEntryFilters().size();
        for (int i = 0; i < n; ++i) {
            FilterInfo filter = this.getEntryFilters().get(i);
            EntryFilterType type = filter.getEntryFilterType();
            if (type == null || type.equals((Object)EntryFilterType.NORMAL)) continue;
            return true;
        }
        return false;
    }

    public static void parseSorter(SorterItemCollection sorterItemCol, String oql) throws ParserException {
        sorterItemCol.decode(oql);
    }

    public static String toOQL(SorterItemCollection sorterItemCol) {
        return sorterItemCol.toOQL();
    }

    public static void toOQL(SorterItemCollection sorterItemCol, StringBuffer buff) {
        sorterItemCol.toOQL(buff);
    }

    private static void parseSorter(SorterItemCollection sorterItemCol, TokenList tokList) throws ParserException {
    }

    public int getTopCount() {
        return this.topCount;
    }

    public void setTopCount(int top) {
        this.topCount = top;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public FilterInfo getFilter() {
        return (FilterInfo)this.get(QUERY_FILTER);
    }

    public void setFilter(FilterInfo filter) {
        this.put(QUERY_FILTER, filter);
    }

    public void setFilter(String filterExpr) throws ParserException {
        FilterInfo filter = new FilterInfo(filterExpr);
        this.setFilter(filter);
    }

    public void setFilter(SqlExpr filterExpr) throws ParserException {
        FilterInfo filter = new FilterInfo(filterExpr);
        this.setFilter(filter);
    }

    public SorterItemCollection getSorter() {
        SorterItemCollection coll = (SorterItemCollection)this.get(QUERY_SORTER);
        if (coll == null) {
            coll = new SorterItemCollection();
            this.put(QUERY_SORTER, coll);
        }
        return coll;
    }

    public SelectorItemCollection getSelector() {
        SelectorItemCollection coll = (SelectorItemCollection)this.get(QUERY_SELECTOR);
        if (coll == null) {
            coll = new SelectorItemCollection();
            this.put(QUERY_SELECTOR, coll);
        }
        return coll;
    }

    public void setSelector(SelectorItemCollection coll) {
        this.put(QUERY_SELECTOR, coll);
    }

    public void setSorter(SorterItemCollection coll) {
        this.put(QUERY_SORTER, coll);
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOS_TYPE;
    }

    public ValidateList validate() {
        return null;
    }

    @Override
    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (!(that instanceof EntityViewInfo)) {
            return false;
        }
        if (!this.getClass().getName().equals(that.getClass().getName())) {
            return false;
        }
        return this.toString().equals(((EntityViewInfo)that).toString());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        this.output(buff);
        return buff.toString();
    }

    private String getEntryFilterTypeName(EntryFilterType filterType) {
        String where = "";
        where = filterType.equals((Object)EntryFilterType.ENTRYALLWHERE) ? "EntryAllWhere" : (filterType.equals((Object)EntryFilterType.ENTRYANYWHERE) ? "EntryAnyWhere" : "EntryWhere");
        return where;
    }

    public boolean isIngorePreOrders() {
        return this.ingorePreOrders;
    }

    public void setIngorePreOrders(boolean ingorePreOrders) {
        this.ingorePreOrders = ingorePreOrders;
    }

    public RTQueryJoinCollection getRTQueryJoins() {
        if (this.rtJoins == null) {
            this.rtJoins = new RTQueryJoinCollection();
        }
        return this.rtJoins;
    }

    public FilterCollection getEntryFilters() {
        if (this.entryFilters == null) {
            this.entryFilters = new FilterCollection();
        }
        return this.entryFilters;
    }

    public void setRTQueryJoins(RTQueryJoinCollection coll) {
        this.rtJoins = coll;
    }

    private void setEntryFilters(FilterCollection coll) {
        this.entryFilters = coll;
    }

    public void output(StringBuffer buff) {
        SelectorItemCollection selectItemCol = this.getSelector();
        FilterInfo filter = this.getFilter();
        SorterItemCollection sorterItemCol = this.getSorter();
        boolean flag = false;
        if (selectItemCol.size() > 0) {
            buff.append("SELECT ");
            boolean selectFlag = false;
            for (int i = 0; i < selectItemCol.size(); ++i) {
                String propName;
                SelectorItemInfo selectItem = selectItemCol.get(i);
                if (selectItem == null || (propName = selectItem.getPropertyName()) == null || propName.length() == 0) continue;
                if (selectFlag) {
                    buff.append(", ");
                }
                selectItem.output(buff);
                selectFlag = true;
            }
            flag = true;
        }
        if (filter != null && filter.getFilterItems().size() != 0) {
            if (flag) {
                buff.append(" WHERE ");
            } else {
                buff.append("WHERE ");
                flag = true;
            }
            filter.output(buff);
        }
        if (this.entryFilters != null && this.entryFilters.size() != 0) {
            int entryFilterSize = this.entryFilters.size();
            for (int entryFilterIndex = 0; entryFilterIndex < entryFilterSize; ++entryFilterIndex) {
                FilterInfo filterInfo = this.entryFilters.get(entryFilterIndex);
                if (filterInfo.getFilterItems().size() <= 0) continue;
                String filterName = this.getEntryFilterTypeName(filterInfo.getEntryFilterType());
                buff.append(" ").append(filterName).append(" ");
                filterInfo.output(buff);
            }
        }
        if (sorterItemCol.size() > 0) {
            if (flag) {
                buff.append(" ORDER BY ");
            } else {
                buff.append("ORDER BY ");
            }
            for (int i = 0; i < sorterItemCol.size(); ++i) {
                if (i != 0) {
                    buff.append(", ");
                }
                sorterItemCol.get(i).output(buff);
            }
        }
        if (this.removeEntry) {
            buff.append(" REMOVEENTRY");
        }
    }

    public boolean isAppendSelectors() {
        return this.appendSelectors;
    }

    public void setAppendSelectors(boolean appendSelectors) {
        this.appendSelectors = appendSelectors;
    }

    public String encode() {
        String sRtJoins;
        StringBuffer sb = new StringBuffer();
        sb.append(this.toString());
        if (this.rtJoins != null && !StringUtils.isEmpty((String)(sRtJoins = this.getRTQueryJoins().encode()))) {
            sb.append(" ").append("COMPARTKEY").append(" ").append(sRtJoins);
        }
        return sb.toString();
    }

    public void decode(String encoded) throws ParserException {
        StringReader strReader = new StringReader(encoded);
        Lexer lexer = new Lexer(CompartKeyWord.instance, null, strReader);
        TokenList tokList = new TokenList(lexer);
        CompartExprParser parser = new CompartExprParser(tokList);
        ArrayList list = parser.build();
        if (list.size() == 2) {
            String sOQL = (String)list.get(0);
            String sRTJoin = (String)list.get(1);
            this.initOQL(sOQL);
            this.initRTJoin(sRTJoin);
        } else if (list.size() == 1) {
            String sOQL = (String)list.get(0);
            this.initOQL(sOQL);
        } else {
            throw new ParserException("Illegal argument for decode!");
        }
    }

    @Override
    public Object clone() {
        EntityViewInfo cloned = new EntityViewInfo();
        if (this.getFilter() != null) {
            cloned.setFilter((FilterInfo)this.getFilter().clone());
        }
        cloned.setSelector((SelectorItemCollection)this.getSelector().clone());
        cloned.setSorter((SorterItemCollection)this.getSorter().clone());
        cloned.setRTQueryJoins((RTQueryJoinCollection)this.getRTQueryJoins().clone());
        cloned.setEntryFilters((FilterCollection)this.getEntryFilters().clone());
        cloned.setTopCount(this.getTopCount());
        cloned.setOffset(this.getOffset());
        cloned.setIngorePreOrders(this.isIngorePreOrders());
        cloned.setAppendSelectors(this.isAppendSelectors());
        cloned.setRemoveEntry(this.isRemoveEntry());
        return cloned;
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        super.marshal(marshaller);
        marshaller.writeObject((Object)this.rtJoins);
        marshaller.writeObject((Object)this.entryFilters);
        marshaller.writeInt(this.topCount);
        marshaller.writeInt(this.offset);
        marshaller.writeBoolean(this.ingorePreOrders);
        marshaller.writeBoolean(this.appendSelectors);
        marshaller.writeBoolean(this.removeEntry);
        marshaller.writeBoolean(this.entryPermCol);
        marshaller.writeBoolean(this.baseOnSelector);
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        super.unmarshal(unmarshaller);
        this.rtJoins = (RTQueryJoinCollection)unmarshaller.readObject();
        this.entryFilters = (FilterCollection)unmarshaller.readObject();
        this.topCount = unmarshaller.readInt();
        this.offset = unmarshaller.readInt();
        this.ingorePreOrders = unmarshaller.readBoolean();
        this.appendSelectors = unmarshaller.readBoolean();
        this.removeEntry = unmarshaller.readBoolean();
        this.entryPermCol = unmarshaller.readBoolean();
        this.baseOnSelector = unmarshaller.readBoolean();
    }

    public boolean isRemoveEntry() {
        return this.removeEntry;
    }

    public void setRemoveEntry(boolean removeEntry) {
        this.removeEntry = removeEntry;
    }

    public boolean isEntryPermCol() {
        return this.entryPermCol;
    }

    public void setEntryPermCol(boolean entryPermCol) {
        this.entryPermCol = entryPermCol;
    }

    public boolean isBaseOnSelector() {
        return this.baseOnSelector;
    }

    public void setBaseOnSelector(boolean baseOnSelector) {
        this.baseOnSelector = baseOnSelector;
    }

    public static void main(String[] args) throws ParserException {
        String oql = "select upper(t1.name) order by upper(t2.name) desc,abs(t3.id)!='abc'";
        oql = "ORDER BY name SCHINESE_PINYIN DESC";
        System.out.println("oql = " + oql);
        EntityViewInfo info2 = new EntityViewInfo(oql);
        System.out.println("filteriteminfo = " + info2.toString());
        System.out.println(oql);
    }
}

