/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.InvalidEntityViewException;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class EntityViewInfoCreator {
    public static EntityViewInfo create(String oql, EntityObjectInfo bo) throws InvalidEntityViewException, ParserException {
        return EntityViewInfoCreator.create(oql, bo.getBOSType(), bo);
    }

    public static EntityViewInfo create(String oql, BOSObjectType bosType, EntityObjectInfo bo) throws InvalidEntityViewException {
        try {
            return EntityViewInfoCreator.parseEntityView(bosType, new EntityViewInfo(oql), bo);
        }
        catch (ParserException pe) {
            throw new InvalidEntityViewException(pe.getMessage() + ",   bo = " + bo + ",   bosType = " + bosType + ",   oql = " + oql);
        }
    }

    private static EntityViewInfo parseEntityView(BOSObjectType bosType, EntityViewInfo view, EntityObjectInfo bo) throws InvalidEntityViewException {
        SelectorItemCollection selectors = view.getSelector();
        boolean flag = true;
        String propName = null;
        SelectorItemInfo item = null;
        int len = selectors.size();
        for (int i = 0; i < len; ++i) {
            item = selectors.get(i);
            propName = item.getPropertyName();
            if (!propName.endsWith("*")) continue;
            flag = false;
            break;
        }
        if (flag) {
            return view;
        }
        selectors = view.getSelector();
        SelectorItemCollection newSelectors = new SelectorItemCollection();
        int len2 = selectors.size();
        for (int i = 0; i < len2; ++i) {
            item = selectors.get(i);
            propName = item.getPropertyName();
            if (propName.endsWith("*")) {
                EntityViewInfoCreator.processSelectorItemIncludeStar(propName, newSelectors, bo);
                continue;
            }
            newSelectors.add(item);
        }
        TreeSet<String> noDupSelectors = new TreeSet<String>();
        int len3 = newSelectors.size();
        for (int i = 0; i < len3; ++i) {
            noDupSelectors.add(newSelectors.get(i).getPropertyName());
        }
        EntityViewInfo newView = (EntityViewInfo)view.clone();
        newView.getSelector().clear();
        Iterator iter = noDupSelectors.iterator();
        while (iter.hasNext()) {
            item = new SelectorItemInfo();
            item.setPropertyName((String)iter.next());
            newView.getSelector().add(item);
        }
        return newView;
    }

    private static void processSelectorItemIncludeStar(String propName, SelectorItemCollection selectors, EntityObjectInfo bo) throws InvalidEntityViewException {
        PropertyCollection props = null;
        SelectorItemInfo item = null;
        StringTokenizer token = new StringTokenizer(propName, ".");
        int count = token.countTokens();
        int j = 1;
        String tmp = null;
        String prefix = "";
        EntityObjectInfo parent = bo;
        PropertyInfo prop = null;
        boolean flag = true;
        while (token.hasMoreTokens()) {
            int i;
            int len;
            tmp = token.nextToken();
            props = parent.getInheritedNoDuplicatedPropertiesRuntime();
            if (j == count) {
                len = props.size();
                for (i = 0; i < len; ++i) {
                    prop = props.get(i);
                    if (prop instanceof OwnPropertyInfo) {
                        item = new SelectorItemInfo();
                        item.setPropertyName(prefix + prop.getName());
                        selectors.add(item);
                        continue;
                    }
                    if (!(prop instanceof LinkPropertyInfo)) continue;
                    String name = ((LinkPropertyInfo)prop).getRelationship().getSupplierObject().getLogicalKey().getKeyPropertys().get(0).getName();
                    item = new SelectorItemInfo();
                    item.setPropertyName(prefix + prop.getName() + "." + name);
                    selectors.add(item);
                }
            } else {
                prefix = StringUtils.isEmpty((String)prefix) ? tmp + "." : prefix + tmp + ".";
                len = props.size();
                for (i = 0; i < len; ++i) {
                    prop = props.get(i);
                    if (!prop.getName().equalsIgnoreCase(tmp)) continue;
                    if (prop instanceof LinkPropertyInfo) {
                        parent = ((LinkPropertyInfo)prop).getRelationship().getSupplierObject();
                        flag = false;
                        break;
                    }
                    throw new InvalidEntityViewException("Cannot parse selecor item[" + propName + "]");
                }
                if (flag) {
                    throw new InvalidEntityViewException("Cannot parse selecor item[" + propName + "]");
                }
            }
            ++j;
        }
    }
}

