/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterItemBaseInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.util.ViewParseUtils;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlDateTimeExpr;
import com.kingdee.bos.sql.dom.expr.SqlDoubleExpr;
import com.kingdee.bos.sql.dom.expr.SqlEmptyExpr;
import com.kingdee.bos.sql.dom.expr.SqlExistsExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlInListExpr;
import com.kingdee.bos.sql.dom.expr.SqlInSubQueryExpr;
import com.kingdee.bos.sql.dom.expr.SqlIntExpr;
import com.kingdee.bos.sql.dom.expr.SqlLongExpr;
import com.kingdee.bos.sql.dom.expr.SqlMethodInvokeExpr;
import com.kingdee.bos.sql.dom.expr.SqlNCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlNullExpr;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.UniqueID;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class FilterItemInfo
extends FilterItemBaseInfo
implements Serializable {
    private static final long serialVersionUID = -655230613831207168L;
    private static final Logger logger = Logger.getLogger(FilterItemInfo.class);
    protected static final BOSObjectType FILTER_ITEM_BOS_TYPE = BOSObjectType.create((String)"flim");

    public FilterItemInfo() {
        this(null, null);
    }

    public FilterItemInfo(String oql) {
        try {
            this.parseOQL(oql);
        }
        catch (ParserException e) {
            throw new RuntimeException("error, oql :" + oql, e);
        }
    }

    public FilterItemInfo(String compareExpr, Object compareValue) {
        this(compareExpr, compareValue, CompareType.EQUALS);
    }

    public FilterItemInfo(String compareExpr, Object compareValue, boolean isRefCrossTable) {
        this(compareExpr, compareValue, CompareType.EQUALS, isRefCrossTable);
    }

    public FilterItemInfo(String compareExpr, Object compareValue, boolean isRefCrossTable, boolean isFuncCol) {
        this(compareExpr, compareValue, CompareType.EQUALS, isRefCrossTable, isFuncCol);
    }

    public FilterItemInfo(String compareExpr, Object compareValue, CompareType compareType) {
        this(compareExpr, compareValue, compareType, false);
    }

    public FilterItemInfo(String compareExpr, Object compareValue, CompareType compareType, String entityName) {
        this(compareExpr, compareValue, compareType, false, entityName);
    }

    public FilterItemInfo(String compareExpr, Object compareValue, CompareType compareType, boolean isRefCrossTable) {
        this(compareExpr, compareValue, compareType, isRefCrossTable, null);
    }

    public FilterItemInfo(String compareExpr, Object compareValue, CompareType compareType, boolean isRefCrossTable, String entityName) {
        this(compareExpr, compareValue, compareType, isRefCrossTable, entityName, false);
    }

    public FilterItemInfo(String compareExpr, Object compareValue, CompareType compareType, boolean isRefCrossTable, boolean isFuncCol) {
        this(compareExpr, compareValue, compareType, isRefCrossTable, null, isFuncCol);
    }

    private FilterItemInfo(String compareExpr, Object compareValue, CompareType compareType, boolean isRefCrossTable, String entityName, boolean isFuncCol) {
        super(compareExpr, compareValue, compareType, isRefCrossTable, entityName);
        this.setFuncCol(isFuncCol);
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        super.marshal(marshaller);
        marshaller.writeBoolean(this.ignoreAsTrue);
        marshaller.writeBoolean(this.ignoreAsFalse);
        marshaller.writeBoolean(this.compareValueIsProperty);
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        super.unmarshal(unmarshaller);
        this.ignoreAsTrue = unmarshaller.readBoolean();
        this.ignoreAsFalse = unmarshaller.readBoolean();
        this.compareValueIsProperty = unmarshaller.readBoolean();
    }

    @Override
    public Object clone() {
        FilterItemInfo cloned = new FilterItemInfo();
        cloned.setPropertyName(this.getPropertyName());
        cloned.setCompareType(this.getCompareType());
        if (this.getCompareValue() != null) {
            Object compareValue = null;
            try {
                compareValue = ObjectUtils.createCopy((Object)this.getCompareValue());
            }
            catch (CloneNotSupportedException e) {
                logger.error((Object)e, (Throwable)e);
            }
            cloned.setCompareValue(compareValue);
        }
        cloned.setRefCrossTable(this.isRefCrossTable());
        cloned.setString("entityName", this.getEntityName());
        cloned.setIgnoreAsTrue(this.getIgnoreAsTrue());
        cloned.setIgnoreAsFalse(this.getIgnoreAsFalse());
        cloned.setCompareValueIsProperty(this.isCompareValueIsProperty());
        cloned.setRefCrossTable(this.isRefCrossTable());
        cloned.setUserDefined(this.isUserDefined());
        cloned.setFuncCol(this.isFuncCol());
        cloned.setExprTemplate(this.getExprTemplate());
        try {
            cloned.setExprReturnType(this.getExprReturnType());
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
        }
        if (this.getFieldList() != null) {
            List newFieldList = null;
            try {
                newFieldList = (List)ObjectUtils.createCopy(this.getFieldList());
            }
            catch (CloneNotSupportedException e) {
                logger.error((Object)e, (Throwable)e);
            }
            cloned.getFieldList().addAll(newFieldList);
        }
        return cloned;
    }

    String getEntityName() {
        return this.getString("entityName");
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        this.output(buff);
        return buff.toString();
    }

    public void output(StringBuffer buff) {
        this.innerOutput(buff);
    }

    protected void innerOutput(StringBuffer buff) {
        Object cmpVal;
        CompareType compareType = this.getCompareType();
        if (!compareType.equals((Object)CompareType.EXISTS) && !compareType.equals((Object)CompareType.NOTEXISTS)) {
            buff.append(this.getPropertyName());
        }
        if ((cmpVal = this.getCompareValue()) == null) {
            if (compareType.equals((Object)CompareType.EQUALS) || compareType.equals((Object)CompareType.IS)) {
                buff.append(" IS NULL");
            } else if (compareType.equals((Object)CompareType.NOTEQUALS) || compareType.equals((Object)CompareType.ISNOT)) {
                buff.append(" IS NOT NULL");
            }
        } else if (compareType.equals((Object)CompareType.IS) && "EMPTY".equals(cmpVal.toString())) {
            buff.append(" IS EMPTY");
        } else if (compareType.equals((Object)CompareType.ISNOT) && "EMPTY".equals(cmpVal.toString())) {
            buff.append(" IS NOT EMPTY");
        } else if (compareType.equals((Object)CompareType.INNER)) {
            buff.append(" IN (");
            buff.append(cmpVal.toString());
            buff.append(")");
        } else if (compareType.equals((Object)CompareType.NOTINNER)) {
            buff.append(" NOT IN (");
            buff.append(cmpVal.toString());
            buff.append(")");
        } else if (compareType.equals((Object)CompareType.EXISTS)) {
            buff.append(" EXISTS (");
            buff.append(cmpVal.toString());
            buff.append(")");
        } else if (compareType.equals((Object)CompareType.NOTEXISTS)) {
            buff.append(" NOT EXISTS (");
            buff.append(cmpVal.toString());
            buff.append(")");
        } else {
            buff.append(' ');
            buff.append(compareType.getName());
            buff.append(' ');
            if (cmpVal instanceof String) {
                String cmpStr = (String)cmpVal;
                if (this.isCompareValueIsProperty()) {
                    block6: for (int i = 0; i < cmpStr.length(); ++i) {
                        char ch = cmpStr.charAt(i);
                        switch (ch) {
                            case '\'': {
                                buff.append("''");
                                continue block6;
                            }
                            default: {
                                buff.append(ch);
                            }
                        }
                    }
                } else {
                    buff.append('\'');
                    block7: for (int i = 0; i < cmpStr.length(); ++i) {
                        char ch = cmpStr.charAt(i);
                        switch (ch) {
                            case '\'': {
                                buff.append("''");
                                continue block7;
                            }
                            default: {
                                buff.append(ch);
                            }
                        }
                    }
                    buff.append('\'');
                }
            } else if (cmpVal instanceof Character) {
                char ch = ((Character)cmpVal).charValue();
                if (ch == '\'') {
                    buff.append("''''");
                } else {
                    buff.append('\'');
                    buff.append(ch);
                    buff.append('\'');
                }
            } else if (cmpVal instanceof Date) {
                Date date = (Date)cmpVal;
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(date);
                SimpleDateFormat sdf = new SimpleDateFormat("{yyyy-MM-dd HH:mm:ss}");
                buff.append(sdf.format(cal.getTime()));
            } else if (cmpVal instanceof Boolean) {
                Boolean b = (Boolean)cmpVal;
                buff.append(b != false ? (char)'1' : '0');
            } else if (cmpVal instanceof Collection) {
                buff.append('(');
                ArrayList<String> liString = new ArrayList<String>();
                Collection collection = (Collection)cmpVal;
                for (Object item : collection) {
                    if (item == null) {
                        liString.add("NULL");
                        continue;
                    }
                    if (item instanceof String) {
                        StringBuffer sb = new StringBuffer();
                        sb.append('\'');
                        sb.append(item.toString().replaceAll("'", "''"));
                        sb.append('\'');
                        liString.add(sb.toString());
                        continue;
                    }
                    liString.add(item.toString());
                }
                Collections.sort(liString);
                Iterator iter = liString.iterator();
                boolean flag = false;
                while (iter.hasNext()) {
                    if (flag) {
                        buff.append(", ");
                    }
                    Object item = iter.next();
                    buff.append(item.toString());
                    flag = true;
                }
                buff.append(')');
            } else if (cmpVal instanceof Uuid) {
                Uuid uid = (Uuid)cmpVal;
                buff.append('\'');
                buff.append(uid.toString());
                buff.append('\'');
            } else if (cmpVal instanceof BOSUuid) {
                BOSUuid bosId = (BOSUuid)cmpVal;
                buff.append('\'');
                buff.append(bosId.toString());
                buff.append('\'');
            } else {
                buff.append(cmpVal.toString());
            }
        }
    }

    public void parseOQL(String oql) throws ParserException {
        FilterItemInfo.parseOQL(this, ViewParseUtils.parseFilterExpr(oql));
    }

    public void parseOQL(SqlExpr expr) throws ParserException {
        FilterItemInfo.parseOQL(this, expr);
    }

    public static void parseOQL(FilterItemInfo filterItem, String oql) throws ParserException {
        FilterItemInfo.parseOQL(filterItem, ViewParseUtils.parseFilterExpr(oql));
    }

    public static void parseOQL(FilterItemInfo filterItem, SqlExpr expr) throws ParserException {
        if (expr == null) {
            return;
        }
        if (expr instanceof SqlBinaryOpExpr) {
            FilterItemInfo.parseBinaryOpExpr(filterItem, (SqlBinaryOpExpr)expr);
        } else if (expr instanceof SqlInListExpr) {
            FilterItemInfo.parseSqlInListExpr(filterItem, (SqlInListExpr)expr);
        } else if (expr instanceof SqlInSubQueryExpr) {
            FilterItemInfo.parseSqlInSubQueryExpr(filterItem, (SqlInSubQueryExpr)expr);
        } else if (expr instanceof SqlExistsExpr) {
            FilterItemInfo.parseSqlExistsQueryExpr(filterItem, (SqlExistsExpr)expr);
        } else {
            throw new ParserException("only support binary op expr filter." + expr);
        }
    }

    private static void parseBinaryOpExpr(FilterItemInfo filterItem, SqlBinaryOpExpr binaryOpExpr) throws ParserException {
        CompareType compareType = null;
        SqlExpr leftExpr = binaryOpExpr.left;
        SqlExpr rightExpr = binaryOpExpr.right;
        switch (binaryOpExpr.operator) {
            case 10: {
                compareType = CompareType.EQUALS;
                break;
            }
            case 11: {
                compareType = CompareType.GREATER;
                break;
            }
            case 12: {
                compareType = CompareType.GREATER_EQUALS;
                break;
            }
            case 14: {
                compareType = CompareType.LESS;
                break;
            }
            case 16: {
                compareType = CompareType.NOTEQUALS;
                break;
            }
            case 15: {
                compareType = CompareType.LESS_EQUALS;
                break;
            }
            case 18: {
                compareType = CompareType.LIKE;
                break;
            }
            case 40: {
                compareType = CompareType.NOTLIKE;
                break;
            }
            case 23: {
                compareType = CompareType.NOTEQUALS;
                break;
            }
            case 13: {
                if ("EMPTY".equalsIgnoreCase(rightExpr.toString())) {
                    compareType = CompareType.IS;
                    break;
                }
                compareType = CompareType.EQUALS;
                break;
            }
            case 41: {
                if ("EMPTY".equalsIgnoreCase(rightExpr.toString())) {
                    compareType = CompareType.ISNOT;
                    break;
                }
                compareType = CompareType.NOTEQUALS;
                break;
            }
            default: {
                throw new ParserException("Illegal Format of FilterItemInfo : " + binaryOpExpr.toString());
            }
        }
        filterItem.setCompareType(compareType);
        if (leftExpr instanceof SqlIdentifierExpr || leftExpr instanceof SqlBinaryOpExpr || leftExpr instanceof SqlMethodInvokeExpr) {
            if (leftExpr instanceof SqlIdentifierExpr) {
                SqlIdentifierExpr leftIdentExpr = (SqlIdentifierExpr)leftExpr;
                filterItem.setPropertyName(leftIdentExpr.value, false);
            } else {
                filterItem.setPropertyName(leftExpr.toString(), false);
            }
            if (!ViewParseUtils.isIdentifierExpr(leftExpr)) {
                int dataType;
                filterItem.setFuncCol(true);
                filterItem.clearFieldList();
                UniqueID fieldIndex = new UniqueID(0L);
                if (leftExpr instanceof SqlMethodInvokeExpr) {
                    String sMethodName = ((SqlMethodInvokeExpr)leftExpr).methodName;
                    dataType = KSqlUtil.getSqlType((String)sMethodName);
                } else {
                    dataType = 12;
                }
                ConstDataType type = ViewParseUtils.getConstDataTypeBySqlType(dataType);
                filterItem.setExprReturnType(type);
                ViewParseUtils.readBinaryFilterExpr(filterItem.getFieldList(), fieldIndex, leftExpr);
                StringBuffer leftExprBuff = new StringBuffer();
                DrSQLFormater formater = new DrSQLFormater(leftExprBuff);
                try {
                    formater.formatExpr(leftExpr);
                }
                catch (FormaterException e) {
                    logger.error((Object)e, (Throwable)e);
                    throw new ParserException("readFilterItem Error.");
                }
                filterItem.setExprTemplate(leftExprBuff.toString());
            }
        } else {
            throw new ParserException("TODO. leftExpr is : " + leftExpr.getClass().getName());
        }
        if (ViewParseUtils.isIdentifierExpr(rightExpr)) {
            filterItem.setCompareValueIsProperty(true);
            filterItem.setCompareValue(rightExpr.toString());
        } else if (rightExpr instanceof SqlBinaryOpExpr) {
            StringBuffer propNameBuff = new StringBuffer();
            DrSQLFormater formater = new DrSQLFormater(propNameBuff);
            try {
                formater.formatExpr(rightExpr);
            }
            catch (FormaterException e) {
                logger.error((Object)e, (Throwable)e);
                throw new ParserException("readFilterItem Error.");
            }
            filterItem.setCompareValueIsProperty(true);
            filterItem.setCompareValue(propNameBuff.toString());
        } else {
            Object rightValue = FilterItemInfo.getExprValue(rightExpr);
            filterItem.setCompareValue(rightValue);
        }
    }

    protected static void parseSqlInListExpr(FilterItemInfo filterItem, SqlInListExpr inListExpr) throws ParserException {
        StringBuffer propNameBuff = new StringBuffer();
        DrSQLFormater formater = new DrSQLFormater(propNameBuff);
        try {
            formater.formatExpr(inListExpr.expr);
        }
        catch (FormaterException e) {
            logger.error((Object)e, (Throwable)e);
            throw new ParserException("readFilterItem Error.");
        }
        filterItem.setPropertyName(propNameBuff.toString());
        filterItem.setCompareType(inListExpr.not ? CompareType.NOTINCLUDE : CompareType.INCLUDE);
        Iterator iter = inListExpr.targetList.iterator();
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        while (iter.hasNext()) {
            SqlExpr itemExpr = (SqlExpr)iter.next();
            Object itemVal = FilterItemInfo.getExprValue(itemExpr);
            set.add(itemVal);
        }
        filterItem.setCompareValue(set);
    }

    protected static void parseSqlExistsQueryExpr(FilterItemInfo filterItem, SqlExistsExpr existsExpr) throws ParserException {
        String subQueryStr;
        if (existsExpr.not) {
            filterItem.setCompareType(CompareType.NOTEXISTS);
        } else {
            filterItem.setCompareType(CompareType.EXISTS);
        }
        DrSQLFormater formater = new DrSQLFormater();
        StringBuffer subQueryBuffer = new StringBuffer();
        try {
            formater.setBuffer(subQueryBuffer);
            formater.formatSelectBase(existsExpr.subQuery);
        }
        catch (FormaterException e) {
            logger.error((Object)e, (Throwable)e);
            throw new ParserException("readFilterItem Error.");
        }
        String rightValue = subQueryStr = formater.getBuffer().toString();
        filterItem.setCompareValue(rightValue);
    }

    protected static void parseSqlInSubQueryExpr(FilterItemInfo filterItem, SqlInSubQueryExpr inQueryExpr) throws ParserException {
        String subQueryStr;
        if (inQueryExpr.not) {
            filterItem.setCompareType(CompareType.NOTINNER);
        } else {
            filterItem.setCompareType(CompareType.INNER);
        }
        SqlExpr leftExpr = inQueryExpr.expr;
        DrSQLFormater formater = new DrSQLFormater();
        if (leftExpr instanceof SqlIdentifierExpr) {
            SqlIdentifierExpr leftIdentExpr = (SqlIdentifierExpr)leftExpr;
            filterItem.setPropertyName(leftIdentExpr.value);
        } else if (leftExpr instanceof SqlBinaryOpExpr) {
            StringBuffer propNameBuff = formater.getBuffer();
            try {
                formater.formatExpr(leftExpr);
            }
            catch (FormaterException e) {
                logger.error((Object)e, (Throwable)e);
                throw new ParserException("readFilterItem Error.");
            }
            filterItem.setPropertyName(propNameBuff.toString());
        } else {
            throw new ParserException("TODO. leftExpr is : " + leftExpr.getClass().getName());
        }
        StringBuffer subQueryBuffer = new StringBuffer();
        try {
            formater.setBuffer(subQueryBuffer);
            formater.formatSelectBase(inQueryExpr.subQuery);
        }
        catch (FormaterException e) {
            logger.error((Object)e, (Throwable)e);
            throw new ParserException("readFilterItem Error.");
        }
        String rightValue = subQueryStr = formater.getBuffer().toString();
        filterItem.setCompareValue(rightValue);
    }

    private static Object getExprValue(SqlExpr expr) throws ParserException {
        Object rtnValue;
        if (expr instanceof SqlIntExpr) {
            SqlIntExpr rightIntExpr = (SqlIntExpr)expr;
            int intValue = Integer.parseInt(rightIntExpr.text);
            rtnValue = intValue;
        } else if (expr instanceof SqlLongExpr) {
            SqlLongExpr rightIntExpr = (SqlLongExpr)expr;
            long intValue = Long.parseLong(rightIntExpr.text);
            rtnValue = intValue;
        } else if (expr instanceof SqlDoubleExpr) {
            SqlDoubleExpr rightDoubleExpr = (SqlDoubleExpr)expr;
            rtnValue = new BigDecimal(rightDoubleExpr.text);
        } else if (expr instanceof SqlCharExpr) {
            SqlCharExpr rightCharExpr = (SqlCharExpr)expr;
            rtnValue = rightCharExpr.getJavaString();
        } else if (expr instanceof SqlNCharExpr) {
            SqlNCharExpr rightNCharExpr = (SqlNCharExpr)expr;
            rtnValue = rightNCharExpr.getJavaString();
        } else if (expr instanceof SqlDateTimeExpr) {
            SqlDateTimeExpr rightDateTimeExpr = (SqlDateTimeExpr)expr;
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(1, rightDateTimeExpr.getYear());
            cal.set(2, rightDateTimeExpr.getMonth() - 1);
            cal.set(5, rightDateTimeExpr.getDate());
            cal.set(11, rightDateTimeExpr.getHour());
            cal.set(12, rightDateTimeExpr.getMinute());
            cal.set(13, rightDateTimeExpr.getSecond());
            cal.set(14, rightDateTimeExpr.getMillisecond());
            rtnValue = new Timestamp(cal.getTimeInMillis());
        } else if (expr instanceof SqlNullExpr) {
            rtnValue = null;
        } else if (expr instanceof SqlEmptyExpr) {
            rtnValue = "EMPTY";
        } else {
            StringBuffer errMsgBuff = new StringBuffer();
            try {
                new DrSQLFormater(errMsgBuff).formatExpr(expr);
            }
            catch (FormaterException e) {
                logger.error((Object)e, (Throwable)e);
            }
            throw new ParserException("TODO." + expr + " : " + errMsgBuff);
        }
        return rtnValue;
    }

    @Override
    public BOSObjectType getBOSType() {
        return FILTER_ITEM_BOS_TYPE;
    }
}

