/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.metadata.entity.ConstraintInfo;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.TypeConversionUtils;

public class NumericConstraintInfo
extends ConstraintInfo {
    private static final BOSObjectType BOS_TYPE = BOSObjectType.create((String)"nust");

    public NumericConstraintInfo() {
        this.setMinValue(Integer.toString(Integer.MIN_VALUE));
        this.setMaxValue(Integer.toString(Integer.MAX_VALUE));
    }

    public String getMaxValue() {
        return this.getString("maxValue");
    }

    public void setMaxValue(String maxValue) {
        this.setString("maxValue", maxValue);
    }

    public String getMinValue() {
        return this.getString("minValue");
    }

    public void setMinValue(String minValue) {
        this.setString("minValue", minValue);
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOS_TYPE;
    }

    @Override
    public ValidateList validate() {
        int min = Integer.MIN_VALUE;
        int max = Integer.MAX_VALUE;
        try {
            min = TypeConversionUtils.objToInt((Object)this.getMinValue());
            max = TypeConversionUtils.objToInt((Object)this.getMaxValue());
        }
        catch (IllegalConversionException illegalConversionException) {
            // empty catch block
        }
        if (min > max) {
            ValidateMetaData vld = new ValidateMetaData();
            vld.addError("NumericConstraintInfo " + this.getName() + ": MinValue cannot great than MaxValue.");
            return vld.getValidateList();
        }
        return null;
    }
}

