/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.RTQueryJoinExprParser;
import com.kingdee.bos.metadata.entity.RTQueryJoinInfo;
import com.kingdee.bos.metadata.entity.RTQueryJoinItemCollection;
import com.kingdee.bos.metadata.entity.RTQueryJoinItemInfo;
import com.kingdee.bos.metadata.entity.RTQueryJoinKeyWord;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.JoinType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.StringReader;
import com.kingdee.bos.sql.parser.TokenList;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.jdom2.JDOMException;

public class RTQueryJoinCollection
implements Serializable {
    private static final long serialVersionUID = 5033305229728924L;
    private static final Logger log = Logger.getLogger(RTQueryJoinCollection.class);
    private ArrayList list = null;

    public RTQueryJoinCollection() {
    }

    public RTQueryJoinCollection(String sXML) throws ParserException, JDOMException, IOException {
        this.parse(sXML);
    }

    private ArrayList getList() {
        if (this.list == null) {
            this.list = new ArrayList();
        }
        return this.list;
    }

    public void add(RTQueryJoinInfo info) {
        if (info != null) {
            this.getList().add(info);
        } else {
            log.error((Object)"Invalid parameter info is null");
        }
    }

    public void remove(RTQueryJoinInfo info) {
        this.getList().remove(info);
    }

    public RTQueryJoinInfo get(int index) {
        return (RTQueryJoinInfo)this.getList().get(index);
    }

    public int size() {
        return this.getList().size();
    }

    public void clear() {
        this.getList().clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.list != null) {
            for (int i = 0; i < this.list.size(); ++i) {
                RTQueryJoinInfo info = (RTQueryJoinInfo)this.list.get(i);
                if (i > 0) {
                    sb.append(" " + RTQueryJoinExprParser.TOKEN_AND + " ");
                }
                sb.append("(");
                sb.append(" " + info.getLeftEntityName());
                sb.append(" " + RTQueryJoinExprParser.JoinType2String(info.getJoinType()));
                sb.append(" " + info.getRightEntityName());
                sb.append(" " + RTQueryJoinExprParser.TOKEN_FROM.value + " ");
                sb.append(info.getRightEntityPK().toString());
                RTQueryJoinItemCollection itemColl = info.getRtQueryJoinItemInfos();
                for (int j = 0; j < itemColl.size(); ++j) {
                    sb.append(" " + RTQueryJoinExprParser.TOKEN_ON + " ");
                    RTQueryJoinItemInfo item = itemColl.get(j);
                    sb.append(item.toString());
                }
                sb.append(" ) ");
            }
        }
        return sb.toString();
    }

    public String toXML() {
        return this.toString();
    }

    public void parse(String expr) throws ParserException, JDOMException, IOException {
        if (StringUtils.isEmpty((String)expr)) {
            return;
        }
        this.clear();
        StringReader strReader = new StringReader(expr);
        Lexer lexer = new Lexer(RTQueryJoinKeyWord.instance, null, strReader);
        TokenList tokList = new TokenList(lexer);
        RTQueryJoinExprParser parser = new RTQueryJoinExprParser(tokList);
        ArrayList list = parser.build();
        if (list.size() < 0) {
            throw new ParserException("Illegal argument for decode,  faild!");
        }
        for (int i = 0; i < list.size(); ++i) {
            RTQueryJoinInfo info = (RTQueryJoinInfo)list.get(i);
            this.add(info);
        }
    }

    public String encode() {
        return this.toString();
    }

    public void decode(String encoded) throws ParserException {
        try {
            this.parse(encoded);
        }
        catch (JDOMException e) {
            throw new ParserException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ParserException(e.getMessage(), (Throwable)e);
        }
    }

    public Object clone() {
        try {
            return ObjectUtils.createCopy((Object)this);
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError();
        }
    }

    public static void main(String[] args) {
        RTQueryJoinCollection joinColl = new RTQueryJoinCollection();
        RTQueryJoinInfo info = new RTQueryJoinInfo();
        info.setLeftEntityName("LeftEntity1");
        info.setRightEntityName("RightEntity1");
        info.setRightEntityPK(MetaDataPK.create("fdasfdsasdfafsdaasdfsdfasdfa"));
        info.setJoinType(JoinType.INNERJOIN);
        RTQueryJoinItemInfo itemInfo = new RTQueryJoinItemInfo();
        itemInfo.setLeftFieldName("field1");
        itemInfo.setCompareType(CompareType.EQUALS);
        itemInfo.setRightFieldName("field2");
        info.getRtQueryJoinItemInfos().add(itemInfo);
        itemInfo = new RTQueryJoinItemInfo();
        itemInfo.setLeftFieldName("field3");
        itemInfo.setCompareType(CompareType.NOTEQUALS);
        itemInfo.setRightFieldName("field4");
        info.getRtQueryJoinItemInfos().add(itemInfo);
        joinColl.add(info);
        info = new RTQueryJoinInfo();
        info.setLeftEntityName("LeftEntity2");
        info.setRightEntityName("RightEntity2");
        info.setRightEntityPK(MetaDataPK.create("adfasdfsaadsfdsfaasaaa"));
        info.setJoinType(JoinType.RIGHTJOIN);
        itemInfo = new RTQueryJoinItemInfo();
        itemInfo.setLeftFieldName("field5");
        itemInfo.setCompareType(CompareType.EQUALS);
        itemInfo.setRightFieldName("field6");
        info.getRtQueryJoinItemInfos().add(itemInfo);
        joinColl.add(info);
        String s = joinColl.toXML();
        System.out.println(s);
        System.out.println("");
        try {
            RTQueryJoinCollection joinColl2 = new RTQueryJoinCollection(s);
            System.out.println(joinColl2.toXML());
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

