/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.entity;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.data.CrossTableInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RelationshipInfo
extends AbstractMetaDataValue
implements Serializable {
    private Map<String, InnerCache> caches = new ConcurrentHashMap<String, InnerCache>();

    public RelationshipInfo() {
    }

    protected RelationshipInfo(boolean init) {
        super(init);
    }

    @Override
    protected void clearVariableWhenValueChanged(String key) {
        super.clearVariableWhenValueChanged(key);
        if ("clientObject".equals(key)) {
            InnerCache cache = this.getCache();
            cache.clientObject = null;
            cache.isParentChildRelation = null;
            cache.clientProperty = null;
            return;
        }
        if ("supplierObject".equals(key)) {
            InnerCache cache = this.getCache();
            cache.supplierObject = null;
            cache.isParentChildRelation = null;
            cache.supplierProperty = null;
            return;
        }
        if ("type".equals(key)) {
            InnerCache cache = this.getCache();
            cache.type = null;
            return;
        }
    }

    public RelationshipType getType() {
        InnerCache cache = this.getCache();
        if (cache.type == null) {
            RelationshipType rtype = RelationshipType.getEnum(this.getString("type"));
            if (rtype == null) {
                rtype = RelationshipType.ASSOCIATION;
            }
            cache.type = rtype;
        }
        return cache.type;
    }

    public void setType(RelationshipType type) {
        if (type != null) {
            this.setString("type", type.getName());
        }
    }

    public EntityObjectInfo getClientObject() {
        InnerCache cache = this.getCache();
        if (cache.clientObject == null) {
            cache.clientObject = (EntityObjectInfo)this.get("clientObject");
        }
        return cache.clientObject;
    }

    public void setClientObject(EntityObjectInfo clientObject) {
        this.put("clientObject", clientObject);
    }

    public boolean isMultiRelation() {
        return !CardinalityType.isOneORZero(this.getClientCardinality()) && !CardinalityType.isOneORZero(this.getSupplierCardinality());
    }

    public boolean isClient(EntityObjectInfo entity) {
        return this.isClient(entity.getFullName());
    }

    public boolean isClient(String entityName) {
        if (this.getSupplierObject() == null || this.getClientObject() == null) {
            return false;
        }
        return this.getClientObject().getFullName().equals(entityName) || !this.getSupplierObject().getFullName().equals(entityName);
    }

    public PropertyInfo getClientProperty() {
        InnerCache cache = this.getCache();
        if (cache.clientProperty != null) {
            return cache.clientProperty.cvalue();
        }
        PropertyInfo clntProp = this.innerGetClientProperty(false);
        cache.clientProperty = PropertyInfo.cnulls(clntProp);
        return clntProp;
    }

    private PropertyInfo innerGetClientProperty(boolean isDesign) {
        EntityObjectInfo client = this.getClientObject();
        if (client == null) {
            return null;
        }
        if (CardinalityType.isOneORZero(this.getSupplierCardinality())) {
            return this.getProperty(client, isDesign);
        }
        return this.getLogicalKeyProperty(client, isDesign);
    }

    public PropertyInfo getClientPropertyDesignTime() {
        return this.innerGetClientProperty(true);
    }

    private PropertyInfo getProperty(EntityObjectInfo entity, boolean isDesign) {
        PropertyCollection pcol = isDesign ? entity.getInheritedProperties() : entity.getInheritedPropertiesRuntime();
        int j = pcol.size();
        for (int i = 0; i < j; ++i) {
            PropertyInfo prop = pcol.get(i);
            if (!(prop instanceof LinkPropertyInfo) || !((LinkPropertyInfo)prop).getRelationship().getName().equalsIgnoreCase(this.getName())) continue;
            return prop;
        }
        return null;
    }

    private PropertyInfo getLogicalKeyProperty(EntityObjectInfo entity, boolean isDesign) {
        PropertyCollection keyProps;
        if (isDesign) {
            LogicalKeyInfo logicKey = entity.getLogicalKey();
            if (logicKey == null) {
                throw new RuntimeException("Metadata define error. Entity not define logic key. Entity:" + entity.getFullName());
            }
            keyProps = logicKey.getKeyPropertys();
        } else {
            keyProps = entity.getLogicalKeyPropertiesRuntime();
        }
        if (keyProps != null && keyProps.size() == 1) {
            return keyProps.get(0);
        }
        return null;
    }

    public PropertyInfo getSupplierProperty() {
        InnerCache cache = this.getCache();
        if (cache.supplierProperty != null) {
            return cache.supplierProperty.cvalue();
        }
        PropertyInfo suppProp = this.innerGetSupplierProperty(false);
        cache.supplierProperty = PropertyInfo.cnulls(suppProp);
        return suppProp;
    }

    private PropertyInfo innerGetSupplierProperty(boolean isDesign) {
        EntityObjectInfo supplier = this.getSupplierObject();
        if (supplier == null) {
            return null;
        }
        if (CardinalityType.isOneORZero(this.getSupplierCardinality())) {
            return this.getLogicalKeyProperty(supplier, isDesign);
        }
        return this.getProperty(supplier, isDesign);
    }

    public PropertyInfo getSupplierPropertyDesignTime() {
        return this.innerGetSupplierProperty(true);
    }

    public EntityObjectInfo getSupplierObject() {
        InnerCache cache = this.getCache();
        if (cache.supplierObject == null) {
            cache.supplierObject = (EntityObjectInfo)this.get("supplierObject");
        }
        return cache.supplierObject;
    }

    public void setSupplierObject(EntityObjectInfo supplierObject) {
        this.put("supplierObject", supplierObject);
    }

    public CardinalityType getSupplierCardinality() {
        CardinalityType ctype = CardinalityType.getEnum(this.getString("supplierCardinality"));
        if (ctype != null) {
            return ctype;
        }
        return CardinalityType.ONE;
    }

    public void setSupplierCardinality(CardinalityType supplierCardinality) {
        if (supplierCardinality != null) {
            this.setString("supplierCardinality", supplierCardinality.getName());
        }
    }

    public CardinalityType getClientCardinality() {
        CardinalityType ctype = CardinalityType.getEnum(this.getString("clientCardinality"));
        if (ctype != null) {
            return ctype;
        }
        return CardinalityType.ONE;
    }

    public void setClientCardinality(CardinalityType clientCardinality) {
        if (clientCardinality != null) {
            this.setString("clientCardinality", clientCardinality.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReverseLink(EntityObjectInfo parentObject) {
        EntityObjectInfo clientObject;
        if (parentObject == null) {
            throw new IllegalArgumentException("parentObject cannot be null!");
        }
        EntityObjectInfo supplierObject = this.getSupplierObject();
        if (supplierObject == null) {
            block14: {
                try {
                    IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(ConfigMDUtil.getContext());
                    loader.clear(MetaDataTypeList.RELATIONSHIP, MetaDataPK.create(this.getFullName()));
                    RelationshipInfo rs = (RelationshipInfo)loader.get(MetaDataTypeList.RELATIONSHIP, MetaDataPK.create(this.getFullName()));
                    EntityObjectInfo tmp = rs.getSupplierObject();
                    if (tmp == null) break block14;
                    RelationshipInfo relationshipInfo = this;
                    synchronized (relationshipInfo) {
                        supplierObject = this.getSupplierObject();
                        if (supplierObject == null) {
                            this.setSupplierObject(tmp);
                            supplierObject = tmp;
                        }
                    }
                }
                catch (Throwable loader) {
                    // empty catch block
                }
            }
            if (supplierObject == null) {
                Context ctx = ConfigMDUtil.getContext();
                String ais = null;
                if (ctx != null) {
                    ais = ctx.getAIS();
                }
                throw new IllegalArgumentException(this.getFullName() + " : supplierObject cannot be null! AIS:" + ais);
            }
        }
        if (RelationshipInfo.equals(supplierObject, clientObject = this.getClientObject())) {
            return false;
        }
        if (this.isParentChildRelation()) {
            return false;
        }
        if (RelationshipInfo.equals(supplierObject, parentObject)) {
            return true;
        }
        if (RelationshipInfo.equals(clientObject, parentObject)) {
            return false;
        }
        return false;
    }

    private boolean isParentChildRelation() {
        InnerCache cache = this.getCache();
        if (cache.isParentChildRelation != null) {
            return cache.isParentChildRelation;
        }
        Boolean isPrtChld = null;
        for (EntityObjectInfo tmp = this.getSupplierObject(); tmp != null; tmp = tmp.getBaseEntity()) {
            if (!RelationshipInfo.equals(tmp, this.getClientObject())) continue;
            isPrtChld = Boolean.TRUE;
            break;
        }
        if (isPrtChld == null) {
            isPrtChld = Boolean.FALSE;
        }
        cache.isParentChildRelation = isPrtChld;
        return isPrtChld;
    }

    public EntityObjectInfo getParentObject(EntityObjectInfo parentObject) {
        if (this.isReverseLink(parentObject)) {
            return this.getSupplierObject();
        }
        return this.getClientObject();
    }

    public EntityObjectInfo getChildObject(EntityObjectInfo parentObject) {
        if (this.isReverseLink(parentObject)) {
            return this.getClientObject();
        }
        return this.getSupplierObject();
    }

    public PropertyInfo getParentProperty(EntityObjectInfo parentObject) {
        if (this.isReverseLink(parentObject)) {
            return this.getSupplierProperty();
        }
        return this.getClientProperty();
    }

    public PropertyInfo getChildProperty(EntityObjectInfo parentObject) {
        if (this.isReverseLink(parentObject)) {
            return this.getClientProperty();
        }
        return this.getSupplierProperty();
    }

    public CardinalityType getParentCardinality(EntityObjectInfo parentObject) {
        if (this.isReverseLink(parentObject)) {
            return this.getSupplierCardinality();
        }
        return this.getClientCardinality();
    }

    public CardinalityType getChildCardinality(EntityObjectInfo parentObject) {
        if (this.isReverseLink(parentObject)) {
            return this.getClientCardinality();
        }
        return this.getSupplierCardinality();
    }

    public RelationshipType getLinkType(EntityObjectInfo parentObject) {
        if (!this.isReverseLink(parentObject)) {
            return this.getType();
        }
        CardinalityType client = this.getClientCardinality();
        CardinalityType supplier = this.getSupplierCardinality();
        if (!client.equals((Object)CardinalityType.ONE_TO_UNBOUNDED) && !client.equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) || !supplier.equals((Object)CardinalityType.ONE_TO_UNBOUNDED) && !supplier.equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) {
            return RelationshipType.ASSOCIATION;
        }
        return this.getType();
    }

    public CrossTableInfo getCrossTable() {
        return (CrossTableInfo)this.get("crossTable");
    }

    public void setCrossTable(CrossTableInfo crossTable) {
        this.put("crossTable", crossTable);
    }

    public boolean isWeakReference() {
        return this.getWeakReferenceInfo() == null;
    }

    public String getWeakReferenceInfo() {
        return this.getString("weakReference");
    }

    public void setWeakReferenceInfo(String weakReference) {
        this.setString("weakReference", weakReference);
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.RELATIONSHIP;
    }

    @Override
    public ValidateList validate() {
        LogicalKeyInfo key;
        super.validate();
        ValidateMetaData vld = this.getValidate();
        if (this.getClientObject() == null) {
            vld.addError("Client Entity cannot be null.");
            return vld.getValidateList();
        }
        EntityObjectInfo supplier = this.getSupplierObject();
        if (supplier == null) {
            vld.addError("Supplier Entity cannot be null.");
            return vld.getValidateList();
        }
        if (!(supplier.isAbstract() || (key = supplier.getLogicalKey()) != null && key.getKeyPropertys() != null && key.getKeyPropertys().size() == 1)) {
            vld.addError("SupplierObject must hava s single-property logicalkey.");
        }
        if (this.getSupplierCardinality() == null) {
            vld.addError("Supplier Cardinality cannot be null.");
            return vld.getValidateList();
        }
        if (this.getClientCardinality() == null) {
            vld.addError("Client Cardinality cannot be null.");
            return vld.getValidateList();
        }
        if (supplier.isAbstract()) {
            vld.addError("SupplierEntity cannot be abstract");
        }
        if (CardinalityType.ONE_TO_UNBOUNDED.equals((Object)this.getSupplierCardinality()) || CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)this.getSupplierCardinality())) {
            boolean hasRelationShip = false;
            PropertyCollection pcol = supplier.getInheritedProperties();
            for (int i = pcol.size() - 1; i >= 0; --i) {
                PropertyInfo prop = pcol.get(i);
                if (!(prop instanceof LinkPropertyInfo) || ((LinkPropertyInfo)prop).getRelationship() == null || !this.getName().equals(((LinkPropertyInfo)prop).getRelationship().getName())) continue;
                hasRelationShip = true;
                break;
            }
            if (!hasRelationShip) {
                vld.addError(supplier.getName() + ".entity should define a Property link to " + this.getName());
            }
        }
        if (!CardinalityType.isOneORZero(this.getClientCardinality()) && !CardinalityType.isOneORZero(this.getSupplierCardinality()) && this.getCrossTable() == null) {
            vld.addError("CrossTable cannot be null.");
        }
        return vld.getValidateList();
    }

    public Object getRuntimeCopy() {
        RelationshipInfo cloned = new RelationshipInfo();
        cloned.setName(this.getName());
        cloned.setPackage(this.getPackage());
        cloned.setType(this.getType());
        cloned.setCrossTable(this.getCrossTable());
        cloned.setClientObject(this.getClientObject());
        cloned.setClientCardinality(this.getClientCardinality());
        cloned.setSupplierObject(this.getSupplierObject());
        cloned.setSupplierCardinality(this.getSupplierCardinality());
        return cloned;
    }

    private InnerCache getCache() {
        InnerCache cache = this.caches.get(ConfigMDUtil.getAIS());
        if (cache == null) {
            cache = new InnerCache();
            this.caches.put(ConfigMDUtil.getAIS(), cache);
        }
        return cache;
    }

    private static class InnerCache {
        private Boolean isParentChildRelation = null;
        private PropertyInfo clientProperty = null;
        private PropertyInfo supplierProperty = null;
        private EntityObjectInfo clientObject = null;
        private EntityObjectInfo supplierObject = null;
        private RelationshipType type = null;

        private InnerCache() {
        }
    }
}

