/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.InvalidMetaDataException;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectCollection;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.facade.FacadeCollection;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class FacadeInfo
extends BusinessObjectInfo
implements Serializable {
    private static Logger logger = Logger.getLogger(FacadeInfo.class);

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.FACADE;
    }

    public FacadeInfo() {
        this.put("extendStereoTypes", new FacadeCollection());
    }

    protected FacadeInfo(boolean init) {
        super(init);
    }

    @Override
    public boolean isSystemMethod(MethodInfo method) {
        return false;
    }

    public FacadeInfo getBaseFacade() {
        return (FacadeInfo)this.get("baseFacade");
    }

    public void setBaseFacade(FacadeInfo baseFacade) {
        this.put("baseFacade", baseFacade);
    }

    public FacadeInfo getRootFacade() {
        if (this.getBaseFacade() == null) {
            return null;
        }
        FacadeInfo facade = this;
        while (facade.getBaseFacade() != null) {
            facade = facade.getBaseFacade();
        }
        return facade;
    }

    public void validateCircle() throws BOSException {
        HashMap<String, FacadeInfo> map = new HashMap<String, FacadeInfo>();
        map.put(this.getFullName(), this);
        for (FacadeInfo temp = this.getBaseFacade(); temp != null; temp = temp.getBaseFacade()) {
            if (!map.containsKey(temp.getFullName())) continue;
            throw new InvalidMetaDataException("The inherited tree is a circle![" + temp.getFullName() + "," + this.getFullName() + "]");
        }
    }

    @Override
    public ValidateList validate() {
        super.validate();
        ValidateMetaData vld = new ValidateMetaData();
        try {
            this.validateCircle();
        }
        catch (BOSException e) {
            vld.addError(e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
        return vld.getValidateList();
    }

    @Override
    public BusinessObjectInfo getParent() {
        if (this.isStereoType()) {
            return null;
        }
        return this.getBaseFacade();
    }

    @Override
    public BusinessObjectCollection getExtendStereoTypes() {
        Object obj = this.get("extendStereoTypes");
        if (obj != null) {
            return (BusinessObjectCollection)((FacadeCollection)obj).cast(BusinessObjectCollection.class);
        }
        return new BusinessObjectCollection();
    }

    @Override
    public BusinessObjectCollection addExtendStereoType(BusinessObjectInfo st) {
        BusinessObjectCollection c = this.getExtendStereoTypes();
        c.add(st);
        this.put("extendStereoTypes", c.cast(FacadeCollection.class));
        return c;
    }
}

