/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.findbugs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

public class FindMetaBugs {
    public static void main(String[] args) throws Exception {
        String path = null;
        if (args.length > 0) {
            path = args[0];
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        if (path == null) {
            System.out.println("Please choose a directory to check: ");
            path = in.readLine();
        }
        FindMetaBugs tool = new FindMetaBugs();
        tool.find(path);
    }

    public void find(String path) throws IOException, JDOMException {
        File file = new File(path);
        System.out.println("begin index ...");
        HashMap<String, Resource> indexes = new HashMap<String, Resource>();
        AbstractEntryHandler handler = new IndexHandler(new String[]{".entity", ".table"}, indexes);
        if (file.isDirectory()) {
            this.processDirectory(file, handler);
        } else {
            this.processJarFile(file, handler);
        }
        System.out.println("begin filter entity ...");
        ArrayList<Entity> entities = new ArrayList<Entity>();
        HashSet<String> filter = new HashSet<String>();
        filter.add("com.kingdee.eas.scm.im.inv.app.InvBillBaseEntry");
        for (Resource r : indexes.values()) {
            handler = new InheritedEntityHanlder(entities, null, filter, indexes);
            handler.handle(r.file, r.entry);
        }
        System.out.println("begin out result ...");
        String[] columns = new String[]{"FQty"};
        int size = entities.size();
        for (int i = 0; i < size; ++i) {
            Resource r;
            r = (Resource)indexes.get(((Entity)entities.get((int)i)).table);
            new TableColumnHandler(columns).handle(r.file, r.entry);
        }
    }

    private void processDirectory(File file, EntryHandler handler) throws IOException, JDOMException {
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.processDirectory(files[i], handler);
                continue;
            }
            if (!files[i].getName().endsWith(".jar")) continue;
            this.processJarFile(files[i], handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJarFile(File jarFile, EntryHandler handler) throws IOException, JDOMException {
        JarFile file = null;
        try {
            file = new JarFile(jarFile);
            Enumeration<JarEntry> entrys = file.entries();
            while (entrys.hasMoreElements()) {
                JarEntry entry = entrys.nextElement();
                String name = entry.getName();
                if (!handler.accept(name)) continue;
                handler.handle(file, entry);
            }
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException e) {
                System.out.println("close JarFile error!" + e.getMessage());
            }
        }
    }

    static class TableColumnHandler
    extends AbstractEntryHandler {
        private final String[] columns;

        public TableColumnHandler(String[] columns) {
            this.columns = columns;
        }

        @Override
        public boolean accept(String name) {
            return name.endsWith(".table");
        }

        @Override
        protected void handle(Resource resource, Element root, Namespace ns) throws IOException, JDOMException {
            Element cols = root.getChild("columns", ns);
            List list = cols.getChildren("column", ns);
            for (Element column : list) {
                String name = column.getChildText("name", ns);
                String isMultilingual = column.getChildText("isMultilingual", ns);
                String dataType = column.getChildText("sqlType", ns);
                String length = column.getChildText("length", ns);
                String scale = column.getChildText("scale", ns);
                String precision = column.getChildText("precision", ns);
                for (int i = 0; i < this.columns.length; ++i) {
                    if (!name.equalsIgnoreCase(this.columns[i])) continue;
                    System.out.println(resource.file.getName() + "$" + this.getFullName(root, ns) + "::" + this.columns[i] + ":" + isMultilingual + "|" + dataType + "|" + length + "|" + scale + "|" + precision);
                }
            }
        }
    }

    static class InheritedEntityHanlder
    extends AbstractEntryHandler {
        private final List<Entity> entities;
        private final Set<String> parents;
        private final Set<String> filtered;
        private final Map<String, Resource> indexes;

        public InheritedEntityHanlder(List<Entity> entities, Set<String> parents, Set<String> filtered, Map<String, Resource> indexes) {
            this.entities = entities;
            this.parents = parents == null ? new HashSet<String>() : parents;
            this.filtered = filtered;
            this.indexes = indexes;
        }

        @Override
        public boolean accept(String name) {
            return name.endsWith(".entity");
        }

        @Override
        protected void handle(Resource resource, Element root, Namespace ns) throws IOException, JDOMException {
            String baseEntity = this.getFullNameByAttr(root.getChild("baseEntity", ns), ns);
            if (baseEntity == null) {
                return;
            }
            if (this.filtered.contains(baseEntity)) {
                String table = this.getFullNameByAttr(root.getChild("table", ns), ns);
                if (table != null) {
                    this.entities.add(new Entity(this.getFullName(root, ns), table));
                }
                if (this.parents != null && this.parents.size() > 0) {
                    this.filtered.addAll(this.parents);
                }
            } else {
                Resource r = this.indexes.get(baseEntity);
                if (r != null) {
                    this.parents.add(baseEntity);
                    new InheritedEntityHanlder(this.entities, this.parents, this.filtered, this.indexes).handle(r.file, r.entry);
                }
            }
        }

        String getFullNameByAttr(Element e, Namespace ns) {
            if (e == null) {
                return null;
            }
            List keys = e.getChildren("key", ns);
            String pack = ((Element)keys.get(0)).getAttributeValue("value");
            String name = ((Element)keys.get(1)).getAttributeValue("value");
            return pack + "." + name;
        }
    }

    static class IndexHandler
    extends AbstractEntryHandler {
        private final String[] suffix;
        private final Map<String, Resource> indexes;

        public IndexHandler(String[] suffix, Map<String, Resource> indexes) {
            this.suffix = suffix;
            this.indexes = indexes;
        }

        @Override
        public boolean accept(String name) {
            for (int i = 0; i < this.suffix.length; ++i) {
                if (!name.endsWith(this.suffix[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void handle(Resource resource, Element root, Namespace ns) throws IOException, JDOMException {
            String fullName = this.getFullName(root, ns);
            this.indexes.put(fullName, resource);
        }
    }

    static class Entity {
        final String name;
        final String table;

        public Entity(String name, String table) {
            this.name = name;
            this.table = table;
        }
    }

    static class Resource {
        final JarFile file;
        final JarEntry entry;

        public Resource(JarFile file, JarEntry entry) {
            this.file = file;
            this.entry = entry;
        }
    }

    static abstract class AbstractEntryHandler
    implements EntryHandler {
        AbstractEntryHandler() {
        }

        @Override
        public void handle(JarFile file, JarEntry entry) throws IOException, JDOMException {
            SAXBuilder builder = new SAXBuilder();
            Element root = builder.build(file.getInputStream(entry)).getRootElement();
            Namespace ns = Namespace.getNamespace((String)"com.kingdee.bos.metadata");
            this.handle(new Resource(file, entry), root, ns);
        }

        protected String getFullName(Element root, Namespace ns) throws IOException, JDOMException {
            String pack = root.getChildText("package", ns);
            String name = root.getChildText("name", ns);
            return pack + "." + name;
        }

        protected abstract void handle(Resource var1, Element var2, Namespace var3) throws IOException, JDOMException;
    }

    static interface EntryHandler {
        public boolean accept(String var1);

        public void handle(JarFile var1, JarEntry var2) throws IOException, JDOMException;
    }
}

