/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.function;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.SAXBuilderFactory;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class FunctionUpdate {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.function.FunctionUpdate");
    private static final Namespace NS = Namespace.getNamespace((String)"com.kingdee.bos.metadata");

    public void readOldFunction(File file) {
        SAXBuilder builder = SAXBuilderFactory.create();
        Document oldDoc = null;
        try {
            oldDoc = builder.build(file);
        }
        catch (JDOMException e) {
            logger.error((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
        Element oldFuncRootElement = oldDoc.getRootElement();
    }

    public static Document update(Document oldDoc, boolean isCreateFile) throws JDOMException {
        Element oldRoot = oldDoc.getRootElement();
        Element nRoot = oldRoot.clone();
        Element entityRef = oldRoot.getChild("entityObject", NS);
        Element facadeRef = oldRoot.getChild("facadeObject", NS);
        Element uiRef = oldRoot.getChild("uiObject", NS);
        String packageName = oldRoot.getChildText("package", NS);
        String functionName = oldRoot.getChildText("name", NS);
        if (entityRef != null) {
            Element entityObjectRefElement = new Element("entityObjectRef", NS);
            Element packageElement = new Element("key", NS);
            Element nameElement = new Element("key", NS);
            packageElement.setAttribute("name", "package");
            packageElement.setAttribute("value", FunctionUpdate.getKeyValue(entityRef, "package"));
            entityObjectRefElement.addContent((Content)packageElement);
            nameElement.setAttribute("name", "name");
            nameElement.setAttribute("value", FunctionUpdate.getKeyValue(entityRef, "name"));
            entityObjectRefElement.addContent((Content)nameElement);
            FunctionUpdate.updateOperations(nRoot.getChild("operations", NS), entityObjectRefElement, true);
            nRoot.removeChild("entityObject", NS);
        } else if (facadeRef != null) {
            Element facadeObjectRefElement = new Element("facadeObjectRef", NS);
            Element packageElement = new Element("key", NS);
            Element nameElement = new Element("key", NS);
            packageElement.setAttribute("name", "package");
            packageElement.setAttribute("value", FunctionUpdate.getKeyValue(facadeRef, "package"));
            facadeObjectRefElement.addContent((Content)packageElement);
            nameElement.setAttribute("name", "name");
            nameElement.setAttribute("value", FunctionUpdate.getKeyValue(facadeRef, "name"));
            facadeObjectRefElement.addContent((Content)nameElement);
            FunctionUpdate.updateOperations(nRoot.getChild("operations", NS), facadeObjectRefElement, false);
            nRoot.removeChild("facadeObject", NS);
        } else if (uiRef != null) {
            Element uiActionRefElement = new Element("uiActionRef");
            Element uiObjectRefElement = new Element("uiObjectRef");
            Element packageElement = new Element("key");
            Element nameElement = new Element("key");
            packageElement.setAttribute("name", "package");
            packageElement.setAttribute("value", FunctionUpdate.getKeyValue(uiRef, "package"));
            uiObjectRefElement.addContent((Content)packageElement);
            nameElement.setAttribute("name", "name");
            nameElement.setAttribute("value", FunctionUpdate.getKeyValue(uiRef, "name"));
            uiObjectRefElement.addContent((Content)nameElement);
            uiActionRefElement.addContent((Content)uiObjectRefElement);
            FunctionUpdate.updateUIOperations(nRoot.getChild("operations", NS), uiActionRefElement);
            nRoot.removeChild("uiObject", NS);
        } else {
            logger.error((Object)"function error.");
            return null;
        }
        Document nDoc = new Document(nRoot);
        if (isCreateFile) {
            FunctionUpdate.createFile(nDoc, packageName, functionName);
        }
        return nDoc;
    }

    private static String xmlToStr(Document oldDoc) {
        Format format = Format.getCompactFormat();
        format.setEncoding("utf-8");
        XMLOutputter xml = new XMLOutputter(format);
        String nFuncXml = xml.outputString(oldDoc);
        return nFuncXml;
    }

    private static String getKeyValue(Element element, String name) {
        String packageName = "";
        List list = element.getChildren();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Element el = (Element)list.get(i);
                if (el.getAttributeValue("name") == null || !el.getAttributeValue("name").equals(name)) continue;
                return el.getAttributeValue("value").toString();
            }
        }
        return packageName;
    }

    private static void updateUIOperations(Element operations, Element refEl) {
        List opl;
        if (operations != null && (opl = operations.getChildren()) != null) {
            for (int i = 0; i < opl.size(); ++i) {
                Element uiActionRefElement = refEl.clone();
                Element operElement = (Element)opl.get(i);
                operElement.addContent((Content)uiActionRefElement);
                String actionName = operElement.getName();
                Element actionElement = new Element("actionRefName");
                actionElement.setText(actionName);
                uiActionRefElement.addContent((Content)actionElement);
                Element idElement = new Element("id");
                idElement.setText(BOSUuid.create((String)"uiaf").toString());
                uiActionRefElement.addContent((Content)idElement);
                if (operElement.getChild("parameters", NS) != null) {
                    Element paramElement = operElement.getChild("parameters", NS).clone();
                    uiActionRefElement.addContent((Content)paramElement);
                    operElement.removeChild("parameters", NS);
                }
                ((Element)opl.get(i)).addContent((Content)FunctionUpdate.createEventElement((Element)opl.get(i), refEl));
            }
        }
    }

    private static void updateOperations(Element operations, Element refEl, boolean isEntity) {
        List opl;
        if (operations != null && (opl = operations.getChildren()) != null) {
            for (int i = 0; i < opl.size(); ++i) {
                Element oldMethodElement;
                Element operElement = (Element)opl.get(i);
                operElement.addContent((Content)refEl.clone());
                if (isEntity) {
                    oldMethodElement = operElement.getChild("entitymethodRef", NS).clone();
                    oldMethodElement.setName("entityMethodRef");
                    operElement.removeChild("entitymethodRef", NS);
                    operElement.addContent((Content)oldMethodElement);
                } else {
                    oldMethodElement = operElement.getChild("facademethodRef", NS).clone();
                    oldMethodElement.setName("facadeMehthodRef");
                    operElement.removeChild("facademethodRef", NS);
                    operElement.addContent((Content)oldMethodElement);
                }
                ((Element)opl.get(i)).addContent((Content)FunctionUpdate.createEventElement((Element)opl.get(i), refEl));
            }
        }
    }

    private static Element createEventElement(Element element, Element refEl) {
        Element eventElement = new Element("eventRef", NS);
        Element packageElement = new Element("key", NS);
        Element nameElement = new Element("key", NS);
        packageElement.setAttribute("name", "package");
        packageElement.setAttribute("value", FunctionUpdate.getKeyValue(refEl, "package"));
        eventElement.addContent((Content)packageElement);
        String eventName = element.getChildText("name", NS) + "Event";
        nameElement.setAttribute("name", "name");
        nameElement.setAttribute("value", eventName);
        eventElement.addContent((Content)nameElement);
        return eventElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFile(Document doc, String packageName, String functionName) {
        XMLOutputter xml = null;
        String prefix = "W:\\MetadataUpdate\\";
        String packageDir = StringUtils.replace((String)packageName, (String)".", (String)"\\");
        String fileName = prefix + packageDir + "\\" + functionName + ".function";
        File file = null;
        FileOutputStream fos = null;
        try {
            xml = new XMLOutputter();
            file = new File(prefix + packageDir);
            file.mkdirs();
            fos = new FileOutputStream(fileName);
            xml.output(doc, (OutputStream)fos);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close FileOutputStream error!", (Throwable)e);
            }
            xml = null;
            file = null;
        }
    }
}

