/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.management;

import com.kingdee.bos.metadata.management.DataSourceInfo;
import com.kingdee.bos.metadata.management.JdbcDriverType;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class DataSource {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.management.DataSource");
    public static final String DRIVER_CLASS = "com.kingdee.bos.sql.shell.Driver";
    private DataSourceInfo model = new DataSourceInfo();

    public DataSource(DataSourceInfo model) {
        this.model = model;
    }

    public DataSource(JdbcDriverType type, String host, int port, String dbName, String user, String pw) {
        this.model.setDriverType(type);
        this.model.setHost(host);
        this.model.setPort(port);
        this.model.setDbName(dbName);
        this.model.setUser(user);
        this.model.setPassword(pw);
    }

    public String makeUrl() {
        StringBuffer sb = new StringBuffer();
        sb.append("jdbc:ksql:");
        if (JdbcDriverType.ORACLE_THIN_DRIVER.equals(this.model.getDriverType())) {
            sb.append("oracle.jdbc.driver.OracleDriver:dbtype=oracle:jdbc:oracle:thin:@");
            sb.append(this.model.getHost());
            sb.append(":");
            sb.append(this.model.getPort());
            sb.append(":");
            sb.append(this.model.getDbName());
        } else if (JdbcDriverType.IBM_DB2_NET_DRIVER.equals(this.model.getDriverType())) {
            sb.append("COM.ibm.db2.jdbc.net.DB2Driver:dbtype=db2:jdbc:db2://");
            sb.append(this.model.getHost());
            sb.append(":");
            sb.append(this.model.getPort());
            sb.append("/");
            sb.append(this.model.getDbName());
        } else {
            sb.append("net.sourceforge.jtds.jdbc.Driver:dbtype=mssqlserver:jdbc:jtds:sqlserver://");
            sb.append(this.model.getHost());
            sb.append(":");
            sb.append(this.model.getPort());
            sb.append(";DatabaseName=");
            sb.append(this.model.getDbName());
            sb.append(";SelectMethod=cursor;Charset=GBK");
        }
        logger.debug((Object)("url:" + sb.toString()));
        return sb.toString();
    }

    public Connection getConnection() throws SQLException {
        try {
            Driver driver = (Driver)Class.forName(DRIVER_CLASS).newInstance();
            DriverManager.registerDriver(driver);
            return DriverManager.getConnection(this.makeUrl(), this.model.getUser(), this.model.getPassword());
        }
        catch (Exception e) {
            logger.debug((Object)e);
            throw new SQLException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect() {
        Connection cn = null;
        try {
            cn = this.getConnection();
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return true;
    }
}

