/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.management;

import com.kingdee.bos.metadata.management.DataSource;
import com.kingdee.bos.metadata.management.JdbcDriverType;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class DataSourceInfo
implements Cloneable,
Serializable {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.management.DataSourceInfo");
    private String host = "";
    private JdbcDriverType driverType = JdbcDriverType.MS_SQL_SERVER_DRIVER;
    private int port = 1433;
    private String dbName = "";
    private String user = "";
    private String password = "";
    private Connection cn;

    public boolean connect() throws SQLException {
        if (this.isConnected()) {
            return true;
        }
        this.cn = new DataSource(this).getConnection();
        return this.isConnected();
    }

    public Connection getConnection() {
        return this.cn;
    }

    public boolean isConnected() {
        boolean b = false;
        if (null != this.cn) {
            try {
                b = !this.cn.isClosed();
            }
            catch (SQLException e) {
                logger.debug((Object)"\u8fde\u63a5\u5df2\u5173\u95ed", (Throwable)e);
            }
            finally {
                try {
                    this.cn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return b;
    }

    public JdbcDriverType getDriverType() {
        return this.driverType;
    }

    public String getHost() {
        return this.host;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public void setDriverType(JdbcDriverType type) {
        this.driverType = type;
    }

    public void setHost(String s) {
        assert (s != null);
        this.host = s;
    }

    public void setPassword(String s) {
        assert (s != null);
        this.password = s;
    }

    public void setPort(int i) {
        if (i > 65535 && i < 0) {
            throw new IllegalArgumentException("\u7aef\u53e3\u53ea\u80fd\u662f\u5927\u4e8e0\u5c0f\u4e8e65535\u7684\u6574\u6570");
        }
        this.port = i;
    }

    public void setUser(String s) {
        assert (s != null);
        this.user = s;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String s) {
        assert (s != null);
        this.dbName = s;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DataSourceInfo)) {
            return false;
        }
        DataSourceInfo other = (DataSourceInfo)o;
        return this.host.equals(other.getHost()) && this.dbName.equals(other.getDbName()) && this.port == other.getPort() && this.driverType.equals(other.getDriverType()) && this.user.equals(other.getUser()) && this.password.equals(other.getPassword());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        DataSourceInfo info = new DataSourceInfo();
        info.setDriverType(this.driverType);
        info.setHost(new String(this.host));
        info.setDbName(new String(this.dbName));
        info.setPort(this.port);
        info.setUser(new String(this.user));
        info.setPassword(new String(this.password));
        return info;
    }
}

