/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.management;

import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.management.DataSourceInfo;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeployOptionInfo
extends AbstractMDElement
implements Serializable {
    public static final int CODE = 1;
    public static final int METADATA = 2;
    public static final int CONFIGFILE = 4;
    public static final int DATABASE = 8;
    public static final int DEV_LEVEL_BASE = 0;
    public static final int DEV_LEVEL_EXTEND = 1;
    public static final int DEV_LEVEL_BIM = 2;
    private boolean isOverrideDeployFile = false;
    private boolean incrementDeploy = false;
    private Map genCodeInAgent = new Hashtable();
    public static final String DEPLOY_APP_IMPL_CODE = "deployAppImplCode";
    public static final String DEPLOY_VALUEINFO_CODE = "deployValueInfoCode";
    public static final String DEPLOY_INFTERFACE_CODE = "deployInfterfaceCode";
    private int devLevel = 0;
    private IDeployMetadataFilter deployMetadataFilter = null;

    public DeployOptionInfo() {
        this.setTargetDBMS(new DataSourceInfo());
        this.setTargetAppServer(1);
        this.setJ2eeOutputDir("");
        this.setJavaOutputDir("");
        this.setMetaDataRepository("");
        this.setDeployLevel(15);
        this.setDeployRPC(false);
        this.setDeployValueInfoCode(true);
        this.setDeployInterfaceCode(true);
        this.setDeployAppImplCode(true);
    }

    public String getName() {
        return this.getString("name");
    }

    public void setName(String name) {
        this.setString("name", name);
    }

    public int getDevLevel() {
        return this.devLevel;
    }

    public void setDevLevel(int level) {
        this.devLevel = level;
    }

    public boolean isDeployValueInfoCode() {
        return this.getBoolean(DEPLOY_VALUEINFO_CODE);
    }

    public boolean isDeployValueInfoCode(String full_name) {
        if (this.deployMetadataFilter != null) {
            return this.deployMetadataFilter.isAllowDeploy(DEPLOY_VALUEINFO_CODE, full_name);
        }
        return this.isDeployValueInfoCode();
    }

    public void setDeployValueInfoCode(boolean isDeployValueInfoCode) {
        this.setBoolean(DEPLOY_VALUEINFO_CODE, isDeployValueInfoCode);
    }

    public boolean isDeployInterfaceCode() {
        return this.getBoolean(DEPLOY_INFTERFACE_CODE);
    }

    public boolean isDeployInterfaceCode(String full_name) {
        if (this.deployMetadataFilter != null) {
            return this.deployMetadataFilter.isAllowDeploy(DEPLOY_INFTERFACE_CODE, full_name);
        }
        return this.isDeployInterfaceCode();
    }

    public void setDeployInterfaceCode(boolean isDeployInfterfaceCode) {
        this.setBoolean(DEPLOY_INFTERFACE_CODE, isDeployInfterfaceCode);
    }

    public boolean isDeployAppImplCode() {
        return this.getBoolean(DEPLOY_APP_IMPL_CODE);
    }

    public boolean isDeployAppImplCode(String full_name) {
        if (this.deployMetadataFilter != null) {
            return this.deployMetadataFilter.isAllowDeploy(DEPLOY_APP_IMPL_CODE, full_name);
        }
        return this.isDeployAppImplCode();
    }

    public void setDeployAppImplCode(boolean isDeployAppImplCode) {
        this.setBoolean(DEPLOY_APP_IMPL_CODE, isDeployAppImplCode);
    }

    public void setAlias(String alias) {
        this.setString("alias", alias);
    }

    public String getAlias() {
        return this.getString("alias");
    }

    public String getMetaDataRepository() {
        return this.getString("metaDataRepository");
    }

    public void setMetaDataRepository(String metaDataRepository) {
        this.setString("metaDataRepository", metaDataRepository);
    }

    public DataSourceInfo getTargetDBMS() {
        return (DataSourceInfo)this.get("targetDataSource");
    }

    public void setTargetDBMS(DataSourceInfo targetDBMS) {
        this.put("targetDataSource", targetDBMS);
    }

    public String getJavaOutputDir() {
        return this.getString("javaOutputDir");
    }

    public void setJavaOutputDir(String javaOutputDir) {
        this.setString("javaOutputDir", javaOutputDir);
    }

    public String getJ2eeOutputDir() {
        return this.getString("j2eeOutputDir");
    }

    public void setJ2eeOutputDir(String j2eeOutputDir) {
        this.setString("j2eeOutputDir", j2eeOutputDir);
    }

    public int getTargetAppServer() {
        return this.getInt("targetAppServer");
    }

    public void setTargetAppServer(int targetAppServer) {
        this.setInt("targetAppServer", targetAppServer);
    }

    public void setDeployLevel(int level) {
        this.setInt("deployLevel", level);
    }

    public int getDeployLevel() {
        return this.getInt("deployLevel");
    }

    public boolean isDeployCode() {
        return this.incrementDeploy || (this.getDeployLevel() & 1) == 1;
    }

    public boolean isDeployMetadata() {
        return this.incrementDeploy || (this.getDeployLevel() & 2) == 2;
    }

    public boolean isDeployConfigFile() {
        return this.incrementDeploy || (this.getDeployLevel() & 4) == 4;
    }

    public boolean isDeployDatabase() {
        return (this.getDeployLevel() & 8) == 8;
    }

    public boolean isOverrideDeployFile() {
        if (this.incrementDeploy) {
            return false;
        }
        return this.isOverrideDeployFile;
    }

    public void setOverrideDeployFile(boolean isOverride) {
        this.isOverrideDeployFile = isOverride;
    }

    public boolean isDefault() {
        return this.getBoolean("defaultOption");
    }

    public void setDefault(boolean b) {
        this.setBoolean("defaultOption", b);
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOSObjectType.create((String)"depo");
    }

    public boolean isIncrementDeploy() {
        return this.incrementDeploy && this.isDeployMetadata();
    }

    public void setIncrementDeploy(boolean incrementDeploy) {
        this.incrementDeploy = incrementDeploy;
    }

    public boolean needToGenAgent(BOSObjectType type, IMetaDataPK pk) {
        Set set = (Set)this.genCodeInAgent.get(type);
        if (set == null) {
            return false;
        }
        return set.contains(pk);
    }

    public Collection getGenAgentBOSObjTypes() {
        return new HashSet(this.genCodeInAgent.keySet());
    }

    public Collection getMetasToGenAgent(BOSObjectType type) {
        Set set = (Set)this.genCodeInAgent.get(type);
        if (set == null) {
            return new HashSet(0);
        }
        return new HashSet(set);
    }

    public void addMetasToGenAgent(BOSObjectType type, IMetaDataPK pk) {
        HashSet<IMetaDataPK> set = (HashSet<IMetaDataPK>)this.genCodeInAgent.get(type);
        if (set == null) {
            set = new HashSet<IMetaDataPK>();
            this.genCodeInAgent.put(type, set);
        }
        set.add(pk);
    }

    public void addMetasToGenAgent(BOSObjectType type, Collection pks) {
        HashSet<Collection> set = (HashSet<Collection>)this.genCodeInAgent.get(type);
        if (set == null) {
            set = new HashSet<Collection>();
            this.genCodeInAgent.put(type, set);
        }
        set.add(pks);
    }

    public void addMetasToGenAgent(Collection metas) {
        if (metas == null || metas.isEmpty()) {
            return;
        }
        Iterator iter = metas.iterator();
        Object obj = null;
        MetaDataInfo mInfo = null;
        while (iter.hasNext()) {
            obj = iter.next();
            if (!(obj instanceof MetaDataInfo)) continue;
            mInfo = obj;
            this.addMetasToGenAgent(BOSObjectType.create((String)mInfo.getMetaDataType()), MetaDataPK.create(mInfo.getPackage(), mInfo.getName()));
        }
    }

    public void removeMetasToGenAgent(BOSObjectType type, IMetaDataPK pk) {
        Set set = (Set)this.genCodeInAgent.get(type);
        if (set == null) {
            return;
        }
        set.remove(pk);
    }

    public void removeMetasToGenAgent(BOSObjectType type, Collection pks) {
        Set set = (Set)this.genCodeInAgent.get(type);
        if (set == null) {
            return;
        }
        set.remove(pks);
    }

    public void cleanMetasToGenAgent(BOSObjectType type) {
        this.genCodeInAgent.remove(type);
    }

    public void cleanAllMetasToGenAgent() {
        this.genCodeInAgent.clear();
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        super.marshal(marshaller);
        marshaller.writeBoolean(this.isOverrideDeployFile);
        marshaller.writeBoolean(this.incrementDeploy);
        marshaller.writeObject((Object)this.genCodeInAgent);
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        super.unmarshal(unmarshaller);
        this.isOverrideDeployFile = unmarshaller.readBoolean();
        this.incrementDeploy = unmarshaller.readBoolean();
        this.genCodeInAgent = (Hashtable)unmarshaller.readObject();
    }

    public boolean isDeployRPC() {
        return this.getBoolean("deployRPC");
    }

    public void setDeployRPC(boolean isDeployRPC) {
        this.setBoolean("deployRPC", isDeployRPC);
    }

    public String getWebUiSrcPath() {
        return this.getString("webuisrcpath");
    }

    public void setWebUiSrcPath(String path) {
        this.setString("webuisrcpath", path);
    }

    public String getWebUiClassesPath() {
        return this.getString("webuiclassespath");
    }

    public void setWebUiClassesPath(String path) {
        this.setString("webuiclassespath", path);
    }

    public void setWebUiRootPath(String path) {
        this.setString("webuirootpath", path);
    }

    public String getWebUiRootPath() {
        return this.getString("webuirootpath");
    }

    public void setWebUiAppName(String name) {
        this.setString("webuiappname", name);
    }

    public String getWebUiAppName() {
        return this.getString("webuiappname");
    }

    public void setWebUiMappingName(String name) {
        this.setString("webuimappingname", name);
    }

    public String getWebUiMappingName() {
        return this.getString("webuimappingname");
    }

    public boolean isMBeanDeploy() {
        return this.getBoolean("MBeanDeploy");
    }

    public void setMBeanDeploy(boolean b) {
        this.setBoolean("MBeanDeploy", b);
    }

    public void setDeployMetadataFilter(IDeployMetadataFilter deployMetadataFilter) {
        this.deployMetadataFilter = deployMetadataFilter;
    }

    public static class DefaultDeployMetadataFilter
    implements IDeployMetadataFilter {
        private HashMap exclude_file_map = new HashMap();

        public void addFilterArray(String deploy_code_type, List list) {
            this.exclude_file_map.put(deploy_code_type, list);
        }

        public List getArray(String deploy_code_type) {
            return (List)this.exclude_file_map.get(deploy_code_type);
        }

        @Override
        public boolean isAllowDeploy(String deploy_code_type, String full_name) {
            if (this.exclude_file_map.containsKey(deploy_code_type) && this.exclude_file_map.get(deploy_code_type) != null) {
                return !((List)this.exclude_file_map.get(deploy_code_type)).contains(full_name);
            }
            return true;
        }
    }

    public static interface IDeployMetadataFilter {
        public boolean isAllowDeploy(String var1, String var2);
    }
}

