/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.management;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.xml.IXMLDAO;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.metadata.AbstractMetaDataContainer;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContext;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.management.IPackageCtrl;
import com.kingdee.bos.metadata.management.PackageCollection;
import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.metadata.management.application.IAppViewCtrl;
import com.kingdee.bos.metadata.management.application.MetaDataCollection;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.service.netfile.NetFile;
import com.kingdee.bos.service.netfile.NetFileFactory;
import com.kingdee.bos.service.netfile.NetFileHelper;
import com.kingdee.bos.service.netfile.NetFileSource;
import com.kingdee.bos.util.BOSObjectType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class PackageCtrl
extends AbstractMetaDataContainer
implements IPackageCtrl {
    @Override
    public BOSObjectType getType() {
        return MetaDataTypeList.PACKAGE;
    }

    public PackageCtrl() {
        super.registerInterface(IAppViewCtrl.class, (Object)this);
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.management", "package"));
    }

    public PackageCtrl(Context ctx) {
        super(ctx);
        super.registerInterface(IAppViewCtrl.class, (Object)this);
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.management", "package"));
    }

    @Override
    public MetaDataCollection getMetaDatas(String pgName) throws DataAccessException {
        MetaDataCollection metaColl = new MetaDataCollection();
        BOSObjectType[] bosTypes = MDContext.supportedTypes.getMetaTypes();
        MetaDataCollection metas = null;
        for (int i = 0; i < bosTypes.length; ++i) {
            metas = this.getMetaDatasByType(bosTypes[i], pgName);
            if (metas == null || metas.size() <= 0) continue;
            metaColl.addObjectCollection(metas);
        }
        Object[] aMetas = metaColl.toArray();
        Arrays.sort(aMetas);
        metaColl.clear();
        int len = aMetas.length;
        for (int i = 0; i < len; ++i) {
            metaColl.add((MetaDataInfo)aMetas[i]);
        }
        return metaColl;
    }

    @Override
    public MetaDataCollection getMetaDatasByType(BOSObjectType type, String pgName) throws DataAccessException {
        IMetaDataPK[] pks = XMLAccessEngine.getXMLLoader((Context)this.getContext()).getMetaDataClassLoader().getMDContext().pkIndexs.getMetaDataPKs(type, pgName);
        MetaDataCollection metaColl = new MetaDataCollection();
        if (pks == null || pks.length <= 0) {
            return metaColl;
        }
        int len = pks.length;
        for (int i = 0; i < len; ++i) {
            metaColl.add(new MetaDataInfo(pks[i], type));
        }
        return metaColl;
    }

    @Override
    public MetaDataCollection getMetaDatas() throws DataAccessException {
        return this.getMetaDatas(null);
    }

    @Override
    public MetaDataCollection getMetaDatasExceptPackage() throws DataAccessException {
        MetaDataCollection metaColl = new MetaDataCollection();
        BOSObjectType[] bosTypes = MDContext.supportedTypes.getMetaTypes();
        MetaDataCollection metas = null;
        for (int i = 0; i < bosTypes.length; ++i) {
            if (MetaDataTypeList.PACKAGE.equals((Object)bosTypes[i]) || (metas = this.getMetaDatasByType(bosTypes[i], null)) == null) continue;
            metaColl.addObjectCollection(metas);
        }
        Object[] aMetas = metaColl.toArray();
        Arrays.sort(aMetas);
        metaColl.clear();
        int len = aMetas.length;
        for (int i = 0; i < len; ++i) {
            metaColl.add((MetaDataInfo)aMetas[i]);
        }
        return metaColl;
    }

    @Override
    public MetaDataCollection getMetaDatasByType(BOSObjectType type) throws DataAccessException {
        return this.getMetaDatasByType(type, null);
    }

    @Override
    public PackageCollection getCollection() throws BOSException {
        return (PackageCollection)this.getDAO().getCollection();
    }

    @Override
    public PackageCollection getCollection(String pgName) throws BOSException {
        return (PackageCollection)((IXMLDAO)this.getDAO()).getCollection(pgName);
    }

    @Override
    public String[] getPackageList(String pgName) {
        NetFileSource fileSrc = Utils.getMetaDataFileSrc(this.getContext());
        NetFileFactory fileFactory = NetFileHelper.getNetFileFactory((NetFileSource)fileSrc);
        NetFile root = null;
        root = pgName == null ? fileFactory.createNetFile("\\") : fileFactory.createNetFile(pgName.replace('.', File.separatorChar));
        String[] fs = root.list();
        String pgPath = null;
        if (fs == null) {
            return null;
        }
        ArrayList<String> v = new ArrayList<String>();
        int length = fs.length;
        for (int i = 0; i < length; ++i) {
            NetFile temp;
            if (fs[i].indexOf(46) != -1 || fs[i].equalsIgnoreCase("cvs") || (temp = fileFactory.createNetFile(root, fs[i])).list() == null) continue;
            pgPath = pgName == null ? fs[i] : pgName + "." + fs[i];
            if (pgPath != null) {
                v.add(pgPath);
            }
            String[] os = this.getPackageList(pgPath);
            v.addAll(Arrays.asList(os));
        }
        String[] pgs = v.toArray(new String[0]);
        return pgs;
    }

    @Override
    public void addnew(IMetaDataPK pk, PackageInfo packageInfo) throws BOSException {
        this.getDAO().addnew(pk, packageInfo);
    }

    @Override
    public IMetaDataPK addnew(PackageInfo packageInfo) throws BOSException {
        return (IMetaDataPK)this.getDAO().addnew(packageInfo);
    }

    @Override
    public void update(IMetaDataPK metaType, PackageInfo packageInfo) throws BOSException {
        this.getDAO().update(metaType, packageInfo);
    }

    @Override
    public PackageInfo getValue(IMetaDataPK metaType) throws BOSException {
        return (PackageInfo)this.getDAO().getValue(metaType);
    }
}

