/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.management.application;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLIOException;
import com.kingdee.bos.dao.xml.XMLParseException;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.management.application.AppViewInfo;
import com.kingdee.bos.metadata.management.application.ApplicationInfo;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.metadata.management.application.SubSystemInfo;
import com.kingdee.bos.service.netfile.NetFile;
import com.kingdee.bos.service.netfile.NetFileFactory;
import com.kingdee.bos.service.netfile.NetFileHelper;
import com.kingdee.bos.service.netfile.NetFileSource;
import java.io.IOException;
import java.io.InputStream;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class AppViewInfoLoader {
    private static final String DEFAULT_APPLICATION_NAME = "UpgradeApplication";
    private static final String APPVIEW_NAME = "bos";

    public static AppViewInfo loadAppViewInfo(Context ctx) throws DataAccessException, IOException {
        AppViewInfo appInfo = null;
        NetFileSource fileSrc = Utils.getMetaDataFileSrc(ctx);
        NetFileFactory fileFactory = NetFileHelper.getNetFileFactory((NetFileSource)fileSrc);
        NetFile slnFile = fileFactory.createNetFile("");
        String fileName = APPVIEW_NAME + Utils.getMetaDataSuffix(MetaDataTypeList.APPVIEW);
        slnFile = fileFactory.createNetFile(fileName);
        if (!slnFile.exists()) {
            throw new XMLIOException("The appview file doesn't exist!");
        }
        InputStream is = fileFactory.createNetFileInputStream(slnFile);
        appInfo = AppViewInfoLoader.load(is);
        is.close();
        return appInfo;
    }

    private static MetaDataInfo setMetaData(Element root, Element metadata) throws DataAccessException {
        MetaDataInfo meta = new MetaDataInfo();
        meta.setPackage(metadata.getChildText("package", root.getNamespace()));
        meta.setName(metadata.getChildText("name", root.getNamespace()));
        meta.setMetaDataType(metadata.getChildText("bosType", root.getNamespace()));
        return meta;
    }

    private static SubSystemInfo setSubSytem(Element root, Element application) throws DataAccessException {
        SubSystemInfo subSystem = new SubSystemInfo();
        subSystem.setName(application.getChildText("name", root.getNamespace()));
        subSystem.setAlias(application.getChildText("alias", root.getNamespace()));
        subSystem.setDescription(application.getChildText("description", root.getNamespace()));
        return subSystem;
    }

    private static AppViewInfo load(InputStream is) throws DataAccessException {
        try {
            Element root = new SAXBuilder().build(is).getRootElement();
            AppViewInfo appInfo = new AppViewInfo();
            Element subSystems = root.getChild("subSystems", root.getNamespace());
            if (subSystems == null) {
                ApplicationInfo appl = new ApplicationInfo();
                appl.setName(DEFAULT_APPLICATION_NAME);
                Element applications = root.getChild("applications", root.getNamespace());
                if (applications != null) {
                    for (Element application : applications.getChildren("application", root.getNamespace())) {
                        SubSystemInfo subSystem = AppViewInfoLoader.setSubSytem(root, application);
                        Element metas = application.getChild("metadatas", root.getNamespace());
                        if (metas != null) {
                            for (Element metadata : metas.getChildren("metadata", root.getNamespace())) {
                                subSystem.getMetaDatas().add(AppViewInfoLoader.setMetaData(application, metadata));
                            }
                        }
                        appl.getSubSystems().add(subSystem);
                    }
                }
                appInfo.getApplications().add(appl);
            }
            return appInfo;
        }
        catch (JDOMException de) {
            throw new XMLParseException(de);
        }
        catch (IOException ioe) {
            throw new XMLIOException(ioe);
        }
    }
}

