/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.management.application;

import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.management.application.SubSystemCollection;
import com.kingdee.bos.metadata.management.application.SubSystemInfo;
import com.kingdee.bos.metadata.validate.IValidate;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.HashMap;

public class ApplicationInfo
extends AbstractMDElement
implements Serializable,
IValidate {
    public ApplicationInfo() {
        this.put("subSystems", new SubSystemCollection());
    }

    public String getName() {
        return this.getString("name");
    }

    public void setName(String name) {
        this.setString("name", name);
    }

    public String getAlias() {
        return this.getString("alias");
    }

    public void setAlias(String alias) {
        this.setString("alias", alias);
    }

    public String getDescription() {
        return this.getString("description");
    }

    public void setDescription(String description) {
        this.setString("description", description);
    }

    public SubSystemCollection getSubSystems() {
        return (SubSystemCollection)this.get("subSystems");
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOSObjectType.create((String)"appl");
    }

    public void addSubSystem(SubSystemInfo subSystem) {
        this.getSubSystems().add(subSystem);
    }

    public void removeSubSystem(SubSystemInfo subSystem) {
        subSystem.getMetaDatas().removeAll();
        this.getSubSystems().remove(subSystem);
    }

    public SubSystemInfo getSubSystemFromName(String subSystemName) {
        SubSystemCollection subSystems = this.getSubSystems();
        SubSystemInfo subSystem = null;
        int length = subSystems.size();
        for (int i = 0; i < length; ++i) {
            if (!StringUtils.equalsIgnoreCase((String)subSystems.get(i).getName(), (String)subSystemName)) continue;
            subSystem = subSystems.get(i);
            break;
        }
        return subSystem;
    }

    @Override
    public ValidateList validate() {
        ValidateMetaData vld = new ValidateMetaData();
        SubSystemCollection subSystems = this.getSubSystems();
        HashMap<String, SubSystemInfo> map = new HashMap<String, SubSystemInfo>();
        for (int i = 0; i < subSystems.size(); ++i) {
            if (map.containsKey(subSystems.get(i).getName())) {
                vld.addError("Duplicated subsystem name: " + subSystems.get(i).getName());
            } else {
                map.put(subSystems.get(i).getName(), subSystems.get(i));
            }
            vld.addValidateList(subSystems.get(i).validate());
        }
        return vld.getValidateList();
    }
}

